<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');

//RUTAS PARA USUARIO
$routes->post('/login',                'Usuario::login');


// RUTAS PARA Pagos Detalle
/*
$routes->get('/pagosdetalle',              'PagosDetalle::index');
$routes->post('/pagosdetalleshow',        'PagosDetalle::show');
$routes->post('/pagosdetalledelete',      'PagosDetalle::delete');
$routes->post('/pagosdetallecreate',      'PagosDetalle::create');
$routes->post('/pagosdetallemayornoconciliado',      'PagosDetalle::mayornoconciliado');
$routes->put('/pagosdetalleupdate',       'PagosDetalle::update');*/


// RUTAS PARA VENTAS
$routes->get('/ventas',              'Ventas::index');
$routes->post('/ventasshow',        'Ventas::show');
$routes->post('/ventasdelete',      'Ventas::delete');
$routes->post('/ventascreate',      'Ventas::create');
$routes->post('/ventasmayornoconciliado',      'Venta::mayornoconciliado');
$routes->post('/ventamayor',      'Venta::mayor');
$routes->post('/showbancotarjeta',      'Venta::showbancotarjeta');
$routes->put('/ventasupdate',       'Venta::update');
$routes->post('/ventasupdateobservacion',       'Venta::updateObservacion');
$routes->post('/ventamayornoconciliado',       'Venta::mayornoconciliado');

// RUTAS PARA RELACION PAGOS VENTAS
$routes->get('/relacionpagosventas',              'RelacionPagosVentas::index');
$routes->post('/shownumeroconciliacion',        'RelacionPagosVentas::shownumeroconciliacion');
$routes->post('/showrelacionpagosventas',        'RelacionPagosVentas::showrelacionpagosventas');
$routes->post('/relacionpagosventasdelete',      'RelacionPagosVentas::delete');
$routes->post('/relacionpagosventascreate',      'RelacionPagosVentas::create');
$routes->put('/relacionpagosventasupdate',       'RelacionPagosVentas::update');
$routes->post('/reportemayorconciliado',       'RelacionPagosVentas::reportemayorconciliado');
$routes->post('/relacionpagosventasborrar',       'RelacionPagosVentas::desconciliacioneliminar');
$routes->post('/relacionpagosventascomprobar',      'RelacionPagosVentas::comprarnumeroconciliacion');
$routes->post('/relacionpagosventascomprobarfechacruce',      'RelacionPagosVentas::comprobarnumeroconciliacionFechaCruce');
$routes->post('/relacionpagosventasreferenciacontable',      'RelacionPagosVentas::agregarreferenciacontable');
$routes->post('/relacionpagosventasverconciliacion',      'RelacionPagosVentas::verConciliacion');
$routes->post('/relacionpagosventasverconciliacionfechacruce',      'RelacionPagosVentas::verConciliacionFechaCruce');
$routes->post('/reportesaldoscentavos',       'RelacionPagosVentas::reportesaldocentavos');

//RUTAS PARA TIPO PAGO
$routes->post('/tipopagocreate',                'TipoPago::crear');
$routes->post('/tipopagoindex',                 'TipoPago::index');
$routes->post('/tipopagoshow',                  'TipoPago::mostrar');
$routes->post('/tipopagoactualizar',            'TipoPago::actualizar');
$routes->post('/tipopagoeliminar',              'TipoPago::eliminar');

//RUTAS PARA CENTRO COSTO
$routes->post('/centrocostocreate',                'CentroCosto::crear');
$routes->post('/centrocostoindex',                 'CentroCosto::index');
$routes->post('/centrocostoactualizar',            'CentroCosto::actualizar');

//RUTAS PARA RELACION BANCO Y TIPO PAGO
$routes->post('/relacionbancotipopagocrear',                'RelacionBancoTipoPago::crear');
$routes->post('/relacionbancotipopagoindex',                 'RelacionBancoTipoPago::index');
$routes->post('/relacionbancotipopagomostrar',      'RelacionBancoTipoPago::mostrar');
$routes->post('/relacionbancotipopagoactualizar',      'RelacionBancoTipoPago::actualizar');
$routes->post('/relacionbancotipopagoeliminar',   'RelacionBancoTipoPago::eliminar');
$routes->post('relacionbancotipopagoporcentajecomision',                'RelacionBancoTipoPago::obtenerpocentajecomision');

// RUTAS PARA BANCO PAGADOR
$routes->post('/bancopagadorcrear',                'BancoPagador::crear');
$routes->post('/bancopagadorindex',                 'BancoPagador::index');
$routes->post('/bancopagadormostrar',      'BancoPagador::mostrar');
$routes->post('/bancopagadoractualizar',      'BancoPagador::actualizar');
$routes->post('/bancopagadoreliminar',   'BancoPagador::eliminar');

//RUTAS PARA PAGO CABECERA
$routes->post('/pagocabecera',                'PagoCabecera::create');
$routes->post('/pagocabeceradatoscabeceradetalle',                'PagoCabecera::datoscabeceradetalle');
$routes->post('/pagocabeceratodos',                 'PagoCabecera::index');
$routes->post('/pagocabeceraeliminar',                 'PagoCabecera::eliminar');
$routes->get('/pagocabecera/(:segment)',      'PagoCabecera::show/$1');
$routes->put('/pagocabecera/(:segment)',      'PagoCabecera::update/$1');
$routes->delete('/pagocabecera/(:segment)',   'PagoCabecera::delete/$1');
$routes->post('/pagoreferenciacontable',     'PagoCabecera::agregarreferenciacontable');
//RUTAS PARA PAGO DETALLE
$routes->post('/pagodetalle',                'PagoDetalle::create');
$routes->get('/pagodetalle',                 'PagoDetalle::index');
$routes->get('/pagodetalle/(:segment)',      'PagoDetalle::show/$1');
$routes->put('/pagodetalle/(:segment)',      'PagoDetalle::update/$1');
$routes->delete('/pagodetalle/(:segment)',   'PagoDetalle::delete/$1');
$routes->post('/pagodetallefiltro',                'PagoDetalle::showfiltroconciliacion');
$routes->get('/pagodetalleconciliado/(:segment)',      'PagoDetalle::datoconciliado/$1');
$routes->get('/pagodetalledesconciliado/(:segment)',      'PagoDetalle::datodesconciliado/$1');
$routes->post('/reportepagonoconciliado',                'PagoDetalle::pagonoconciliado');
$routes->post('/reportepago',                'PagoDetalle::pago');
$routes->post('/agregarfechacruce',                'PagoDetalle::agregarfechacruce');
$routes->post('/pagoupdateobservacion',       'PagoDetalle::updateObservacionPago');

//RUTAS PARA VENTA
$routes->post('/venta',                'Venta::create');
$routes->get('/venta',                 'Venta::index');
$routes->get('/venta/(:segment)',      'Venta::show/$1');
$routes->put('/venta/(:segment)',      'Venta::update/$1');
$routes->delete('/venta/(:segment)',   'Venta::delete/$1');
$routes->post('/ventafiltro',                'Venta::showfiltroconciliacion');
$routes->get('/ventaconciliado/(:segment)',      'Venta::datoconciliado/$1');
$routes->get('/ventadesconciliado/(:segment)',      'Venta::datodesconciliado/$1');


//cierre mes
$routes->post('/fechamaximacierremes',                'HistorialPagoDetalle::getultimafechacierremes');




$routes->get('/conciliacion',              'Conciliacion::index');


//RUTAS PARA EL BACO
$routes->post('banco',                'Banco::create');
$routes->get('banco',                 'Banco::index');
$routes->get('banco/(:segment)',      'Banco::show/$1');
$routes->put('banco/(:segment)',      'Banco::update/$1');
$routes->delete('banco/(:segment)',   'Banco::delete/$1');

//RUTAS PARA TRAJETA CREDITO
$routes->post('/tarjetacredito',                'TarjetaCredito::create');
$routes->post('/tarjetacreditomostrarporbanco',                'TarjetaCredito::mostrartarjetasporbanco');


//RUTAS PARA TIPO CUENTA
$routes->post('/tipocuenta',      'TipoCuenta::create');


//RUTAS PARA DATOS PAGOS VENTAS
$routes->post('datospagosventas',                'DatosPagosVentas::create');
$routes->post('datospagosventaseliminar',   'DatosPagosVentas::eliminar');
$routes->post('datospagosventassegunnumeroconciliacion',      'DatosPagosVentas::showsegunnumeroconciliacion');



//RUTAS  PARA USAR LAS APIS DE MEGAPROFER
$routes->get('/megaproferventasdiarias',      'Venta::megaproferventasdiarias');
$routes->get('/megaproferbanco',      'Banco::megaproferbanco');
$routes->get('/megaprotarjetacredito',      'TarjetaCredito::megaprotarjetacredito');
$routes->get('/megaprofertipocuenta',      'TipoCuenta::megaprofertipocuenta');
$routes->get('/dependientesInsert',      'Ajustes::dependientesInsert');
$routes->get('/tercerosInsert',      'Ajustes::tercerosInsert');



//RUTAS PARA HISTORIAL PAGO DETALLE
$routes->post('/historialcierremes',                'HistorialPagoDetalle::historial');
$routes->post('/historialpagodetalle',                'HistorialPagoDetalle::index');

//RUTAS PARA HISTORIAL venta
$routes->post('/historialventacierremes',                'HistorialVenta::historial');
$routes->post('/historialventa',                'HistorialVenta::index');

//ESTADISTICAS
$routes->post('/estadisticasrelacionpagosventasayervshoy',                'RelacionPagosVentas::estadisticasayervshoy');









// RUTAS PARA CIERRES PROCESOS
//$routes->resource('cierresprocesos');
$routes->get('/cierresprocesos',              'CierresProcesos::index');
$routes->post('/cierresprocesosshow',        'CierresProcesos::show');
$routes->post('/cierresprocesosdelete',      'CierresProcesos::delete');
$routes->post('/cierresprocesoscreate',      'CierresProcesos::create');
$routes->put('/cierresprocesosupdate',       'CierresProcesos::update');
// RUTAS PARA Pagos Cabecera
//$routes->resource('pagoscabecera');
$routes->post('pagoscabecera',                'PagosCabecera::create');
$routes->get('pagoscabecera',                 'PagosCabecera::index');
$routes->get('pagoscabecera/(:segment)',      'PagosCabecera::show/$1');
$routes->put('pagoscabecera/(:segment)',      'PagosCabecera::update/$1');
$routes->delete('pagoscabecera/(:segment)',   'PagosCabecera::delete/$1');


// RUTAS PARA AJUSTES CENTAVOS
//$routes->resource('ajustescentavos');
$routes->post('ajustescentavos',                'AjustesCentavos::create');
$routes->get('ajustescentavos',                 'AjustesCentavos::index');
$routes->get('ajustescentavos/(:segment)',      'AjustesCentavos::show/$1');
$routes->put('ajustescentavos/(:segment)',      'AjustesCentavos::update/$1');
$routes->delete('ajustescentavos/(:segment)',   'AjustesCentavos::delete/$1');

// RUTAS PARA CIERRES PROCESOS MODIFICACIONES
//$routes->resource('cierresprocesosmodificaciones');
$routes->post('cierresprocesosmodificaciones',                'CierresProcesosModificaciones::create');
$routes->get('cierresprocesosmodificaciones',                 'CierresProcesosModificaciones::index');
$routes->get('cierresprocesosmodificaciones/(:segment)',      'CierresProcesosModificaciones::show/$1');
$routes->put('cierresprocesosmodificaciones/(:segment)',      'CierresProcesosModificaciones::update/$1');
$routes->delete('cierresprocesosmodificaciones/(:segment)',   'CierresProcesosModificaciones::delete/$1');
// RUTAS PARA CRUCE ANULADOS
//$routes->resource('cruceanulados');
$routes->get('/cruceanulados',              'CruceAnulados::index');
$routes->post('/cruceanuladosshow',        'CruceAnulados::show');
$routes->post('/cruceanuladosdelete',      'CruceAnulados::delete');
$routes->post('/cruceanuladoscreate',      'CruceAnulados::create');
$routes->put('/cruceanuladosupdate',       'CruceAnulados::update');
// RUTAS PARA ESTADOS VENTAS PAGOS
//$routes->resource('estadosventaspagos');
$routes->get('/estadosventaspagos',              'EstadosVentasPagos::index');
$routes->post('/estadosventaspagosshow',        'EstadosVentasPagos::show');
$routes->post('/estadosventaspagosdelete',      'EstadosVentasPagos::delete');
$routes->post('/estadosventaspagoscreate',      'EstadosVentasPagos::create');
$routes->put('/estadosventaspagosupdate',       'EstadosVentasPagos::update');
// RUTAS PARA FRECUENCIAS PAGO
//$routes->resource('frecuenciaspago');
$routes->get('/frecuenciaspago',              'FrecuenciasPago::index');
$routes->post('/frecuenciaspagoshow',        'FrecuenciasPago::show');
$routes->post('/frecuenciaspagodelete',      'FrecuenciasPago::delete');
$routes->post('/frecuenciaspagocreate',      'FrecuenciasPago::create');
$routes->put('/frecuenciaspagoupdate',       'FrecuenciasPago::update');
// RUTAS PARA LOGS AJUSTE CENTAVOS
//$routes->resource('logsajustecentavos');
$routes->post('logsajustecentavos',                'LogsAjusteCentavos::create');
$routes->get('logsajustecentavos',                 'LogsAjusteCentavos::index');
$routes->get('logsajustecentavos/(:segment)',      'LogsAjusteCentavos::show/$1');
$routes->put('logsajustecentavos/(:segment)',      'LogsAjusteCentavos::update/$1');
$routes->delete('logsajustecentavos/(:segment)',   'LogsAjusteCentavos::delete/$1');
// RUTAS PARA MOVIMIENTOS VENTAS
//$routes->resource('movimientosventas');
$routes->post('movimientosventas',                'MovimientosVentas::create');
$routes->get('movimientosventas',                 'MovimientosVentas::index');
$routes->get('movimientosventas/(:segment)',      'MovimientosVentas::show/$1');
$routes->put('movimientosventas/(:segment)',      'MovimientosVentas::update/$1');
$routes->delete('movimientosventas/(:segment)',   'MovimientosVentas::delete/$1');
// RUTAS PARA MOVIMIENTOS VENTAS
//$routes->resource('movimientospagos');
$routes->get('/movimientospagos',              'MovimientosPagos::index');
$routes->post('/movimientospagosshow',        'MovimientosPagos::show');
$routes->post('/movimientospagosdelete',      'MovimientosPagos::delete');
$routes->post('/movimientospagoscreate',      'MovimientosPagos::create');
$routes->put('/movimientospagosupdate',       'MovimientosPagos::update');
// RUTAS PARA PAGOS REFERENCIAS BANCARIAS DETALLE
//$routes->resource('pagosreferenciasbancariasdetalle');
$routes->get('/pagosreferenciasbancariasdetalle',              'PagosReferenciasBancariasDetalle::index');
$routes->post('/pagosreferenciasbancariasdetalleshow',        'PagosReferenciasBancariasDetalle::show');
$routes->post('/pagosreferenciasbancariasdetalledelete',      'PagosReferenciasBancariasDetalle::delete');
$routes->post('/pagosreferenciasbancariasdetallecreate',      'PagosReferenciasBancariasDetalle::create');
$routes->put('/pagosreferenciasbancariasdetalleupdate',       'PagosReferenciasBancariasDetalle::update');
// RUTAS PARA PARAMETRIZACION CENTRO COSTO
//$routes->resource('parametrizacioncentrocosto');
$routes->get('/parametrizacioncentrocosto',              'ParametrizacionCentroCosto::index');
$routes->post('/parametrizacioncentrocostoshow',        'ParametrizacionCentroCosto::show');
$routes->post('/parametrizacioncentrocostodelete',      'ParametrizacionCentroCosto::delete');
$routes->post('/parametrizacioncentrocostocreate',      'ParametrizacionCentroCosto::create');
$routes->put('/parametrizacioncentrocostoupdate',       'ParametrizacionCentroCosto::update');
// RUTAS PARA REFERENCIAS BANCARIAS CABECERA
//$routes->resource('referenciasbancariascabecera');
$routes->post('referenciasbancariascabecera',                'ReferenciasBancariasCabecera::create');
$routes->get('referenciasbancariascabecera',                 'ReferenciasBancariasCabecera::index');
$routes->get('referenciasbancariascabecera/(:segment)',      'ReferenciasBancariasCabecera::show/$1');
$routes->put('referenciasbancariascabecera/(:segment)',      'ReferenciasBancariasCabecera::update/$1');
$routes->delete('referenciasbancariascabecera/(:segment)',   'ReferenciasBancariasCabecera::delete/$1');
// RUTAS PARA RELACION PAGOS RETENCIONES
//$routes->resource('relacionpagosretenciones');
$routes->get('/relacionpagosretenciones',              'RelacionPagosRetenciones::index');
$routes->post('/relacionpagosretencionesshow',        'RelacionPagosRetenciones::show');
$routes->post('/relacionpagosretencionesdelete',      'RelacionPagosRetenciones::delete');
$routes->post('/relacionpagosretencionescreate',      'RelacionPagosRetenciones::create');
$routes->put('/relacionpagosretencionesupdate',       'RelacionPagosRetenciones::update');

// RUTAS PARA RETENCION CABECERA
//$routes->resource('retencioncabecera');
$routes->post('retencioncabecera',                'RetencionCabecera::create');
$routes->get('retencioncabecera',                 'RetencionCabecera::index');
$routes->get('retencioncabecera/(:segment)',      'RetencionCabecera::show/$1');
$routes->put('retencioncabecera/(:segment)',      'RetencionCabecera::update/$1');
$routes->delete('retencioncabecera/(:segment)',   'RetencionCabecera::delete/$1');
// RUTAS PARA RETENCION DETALLE
//$routes->resource('retenciondetalle');
$routes->get('/retenciondetalle',              'RetencionDetalle::index');
$routes->post('/retenciondetalleshow',        'RetencionDetalle::show');
$routes->post('/retenciondetalledelete',      'RetencionDetalle::delete');
$routes->post('/retenciondetallecreate',      'RetencionDetalle::create');
$routes->put('/retenciondetalleupdate',       'RetencionDetalle::update');
// RUTAS PARA RUC RAZON SOCIAL
//$routes->resource('rucrazonsocial');
$routes->get('/rucrazonsocial',              'RucRazonSocial::index');
$routes->post('/rucrazonsocialshow',        'RucRazonSocial::show');
$routes->post('/rucrazonsocialdelete',      'RucRazonSocial::delete');
$routes->post('/rucrazonsocialcreate',      'RucRazonSocial::create');
$routes->put('/rucrazonsocialupdate',       'RucRazonSocial::update');

//actualizar
$routes->get('/actualizarBancos',            'Actualizar::actualizarBancos');









$routes->get('/prueba',      'Venta::prueba');








/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
