<?php

namespace App\Controllers;

use App\Models\AjustesModel;
use App\Models\TipoCuentaModel;
use CodeIgniter\RESTful\ResourceController;

class Ajustes extends ResourceController
{

    public function ventaInsert(){
        try{
            $monto = $_POST['monto'];
            $tcredito = $_POST['tcredito'];
            $cuotas = $_POST['cuotas'];
            $lote = $_POST['lote'];
            $referencia = $_POST['referencia'];
            $autorizacion = $_POST['autorizacion'];
            $fpago = $_POST['fpago'];
            $ftransaccion = $_POST['ftransaccion'];
            $ccosto = $_POST['ccosto'];
            $ntc = $_POST['ntc'];
            $ajustes_model=new  AjustesModel();
            $datos = array(
                    "ven_codigo"=>0,
                    "ven_monto"=>$monto,
                    "ven_ajuste"=>0,
                    "ven_tarjeta_credito"=>"",
                    "ven_id_tarjeta_credito"=>0,
                    "ven_banco"=>"",
                    "ven_id_banco"=>0,
                    "ven_tipo_credito"=>$tcredito,
                    "ven_cuotas"=>$cuotas,
                    "ven_lote"=>$lote,
                    "ven_referencia"=>$referencia,
                    "ven_autorizacion"=>$autorizacion,
                    "ven_fecha_pago"=>date("Y-m-d", strtotime($fpago)),
                    "ven_fecha_transaccion"=>date("Y-m-d", strtotime($ftransaccion)),
                    "ven_centro_costo"=>$ccosto,
                    "tic_id"=>1,
                    "ven_estado"=>1,
                    "ven_voucher"=>"",
                    "ven_terminal"=>"",
                    "ven_fecha_modificacion"=>date("Y-m-d"),
                    "ven_mes_gracia"=>0,
                    "ven_status"=>"CO",
                    "ven_numero_tc"=>$ntc
                );
            $resultado = $ajustes_model->insertVenta($datos);
            return $this->respond($resultado[0]);
        } catch (Exception $e) {  
            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function tercerosInsert()
    {
        try {
            $ajustes_model=new  AjustesModel();
            $ajustes_model->truncateTerceros();
            
            $opciones = array('http' =>
                array(
                    'method'  => 'GET',
                    'header'  => array(
                        'Content-type: application/x-www-form-urlencoded',
                        'Authorization: rapidito-prod;7g::H]d<e%USiL1QTW',
                        "username: CACHAPI",
                        "password: Mega.2021",
                    ),         
                )
            );

            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents('https://api.megaprofer.com/api/indirectCustomer', false, $contexto);
            $resultado=json_decode($resultado,true);

            
            foreach ($resultado as $value) {
                $datos =array(
                    "ter_codigo"=> $value['customerRecId'],
                    "ter_nombres"=> $value['customerFullName'],
                    "ter_origen"=> $value['systemOrigen'],
                    "ter_fecha"=> date("Y-m-d", strtotime($value['createDateMessages'])),
                    "ter_estado"=> $value['customerStatus']=="true"||$value['customerStatus']==true ? 1: 0,
                );
                $ajustes_model->insertar($datos);  
            }
            
            return $this->genericResponse("Ingresado con exito",null, 200);
        } catch (Exception $e) {  
            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    
    public function dependientesInsert()
    {
        
        try {
            $ajustes_model=new  AjustesModel();
            
            $ajustes_model->truncateDependientes();
            
            
            $opciones = array('http' =>
                array(
                    'method'  => 'GET',
                    'header'  => array(
                        'Content-type: application/x-www-form-urlencoded',
                        'Authorization: rapidito-prod;7g::H]d<e%USiL1QTW',
                        "username: CACHAPI",
                        "password: Mega.2021",
                    ),         
                )
            );

            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents('https://api.megaprofer.com/api/EmployeesFranchises', false, $contexto);
            $resultado=json_decode($resultado,true);

            
            foreach ($resultado as $value) {
                $datos =array(
                    "dep_codigo"=> $value['dni'],
                    "dep_nombres"=> $value['fullName'],
                    "dep_origen"=> '',
                    "dep_fecha"=> date("Y-m-d"),
                    "dep_estado"=> $value['active']=="true"||$value['active']==true ? 1: 0,
                );
                $ajustes_model->insertarDependientes($datos);  
            }
            
            return $this->genericResponse("Ingresado con exito",null, 200);
        } catch (Exception $e) {  
            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    
    public function getNoConciliadosPago(){
        try{
            $filtro = array();
            $filtro["tic_id"]=1;
            if($this->request->getPost('pad_fecha_transaccion') != NULL){
                $pad_fecha_transaccion=$this->request->getPost('pad_fecha_transaccion');
                $filtro["pad_fecha_transaccion"]=$pad_fecha_transaccion;
            }
            if($this->request->getPost('pad_lote') != NULL){
                $pad_lote=$this->request->getPost('pad_lote');
                $filtro["pad_lote"]=$pad_lote;
            }
            if($this->request->getPost('pad_cuenta_contable_banco') != NULL){
                $pad_cuenta_contable_banco=$this->request->getPost('pad_cuenta_contable_banco');
                $filtro["pad_cuenta_contable_banco"]=$pad_cuenta_contable_banco;
            }
            if($this->request->getPost('pad_autorizacion') != NULL){
                $pad_autorizacion=$this->request->getPost('pad_autorizacion');
                $filtro["pad_autorizacion"]=$pad_autorizacion;
            }
            if($this->request->getPost('pad_tipo_tarjeta') != NULL){
                $pad_tipo_tarjeta=$this->request->getPost('pad_tipo_tarjeta');
                $filtro["pad_tipo_tarjeta"]=$pad_tipo_tarjeta;
            }
            $noConciliado = new AjustesModel();
            $datos=$noConciliado->getNoConciliadoPago($filtro);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }
        }catch(Exception $e){
            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    
    public function getNoConciliadosVentas(){
        try{
            $filtro = array();
            $filtro["tic_id"]=1;
            if($this->request->getPost('ven_fecha_transaccion') != NULL){
                $ven_fecha_transaccion=$this->request->getPost('ven_fecha_transaccion');
                $filtro["ven_fecha_transaccion"]=$ven_fecha_transaccion;
            }
            if($this->request->getPost('ven_lote') != NULL){
                $ven_lote=$this->request->getPost('ven_lote');
                $filtro["ven_lote"]=$ven_lote;
            }
            if($this->request->getPost('ven_id_banco') != NULL){
                $ven_id_banco=$this->request->getPost('ven_id_banco');
                $filtro["ven_id_banco"]=$ven_id_banco;
            }
            if($this->request->getPost('ven_autorizacion') != NULL){
                $ven_autorizacion=$this->request->getPost('ven_autorizacion');
                $filtro["ven_autorizacion"]=$ven_autorizacion;
            }
            if($this->request->getPost('ven_tarjeta_credito') != NULL){
                $ven_tarjeta_credito=$this->request->getPost('ven_tarjeta_credito');
                $filtro["ven_tarjeta_credito"]=$ven_tarjeta_credito;
            }
            $noConciliado = new AjustesModel();
            $datos=$noConciliado->getNoConciliadoVentas($filtro);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }
        }catch(Exception $e){
            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function readTerceros()
    {
        try {
            $tercero_model=new  AjustesModel();
            $datos=$tercero_model->getTodosAjustes();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    
    public function readDependientes()
    {
        try {
            $tercero_model=new  AjustesModel();
            $datos=$tercero_model->getTodosDependientes();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function readBancos()
    {
        try {
            $banco_model=new  AjustesModel();
            $datos=$banco_model->getTodosBancos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    
    public function readTipoCuenta()
    {
        try {
            $cuentas_model=new  TipoCuentaModel();
            $datos=$cuentas_model->getTipoCuenta();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function ajustesValores(){
        try{
            
            
            $datos = $this->request->getPost('array');
            $filtro = json_decode($datos);
            $filtro->aju_estado =1;
            $cobro=false;
            if(count((array)$filtro) > 1){    
                $ajuste_model = new AjustesModel();
                $filtro->aju_id="1";
                $filtro->aju_api = "";
                $ajustes = (array)$filtro->aju_ajustes;
                $aj = array();
                $detalleFranquiciado='';
                
                //Modificar monto de ventas y pagos
                for($i = 0; $i < count($ajustes); $i++){
                    $datos = (array) $ajustes[$i];
                    if($datos["DetalleCuentaContable"]=="Prestamos Franquiciados")
                    {
                        $detalleFranquiciado=$datos["DetalleCentroCosto"];
                        $datos["DetalleCentroCosto"]='';
                    }
                    if($datos["DetalleCuentaContable"]=="Anticipos"){
                        $datos["D_Valor"]=0;
                        $datos["H_Valor"]=$filtro->aju_monto;
                        $cobro==true;
                    }
                    if($datos["D_Valor"]==-1||$datos["H_Valor"]==-1){
                        $datos["D_Valor"]=0;
                        $datos["H_Valor"]=$filtro->aju_monto;
                        $cobro==true;
                    }
                    if(floatval($filtro->aju_totalajuste)==-1)
                    {
                        $filtro->aju_totalajuste=0;
                        $datos["D_Valor"]=0;
                        $datos["H_Valor"]=$filtro->aju_monto;
                        $cobro=true;
                    }
                    array_push($aj, array(
                            "referenceId_Banco"=>$datos["referenceId_Banco"],
                            "detalleBanco"=>$datos["DetalleBanco"],
                            "referenceId_CuentaContable"=>$datos["referenceId_CuentaContable"],
                            "detalleCuentaContable"=>$datos["DetalleCuentaContable"],
                            "referenceId_Tercero"=>$datos["referenceId_Tercero"],
                            "detalleTercero"=>$datos["DetalleTercero"],
                            "referenceId_Dependiente"=>$datos["referenceId_Dependiente"],
                            "detalleDependiente"=>$datos["DetalleDependiente"],
                            "detalleCentroCosto"=>$datos["DetalleCentroCosto"],
                            "detalleReferencia"=>$datos["DetalleReferencia"],
                            "detalleFranquiciado"=>$detalleFranquiciado,
                            "d_Valor"=>$datos["D_Valor"],
                            "h_Valor"=>$datos["H_Valor"],
                        ));
                    if($datos["tipoCuenta"] == "COBRO" || $cobro==true){
                        $ajuste_model->insertCobro(array(
                            "cob_fecha"=>date("Y-m-d H:i:s"),
                            "cob_cuentaid"=>$datos["referenceId_CuentaContable"],
                            "cob_cuenta"=>$datos["DetalleCuentaContable"],
                            "cob_terceroid"=>$datos["referenceId_Tercero"],
                            "cob_tercero"=>$datos["DetalleTercero"],
                            "cob_monto"=>$filtro->aju_monto,
                            "cob_debe"=>$datos["D_Valor"],
                            "cob_haber"=>$datos["H_Valor"],
                            "cob_estado"=>1
                        ));
                    }
                    $detalleFranquiciado='';
                    if($datos["DetalleCuentaContable"]=="Clientes Tarjeta de Credito"){
                        if($cobro==false){
                            switch($datos["tipoCuenta"]){
                                case "VENTA":
                                    if(floatval($datos["D_Valor"])!=0){
                                        $ajuste_model->updateVenta($datos["idAjuste"], array(
                                                "ven_monto"=>(floatval($filtro->aju_monto)+floatval($filtro->aju_totalajuste)),
                                                "ven_ajuste"=>floatval($filtro->aju_totalajuste),
                                            ));
                                        break;
                                    }
                                    if(floatval($datos["H_Valor"])!=0){
                                        $ajuste_model->updateVenta($datos["idAjuste"], array(
                                                "ven_monto"=>(floatval($filtro->aju_monto)-floatval($filtro->aju_totalajuste)),
                                                "ven_ajuste"=>floatval($filtro->aju_totalajuste),
                                            ));
                                        break;
                                    }
                                    
                                case "PAGO":
                                    if(floatval($datos["D_Valor"])!=0){
                                        $ajuste_model->updatePagos($datos["idAjuste"], array(
                                                "pad_monto_depositado"=>(floatval($filtro->aju_monto)-floatval($filtro->aju_totalajuste)),
                                                "pad_ajuste"=>floatval($filtro->aju_totalajuste),
                                            ));
                                        break;
                                    }
                                    if(floatval($datos["H_Valor"])!=0){
                                        $ajuste_model->updatePagos($datos["idAjuste"], array(
                                                "pad_monto_depositado"=>(floatval($filtro->aju_monto)+floatval($filtro->aju_totalajuste)),
                                                "pad_ajuste"=>floatval($filtro->aju_totalajuste),
                                            ));
                                        break;
                                    }
                            }
                        }
                        else {$cobro=false;}
                        
                    }
                }
                
                $temporal = $filtro;
                $registro = $ajuste_model->insertAjuste(array(
                        "aju_fecha"=>$temporal->aju_fecha,
                        "aju_nombre"=>$temporal->aju_nombre,
                        "aju_descripcion"=>$temporal->aju_descripcion,
                        "aju_lote"=>$temporal->aju_lote,
                        "aju_ntarjeta"=>$temporal->aju_ntarjeta,
                        "aju_autorizacion"=>$temporal->aju_autorizacion,
                        "aju_ttarjeta"=>$temporal->aju_ttarjeta,
                        "aju_totalajuste"=>$temporal->aju_totalajuste,
                        "aju_ajuste"=>json_encode($aj),
                        "aju_api"=>$temporal->aju_api,
                        "aju_estado"=>1
                    ));
                if(!empty($registro)){
                    $filtro->aju_id=$registro[0]["aju_id"]."";
                }
                //quitar
                //$filtro->aju_id="44";
                $datosEn = array(
                            "cabeceraId"=>$filtro->aju_id."",
                            "fecha_de_ajuste"=>$filtro->aju_fecha." 00:00:00",
                            "usuario"=>$filtro->aju_nombre."",
                            "descripcion"=>$filtro->aju_descripcion."",
                            "lote"=>$filtro->aju_lote."",
                            "numeroTarjeta"=>$filtro->aju_ntarjeta."",
                            "autorizacion"=>$filtro->aju_autorizacion."",
                            "tipoTarjeta"=>$filtro->aju_ttarjeta."",
                            "totalAjuste"=>floatval($filtro->aju_totalajuste),
                            "ajustes"=>$aj
                        );
                $enviarD = json_encode($datosEn);
                /*$opciones = array('http' =>
                    array(
                        'method'  => 'POST',
                        'header'  => array(
                            'Content-type: application/x-www-form-urlencoded',
                            'Authorization: rapidito-prod;7g::H]d<e%USiL1QTW',
                        ),       
                        'content' => $enviarD,  
                    )
                );*/
                $opciones = array('http' =>
                    array(
                        'method'  => 'POST',
                        'header'  => array(
                            'Content-type: application/json',
                            'Authorization: rapidito-int;N4RaVsn|&BaXLTIk]1',
                        ),       
                        'content' => $enviarD,  
                    )
                );
                //var_dump($opciones);
                $contexto = stream_context_create($opciones);
                //$resultado = file_get_contents('https://api.megaprofer.com/api/conciliation/sendAccountingMoveAdjustment', false, $contexto);
                $resultado = file_get_contents('https://int-api.megaprofer.com/api/conciliation/sendAccountingMoveAdjustment', false, $contexto);
                $resultado=json_decode($resultado,true);
                
                //var_dump($resultado);
                
                $filtro->aju_api=$resultado['numero_conciliacion_ajuste'];
                //quitar
                //$filtro->aju_api="1020020";
                
                $temporal = $filtro;
                
                $ajuste_model->updateAjuste($filtro->aju_id, array(
                        "aju_fecha"=>$temporal->aju_fecha,
                        "aju_nombre"=>$temporal->aju_nombre,
                        "aju_descripcion"=>$temporal->aju_descripcion,
                        "aju_lote"=>$temporal->aju_lote,
                        "aju_ntarjeta"=>$temporal->aju_ntarjeta,
                        "aju_autorizacion"=>$temporal->aju_autorizacion,
                        "aju_ttarjeta"=>$temporal->aju_ttarjeta,
                        "aju_totalajuste"=>$temporal->aju_totalajuste,
                        "aju_ajuste"=>json_encode($aj),
                        "aju_api"=>$temporal->aju_api,
                        "aju_estado"=>1
                    ));
                
                return $this->genericResponse($filtro, null, 200);
            }else{
                return $this->genericResponse(null, "No ha ingresado los valores correctos", 400);
            }

        }catch(Exception $e){
            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    private function genericResponse($data, $msj, $code)
    {
        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}