<?php

namespace App\Controllers;

use App\Models\BancoModel;
use CodeIgniter\RESTful\ResourceController;

class Banco extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $banco_model=new  BancoModel();
            $datos=$banco_model->getTodosBancos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($ban_id =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $banco_model=new  BancoModel();
            $datos=$banco_model->getUnBancos($ban_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    

    public function delete($ban_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $banco_model=new  BancoModel(); 
            $datos=$banco_model->getUnBancos($ban_id);
            if(empty($datos)){
                return $this->genericResponse(null, "No Eliminado", 404);
            }
            $datos=array(
                "ban_estado"=>0,
            );            
            
            $banco_model->eliminar($ban_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {           
            $ban_codigo=$this->request->getPost('ban_codigo');            
            $ban_nombre=$this->request->getPost('ban_nombre');
            $ban_numero_cuenta=$this->request->getPost('ban_numero_cuenta');
            $ban_cuenta_contable=$this->request->getPost('ban_cuenta_contable');
            $ban_fecha_actualizacion=$this->request->getPost('ban_fecha_actualizacion');
            $ban_tipo=$this->request->getPost('ban_tipo');            
            $ban_estado=$this->request->getPost('ban_estado');
            
            $datos =array(
                "ban_codigo"=> $ban_codigo,
                "ban_numero_cuenta"=> $ban_numero_cuenta,
                "ban_nombre"=> $ban_nombre,
                "ban_cuenta_contable"=> $ban_cuenta_contable,
                "ban_fecha_actualizacion"=> $ban_fecha_actualizacion,
                "ban_tipo"=> $ban_tipo,
                "ban_estado"=> $ban_estado,                             
            );
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "ban_codigo"=> 'required',                
                "ban_nombre"=> 'required',
                "ban_numero_cuenta"=> 'required',
                "ban_cuenta_contable"=> 'required',
                "ban_fecha_actualizacion"=> 'required',
                "ban_tipo"=> 'required',
                "ban_estado"=> 'numeric',                       
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }            
            $banco_model=new  BancoModel(); 
            $banco_model->insertar($datos);  
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ban_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ban_nombre=$datos_ingresado['ban_nombre'];
            $ban_descripcion=$datos_ingresado['ban_descripcion'];
            $ban_estado=$datos_ingresado['ban_estado'];
            
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

            
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ban_nombre"=> $ban_nombre,
                "ban_descripcion"=> $ban_descripcion,
                "ban_estado"=> $ban_estado,
                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "ban_nombre"=> 'required',
                "ban_descripcion"=> 'required',
                "ban_estado"=> 'numeric',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $banco_model=new  BancoModel(); 
            $banco_model->actualizar($ban_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$banco_model->getUnBancos($ban_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            
            

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    public function megaproferbanco()
    {

        try {
            $banco_model=new  BancoModel(); 
            
            $banco_model->truncateBancos();
            
            //$updatedDate ='2021-04-20';
            $opciones = array('http' =>
                array(
                    'method'  => 'GET',
                    'header'  => array(
                        'Content-type: application/x-www-form-urlencoded',
                        'Authorization: rapidito-prod;7g::H]d<e%USiL1QTW',
                        "username:CACHAPI",
                        "password:Mega.2021",
                    ),         
                )
            );

            $contexto = stream_context_create($opciones);
            //$resultado = file_get_contents('https://int.api.megaprofer.com/api/bankCreditCardConciliation', false, $contexto);
            $resultado = file_get_contents('https://api.megaprofer.com/api/bankCreditCardConciliation', false, $contexto);
            $resultado=json_decode($resultado,true);

            
            foreach ($resultado as $value) {
                $datos =array(
                    "ban_codigo"=> !empty($value['bankRecId'])?$value['bankRecId']:001,
                    "ban_nombre"=> $value['nameBank'],
                    "ban_numero_cuenta"=> $value['ledgerAccountBank'],
                    "ban_cuenta_contable"=> $value['systemOrigen'],
                    "ban_fecha_actualizacion"=> date("Y-m-d", strtotime($value['createDateMessage'])),
                    "ban_tipo"=> "Falta",//$value['type'],
                    "ban_estado"=> 1,
                );
                $banco_model->insertar($datos);  
            }
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    } 

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}