<?php

namespace App\Controllers;

use App\Models\BancoPagadorModel;
use CodeIgniter\RESTful\ResourceController;

class BancoPagador extends ResourceController
{
    

    public function index()
    {

        try {
            $banco_pagador_model=new  BancoPagadorModel();
            $datos=$banco_pagador_model->getBancoPagador();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function mostrar()        
    {        

        try {
            $bap_id=$this->request->getPost('bap_id');
            
            $banco_pagador_model=new  BancoPagadorModel();
            $datos=$banco_pagador_model->getUnBancoPagador($bap_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function eliminar()
    {
        try {
            $bap_id=$this->request->getPost('bap_id');

            $datos=array(
                "bap_estado"=>0,
            );            
            $banco_pagador_model=new  BancoPagadorModel();
            $banco_pagador_model->eliminar($bap_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function crear()
    {

        try {
            
            
            $bap_codigo=$this->request->getPost('bap_codigo');
            $bap_nombre=$this->request->getPost('bap_nombre');
            $bap_estado=$this->request->getPost('bap_estado');
            
            $datos =array(
                "bap_codigo"=> $bap_codigo,
                "bap_nombre"=> $bap_nombre,
                "bap_estado"=> $bap_estado,                                               
            );
            
            
            $banco_pagador_model=new  BancoPagadorModel();
            $banco_pagador_model->insertar($datos);            
            
                      
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function actualizar()
    {
        try {
            $bap_id=$this->request->getPost('bap_id');

            $bap_codigo=$this->request->getPost('bap_codigo');
            $bap_nombre=$this->request->getPost('bap_nombre');
            $bap_estado=$this->request->getPost('bap_estado');
            
            $datos =array(
                "bap_codigo"=> $bap_codigo,
                "bap_nombre"=> $bap_nombre,
                "bap_estado"=> $bap_estado,                                               
            );
            $banco_pagador_model=new  BancoPagadorModel();
            $banco_pagador_model->actualizar($bap_id,$datos);           
            
            
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}