<?php

namespace App\Controllers;

use App\Models\CierresProcesosModel;
use CodeIgniter\RESTful\ResourceController;

class CierresProcesos extends ResourceController
{
    protected $format = 'json';

    public function index()
    {
        
        try {
            $cierres_procesos_model=new  CierresProcesosModel();
            $datos=$cierres_procesos_model->getCierresProcesos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id=null)        
    
    {
        
        try {
            /*================================================
            =            Busqueda por mes y año            =
            ================================================*/
            $cip_anio_cierre =$this->request->getPost('cip_anio_cierre');        
            $cip_mes_cierre =$this->request->getPost('cip_mes_cierre');
            $cierres_procesos_model=new  CierresProcesosModel();
            $datos=$cierres_procesos_model->getCierreProceso($cip_mes_cierre,$cip_anio_cierre);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda por cip_codigo_cierre  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar por mes-año            =
            ================================================*/

            $cip_anio_cierre =$this->request->getPost('cip_anio_cierre'); 
            $cip_mes_cierre =$this->request->getPost('cip_mes_cierre');
            $datos=array(
                "cip_estado"=>0,
            );            
            $cierres_procesos_model=new  CierresProcesosModel();
            $cierres_procesos_model->eliminar($cip_mes_cierre,$cip_anio_cierre,$datos);            
            return $this->genericResponse("Eliminado con exito", null, 200);  
                        
            /*=====  End of Eliminar por ven_voucher  ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {
        
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $cip_mes_cierre =$this->request->getPost('cip_mes_cierre');
            $cip_anio_cierre =$this->request->getPost('cip_anio_cierre');            
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

            /*=============================================
            =            Datos extra para la base de datos            =
            =============================================*/            
            
            
            $cip_fecha_movimiento= date("Y-m-d");
            $cip_tipo_cierre="fin";
            $cip_usuario="Cristian";
            $cip_estado="1";
            $cip_observaciones="finalizado";
            $cip_usuario_modificacion="Cristian1";

            /*=====  End of Section Datos extra para la base de datos  ======*/
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
            
            
                "cip_mes_cierre"=> $cip_mes_cierre,
                "cip_anio_cierre"=>$cip_anio_cierre,
                "cip_fecha_movimiento"=>$cip_fecha_movimiento,                
                "cip_tipo_cierre"=>$cip_tipo_cierre,
                "cip_usuario"=>$cip_usuario,
                "cip_estado"=>$cip_estado,
                "cip_observaciones"=>$cip_observaciones,
                "cip_usuario_modificacion"=>$cip_usuario_modificacion,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                'cip_mes_cierre' => 'required|is_unique[tbl_cierres_procesos.cip_mes_cierre]',
                'cip_anio_cierre' => 'required|is_unique[tbl_cierres_procesos.cip_anio_cierre]',                
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*================================================
            =            validar datos Ingresados            =
            ================================================*/
            
            if(is_numeric($cip_mes_cierre) && $cip_mes_cierre != null){
                if(is_numeric($cip_anio_cierre) && $cip_anio_cierre != null){
                    /*============================================
                    =            Realizamos el Insert            =
                    ============================================*/
                    $cierres_procesos_model=new  CierresProcesosModel();
                    $existente=$cierres_procesos_model->getCierreProceso($cip_mes_cierre,$cip_anio_cierre);
                    if(empty($existente)){                            
                            $cierres_procesos_model->insertar($datos);
                            return $this->genericResponse("Ingresado con exito",null, 200);
                    }else{
                        return $this->genericResponse(null,'mes y año cerrado', 404);
                    }      
                    
                    /*=====  End of Realizamos el Insert  ======*/
                   
                    
                    
                }else{
                    return $this->genericResponse(null, "cip_anio_cierre no es numerico o vacio", 404);
                }
            }else{
                return $this->genericResponse(null, "cip_mes_cierre no es numerico o vacio", 404);
            }            
            /*=====  End of Section validar datos Ingresados  ======*/       

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        //PREGUNTAR:  SI SE GUARDA MARZO O 03 

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $cip_mes_cierre =$datos_ingresado['cip_mes_cierre'];
            $cip_anio_cierre =$datos_ingresado['cip_anio_cierre'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

            /*=============================================
            =            Datos extra para la base de datos            =
            =============================================*/            
            
            
            $cip_fecha_movimiento= date("Y-m-d H:i:s");
            $cip_tipo_cierre="fin";
            $cip_usuario="Cristian";
            $cip_estado="1";
            $cip_observaciones="finalizado";
            $cip_usuario_modificacion="Cristian1";

            /*=====  End of Section Datos extra para la base de datos  ======*/
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
            
            
                "cip_mes_cierre"=> $cip_mes_cierre,
                "cip_anio_cierre"=>$cip_anio_cierre,
                "cip_fecha_movimiento"=>$cip_fecha_movimiento,                
                "cip_tipo_cierre"=>$cip_tipo_cierre,
                "cip_usuario"=>$cip_usuario,
                "cip_estado"=>$cip_estado,
                "cip_observaciones"=>$cip_observaciones,
                "cip_usuario_modificacion"=>$cip_usuario_modificacion,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                'cip_mes_cierre' => 'required',
                'cip_anio_cierre' => 'required',                
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*================================================
            =            validar datos Ingresados            =
            ================================================*/
            
            if(is_numeric($cip_mes_cierre) && $cip_mes_cierre != null){
                if(is_numeric($cip_anio_cierre) && $cip_anio_cierre != null){
                    /*============================================
                    =            Realizamos el Insert            =
                    ============================================*/
                    $cierres_procesos_model=new  CierresProcesosModel();
                    $cierres_procesos_model->actualizar($cip_mes_cierre,$cip_anio_cierre,$datos);      
                    //NOSE COMO VALIDAR EL INGRESO              
                    /*=====  End of Realizamos el Insert  ======*/
                    /*=====================================================
                    =            Retornamos datos actualizados            =
                    =====================================================*/
                    $existente=$cierres_procesos_model->getCierreProceso($cip_mes_cierre,$cip_anio_cierre);
                    if(!empty($existente)){
                        return $this->genericResponse($existente, null, 200);
                    }else{
                        return $this->genericResponse(null, "No hay datos", 404);
                    }   
                    /*=====  End of Retornamos datos actualizados  ======*/
                    
                    
                    
                }else{
                    return $this->genericResponse(null, "cip_anio_cierre no es numerico o vacio", 404);
                }
            }else{
                return $this->genericResponse(null, "cip_mes_cierre no es numerico o vacio", 404);
            }            
            /*=====  End of Section validar datos Ingresados  ======*/       

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}