<?php

namespace App\Controllers;

use App\Models\CruceAnuladosModel;
use CodeIgniter\RESTful\ResourceController;

class CruceAnulados extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $cruce_anulados_model=new  CruceAnuladosModel();
            $datos=$cruce_anulados_model->getCruceAnulados();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $cra_codigo_pago1=$this->request->getPost('cra_codigo_pago1');
            $cra_numero_item1=$this->request->getPost('cra_numero_item1');
            $cra_codigo_pago2=$this->request->getPost('cra_codigo_pago2');
            $cra_numero_item2=$this->request->getPost('cra_numero_item2');
            
            $cruce_anulados_model=new  CruceAnuladosModel();
            $datos=$cruce_anulados_model->getUnCruceAnulados($cra_codigo_pago1,$cra_numero_item1,$cra_codigo_pago2,$cra_numero_item2);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $cra_codigo_pago1=$this->request->getPost('cra_codigo_pago1');
            $cra_numero_item1=$this->request->getPost('cra_numero_item1');
            $cra_codigo_pago2=$this->request->getPost('cra_codigo_pago2');
            $cra_numero_item2=$this->request->getPost('cra_numero_item2');

            $datos=array(
                "cra_estado"=>0,
            );            
            $cruce_anulados_model=new  CruceAnuladosModel();
            $cruce_anulados_model->eliminar($cra_codigo_pago1,$cra_numero_item1,$cra_codigo_pago2,$cra_numero_item2,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $cra_codigo_pago1=$this->request->getPost('cra_codigo_pago1');
            $cra_numero_item1=$this->request->getPost('cra_numero_item1');
            $cra_valor_pago1=$this->request->getPost('cra_valor_pago1');
            $cra_codigo_pago2=$this->request->getPost('cra_codigo_pago2');
            $cra_numero_item2=$this->request->getPost('cra_numero_item2');
            $cra_valor_pago2=$this->request->getPost('cra_valor_pago2');
            $cra_diferencia_pago=$this->request->getPost('cra_diferencia_pago');
            $cra_fecha_cruce=$this->request->getPost('cra_fecha_cruce');
            $cra_usuario_cruce=$this->request->getPost('cra_usuario_cruce');
            $cra_fecha_registro=$this->request->getPost('cra_fecha_registro');
            $cra_estado=$this->request->getPost('cra_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "cra_codigo_pago1"=> $cra_codigo_pago1,
                "cra_numero_item1"=> $cra_numero_item1,
                "cra_valor_pago1"=> $cra_valor_pago1,
                "cra_codigo_pago2"=> $cra_codigo_pago2,
                "cra_numero_item2"=> $cra_numero_item2,
                "cra_valor_pago2"=> $cra_valor_pago2,
                "cra_diferencia_pago"=> $cra_diferencia_pago,
                "cra_fecha_cruce"=> $cra_fecha_cruce,
                "cra_usuario_cruce"=> $cra_usuario_cruce,
                "cra_fecha_registro"=> $cra_fecha_registro, 
                "cra_estado"=> $cra_estado,               

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "cra_codigo_pago1"=> 'required',
                "cra_numero_item1"=> 'required|numeric',
                "cra_valor_pago1"=> 'required|numeric',
                "cra_codigo_pago2"=> 'required',
                "cra_numero_item2"=> 'required|numeric',
                "cra_valor_pago2"=> 'required|numeric',
                "cra_diferencia_pago"=> 'required|numeric',
                "cra_fecha_cruce"=> 'required|valid_date',
                "cra_usuario_cruce"=> 'required',
                "cra_fecha_registro"=> 'required|valid_date',  
                "cra_estado"=> 'required',             
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $cruce_anulados_model=new  CruceAnuladosModel();
            $cruce_anulados_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $cra_codigo_pago1=$datos_ingresado['cra_codigo_pago1'];
            $cra_numero_item1=$datos_ingresado['cra_numero_item1'];
            $cra_valor_pago1=$datos_ingresado['cra_valor_pago1'];
            $cra_codigo_pago2=$datos_ingresado['cra_codigo_pago2'];
            $cra_numero_item2=$datos_ingresado['cra_numero_item2'];
            $cra_valor_pago2=$datos_ingresado['cra_valor_pago2'];
            $cra_diferencia_pago=$datos_ingresado['cra_diferencia_pago'];
            $cra_fecha_cruce=$datos_ingresado['cra_fecha_cruce'];
            $cra_usuario_cruce=$datos_ingresado['cra_usuario_cruce'];
            $cra_fecha_registro=$datos_ingresado['cra_fecha_registro'];
            $cra_estado=$datos_ingresado['cra_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "cra_codigo_pago1"=> $cra_codigo_pago1,
                "cra_numero_item1"=> $cra_numero_item1,
                "cra_valor_pago1"=> $cra_valor_pago1,
                "cra_codigo_pago2"=> $cra_codigo_pago2,
                "cra_numero_item2"=> $cra_numero_item2,
                "cra_valor_pago2"=> $cra_valor_pago2,
                "cra_diferencia_pago"=> $cra_diferencia_pago,
                "cra_fecha_cruce"=> $cra_fecha_cruce,
                "cra_usuario_cruce"=> $cra_usuario_cruce,
                "cra_fecha_registro"=> $cra_fecha_registro, 
                "cra_estado"=> $cra_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "cra_codigo_pago1"=> 'required',
                "cra_numero_item1"=> 'required|numeric',
                "cra_valor_pago1"=> 'required|numeric',
                "cra_codigo_pago2"=> 'required',
                "cra_numero_item2"=> 'required|numeric',
                "cra_valor_pago2"=> 'required|numeric',
                "cra_diferencia_pago"=> 'required|numeric',
                "cra_fecha_cruce"=> 'required|valid_date',
                "cra_usuario_cruce"=> 'required',
                "cra_fecha_registro"=> 'required|valid_date',  
                "cra_estado"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $cruce_anulados_model=new  CruceAnuladosModel();
            $cruce_anulados_model->actualizar($cra_codigo_pago1,$cra_numero_item1,$cra_codigo_pago2,$cra_numero_item2,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$cruce_anulados_model->getUnCruceAnulados($cra_codigo_pago1,$cra_numero_item1,$cra_codigo_pago2,$cra_numero_item2);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}