<?php

namespace App\Controllers;

use App\Models\HistorialPagoDetalleModel;
use CodeIgniter\RESTful\ResourceController;
use App\Controllers\HistorialVenta;

class HistorialPagoDetalle extends ResourceController
{
    
    public function index(){
        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $tipo_busqueda =$this->request->getPost('tipobusqueda');
            
            $historia_pago_detalle_model= new   HistorialPagoDetalleModel();
            $datos=$historia_pago_detalle_model->gethistorialpagodetalle($desde,$hasta,$tipo_busqueda);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
    public function getultimafechacierremes(){
        try {
                        
            $historia_pago_detalle_model= new   HistorialPagoDetalleModel();
            $datos=$historia_pago_detalle_model->ultimafechacierremes();
            
            if(!empty($datos[0]['cim_hasta'])){
                $datos=$datos[0]['cim_hasta'];
            }else{
                $datos=null;
            }
            
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
    public function historial()
    {

        try {
            $historia_pago_detalle_model= new   HistorialPagoDetalleModel();
            
            
            $mes=$this->request->getPost('mes');
            $desde=date("Y-m-d", strtotime($mes));
            $hasta=date("Y-m-t", strtotime($mes));
            
            $datos_comprobarcierremes=$historia_pago_detalle_model->comprobarcierremes($desde,$hasta);

            if(!empty($datos_comprobarcierremes)){
                return $this->genericResponse(null,'Error, el mes seleccionado ya se encuentra cerrado', 400);
            }
            
            $desde_anterior=date("Y-m-d",strtotime($mes."- 1 month")); 
            $hasta_anterior=date("Y-m-t",strtotime($mes."- 1 month")); 
            $datos_comprobarcierremesanterior=$historia_pago_detalle_model->comprobarcierremesanterior($desde_anterior,$hasta_anterior);
            
            if(empty($datos_comprobarcierremesanterior)){
                return $this->genericResponse(null,'Error, aún no se ha cerrado el mes anterior al seleccionado', 400);
            }
            
            
            
            $fechas_cierre_mes=array(
                'cim_desde'=>$desde,
                'cim_hasta'=>$hasta,
                'cim_estado'=>1,
            );
            $cim_id=$historia_pago_detalle_model->insertarcierremes($fechas_cierre_mes);
            $cim_id=$cim_id[0]['cim_id'];
            
            $datos_conciliados=$historia_pago_detalle_model->selectpagodetalleconciliado($desde,$hasta,2);
            

            $datos_no_conciliados=$historia_pago_detalle_model->selectpagodetallenoconciliado($desde,$hasta,1);
            

            $hpd_fecha_cruce='';
            $tic_id=1;
            foreach ($datos_conciliados as  $value) {
                if($value['pad_fecha_transaccion']>$hasta)
                {
                    $hpd_fecha_cruce='0000-00-00';
                    $tic_id=1;
                }
                else
                {
                    $hpd_fecha_cruce=$value['pad_fecha_cruce'];
                    $tic_id=2;
                }
                $datos=array(
                    'pad_id'=>$value['pad_id'],
                    'hpd_fecha_pago'=>$value['pad_fecha_pago'],
                    'hpd_fecha_transaccion'=>$value['pad_fecha_transaccion'],
                    'hpd_fecha_cruce'=>$hpd_fecha_cruce,
                    'hpd_comercio'=>$value['pad_comercio'],
                    'hpd_numero_retencion'=>$value['pad_numero_retencion'],
                    'hpd_monto_depositado'=>$value['pad_monto_depositado'],
                    'hpd_total_pagar'=>$value['pad_total_pagar'],
                    'hpd_retencion_iva'=>$value['pad_retencion_iva'],
                    'hpd_retencion_fuente'=>$value['pad_retencion_fuente'],
                    'hpd_porcentaje_comision'=>$value['pad_porcentaje_comision'],
                    'hpd_descuento_comision'=>$value['pad_descuento_comision'],
                    'hpd_autorizacion'=>$value['pad_autorizacion'],
                    'hpd_lote'=>$value['pad_lote'],
                    'hpd_id_terminal'=>$value['pad_id_terminal'],
                    'hpd_cuenta_contable_banco'=>$value['pad_cuenta_contable_banco'],
                    'pac_id'=>$value['pac_id'],
                    'tic_id'=>$tic_id,
                    'hpd_estado'=>1,
                    'cim_id'=>$cim_id,

                );

                $historia_pago_detalle_model->insertar($datos);
            }
            foreach ($datos_no_conciliados as  $value) {
                $datos=array(
                    'pad_id'=>$value['pad_id'],
                    'hpd_fecha_pago'=>$value['pad_fecha_pago'],
                    'hpd_fecha_transaccion'=>$value['pad_fecha_transaccion'],
                    'hpd_fecha_cruce'=>$value['pad_fecha_cruce'],
                    'hpd_comercio'=>$value['pad_comercio'],
                    'hpd_numero_retencion'=>$value['pad_numero_retencion'],
                    'hpd_monto_depositado'=>$value['pad_monto_depositado'],
                    'hpd_total_pagar'=>$value['pad_total_pagar'],
                    'hpd_retencion_iva'=>$value['pad_retencion_iva'],
                    'hpd_retencion_fuente'=>$value['pad_retencion_fuente'],
                    'hpd_porcentaje_comision'=>$value['pad_porcentaje_comision'],
                    'hpd_descuento_comision'=>$value['pad_descuento_comision'],
                    'hpd_autorizacion'=>$value['pad_autorizacion'],
                    'hpd_lote'=>$value['pad_lote'],
                    'hpd_id_terminal'=>$value['pad_id_terminal'],
                    'hpd_cuenta_contable_banco'=>$value['pad_cuenta_contable_banco'],
                    'pac_id'=>$value['pac_id'],
                    'tic_id'=>$value['tic_id'],
                    'hpd_estado'=>1,
                    'cim_id'=>$cim_id,
                );

                $historia_pago_detalle_model->insertar($datos);
            }
            
            $historial_venta=new HistorialVenta();
            $historial_venta->historial($desde, $hasta, $cim_id);
            return $this->genericResponse('Cierre de mes exitoso',null, 200);
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }        
        
    }


    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}