<?php

namespace App\Controllers;

use App\Models\LogsAjusteCentavosModel;
use CodeIgniter\RESTful\ResourceController;

class LogsAjusteCentavos extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $logs_ajuste_centavos_model=new  LogsAjusteCentavosModel();
            $datos=$logs_ajuste_centavos_model->getLogsAjusteCentavos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($lac_id    =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $logs_ajuste_centavos_model=new  LogsAjusteCentavosModel();
            $datos=$logs_ajuste_centavos_model->getUnLogsAjusteCentavos($lac_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($lac_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "lac_estado"=>0,
            );            
            $logs_ajuste_centavos_model=new  LogsAjusteCentavosModel();
            $logs_ajuste_centavos_model->eliminar($lac_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $lac_usuario=$this->request->getPost('lac_usuario');
            $lac_tipo=$this->request->getPost('lac_tipo');
            $lac_cantidad=$this->request->getPost('lac_cantidad');
            $lac_fecha_ingreso=$this->request->getPost('lac_fecha_ingreso');
            $lac_estado=$this->request->getPost('lac_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "lac_usuario"=> $lac_usuario,
                "lac_tipo"=> $lac_tipo,
                "lac_cantidad"=> $lac_cantidad,
                "lac_fecha_ingreso"=> $lac_fecha_ingreso,
                "lac_estado"=> $lac_estado,                

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "lac_usuario"=> 'required',
                "lac_tipo"=> 'required',
                "lac_cantidad"=> 'required|numeric',
                "lac_fecha_ingreso"=> 'required|valid_date',
                "lac_estado"=> 'required',            
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $logs_ajuste_centavos_model=new  LogsAjusteCentavosModel();
            $logs_ajuste_centavos_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($lac_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $lac_usuario=$datos_ingresado['lac_usuario'];
            $lac_tipo=$datos_ingresado['lac_tipo'];
            $lac_cantidad=$datos_ingresado['lac_cantidad'];
            $lac_fecha_ingreso=$datos_ingresado['lac_fecha_ingreso'];
            $lac_estado=$datos_ingresado['lac_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "lac_usuario"=> $lac_usuario,
                "lac_tipo"=> $lac_tipo,
                "lac_cantidad"=> $lac_cantidad,
                "lac_fecha_ingreso"=> $lac_fecha_ingreso,
                "lac_estado"=> $lac_estado,    

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "lac_usuario"=> 'required',
                "lac_tipo"=> 'required',
                "lac_cantidad"=> 'required|numeric',
                "lac_fecha_ingreso"=> 'required|valid_date',
                "lac_estado"=> 'required',                          
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $logs_ajuste_centavos_model=new  LogsAjusteCentavosModel();
            $logs_ajuste_centavos_model->actualizar($lac_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$logs_ajuste_centavos_model->getUnLogsAjusteCentavos($lac_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}