<?php

namespace App\Controllers;

use App\Models\PagoDetalleModel;
use CodeIgniter\RESTful\ResourceController;

class PagoDetalle extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjustesCentavos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    

    public function show($ajc_id =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    public function pagonoconciliado()        
    {        

        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $tipo_busqueda =$this->request->getPost('tipobusqueda');
            
            $pago_detalle_model=new  PagoDetalleModel();
            $datos=$pago_detalle_model->getpagonoconciliado($desde,$hasta,$tipo_busqueda);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    public function pago()        
    {        

        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $tipo_busqueda =$this->request->getPost('tipobusqueda');
            
            $pago_detalle_model=new  PagoDetalleModel();
            $datos=$pago_detalle_model->getpago($desde,$hasta,$tipo_busqueda);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    public function datoconciliado($pad_id = null)
    {
        try {
            
            $datos=array(
                "tic_id"=>2,
            );            
            $pago_detalle_model=new  PagoDetalleModel();
            $pago_detalle_model->conciliado($pad_id,$datos);           
            return $this->genericResponse("Conciliado con exito", null, 200);  

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    public function datodesconciliado($pad_id = null)
    {
        try {
            
            $datos=array(
                "tic_id"=>1,
            );            
            $pago_detalle_model=new  PagoDetalleModel();
            $pago_detalle_model->conciliado($pad_id,$datos);           
            return $this->genericResponse("Conciliado con exito", null, 200);  

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    public function agregarfechacruce()
    {
        try {
            $pad_fecha_cruce =$this->request->getPost('pad_fecha_cruce');
            $pad_id =$this->request->getPost('pad_id');
            $datos=array(
                "pad_fecha_cruce"=>$pad_fecha_cruce,
            );            
            $pago_detalle_model=new  PagoDetalleModel();
            $pago_detalle_model->actualizar($pad_id,$datos);           
            return $this->genericResponse("Fecha de cruce ingresada", null, 200);  

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    public function showfiltroconciliacion()        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $pad_fecha_pago =$this->request->getPost('pad_fecha_pago');
            $pad_fecha_pago_fin =$this->request->getPost('pad_fecha_pago_fin');
            $pad_lote =$this->request->getPost('pad_lote');
            $pad_autorizacion =$this->request->getPost('pad_autorizacion');
            $pad_id_terminal =$this->request->getPost('pad_id_terminal');
            $pad_fecha_transaccion =$this->request->getPost('pad_fecha_transaccion');
            $pad_fecha_transaccion_fin =$this->request->getPost('pad_fecha_transaccion_fin');
            $tic_id =$this->request->getPost('tic_id');
            $pad_monto_depositado_min =$this->request->getPost('pad_monto_depositado_min');
            $pad_monto_depositado_max =$this->request->getPost('pad_monto_depositado_max');

            $pago_detalle_model=new  PagoDetalleModel();
            $datos=$pago_detalle_model->filtroconciliacion($pad_fecha_pago,$pad_fecha_pago_fin,$pad_lote,$pad_autorizacion,$pad_id_terminal,$pad_fecha_transaccion,$pad_fecha_transaccion_fin,$tic_id,$pad_monto_depositado_min,$pad_monto_depositado_max);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }        
    }

    public function delete($ajc_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "ajc_estado"=>0,
            );            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->eliminar($ajc_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $pad_fecha_pago=$this->request->getPost('pad_fecha_pago');
            $pad_fecha_transaccion=$this->request->getPost('pad_fecha_transaccion');
            $pad_comercio=$this->request->getPost('pad_comercio');
            $pad_numero_retencion=$this->request->getPost('pad_numero_retencion');
            $pad_monto_depositado=$this->request->getPost('pad_monto_depositado');
            $pad_total_pagar=$this->request->getPost('pad_total_pagar');
            $pad_retencion_iva=$this->request->getPost('pad_retencion_iva');
            $pad_retencion_fuente=$this->request->getPost('pad_retencion_fuente');
            $pad_porcentaje_comision=$this->request->getPost('pad_porcentaje_comision');
            $pad_descuento_comision=$this->request->getPost('pad_descuento_comision');
            $pad_autorizacion=$this->request->getPost('pad_autorizacion');
            $pad_lote=$this->request->getPost('pad_lote');
            $pad_id_terminal=$this->request->getPost('pad_id_terminal');
            $pad_cuenta_contable_banco=$this->request->getPost('pad_cuenta_contable_banco');
            $pac_id=$this->request->getPost('pac_id');
            $pad_estado=$this->request->getPost('pad_estado');
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pad_fecha_pago"=> $pad_fecha_pago,
                "pad_fecha_transaccion"=> $pad_fecha_transaccion,
                "pad_comercio"=> $pad_comercio,
                "pad_numero_retencion"=> $pad_numero_retencion,
                "pad_monto_depositado"=> $pad_monto_depositado,
                "pad_total_pagar"=> $pad_total_pagar,
                "pad_retencion_iva"=> $pad_retencion_iva,
                "pad_retencion_fuente"=> $pad_retencion_fuente,
                "pad_porcentaje_comision"=> $pad_porcentaje_comision,
                "pad_descuento_comision"=> $pad_descuento_comision,
                "pad_autorizacion"=> $pad_autorizacion,               
                "pad_lote"=> $pad_lote,
                "pad_id_terminal"=> $pad_id_terminal,
                "pad_cuenta_contable_banco"=> $pad_cuenta_contable_banco,
                "pac_id"=> $pac_id,
                "tic_id"=>1,
                "pad_estado"=> $pad_estado,
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "pad_fecha_pago"=> 'required|valid_date',
                "pad_fecha_transaccion"=> 'required|valid_date',
                "pad_comercio"=> 'required|numeric',
                "pad_numero_retencion"=> 'required|numeric',
                "pad_monto_depositado"=> 'required|numeric',
                "pad_total_pagar"=> 'required|numeric',
                "pad_retencion_iva"=> 'required|numeric',
                "pad_retencion_fuente"=> 'required|numeric',
                "pad_porcentaje_comision"=> 'required|numeric',
                "pad_descuento_comision"=> 'required|numeric',
                "pad_autorizacion"=> 'required|numeric',               
                "pad_lote"=> 'required|numeric',
                "pad_id_terminal"=> 'required|numeric',
                "pad_cuenta_contable_banco"=> 'required|numeric',
                "pac_id"=> 'required|numeric',
                "pad_estado"=> 'required|numeric',
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $pago_detalle_model=new  PagoDetalleModel();
            $resultado= $pago_detalle_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse($resultado,null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ajc_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ajc_valor_movimiento=$datos_ingresado['ajc_valor_movimiento'];
            $ajc_cuenta_contable=$datos_ingresado['ajc_cuenta_contable'];
            $ajc_fecha_contable=$datos_ingresado['ajc_fecha_contable'];
            $ajc_referencia_contable=$datos_ingresado['ajc_referencia_contable'];
            $ajc_observacion=$datos_ingresado['ajc_observacion'];
            $ajc_oficina=$datos_ingresado['ajc_oficina'];
            $ajc_sucursal=$datos_ingresado['ajc_sucursal'];
            $ajc_fecha_registro=$datos_ingresado['ajc_fecha_registro'];
            $ajc_centro_costo=$datos_ingresado['ajc_centro_costo'];
            $ajc_numero_comprobante =$datos_ingresado['ajc_numero_comprobante'];
            $ajc_usuario=$datos_ingresado['ajc_usuario'];
            $ajc_estado=$datos_ingresado['ajc_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ajc_valor_movimiento"=> $ajc_valor_movimiento,
                "ajc_cuenta_contable"=> $ajc_cuenta_contable,
                "ajc_fecha_contable"=> $ajc_fecha_contable,
                "ajc_referencia_contable"=> $ajc_referencia_contable,
                "ajc_observacion"=> $ajc_observacion,
                "ajc_oficina"=> $ajc_oficina,
                "ajc_sucursal"=> $ajc_sucursal,
                "ajc_fecha_registro"=> $ajc_fecha_registro,
                "ajc_centro_costo"=> $ajc_centro_costo,
                "ajc_numero_comprobante"=> $ajc_numero_comprobante,
                "ajc_usuario"=> $ajc_usuario,
                "ajc_estado"=> $ajc_estado,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "ajc_valor_movimiento"=> 'required',
                "ajc_cuenta_contable"=> 'required',
                "ajc_fecha_contable"=> 'required|valid_date',
                "ajc_referencia_contable"=> 'required',
                "ajc_observacion"=> 'required',
                "ajc_oficina"=> 'required',
                "ajc_sucursal"=> 'required',
                "ajc_fecha_registro"=> 'required|valid_date',
                "ajc_centro_costo"=> 'required',
                "ajc_numero_comprobante"=> 'required|numeric',
                "ajc_usuario"=> 'required',
                "ajc_estado"=> 'required|numeric',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->actualizar($ajc_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
    public function updateobservacionpago()
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $pad_observacion=$datos_ingresado['pad_observacion'];
            $pad_id=$datos_ingresado['pad_id'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pad_observacion"=> $pad_observacion,       
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "pad_observacion"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
               // return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $pago_detalle_model=new  PagoDetalleModel();
            $pago_detalle_model->actualizar($pad_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$pago_detalle_model->getPagosDetalleTotalAjuste($pad_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
}