<?php

namespace App\Controllers;

use App\Models\PagosReferenciasBancariasDetalleModel;
use CodeIgniter\RESTful\ResourceController;

class PagosReferenciasBancariasDetalle extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $pagos_referencias_bancarias_detalle_model=new  PagosReferenciasBancariasDetalleModel();
            $datos=$pagos_referencias_bancarias_detalle_model->getPagosReferenciasBancariasDetalle();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id=null)        
    {


        try {
            /*================================================
            =            Busqueda por mes y año            =
            ================================================*/
            $pac_codigo_archivo  =$this->request->getPost('pac_codigo_archivo');        
            $rbc_codigo_referencia_bancaria  =$this->request->getPost('rbc_codigo_referencia_bancaria');
            $prb_referencia_bancaria  =$this->request->getPost('prb_referencia_bancaria');
            $pagos_referencias_bancarias_detalle_model=new  PagosReferenciasBancariasDetalleModel();
            $datos=$pagos_referencias_bancarias_detalle_model->getUnPagosReferenciasBancariasDetalle($pac_codigo_archivo,$rbc_codigo_referencia_bancaria,$prb_referencia_bancaria);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda por cip_codigo_cierre  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar por mes-año            =
            ================================================*/

            $pac_codigo_archivo  =$this->request->getPost('pac_codigo_archivo');        
            $rbc_codigo_referencia_bancaria  =$this->request->getPost('rbc_codigo_referencia_bancaria');
            $prb_referencia_bancaria  =$this->request->getPost('prb_referencia_bancaria');
            
            $datos=array(
                "prb_estado"=>0,
            );            
            $pagos_referencias_bancarias_detalle_model=new  PagosReferenciasBancariasDetalleModel();
            $pagos_referencias_bancarias_detalle_model->eliminar($pac_codigo_archivo,$rbc_codigo_referencia_bancaria,$prb_referencia_bancaria,$datos);            
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar por ven_voucher  ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {
        
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $pac_codigo_archivo=$this->request->getPost('pac_codigo_archivo');
            $prb_referencia_bancaria=$this->request->getPost('prb_referencia_bancaria');
            $prb_valor=$this->request->getPost('prb_valor');
            $rbc_codigo_referencia_bancaria=$this->request->getPost('rbc_codigo_referencia_bancaria');
            $prb_tipo_registro=$this->request->getPost('prb_tipo_registro');
            $prb_fecha_deposito_bancario=$this->request->getPost('prb_fecha_deposito_bancario');
            $prb_fecha_ingreso_registor=$this->request->getPost('prb_fecha_ingreso_registor');
            $prb_usuario_registro=$this->request->getPost('prb_usuario_registro');
            $prb_estado=$this->request->getPost('prb_estado');
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

            
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(

                "pac_codigo_archivo"=> $pac_codigo_archivo,
                "prb_referencia_bancaria"=> $prb_referencia_bancaria,
                "prb_valor"=> $prb_valor,
                "rbc_codigo_referencia_bancaria"=> $rbc_codigo_referencia_bancaria,
                "prb_tipo_registro"=> $prb_tipo_registro,
                "prb_fecha_deposito_bancario"=> $prb_fecha_deposito_bancario,
                "prb_fecha_ingreso_registor"=> $prb_fecha_ingreso_registor,
                "prb_usuario_registro"=> $prb_usuario_registro,
                "prb_estado"=> $prb_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([


                "pac_codigo_archivo"=>'required',
                "prb_referencia_bancaria"=> 'required',
                "prb_valor"=> 'required|numeric',
                "rbc_codigo_referencia_bancaria"=> 'required',
                "prb_tipo_registro"=> 'required',
                "prb_fecha_deposito_bancario"=> 'required|valid_date',
                "prb_fecha_ingreso_registor"=> 'required|valid_date',
                "prb_usuario_registro"=> 'required',
                "prb_estado"=> 'required',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*================================================
            =             Ingresar          =
            ================================================*/
            $pagos_referencias_bancarias_detalle_model=new  PagosReferenciasBancariasDetalleModel();
            $pagos_referencias_bancarias_detalle_model->insertar($datos);
            return $this->genericResponse("ingresado con exito", null, 200);
            /*=====  End of Section Ingresar  ======*/       

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        //PREGUNTAR:  SI SE GUARDA MARZO O 03 

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $pac_codigo_archivo=$datos_ingresado['pac_codigo_archivo'];
            $prb_referencia_bancaria=$datos_ingresado['prb_referencia_bancaria'];
            $prb_valor=$datos_ingresado['prb_valor'];
            $rbc_codigo_referencia_bancaria=$datos_ingresado['rbc_codigo_referencia_bancaria'];
            $prb_tipo_registro=$datos_ingresado['prb_tipo_registro'];
            $prb_fecha_deposito_bancario=$datos_ingresado['prb_fecha_deposito_bancario'];
            $prb_fecha_ingreso_registor=$datos_ingresado['prb_fecha_ingreso_registor'];
            $prb_usuario_registro=$datos_ingresado['prb_usuario_registro'];
            $prb_estado=$datos_ingresado['prb_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

            
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pac_codigo_archivo"=> $pac_codigo_archivo,
                "prb_referencia_bancaria"=> $prb_referencia_bancaria,
                "prb_valor"=> $prb_valor,
                "rbc_codigo_referencia_bancaria"=> $rbc_codigo_referencia_bancaria,
                "prb_tipo_registro"=> $prb_tipo_registro,
                "prb_fecha_deposito_bancario"=> $prb_fecha_deposito_bancario,
                "prb_fecha_ingreso_registor"=> $prb_fecha_ingreso_registor,
                "prb_usuario_registro"=> $prb_usuario_registro,
                "prb_estado"=> $prb_estado,               
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "pac_codigo_archivo"=>'required',
                "prb_referencia_bancaria"=> 'required',
                "prb_valor"=> 'required|numeric',
                "rbc_codigo_referencia_bancaria"=> 'required',
                "prb_tipo_registro"=> 'required',
                "prb_fecha_deposito_bancario"=> 'required|valid_date',
                "prb_fecha_ingreso_registor"=> 'required|valid_date',
                "prb_usuario_registro"=> 'required',
                "prb_estado"=> 'required',                
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            $pagos_referencias_bancarias_detalle_model=new  PagosReferenciasBancariasDetalleModel();
            $pagos_referencias_bancarias_detalle_model->actualizar($pac_codigo_archivo,$rbc_codigo_referencia_bancaria,$prb_referencia_bancaria,$datos);      

            $existente=$pagos_referencias_bancarias_detalle_model->getUnPagosReferenciasBancariasDetalle($pac_codigo_archivo,$rbc_codigo_referencia_bancaria,$prb_referencia_bancaria);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Retornamos datos actualizados  ======*/

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}