<?php

namespace App\Controllers;

use App\Models\RelacionBancoTipoPagoModel;
use CodeIgniter\RESTful\ResourceController;

class RelacionBancoTipoPago extends ResourceController
{


    public function index()
    {

        try {
            $relacion_banco_tipo_pago_model=new  RelacionBancoTipoPagoModel();
            $datos=$relacion_banco_tipo_pago_model->getTodoRelacionBancoTipoPago();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function mostrar()        
    {        

        try {

            $rbt_id =$this->request->getPost('rbt_id');
            $relacion_banco_tipo_pago_model=new  RelacionBancoTipoPagoModel();
            $datos=$relacion_banco_tipo_pago_model->getUnRelacionBancoTipoPago($rbt_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    public function obtenerpocentajecomision()        
    {        

        try {
            $pad_cuenta_contable_banco   =$this->request->getPost('pad_cuenta_contable_banco');
            $ban_codigo_banco =$this->request->getPost('ban_codigo_banco');
            $tac_codigo =$this->request->getPost('tac_codigo');
            $tip_tipo_pago =$this->request->getPost('tip_tipo_pago');
            $rbt_meses_gracia =$this->request->getPost('rbt_meses_gracia');
            $rbt_numero_cuotas =$this->request->getPost('rbt_numero_cuotas');



            $relacion_banco_tipo_pago_model=new  RelacionBancoTipoPagoModel();
            $datos=$relacion_banco_tipo_pago_model->getPorcentajedecomision($pad_cuenta_contable_banco,$ban_codigo_banco,$tac_codigo,$tip_tipo_pago,$rbt_meses_gracia,$rbt_numero_cuotas);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    

    public function eliminar()
    {
        try {
            $rbt_id =$this->request->getPost('rbt_id');
            $relacion_banco_tipo_pago_model=new  RelacionBancoTipoPagoModel();
            $datos=array(
                "rbt_estado"=>0,
            );            

            $relacion_banco_tipo_pago_model->eliminar($rbt_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function crear()
    {

        try {

            $bap_id=$this->request->getPost('bap_id');
            $ban_codigo_banco =$this->request->getPost('ban_codigo_banco');
            $tac_codigo=$this->request->getPost('tac_codigo');
            $tip_id=$this->request->getPost('tip_id');
            $rbt_meses_gracia=$this->request->getPost('rbt_meses_gracia');
            $rbt_numero_cuotas=$this->request->getPost('rbt_numero_cuotas');
            $rbt_porcentaje_comision=$this->request->getPost('rbt_porcentaje_comision');
            $rbt_frecuencia_pago=$this->request->getPost('rbt_frecuencia_pago');
            $rbt_fecha_creacion=$this->request->getPost('rbt_fecha_creacion');
            $rbt_id_usuario=$this->request->getPost('rbt_id_usuario');
            $rbt_nombre_usuario=$this->request->getPost('rbt_nombre_usuario');
            $rbt_estado=$this->request->getPost('rbt_estado');
            $rbt_fecha_contable=$this->request->getPost('rbt_fecha_contable');
            $rbt_fecha_modificacion=$this->request->getPost('rbt_fecha_modificacion');
            $rbt_id_usuario_modificacion =$this->request->getPost('rbt_id_usuario_modificacion');
            $rbt_nombre_usuario_modificacion =$this->request->getPost('rbt_nombre_usuario_modificacion');
            $rbt_fecha_desde=$this->request->getPost('rbt_fecha_desde');
            $rbt_fecha_hasta=$this->request->getPost('rbt_fecha_hasta');
            $rbt_porcentaje_feriado =$this->request->getPost('rbt_porcentaje_feriado');
            
            
            
            $datos =array(
                "bap_id"=> $bap_id ,
                "ban_codigo_banco"=> $ban_codigo_banco ,
                "tac_codigo"=> $tac_codigo ,
                "tip_id"=> $tip_id ,
                "rbt_meses_gracia"=> $rbt_meses_gracia ,
                "rbt_numero_cuotas"=> $rbt_numero_cuotas ,
                "rbt_porcentaje_comision"=> $rbt_porcentaje_comision ,
                "rbt_frecuencia_pago"=> $rbt_frecuencia_pago ,
                "rbt_fecha_creacion"=> $rbt_fecha_creacion ,
                "rbt_id_usuario"=> $rbt_id_usuario ,
                "rbt_nombre_usuario"=> $rbt_nombre_usuario ,
                "rbt_fecha_contable"=> $rbt_fecha_contable ,
                "rbt_fecha_modificacion"=> $rbt_fecha_modificacion ,
                "rbt_id_usuario_modificacion"=> $rbt_id_usuario_modificacion ,
                "rbt_nombre_usuario_modificacion"=> $rbt_nombre_usuario_modificacion ,
                "rbt_estado"=> $rbt_estado ,

                "rbt_fecha_desde"=> $rbt_fecha_desde ,
                "rbt_fecha_hasta"=> $rbt_fecha_hasta ,
                "rbt_porcentaje_feriado"=> $rbt_porcentaje_feriado ,
            );
            
            
            $relacion_banco_tipo_pago_model=new  RelacionBancoTipoPagoModel();
            $relacion_banco_tipo_pago_model->insertar($datos);            
            

            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function actualizar()
    {
        try {

            $relacion_banco_tipo_pago_model=new  RelacionBancoTipoPagoModel();
            $rbt_id =$this->request->getPost('rbt_id');

            $datos_relacion_banco_tipo_pago=$relacion_banco_tipo_pago_model->getUnRelacionBancoTipoPago($rbt_id);
            

            if(empty($datos_relacion_banco_tipo_pago)){
                return $this->genericResponse(null, "No hay datos", 404);
            }





            $bap_id=$this->request->getPost('bap_id');
            if(empty($bap_id)){
                $bap_id=$datos_relacion_banco_tipo_pago[0]['bap_id'];
            }

            $ban_codigo_banco =$this->request->getPost('ban_codigo_banco');
            if(empty($ban_codigo_banco)){
                $ban_codigo_banco=$datos_relacion_banco_tipo_pago[0]['ban_codigo_banco'];
            }

            $tac_codigo=$this->request->getPost('tac_codigo');
            if(empty($tac_codigo)){
                $tac_codigo=$datos_relacion_banco_tipo_pago[0]['tac_codigo'];
            }

            $tip_id=$this->request->getPost('tip_id');
            if(empty($tip_id)){
                $tip_id=$datos_relacion_banco_tipo_pago[0]['tip_id'];
            }

            $rbt_meses_gracia=$this->request->getPost('rbt_meses_gracia');
            if(empty($rbt_meses_gracia)){
                $rbt_meses_gracia=$datos_relacion_banco_tipo_pago[0]['rbt_meses_gracia'];
            }

            $rbt_numero_cuotas=$this->request->getPost('rbt_numero_cuotas');
            if(empty($rbt_numero_cuotas)){
                $rbt_numero_cuotas=$datos_relacion_banco_tipo_pago[0]['rbt_numero_cuotas'];
            }

            $rbt_porcentaje_comision=$this->request->getPost('rbt_porcentaje_comision');
            if(empty($rbt_porcentaje_comision)){
                $rbt_porcentaje_comision=$datos_relacion_banco_tipo_pago[0]['rbt_porcentaje_comision'];
            }

            $rbt_frecuencia_pago=$this->request->getPost('rbt_frecuencia_pago');
            if(empty($rbt_frecuencia_pago)){
                $rbt_frecuencia_pago=$datos_relacion_banco_tipo_pago[0]['rbt_frecuencia_pago'];
            }

            

            $rbt_id_usuario=$this->request->getPost('rbt_id_usuario');
            if(empty($rbt_id_usuario)){
                $rbt_id_usuario=$datos_relacion_banco_tipo_pago[0]['rbt_id_usuario'];
            }

            $rbt_nombre_usuario=$this->request->getPost('rbt_nombre_usuario');
            if(empty($rbt_nombre_usuario)){
                $rbt_nombre_usuario=$datos_relacion_banco_tipo_pago[0]['rbt_nombre_usuario'];
            }

            $rbt_estado=$this->request->getPost('rbt_estado');
            if(empty($rbt_estado)){
                $rbt_estado=$datos_relacion_banco_tipo_pago[0]['rbt_estado'];
            }

            $rbt_fecha_contable=$this->request->getPost('rbt_fecha_contable');
            if(empty($rbt_fecha_contable)){
                $rbt_fecha_contable=$datos_relacion_banco_tipo_pago[0]['rbt_fecha_contable'];
            }

            $rbt_fecha_modificacion=$this->request->getPost('rbt_fecha_modificacion');
            if(empty($rbt_fecha_modificacion)){
                $rbt_fecha_modificacion=$datos_relacion_banco_tipo_pago[0]['rbt_fecha_modificacion'];
            }

            $rbt_id_usuario_modificacion =$this->request->getPost('rbt_id_usuario_modificacion');
            if(empty($rbt_id_usuario_modificacion)){
                $rbt_id_usuario_modificacion=$datos_relacion_banco_tipo_pago[0]['rbt_id_usuario_modificacion'];
            }

            $rbt_nombre_usuario_modificacion =$this->request->getPost('rbt_nombre_usuario_modificacion');
            if(empty($rbt_nombre_usuario_modificacion)){
                $rbt_nombre_usuario_modificacion=$datos_relacion_banco_tipo_pago[0]['rbt_nombre_usuario_modificacion'];
            }
            

            $rbt_fecha_desde=$this->request->getPost('rbt_fecha_desde');
            $rbt_fecha_hasta=$this->request->getPost('rbt_fecha_hasta');
            $rbt_porcentaje_feriado =$this->request->getPost('rbt_porcentaje_feriado');
            
            
            $datos =array(
                "bap_id"=> $bap_id ,
                "ban_codigo_banco"=> $ban_codigo_banco ,
                "tac_codigo"=> $tac_codigo ,
                "tip_id"=> $tip_id ,
                "rbt_meses_gracia"=> $rbt_meses_gracia ,
                "rbt_numero_cuotas"=> $rbt_numero_cuotas ,
                "rbt_porcentaje_comision"=> $rbt_porcentaje_comision ,
                "rbt_frecuencia_pago"=> $rbt_frecuencia_pago ,                
                "rbt_id_usuario"=> $rbt_id_usuario ,
                "rbt_fecha_contable"=> $rbt_fecha_contable ,
                "rbt_fecha_modificacion"=> $rbt_fecha_modificacion ,
                "rbt_id_usuario_modificacion"=> $rbt_id_usuario_modificacion ,
                "rbt_nombre_usuario_modificacion"=> $rbt_nombre_usuario_modificacion ,
                "rbt_estado"=> $rbt_estado ,

                "rbt_fecha_desde"=> $rbt_fecha_desde ,
                "rbt_fecha_hasta"=> $rbt_fecha_hasta ,
                "rbt_porcentaje_feriado"=> $rbt_porcentaje_feriado ,
            );
            
            

            
            $relacion_banco_tipo_pago_model->actualizar($rbt_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$relacion_banco_tipo_pago_model->getUnRelacionBancoTipoPago($rbt_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}