<?php

namespace App\Controllers;

use App\Models\RucRazonSocialModel;
use CodeIgniter\RESTful\ResourceController;

class RucRazonSocial extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $ruc_razon_social_model=new  RucRazonSocialModel();
            $datos=$ruc_razon_social_model->getRucRazonSocial();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $bap_codigo_banco =$this->request->getPost('bap_codigo_banco');
            $rrs_ruc =$this->request->getPost('rrs_ruc');
            
            $ruc_razon_social_model=new  RucRazonSocialModel();
            $datos=$ruc_razon_social_model->getUnRucRazonSocial($bap_codigo_banco,$rrs_ruc);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $bap_codigo_banco =$this->request->getPost('bap_codigo_banco');
            $rrs_ruc =$this->request->getPost('rrs_ruc');

            $datos=array(
                "rrs_estado"=>0,
            );            
            $ruc_razon_social_model=new  RucRazonSocialModel();
            $ruc_razon_social_model->eliminar($bap_codigo_banco,$rrs_ruc,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            
            $bap_codigo_banco=$this->request->getPost('bap_codigo_banco');
            $rrs_ruc=$this->request->getPost('rrs_ruc');
            $rrs_razon_social=$this->request->getPost('rrs_razon_social');
            $rrs_estado=$this->request->getPost('rrs_estado');
            $rrs_autorizacion_sri=$this->request->getPost('rrs_autorizacion_sri');
            $rrs_fecha_caducidad=$this->request->getPost('rrs_fecha_caducidad');
            $rrs_numero_serie=$this->request->getPost('rrs_numero_serie');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "bap_codigo_banco"=> $bap_codigo_banco,
                "rrs_ruc"=> $rrs_ruc,
                "rrs_razon_social"=> $rrs_razon_social,
                "rrs_estado"=> $rrs_estado,
                "rrs_autorizacion_sri"=> $rrs_autorizacion_sri,
                "rrs_fecha_caducidad"=> $rrs_fecha_caducidad,
                "rrs_numero_serie"=> $rrs_numero_serie,
                             

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  


                "bap_codigo_banco"=> 'required',
                "rrs_ruc"=> 'required',
                "rrs_razon_social"=> 'required',
                "rrs_estado"=> 'required',
                "rrs_autorizacion_sri"=> 'required',
                "rrs_fecha_caducidad"=> 'required|valid_date',
                "rrs_numero_serie"=> 'required|numeric',           
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $ruc_razon_social_model=new  RucRazonSocialModel();
            $ruc_razon_social_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $bap_codigo_banco=$datos_ingresado['bap_codigo_banco'];
            $rrs_ruc=$datos_ingresado['rrs_ruc'];
            $rrs_razon_social=$datos_ingresado['rrs_razon_social'];
            $rrs_estado=$datos_ingresado['rrs_estado'];
            $rrs_autorizacion_sri=$datos_ingresado['rrs_autorizacion_sri'];
            $rrs_fecha_caducidad=$datos_ingresado['rrs_fecha_caducidad'];
            $rrs_numero_serie=$datos_ingresado['rrs_numero_serie'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "bap_codigo_banco"=> $bap_codigo_banco,
                "rrs_ruc"=> $rrs_ruc,
                "rrs_razon_social"=> $rrs_razon_social,
                "rrs_estado"=> $rrs_estado,
                "rrs_autorizacion_sri"=> $rrs_autorizacion_sri,
                "rrs_fecha_caducidad"=> $rrs_fecha_caducidad,
                "rrs_numero_serie"=> $rrs_numero_serie,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "bap_codigo_banco"=> 'required',
                "rrs_ruc"=> 'required',
                "rrs_razon_social"=> 'required',
                "rrs_estado"=> 'required',
                "rrs_autorizacion_sri"=> 'required',
                "rrs_fecha_caducidad"=> 'required|valid_date',
                "rrs_numero_serie"=> 'required|numeric',                   
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $ruc_razon_social_model=new  RucRazonSocialModel();
            $ruc_razon_social_model->actualizar($bap_codigo_banco,$rrs_ruc,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$ruc_razon_social_model->getUnRucRazonSocial($bap_codigo_banco,$rrs_ruc);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}