<?php

namespace App\Controllers;

use App\Models\TipoCuentaModel;
use CodeIgniter\RESTful\ResourceController;

class TipoCuenta extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjustesCentavos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($ajc_id =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($ajc_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "ajc_estado"=>0,
            );            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->eliminar($ajc_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {



            $tcu_codigo=$this->request->getPost('tcu_codigo');
            $tcu_descripcion=$this->request->getPost('tcu_descripcion');
            $tcu_tipo=$this->request->getPost('tcu_tipo');
            $tcu_fecha_modificacion=$this->request->getPost('tcu_fecha_modificacion');
            $tcu_estado=$this->request->getPost('tcu_estado');
            
            $datos =array(
                "tcu_codigo"=> $tcu_codigo,
                "tcu_descripcion"=> $tcu_descripcion,
                "tcu_tipo"=> $tcu_tipo,
                "tcu_fecha_modificacion"=> $tcu_fecha_modificacion,
                "tcu_estado"=> $tcu_estado,

            );    
            $tipo_cuenta_model=new  TipoCuentaModel();
            $tipo_cuenta_model->insertar($datos);            
            

            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ajc_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ajc_valor_movimiento=$datos_ingresado['ajc_valor_movimiento'];
            $ajc_cuenta_contable=$datos_ingresado['ajc_cuenta_contable'];
            $ajc_fecha_contable=$datos_ingresado['ajc_fecha_contable'];
            $ajc_referencia_contable=$datos_ingresado['ajc_referencia_contable'];
            $ajc_observacion=$datos_ingresado['ajc_observacion'];
            $ajc_oficina=$datos_ingresado['ajc_oficina'];
            $ajc_sucursal=$datos_ingresado['ajc_sucursal'];
            $ajc_fecha_registro=$datos_ingresado['ajc_fecha_registro'];
            $ajc_centro_costo=$datos_ingresado['ajc_centro_costo'];
            $ajc_numero_comprobante =$datos_ingresado['ajc_numero_comprobante'];
            $ajc_usuario=$datos_ingresado['ajc_usuario'];
            $ajc_estado=$datos_ingresado['ajc_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ajc_valor_movimiento"=> $ajc_valor_movimiento,
                "ajc_cuenta_contable"=> $ajc_cuenta_contable,
                "ajc_fecha_contable"=> $ajc_fecha_contable,
                "ajc_referencia_contable"=> $ajc_referencia_contable,
                "ajc_observacion"=> $ajc_observacion,
                "ajc_oficina"=> $ajc_oficina,
                "ajc_sucursal"=> $ajc_sucursal,
                "ajc_fecha_registro"=> $ajc_fecha_registro,
                "ajc_centro_costo"=> $ajc_centro_costo,
                "ajc_numero_comprobante"=> $ajc_numero_comprobante,
                "ajc_usuario"=> $ajc_usuario,
                "ajc_estado"=> $ajc_estado,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "ajc_valor_movimiento"=> 'required',
                "ajc_cuenta_contable"=> 'required',
                "ajc_fecha_contable"=> 'required|valid_date',
                "ajc_referencia_contable"=> 'required',
                "ajc_observacion"=> 'required',
                "ajc_oficina"=> 'required',
                "ajc_sucursal"=> 'required',
                "ajc_fecha_registro"=> 'required|valid_date',
                "ajc_centro_costo"=> 'required',
                "ajc_numero_comprobante"=> 'required|numeric',
                "ajc_usuario"=> 'required',
                "ajc_estado"=> 'required|numeric',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->actualizar($ajc_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
    public function megaprofertipocuenta()
    {
        try {

            $tipo_cuenta_model=new  TipoCuentaModel();
            $tipo_cuenta_model->truncateTipoCuentas();
            
            $opciones = array('http' =>
                array(
                    'method'  => 'GET',
                    'header'  => array(
                        'Content-type: application/x-www-form-urlencoded',
                        'Authorization: rapidito-prod;7g::H]d<e%USiL1QTW',
                        'username:CACHAPI',
                        "password:Mega.2021",
                    ),         
                )
            );

            $contexto = stream_context_create($opciones);
            //$resultado = file_get_contents('https://int.api.megaprofer.com/api/reportLedgerAccount', false, $contexto);
            $resultado = file_get_contents('https://api.megaprofer.com/api/reportLedgerAccount', false, $contexto);
            $resultado=json_decode($resultado,true);

            
            foreach ($resultado as $value) {
                $datos =array(
                    "tcu_codigo"=> $value['ledgerAccountRecId'],
                    "tcu_descripcion"=> $value['ledgerAccountDescription'],
                    "tcu_tipo"=> $value['systemOrigen'],
                    "tcu_fecha_modificacion"=> date("Y-m-d", strtotime($value['createDateMessage'])),
                    "tcu_estado"=> 1,
                    "tcu_cuenta"=> $value['ledgerAccountNumber'],
                );
                $tipo_cuenta_model->insertar($datos);  
            }
            return $this->genericResponse("Ingresado con exito",null, 200);     


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
    
}