<?php

namespace App\Controllers;

use App\Models\VentaModel;
use CodeIgniter\RESTful\ResourceController;

class Venta extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $venta_model=new  VentaModel();
            $datos=$venta_model->getVenta();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    public function mayornoconciliado()
    {

        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $venta_model=new  VentaModel();
            $datos=$venta_model->getmayornoconciliado($desde,$hasta);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    
    public function mayor()
    {

        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $venta_model=new  VentaModel();
            $datos=$venta_model->getMayor($desde,$hasta);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    
    public function show($ven_id =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $venta_model=new  VentaModel();
            $datos=$venta_model->getUnaVenta($ven_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function showfiltroconciliacion()        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $ven_fecha_pago =$this->request->getPost('ven_fecha_pago');
            $ven_lote =$this->request->getPost('ven_lote');
            $ven_autorizacion =$this->request->getPost('ven_autorizacion');
            $ven_centro_costo =$this->request->getPost('ven_centro_costo');
            $ven_fecha_transaccion_fin =$this->request->getPost('ven_fecha_transaccion_fin');
            $ven_fecha_transaccion =$this->request->getPost('ven_fecha_transaccion');
            $tic_id =$this->request->getPost('tic_id');
            $ven_monto_min =$this->request->getPost('ven_monto_min');
            $ven_monto_max =$this->request->getPost('ven_monto_max');

            $venta_model=new  VentaModel();
            $datos=$venta_model->filtroconciliacion($ven_fecha_pago,$ven_lote,$ven_autorizacion,$ven_centro_costo,$ven_fecha_transaccion,$ven_fecha_transaccion_fin,$tic_id,$ven_monto_min,$ven_monto_max);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($ven_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "ven_estado"=>0,
            );            
            $venta_model=new  VentaModel();
            $venta_model->eliminar($ven_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    public function datoconciliado($ven_id = null)
    {
        try {

            $datos=array(
                "tic_id"=>2,
            );            
            $venta_model=new  VentaModel();
            $venta_model->conciliado($ven_id,$datos);           
            return $this->genericResponse("Conciliado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    public function datodesconciliado($ven_id = null)
    {
        try {

            $datos=array(
                "tic_id"=>1,
            );            
            $venta_model=new  VentaModel();
            $venta_model->conciliado($ven_id,$datos);           
            return $this->genericResponse("Conciliado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {

            $ven_codigo=$this->request->getPost('ven_codigo');
            $ven_monto=$this->request->getPost('ven_monto');
            $ven_tarjeta_credito=$this->request->getPost('ven_tarjeta_credito');
            $ven_id_tarjeta_credito=$this->request->getPost('ven_id_tarjeta_credito');
            $ven_banco=$this->request->getPost('ven_banco');
            $ven_tipo_credito=$this->request->getPost('ven_tipo_credito');
            $ven_cuotas=$this->request->getPost('ven_cuotas');
            $ven_lote=$this->request->getPost('ven_lote');
            $ven_referencia=$this->request->getPost('ven_referencia');
            $ven_autorizacion=$this->request->getPost('ven_autorizacion');

            $ven_fecha_pago=$this->request->getPost('ven_fecha_pago');
            $ven_fecha_transaccion=$this->request->getPost('ven_fecha_transaccion');
            $ven_centro_costo=$this->request->getPost('ven_centro_costo');
            $tic_id=$this->request->getPost('tic_id');
            $ven_voucher=$this->request->getPost('ven_voucher');
            $ven_id_banco=$this->request->getPost('ven_id_banco');
            $ven_fecha_modificacion=$this->request->getPost('ven_fecha_modificacion');
            $ven_mes_gracia=$this->request->getPost('ven_mes_gracia');
            $ven_terminal=$this->request->getPost('ven_terminal');
            $ven_status=$this->request->getPost('ven_status');
            $ven_estado=$this->request->getPost('ven_estado');
            
            
            
            $datos =array(
                "ven_codigo"=> $ven_codigo,
                "ven_monto"=> $ven_monto,
                "ven_tarjeta_credito"=> $ven_tarjeta_credito,
                "ven_id_tarjeta_credito"=> $ven_id_tarjeta_credito,
                "ven_banco"=> $ven_banco,
                "ven_tipo_credito"=> $ven_tipo_credito,
                "ven_cuotas"=> $ven_cuotas,
                "ven_lote"=> $ven_lote,
                "ven_referencia"=> $ven_referencia,
                "ven_autorizacion"=> $ven_autorizacion,
                "ven_fecha_pago"=> $ven_fecha_pago,
                "ven_fecha_transaccion"=> $ven_fecha_transaccion,
                "ven_centro_costo"=> $ven_centro_costo,
                "tic_id"=> $tic_id,
                "ven_voucher"=> $ven_voucher,
                "ven_id_banco"=> $ven_id_banco,
                "ven_fecha_modificacion"=> $ven_fecha_modificacion,
                "ven_mes_gracia"=> $ven_mes_gracia,
                "ven_terminal"=> $ven_terminal,
                "ven_status"=> $ven_status,
                "ven_estado"=> $ven_estado,               
            );
            
            //return $this->genericResponse($datos,null, 200);
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "ven_codigo"=> 'required',
                "ven_monto"=> 'required|numeric',
                "ven_tarjeta_credito"=> 'required',
                "ven_id_tarjeta_credito"=> 'required|numeric',
                "ven_banco"=> 'required',
                "ven_tipo_credito"=> 'required',
                "ven_cuotas"=> 'required|numeric',
                "ven_lote"=> 'required',
                "ven_referencia"=> 'required',
                "ven_autorizacion"=>'required',

                "ven_fecha_pago"=> 'required',
                "ven_fecha_transaccion"=> 'required',
                
                "tic_id"=> 'required',
                "ven_voucher"=> 'required',
                "ven_id_banco"=> 'required',
                "ven_fecha_modificacion"=> 'required',
                "ven_mes_gracia"=> 'required',
                "ven_terminal"=> 'required',

                "ven_estado"=> 'required',                
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            $venta_model=new  VentaModel();
            $venta_model->insertar($datos);            
            

            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ven_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ven_codigo=$datos_ingresado['ven_codigo'];
            $ven_monto=$datos_ingresado['ven_monto'];
            $ven_tarjeta_credito=$datos_ingresado['ven_tarjeta_credito'];
            $ven_id_tarjeta_credito=$datos_ingresado['ven_id_tarjeta_credito'];
            $ven_banco=$datos_ingresado['ven_banco'];
            $ven_tipo_credito=$datos_ingresado['ven_tipo_credito'];
            $ven_cuotas=$datos_ingresado['ven_cuotas'];
            $ven_lote=$datos_ingresado['ven_lote'];
            $ven_referencia=$datos_ingresado['ven_referencia'];
            $ven_autorizacion=$datos_ingresado['ven_autorizacion'];
            $ven_estado=$datos_ingresado['ven_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ven_codigo"=> $ven_codigo,
                "ven_monto"=> $ven_monto,
                "ven_tarjeta_credito"=> $ven_tarjeta_credito,
                "ven_id_tarjeta_credito"=> $ven_id_tarjeta_credito,
                "ven_banco"=> $ven_banco,
                "ven_tipo_credito"=> $ven_tipo_credito,
                "ven_cuotas"=> $ven_cuotas,
                "ven_lote"=> $ven_lote,
                "ven_referencia"=> $ven_referencia,
                "ven_autorizacion"=> $ven_autorizacion,
                "ven_estado"=> $ven_estado,                  
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "ven_codigo"=> 'required|numeric',
                "ven_monto"=> 'required|numeric',
                "ven_tarjeta_credito"=> 'required',
                "ven_id_tarjeta_credito"=> 'required|numeric',
                "ven_banco"=> 'required|numeric',
                "ven_tipo_credito"=> 'required',
                "ven_cuotas"=> 'required|numeric',
                "ven_lote"=> 'required',
                "ven_referencia"=> 'required',
                "ven_autorizacion"=>'required',
                "ven_estado"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $venta_model=new  VentaModel();
            $venta_model->actualizar($ven_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$venta_model->getUnaVenta($ven_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
    
    public function updateObservacion($ven_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ven_observacion=$datos_ingresado['ven_observacion'];
            $ven_id=$datos_ingresado['ven_id'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ven_observacion"=> $ven_observacion,       
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "ven_observacion"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                //return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $venta_model=new  VentaModel();
            $venta_model->actualizar($ven_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$venta_model->getUnaVenta($ven_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    public function megaproferventasdiarias()
    {

        try {
            
            $fecha=date("Y-m-d");
            $fechaA=date("Y-m-d",strtotime($fecha."- 1 days")); 
            $j='';
            /*for($i=19;$i<26;$i++)
            {
                if($i<10)
                {
                    $j='0'.$i;
                }
                else
                {
                    $j=$i;
                }
            $fechaA='2025-05-'.$j;*/
            var_dump($fechaA);
            $opciones = array('http' =>
                array(
                    'method'  => 'GET',
                    'header'  => array(
                        'Content-type: application/x-www-form-urlencoded',
                        'Authorization: rapidito-prod;7g::H]d<e%USiL1QTW',
                    ),         
                )
            );

            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents('https://api.megaprofer.com/api/dailySalesCreditCard?updatedDate='.$fechaA, false, $contexto);
            $resultado=json_decode($resultado,true);
            var_dump($resultado);
            $venta_model=new  VentaModel();
            foreach ($resultado as $value) {
                $datos =array(
                    "ven_codigo"=> $value['idTransaction'],
                    "ven_monto"=> $value['amount'],
                    "ven_tarjeta_credito"=> $value['nameCreditCard'],
                    "ven_id_tarjeta_credito"=> $value['idCreditCard'],                    
                    "ven_banco"=> $value['bankName'],
                    "ven_id_banco"=> $value['idBank'],
                    "ven_tipo_credito"=> $value['creditTypeValue']=="1" || $value['creditTypeValue']==1 ? $value['creditType']." con interes" : $value['creditType']." sin interes",
                    "ven_cuotas"=> $value['creditInstallments'],
                    "ven_lote"=> intVal($value['lot']),
                    "ven_referencia"=> $value['id'],
                    "ven_autorizacion"=> $this->getautorizacion($value['authorizeNumberTransaction']) ,
                    "ven_fecha_pago"=> '2022-01-01',
                    "ven_fecha_transaccion"=> $value['transactionDate']??'',
                    "ven_centro_costo"=> !(empty($value['costCenter']))?$value['costCenter']:'',
                    "tic_id"=> 1,
                    "ven_voucher"=> $value['idVoucher'],                    
                    "ven_fecha_modificacion"=> date("Y-m-d", strtotime($value['updateDate'])),
                    "ven_mes_gracia"=> $value['monthsOfGrace'],
                    "ven_terminal"=> $value['idTerminal'],
                    "ven_status"=> $value['status'],
                    "ven_estado"=> 1,   
                    "ven_numero_tc"=>$value['numberCreditCard'],
                );
                $comprobar_existente=$venta_model->getComprobarVentacodigo($value['idTransaction']);
                if(empty($comprobar_existente)){
                    $venta_model->insertar($datos); 
                }else{
                    $tic_id=$comprobar_existente[0]['tic_id'];
                    if($tic_id==1){
                        $venta_model->actualizardatossegunVentaCodigo($value['idTransaction'],$datos);
                    }
                    
                    
                }
                
            }
            
            
           

//}
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    
    public function getautorizacion($autorizacion){
        $aut=explode('-', $autorizacion);
        return intVal($aut[count($aut)-1]);
    }
    
    
    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
    
    
    
    
    public function prueba()
    {

        try {
            
            
            $opciones = array('http' =>
                array(
                    'method'  => 'GET',
                    'header'  => array(
                        'Content-type: application/json',
                        'Authorization: rapidito-prod;?q=HJdce8USiL1QTW',
                    ),         
                )
            );

            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents('https://api.megaprofer.com/api/priceList');
            $resultado=json_decode($resultado,true);
            var_dump($resultado);
//        return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
}