<?php 
namespace App\Models;

use CodeIgniter\Model;

class HistorialVentaModel extends Model
{
    public function gethistorialventa($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_historial_venta');
        $builder->select('tbl_historial_venta.*,tbl_tipo_consulta.*');  
        $builder->join('tbl_tipo_consulta', 'tbl_historial_venta.tic_id=tbl_tipo_consulta.tic_id');
        $builder->join('tbl_cierre_mes', 'tbl_cierre_mes.cim_id=tbl_historial_venta.cim_id');
        $builder->where('tbl_cierre_mes.cim_desde >=', $desde); 
        $builder->where('tbl_cierre_mes.cim_hasta <=', $hasta);
        


        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_historial_venta');
        $builder->set($data);
        $builder->insert();

    }

    public function selectventaconciliada($desde,$hasta,$tic_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*, tbl_relacion_pagos_ventas.rpv_fecha_cruce');
        $builder->join('(select distinct ven_id, rpv_id from tbl_datos_pagos_ventas) as tbl_datos_pagos_ventas','tbl_datos_pagos_ventas.ven_id=tbl_venta.ven_id');
        $builder->join('(select distinct rpv_id, rpv_fecha_cruce from tbl_relacion_pagos_ventas) as tbl_relacion_pagos_ventas','tbl_datos_pagos_ventas.rpv_id=tbl_relacion_pagos_ventas.rpv_id');
        $builder->where('tbl_venta.ven_fecha_transaccion <=', $hasta);
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce >=', $desde);
        $builder->where('tbl_venta.tic_id', $tic_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function selectventanoconciliada($desde,$hasta,$tic_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_fecha_transaccion <=', $hasta);
        $builder->where('tbl_venta.tic_id', $tic_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function comprobarcierremes($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->where('tbl_cierre_mes.cim_desde', $desde); 
        $builder->where('tbl_cierre_mes.cim_hasta', $hasta);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertarcierremes($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->set($data);
        $builder->insert();

    }

    public function ultimafechacierremes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->selectMax('tbl_cierre_mes.cim_hasta');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
}