<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class RelacionBancoTipoPagoModel extends Model
{
    public function getTodoRelacionBancoTipoPago()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_banco_tipo_pago');
        $builder->select('tbl_relacion_banco_tipo_pago.*,tbl_banco.*,tbl_tipo_pago.*,tbl_banco_pagador.*,tbl_tarjeta_credito.*');    
        $builder->join('tbl_banco_pagador', 'tbl_relacion_banco_tipo_pago.bap_id=tbl_banco_pagador.bap_codigo');
        $builder->join('tbl_banco', 'tbl_relacion_banco_tipo_pago.ban_codigo_banco=tbl_banco.ban_codigo');
        $builder->join('tbl_tarjeta_credito', 'tbl_relacion_banco_tipo_pago.tac_codigo=tbl_tarjeta_credito.tac_codigo');
        $builder->join('tbl_tipo_pago', 'tbl_relacion_banco_tipo_pago.tip_id=tbl_tipo_pago.tip_id');   
        $builder->orderBy('tbl_banco_pagador.bap_nombre', 'ASC');
        $builder->orderBy('tbl_banco.ban_nombre', 'ASC');
        $builder->orderBy('tbl_tipo_pago.tip_id', 'ASC'); 
        $builder->orderBy('tbl_tarjeta_credito.tac_nombre', 'ASC');    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPorcentajedecomision($pad_cuenta_contable_banco,$ban_codigo_banco,$tac_codigo,$tip_tipo_pago,$rbt_meses_gracia,$rbt_numero_cuotas)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_banco_tipo_pago');
        $builder->select('tbl_relacion_banco_tipo_pago.*,tbl_tipo_pago.*');    
        $builder->join('tbl_tipo_pago', 'tbl_relacion_banco_tipo_pago.tip_id=tbl_tipo_pago.tip_id');
        $builder->join('tbl_banco', 'tbl_banco.ban_codigo=tbl_relacion_banco_tipo_pago.bap_id');
        $builder->where('tbl_relacion_banco_tipo_pago.ban_codigo_banco', $ban_codigo_banco);
        $builder->where('tbl_relacion_banco_tipo_pago.tac_codigo', $tac_codigo);
        $builder->where('tbl_relacion_banco_tipo_pago.rbt_meses_gracia', $rbt_meses_gracia);
        $builder->where('tbl_relacion_banco_tipo_pago.rbt_numero_cuotas', $rbt_numero_cuotas);
        $builder->where('tbl_tipo_pago.tip_tipo_pago',$tip_tipo_pago);
        //$builder->where('tbl_banco.ban_cuenta_contable',$pad_cuenta_contable_banco);
        $query=$builder->get(); 
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnRelacionBancoTipoPago($rbt_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_banco_tipo_pago');
        $builder->select('tbl_relacion_banco_tipo_pago.*');     
        $builder->where('tbl_relacion_banco_tipo_pago.rbt_id', $rbt_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_banco_tipo_pago');
        //$builder->set();
		$builder->insert($data);

    }
    public function actualizar($rbt_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_banco_tipo_pago');
        $builder->where('tbl_relacion_banco_tipo_pago.rbt_id', $rbt_id);
		return $builder->update($data);        
    }
    public function eliminar($rbt_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_banco_tipo_pago');
        $builder->where('tbl_relacion_banco_tipo_pago.rbt_id', $rbt_id);   
		$builder->update($data);        
    }

}