<?php 
namespace App\Models;

use CodeIgniter\Model;

class VentaModel extends Model
{
    public function getVenta()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getmayornoconciliado($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*'); 
        $builder->where('tbl_venta.ven_fecha_transaccion >=', $desde); 
        $builder->where('tbl_venta.ven_fecha_transaccion <=', $hasta);
        $builder->where('tbl_venta.tic_id', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getMayor($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*,dpv.*,tbl_relacion_pagos_ventas.*,tbl_tipo_consulta.*,ajuste.*'); 
        $builder->join('(select distinct ven_id, rpv_id from tbl_datos_pagos_ventas) as dpv','tbl_venta.ven_id=dpv.ven_id ','left');
        $builder->join('tbl_relacion_pagos_ventas','tbl_relacion_pagos_ventas.rpv_id=dpv.rpv_id','left');
        $builder->join('tbl_tipo_consulta','tbl_tipo_consulta.tic_id=tbl_venta.tic_id');
        $builder->join('(select ven_id, GROUP_CONCAT(`aju_fecha`) a , GROUP_CONCAT(`aju_nombre`) b from tbl_ajustes group by 1) as ajuste','ajuste.ven_id=tbl_venta.ven_id','left');
        $builder->where('tbl_venta.ven_fecha_transaccion >=', $desde); 
        $builder->where('tbl_venta.ven_fecha_transaccion <=', $hasta);
        //$builder->where('tbl_venta.tic_id', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getUnaVenta($ven_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.ven_id', $ven_id);        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->insert($data);

    }
    public function actualizar($ven_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_id', $ven_id);
        return $builder->update($data);        
    }
    public function eliminar($ven_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_id', $ven_id);   
        $builder->update($data);        
    }
    public function conciliado($ven_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_id', $ven_id);   
        $builder->update($data);        
    }
    public function filtroconciliacion($ven_fecha_pago,$ven_lote,$ven_autorizacion,$ven_centro_costo,$ven_fecha_transaccion,$ven_fecha_transaccion_fin,$tic_id,$ven_monto_min,$ven_monto_max)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*,centro_costo.cco_pdv as "a", tbl_centro_costo.cco_pdv as "b"');  
        $builder->join('tbl_centro_costo', 'tbl_venta.ven_centro_costo=tbl_centro_costo.cco_ctc and tbl_venta.ven_centro_costo!=""','left'); 
        $builder->join('(select * from tbl_centro_costo) as centro_costo', 'tbl_venta.ven_centro_costo=centro_costo.cco_centro_costo and tbl_venta.ven_centro_costo!=""','left'); 
        if($ven_fecha_pago != null){
            $builder->where('tbl_venta.ven_fecha_pago', $ven_fecha_pago);
        }
        if($ven_lote != null){
            $builder->where('tbl_venta.ven_lote', $ven_lote);
        }
        if($ven_autorizacion != null){
            $builder->where('tbl_venta.ven_autorizacion', $ven_autorizacion);
        }
        if($ven_centro_costo != null){
            $builder->where('tbl_venta.ven_centro_costo', $ven_centro_costo);
        }
        if($ven_fecha_transaccion != null){
            $builder->where('tbl_venta.ven_fecha_transaccion >=', $ven_fecha_transaccion);
            $builder->where('tbl_venta.ven_fecha_transaccion <=', $ven_fecha_transaccion_fin);
        }
        if($tic_id != null){
            $builder->where('tbl_venta.tic_id', $tic_id);
        } 

        if($ven_monto_min != null && $ven_monto_max != null){
            $builder->where('tbl_venta.ven_monto >=', $ven_monto_min);
            $builder->where('tbl_venta.ven_monto <=', $ven_monto_max);
        }else{
            if($ven_monto_min != null){
                $builder->where('tbl_venta.ven_monto', $ven_monto_min);
            }else{
                if($ven_monto_max != null){
                    $builder->where('tbl_venta.ven_monto', $ven_monto_max);
                }
            }
        }
        $builder->where('tbl_venta.ven_monto >', 0);
        //$builder->where('tbl_venta.ven_banco', 'PICHINCHA');
        //$builder->orderBy('tbl_venta.ven_monto','asc');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function getComprobarVentacodigo($ven_codigo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.ven_codigo', $ven_codigo);        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function actualizardatossegunVentaCodigo($ven_codigo,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('tbl_venta.ven_codigo', $ven_codigo);   
        $builder->update($data);        
    }
    
    public function getValorAjuste($ven_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.ven_ajuste'); 
        $builder->where('tbl_venta.ven_id', $ven_id); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getComprobarSiExisteVenta($ven_monto,$ven_autorizacion,$ven_lote,$ven_numero_tc,$ven_centro_costo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');    
        $builder->where('tbl_venta.ven_monto', $ven_monto);    
        $builder->where('tbl_venta.ven_autorizacion', $ven_autorizacion);    
        $builder->where('tbl_venta.ven_lote', $ven_lote);    
        $builder->where('tbl_venta.ven_numero_tc', $ven_numero_tc);    
        $builder->where('tbl_venta.ven_centro_costo', $ven_centro_costo);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

}