<?php

namespace App\Models;

use CodeIgniter\Model;
use Exception;

class Cuadreventasmodel extends Model
{
    protected $table = 'transaccion_cabecera'; // Tabla principal
    protected $primaryKey = 'trc_id'; // Llave primaria
    protected $returnType = 'array';
    
    public function obtenerTransacciones($inicioMes, $finMes, $almacen)
{
    $db = \Config\Database::connect('postgres');

    // Consulta parametrizada segura
    $sql = "
        WITH pagos_tarjeta AS (
            SELECT 
                trp_secuencial, 
                trp_nombre_almacen,
                bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD','DE_UNA')) AS es_tarjeta
            FROM 
                transaccion_pago
            GROUP BY 
                trp_secuencial, trp_nombre_almacen
        )
        SELECT 
            tc.trc_nombre_almacen,
            tc.trc_fecha_transaccion,
            tc.trc_secuencial,
            td.trd_codigo_referencia,
            CASE 
                WHEN td.trd_es_pesado = false AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > 
                     ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN td.trd_subtotal 
                ELSE 0 
            END AS valor_ferreteria_precio_mayor,

            CASE 
                WHEN td.trd_es_pesado = false 
                    AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
                    AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > 
                        ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ROUND(
                    ((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - 
                      ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) 
                    * td.trd_cantidad_venta) * 0.80, 4)
                ELSE 0 
            END AS comision_ferreteria_precio_mayor,
            

    
        CASE 
            WHEN td.trd_es_pesado = false AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal  
            ELSE 0 
        END
     AS valor_ferreteria_precio_igual,

    
        CASE 
            WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) * td.trd_cantidad_venta * 0.005, 4)
            ELSE 0 
        END
    AS comision_ferreteria_precio_igual,

    
        CASE 
            WHEN td.trd_es_pesado = true AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal  
            ELSE 0 
        END
     AS valor_pesado_precio_mayor,

    
        CASE 
            WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80, 4)
            ELSE 0 
        END
    AS comision_pesado_precio_mayor,

    
        CASE 
            WHEN td.trd_es_pesado = true AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal 
            ELSE 0 
        END
    AS valor_pesado_precio_igual,

    
        CASE 
            WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) * td.trd_cantidad_venta * 0.0025, 4)
            ELSE 0 
        END
     AS comision_pesado_precio_igual

    

        FROM 
            transaccion_cabecera tc
        JOIN 
            transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
        LEFT JOIN 
            pagos_tarjeta pt ON tc.trc_secuencial = pt.trp_secuencial 
                            AND tc.trc_nombre_almacen = pt.trp_nombre_almacen
        WHERE 
            tc.trc_fecha_transaccion >= '$inicioMes' AND
            tc.trc_fecha_transaccion <= '$finMes' ";
            
            if($almacen!='0'){
            $sql.=" AND tc.trc_nombre_almacen = '$almacen'";
            }
            /*$sql.=" AND NOT EXISTS (
                SELECT 1
                FROM cotizacion_cabecera ctc
                WHERE ctc.trc_secuencial = tc.trc_secuencial
                AND ctc.ctc_dni_cliente = tc.trc_dni_cliente
            )";*/
    

    // Mostrar la consulta con los valores reales para depuración
   //echo "<pre>$debugSql</pre>"; // Solo para desarrollo, luego comenta o elimina esta l��nea

    // Ejecutar la consulta segura
    $query = $db->query($sql, [$inicioMes, $finMes, $almacen]);
    return $query->getResultArray();
}

 public function obtenerNotasCredito($inicioMes, $finMes, $almacen)
{
    $db = \Config\Database::connect('postgres');

    // Consulta parametrizada segura
    $sql = "
        WITH pagos_tarjeta AS (
    SELECT 
        trp_secuencial, 
        trp_nombre_almacen,
        bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD', 'DE_UNA')) AS es_tarjeta
    FROM 
        transaccion_pago
    GROUP BY 
        trp_secuencial, trp_nombre_almacen
)
SELECT 
    ncc.ncc_nombre_almacen,
    ncc.ncc_fecha_transaccion_nc,
    ncc.ncc_secuencial_fv,
    ncd.ncd_codigo_referencia,
    COALESCE(pt.es_tarjeta, false) AS es_tarjeta,

    -- Valor de devolución de ferretería (precio mayor)
    CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END AS nc_valor_ferreteria_precio_mayor,

    -- Comisión devolución ferretería (precio mayor)
    CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
               - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) 
               * ncd.ncd_cantidad) * 0.80
        ELSE 0
    END AS nc_comision_ferreteria_precio_mayor,

    -- Valor devolución pesado (precio mayor)
    CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END AS nc_valor_pesado_precio_mayor,

    -- Comisión devolución pesado (precio mayor)
    CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
               - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) 
               * ncd.ncd_cantidad) * 0.80
        ELSE 0
    END AS nc_comision_pesado_precio_mayor,

    -- Valor devolución ferretería (precio igual)
    CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END AS nc_valor_ferreteria_precio_igual,

    -- Comisión devolución ferretería (precio igual)
    CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) 
              * ncd.ncd_cantidad) * 0.005
        ELSE 0
    END AS nc_comision_ferreteria_precio_igual,

    -- Valor devolución pesado (precio igual)
    CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END AS nc_valor_pesado_precio_igual,

    -- Comisión devolución pesado (precio igual)
    CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                 = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) 
              * ncd.ncd_cantidad) * 0.0025
        ELSE 0
    END AS nc_comision_pesado_precio_igual

FROM 
    nota_credito_cabecera ncc
JOIN 
    nota_credito_detalle ncd ON ncc.ncc_id = ncd.ncd_id_cabecera
LEFT JOIN 
    pagos_tarjeta pt ON ncc.ncc_secuencial_fv = pt.trp_secuencial 
                     AND ncc.ncc_nombre_almacen = pt.trp_nombre_almacen
WHERE 
    ncc.ncc_fecha_transaccion_nc BETWEEN '$inicioMes' AND '$finMes'";
    if($almacen!='0'){
            $sql.=" AND ncc.ncc_nombre_almacen = '$almacen'";
            }
    $sql.="ORDER BY 
    ncc.ncc_fecha_transaccion_nc, ncc.ncc_secuencial_fv";

    

    // Mostrar la consulta con los valores reales para depuración
   //echo "<pre>$sql</pre>"; // Solo para desarrollo, luego comenta o elimina esta l��nea
   

    // Ejecutar la consulta segura
    $query = $db->query($sql, [$inicioMes, $finMes, $almacen]);
    return $query->getResultArray();
    
    //print_r($query->getResultArray()); die();
}
}
