<?php

namespace App\Models;

use CodeIgniter\Model;

class Notascreditomodel extends Model
{
    protected $table = 'nota_credito_cabecera';
    protected $primaryKey = 'ncc_id';
    protected $allowedFields = [
        'ncc_dispatch_id',
        'ncc_nombre_almacen',
        'ncc_punto_emision',
        'ncc_fecha_transaccion_nc',
        'ncc_secuencial_nc',
        'ncc_fecha_transaccion_fv',
        'ncc_secuencial_fv',
        'ncc_dni_cliente',
        'ncc_nombre_cliente'
    ];

    protected $db;  // Variable para la conexión PostgreSQL

    public function __construct()
    {
        parent::__construct();
        // Establecer la conexión explícita a la base de datos PostgreSQL
        $this->db = \Config\Database::connect('postgres');
    }

    /**
     * Inserta una nueva nota de crédito en la tabla cabecera si no existe.
     *
     * @param array $data
     * @return int|bool Retorna el ID de la cabecera insertada o false si no se insertó
     */
    public function insertarCabecera($data)
    {
        // Convertir fechas al formato correcto para PostgreSQL
        $data['ncc_fecha_transaccion_nc'] = date('Y-m-d H:i:s', strtotime($data['ncc_fecha_transaccion_nc']));
        $data['ncc_fecha_transaccion_fv'] = date('Y-m-d H:i:s', strtotime($data['ncc_fecha_transaccion_fv']));

        // Asegurarse de que los valores NULL estén correctamente configurados
        $data['ncc_dispatch_id'] = $data['ncc_dispatch_id'] ?: null;
        $data['ncc_punto_emision'] = $data['ncc_punto_emision'] ?: null;

        // Crear la consulta SQL para insertar si no existe un conflicto
        $sql = "INSERT INTO nota_credito_cabecera (ncc_dispatch_id, ncc_nombre_almacen, ncc_punto_emision, ncc_fecha_transaccion_nc, ncc_secuencial_nc, ncc_fecha_transaccion_fv, ncc_secuencial_fv, ncc_dni_cliente, ncc_nombre_cliente) 
                VALUES (:ncc_dispatch_id:, :ncc_nombre_almacen:, :ncc_punto_emision:, :ncc_fecha_transaccion_nc:, :ncc_secuencial_nc:, :ncc_fecha_transaccion_fv:, :ncc_secuencial_fv:, :ncc_dni_cliente:, :ncc_nombre_cliente:)
                ON CONFLICT (ncc_secuencial_nc) DO NOTHING"; // Evitar duplicados

        // Ejecutar la consulta
        $this->db->query($sql, $data);

        // Imprimir el último query ejecutado
        echo $this->db->getLastQuery();

        // Capturar y devolver el error en caso de que ocurra
        $error = $this->db->error();
        if ($error['code'] != 0) {
            echo 'Error en la consulta de cabecera: ' . $error['message'];
            log_message('error', 'Error en la inserción de nota_credito_cabecera: ' . $error['message']);
            return false;
        }

        // Retornar el ID insertado si se realizó la inserción, o null si no se insertó
        return $this->db->affectedRows() > 0 ? $this->db->insertID() : false;
    }

    /**
     * Inserta los detalles de la nota de crédito.
     *
     * @param array $data
     * @return bool
     */
    public function insertarDetalle1($data)
    {
        // Convertir booleanos en PostgreSQL: usar 'TRUE' o 'FALSE'
        $data['ncd_es_pesado'] = $data['ncd_es_pesado'] ? 'TRUE' : 'FALSE';

        // Ejecutar la consulta de inserción
        $this->db->table('nota_credito_detalle')->insert($data);

        // Imprimir el último query ejecutado
        echo $this->db->getLastQuery();

        // Capturar el error en caso de fallo
        $error = $this->db->error();
        if ($error['code'] != 0) {
            // Imprimir el error en pantalla (si es ambiente de desarrollo)
            echo 'Error en la consulta de detalle: ' . $error['message'];

            // Registrar el error en el log
            log_message('error', 'Error en la inserción de nota_credito_detalle: ' . $error['message']);

            return false;
        }

        return true;
    }
    public function existeCabecera($dispatchId, $fechaTransaccionNc, $secuencialNc,$secuencialFv)
{
    $query = $this->db->table('nota_credito_cabecera')
                      ->where('ncc_dispatch_id', $dispatchId)
                      ->where('ncc_fecha_transaccion_nc', $fechaTransaccionNc)
                      ->where('ncc_secuencial_nc', $secuencialNc)
                      ->where('ncc_secuencial_fv', $secuencialFv)
                      ->get();

    return $query->getRow();
}

public function existeDetalle($ncd_id_cabecera, $codigoReferencia, $descripcionProducto)
{
    $query = $this->db->table('nota_credito_detalle')
                      ->where('ncd_id_cabecera', $ncd_id_cabecera)
                      ->where('ncd_codigo_referencia', $codigoReferencia)
                      ->where('ncd_descripcion_producto', $descripcionProducto)
                      ->get();

    return $query->getRow();
}

public function insertarDetalle($dataDetalle)
{
    $this->db->table('nota_credito_detalle')->insert($dataDetalle);
}

}
