<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Sobregirosmodel extends Model
{
    
    public function insertar($puv_id,$monto,$observacion,$fecha)
    {
        $data=[
            'puv_id'=>$puv_id,
            'sob_mes'=>$fecha,
            'sob_monto'=>$monto,
            'sob_abono'=>0,
            'sob_saldo'=>$monto,
            'sob_estado'=>0,
            'sob_observacion'=>$observacion];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_sobregiros');
        $builder->set($data);
		$builder->insert();

    }
    public function getSobregirosPUVID($puv_id,$mes)
    {
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_sobregiros');
        $builder->select('tbl_sobregiros.*');  
        $builder->where('tbl_sobregiros.puv_id', $puv_id);
        $builder->where('tbl_sobregiros.sob_saldo!=', 0);
        $builder->where('tbl_sobregiros.sob_mes>=', $mes);
        $query = $builder->get();
        $resultado = $query->getResultArray();
        return $resultado;
    }
    public function getSobregirosPUVID_SOBMES($puv_id,$mes)
    {
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_sobregiros');
        $builder->select('tbl_sobregiros.*');  
        $builder->where('tbl_sobregiros.puv_id', $puv_id);
        $builder->where('tbl_sobregiros.sob_saldo!=', 0);
        $builder->where('tbl_sobregiros.sob_mes=', $mes);
        //$builder->where('tbl_sobregiros.sob_mes>=', $mes1);
        $query = $builder->get();
        $resultado = $query->getResultArray();
        return $resultado;
    }
    public function reiniciarAbonoSobregiros($puv_id, $mes)
    {
        $db = \Config\Database::connect();
        
        // Eliminar los abonos para el puv_id y el mes especificado
        $builder = $db->table('tbl_sobregiros_abonos');
        $builder->where('soa_fecha', $mes);  // Corrección en la expresión WHERE
        $builder->delete(); 
        
        $builder = $db->table('tbl_sobregiros');
        $builder->where('puv_id', $puv_id);
        $builder->where('sob_mes', $mes);  // Corrección en la expresión WHERE
        $builder->delete(); 
        
        // Actualizar los saldos y abonos en la tabla tbl_sobregiros
        $sql = "
            UPDATE tbl_sobregiros s
            LEFT JOIN (
                SELECT sob_id, SUM(soa_monto) AS total_abono
                FROM tbl_sobregiros_abonos
                GROUP BY sob_id
            ) abonos ON s.sob_id = abonos.sob_id
            SET 
                s.sob_abono = IFNULL(abonos.total_abono, 0),  
                s.sob_saldo = s.sob_monto - IFNULL(abonos.total_abono, 0),  
                s.sob_estado = CASE
                    WHEN s.sob_saldo = 0 THEN 1
                    ELSE 0
                END
        ";

        // Ejecutar la consulta SQL directamente
        return $db->query($sql);  // Usar `$db` en lugar de `$this->db`
    }
    public function insertarAbonosSobregiros($sob_id,$fecha,$monto,$observacion)
    {
        $data=[
            'sob_id'=>$sob_id,
            'soa_fecha'=>$fecha,
            'soa_monto'=>$monto,
            'soa_observacion'=>$observacion];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_sobregiros_abonos');
        $builder->set($data);
		$builder->insert();

    }
    public function updateSaldos($sob_id,$abono,$saldo,$estado){
        $data=[
            'sob_abono'=>$abono,
            'sob_saldo'=>$saldo,
            'sob_estado'=>$estado];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_sobregiros');
        $builder->where('tbl_sobregiros.sob_id', $sob_id);
        $sql = $builder->getCompiledUpdate();

        
        return $builder->update($data); 
    }
    public function getSobregirosPendientes($mes){
        
        
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_sobregiros');
        
        // Seleccionar todos los campos de `tbl_sobregiros`
        $builder->select('tbl_sobregiros.*');
        
        // Filtrar los registros donde `sob_saldo` no es igual a 0
        $builder->where('tbl_sobregiros.sob_estado !=', 1);
        
        $builder->where('tbl_sobregiros.sob_mes <=', $mes);
        
        // Agregar GROUP BY para agrupar los resultados por `sob_mes`
        $builder->groupBy('tbl_sobregiros.sob_mes');
        
        // Ejecutar la consulta
        $query = $builder->get();
        
        // Obtener los resultados
        $resultado = $query->getResultArray();
        
        // Retornar los resultados
        return $resultado;

    }
    public function reiniciarAbonoSobregirosTodos($mes)
    {
        $db = \Config\Database::connect();
        
        // Eliminar los abonos para el puv_id y el mes especificado
        $builder = $db->table('tbl_sobregiros_abonos');
        $builder->where('soa_fecha', $mes);  
        $builder->delete(); 
        
        $builder = $db->table('tbl_sobregiros');
        $builder->where('sob_mes', $mes); 
        $builder->delete(); 
        
        // Actualizar los saldos y abonos en la tabla tbl_sobregiros
        $sql = "
            UPDATE tbl_sobregiros s
            LEFT JOIN (
                SELECT sob_id, SUM(soa_monto) AS total_abono
                FROM tbl_sobregiros_abonos
                GROUP BY sob_id
            ) abonos ON s.sob_id = abonos.sob_id
            SET 
                s.sob_abono = IFNULL(abonos.total_abono, 0),  
                s.sob_saldo = s.sob_monto - IFNULL(abonos.total_abono, 0),  
                s.sob_estado = CASE
                    WHEN s.sob_saldo = 0 THEN 1
                    ELSE 0
                END
        ";

        // Ejecutar la consulta SQL directamente
        return $db->query($sql);  // Usar `$db` en lugar de `$this->db`
    }
}