
<script>
    class Excel1{
        constructor(content){
            this.content=content;
        }
        header(){
            return this.content[0];
        }
        rows(){
            return new RowCollection1(this.content.slice(1,this.content.length));
        }
    }
    class RowCollection1{
        constructor(rows){
            this.rows=rows;
        }
        get(index){
            return new Row(this.rows[index]);
        }
        count(){
            return this.rows.length;
        }
    }
    class Row1{
        constructor(row){
            this.row=row;
        }
        mesEstimado(){
            return this.row[0];
        }
        anoEstimado(){
            return this.row[1];
        }
        numeroCuota(){
            return this.row[2];
        }
        valorCapital(){
            return this.row[3];
        }
        valorInteres(){
            return this.row[4];
        }
        valorCuotaTotal(){
            return this.row[5];
        }
        count(){
            return this.row.length;
        }
    }
    class ExcelPrinter1{
        static print(tableId, excel){
            const table=document.getElementById(tableId);
            
            if(excel1.header().length==6 && excel1.header()[0]=='MES DE DESCUENTO ESTIMADO' && excel1.header()[1]=='AÑO DESCUENTO' && excel1.header()[2]=='NÚMERO DE CUOTA' && excel1.header()[3]=='VALOR DE CAPITAL' && excel1.header()[4]=='VALOR DE INTERĖS' && excel1.header()[5]=='VALOR DE CUOTA TOTAL' ){
                excel1.header().forEach(title=>(
                    table.querySelector("thead>tr").innerHTML+=`<th>${title}</th>`
                    ))
                table.querySelector("tbody").innerHTML='';    
                for(let index=0; index<excel1.rows().count();index++)
                {
                    const row=excel1.rows().get(index);
                    if(index==0){
                        document.getElementById('fechadesde').value=row.anoEstimado()+'-'+row.mesEstimado()+'-01';
                    }
                    if(index<excel1.rows().count()){
                        document.getElementById('fechahasta').value=row.anoEstimado()+'-'+row.mesEstimado()+'-01';
                    }
                    table.querySelector("tbody").innerHTML+=`
                    <tr>
                    <td>${obtenerNombreMes(row.mesEstimado())}</td>
                    <td>${row.anoEstimado()}</td>
                    <td>${row.numeroCuota()}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorCapital())}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorInteres())}</td>
                    <td style='text-align:right'>${USDollar.format(row.valorCuotaTotal())}</td>
                    </tr>`
                }
                document.getElementById('detalleamortizacion').value=(JSON.stringify(excel1.rows()));
            }
            else{
                alert("Error en el archivo");
                document.getElementById('reftablaamortizacion').value='';
            }
        }
        
    }
    var excelInput=document.getElementById('reftablaamortizacion');
    excelInput.addEventListener('change',async function(){
        const content=await readXlsxFile(excelInput.files[0]);
        const excel=new Excel1(content);
        //console.log(excel1.header());
        //console.log(excel1.rows().rows);
        //console.log(excel1.rows().get());
        console.log(ExcelPrinter1.print("amortizacion",excel));
    });
    
    

</script>