<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Periodicidadmodel;

class Periodicidad extends BaseController
{

	public function index(){
		$periodicidad_model= new Periodicidadmodel();
		$datos_periodidicad=$periodicidad_model->getPeriodicidad();

		$enviar_datos=array(
			'datos_periodidicad' => !empty($datos_periodidicad)?$datos_periodidicad:null , 
		);

        $datos = $this->datosMenu();
        
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("periodicidad/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$periodicidad_model= new Periodicidadmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('periodicidad'))){
				$per_periodicidad=$this->request->getPost('periodicidad');
				$ingresar_datos=array(
					'per_periodicidad'=>$per_periodicidad,
					'per_estado'=>1
				);
				$periodicidad_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Periodicidad')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Periodicidad')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$periodicidad_model= new Periodicidadmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editperiodicidad')) && !empty($this->request->getPost('editperid'))){
				$per_periodicidad=$this->request->getPost('editperiodicidad');
				$per_id=$this->request->getPost('editperid');
				$editar_datos=array(
					'per_periodicidad'=>$per_periodicidad,
					'per_estado'=>1
				);
				$periodicidad_model->actualizar($per_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Periodicidad')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Periodicidad')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$periodicidad_model= new Periodicidadmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'per_estado'=>0
				);
				$periodicidad_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Periodicidad')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Periodicidad')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
    
}