<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Basecomisionesmodel;
use App\Models\Conveniomodel;
use App\Models\Comisionmodel;
use App\Models\Convenioporcentajemodel;
use App\Models\Descuentosmodel;
use App\Models\Prestamosmodel;
use App\Models\Puntoventamodel;
use App\Models\Ventamodel;
use App\Models\Postconveniomodel;
use App\Models\Postconveniovalormodel;
use App\Models\Descuentomensualmodel;
use App\Models\Descuentomensualvalormodel;
use App\Models\Descuentospdvtipofranquiciamodel;
use App\Models\Documentoenviadomodel;
use App\Models\Comisionmesfinalizadomodel;
class Reporte extends BaseController
{

	public function index(){
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("reporte/fechareportegeneral");
		echo view("layouts/footer");
	}
	public function fechareportecomparacion(){
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("reporte/fechareportecomparacion");
		echo view("layouts/footer");
	}
	public function reportegeneral(){
	    
	    $session = \Config\Services::session();
	    if(empty($this->request->getPost('mes'))){
			$session->setFlashdata('mensaje_malo', 'Ingrese Mes');
			return redirect()->to(base_url('Reporte'));
		}
        $datos_menu = $this->datosMenu();
		$mes=$this->request->getPost('mes');
		$tipo=$this->request->getPost('tipo');
		$mes_aux=date("Y-m", strtotime($mes));
		$mes_inicio=date("Y-m-1", strtotime($mes));

		$comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
		$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
		if(!empty($resultado)){
			$datos_registrados = file_get_contents($resultado[0]['cmf_link']);
			$datos_registrados = base64_decode($datos_registrados);
			$datos_registrados = json_decode($datos_registrados,true);
			$titulos=$datos_registrados['titulos'];
			$datos=$datos_registrados['datos'];
			$imprimir_datos_csv=json_decode($datos_registrados['imprimir_datos_csv'],true);	
			$enviar_datos=array(
				'titulos'=>$titulos,
				'datos'=>$datos,
				'imprimir_datos_csv'=>$imprimir_datos_csv,
				'mes'=>$mes_aux,
				'finalizado'=>true,
				'tipo'=>$tipo
			);		
			$datos_menu = $this->datosMenu();
			echo view("layouts/header");
			echo view("layouts/aside",$datos_menu);
			echo view("reporte/list",$enviar_datos);
			echo view("layouts/footer");
			return;
		}

        $enviar_datos=$this->obtenerReporteGeneralMes($mes,'fechareportegeneral',$tipo);
        if($enviar_datos=='no')
        {
            return redirect()->to(base_url('Reporte')); 
        }
	    echo view("layouts/header");
		echo view("layouts/aside",$datos_menu);
		echo view("reporte/list",$enviar_datos);
		echo view("layouts/footer");
	}
	
	public function obtenercuotas($desde,$hasta)
	{
		$desde=date('Y-m',strtotime($desde));
		$hasta=date('Y-m',strtotime($hasta));
		$cuotas=0;

		while($desde<$hasta){
			
			$desde=date("Y-m",strtotime($desde."+ 1 month")); 
			$cuotas=$cuotas+1;
		}

		return $cuotas;
	}

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}

	public function fechasreporteventa(){
		$datos_menu = $this->datosMenu();		
		echo view("layouts/header");
		echo view("layouts/aside",$datos_menu);
		echo view("reporte/fechareporteventa");
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		$mes='';
		if(!empty($this->request->getPost('mes'))){
			$mes= $this->request->getPost('mes');
		}

		

		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('Hoja1');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "Hoja1"');
				return redirect()->to(base_url('Reporte/fechareporteventa'));
			}    

			$data=[];

			$pdv_no_encontrados='';

			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=5; $row<=$highestRow; $row++)				
				{

					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
					$fechacontable = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
					if($pdv=='(en blanco)' && $fechacontable=='(en blanco)'){
						break;
					}
					
					if(!empty($fechacontable) && $fechacontable!='(en blanco)'){
						$fechacontable = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fechacontable);  
						$fechacontable =$fechacontable->format('Y-m-d');						

						$sum_ventas_netas = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						$sum_iva = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						$sum_total = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();	
						$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
						$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

						if($puv_id!=0){						
							$data[]=array(						
								'puv_id'=>$puv_id,
								'pdv'=>$pdv,
								'fechacontable'=>$fechacontable,
								'sum_ventas_netas'=>$sum_ventas_netas,
								'sum_iva'=>$sum_iva,
								'sum_total'=>$sum_total,													
							);
						}else{
							$pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
						}
					}else{
						$sum_ventas_netas = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						$sum_iva = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						$sum_total = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();						
						$puv_id=$data[sizeof($data)-1]['puv_id'];						
						$data[]=array(						

							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'fechacontable'=>$fechacontable,
							'sum_ventas_netas'=>$sum_ventas_netas,
							'sum_iva'=>$sum_iva,
							'sum_total'=>$sum_total,													
						);
					}

				}
				break;
			}			
			
			$datos = $this->datosMenu();
			$enviar_datos=array(            
				'data'=>$data,
				'mensaje'=>$pdv_no_encontrados,
				'mes'=>$mes,
			);

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("reporte/tabla",$enviar_datos);
			echo view("layouts/footer");
		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Formatocarga')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();
		if(!empty($this->request->getPost('datos')) && !empty($this->request->getPost('mes'))){
			$venta_model=new Ventamodel();
			$datos =$this->request->getPost('datos');
			$mes =$this->request->getPost('mes');			           
			echo '<pre>'; print_r($mes); echo '</pre>';
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);	

			foreach ($datos as $value) {
				if(empty($value['fechacontable'])){
					$value['fechacontable']='0000-00-00';
				}
				$datos_venta=array(				
					'puv_id'=>$value['puv_id'],
					'puv_punto_venta_nombre'=>$value['pdv'],
					'ven_fecha_contable'=>$value['fechacontable'],
					'ven_venta_neta'=>$value['sum_ventas_netas'],
					'ven_iva'=>$value['sum_iva'],
					'ven_total'=>$value['sum_total'],
					'ven_mes'=>$mes,
				);				
				$venta_model->insertar($datos_venta);
			}		
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Reporte/fechasreporteventa')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Reporte/fechasreporteventa')); 
		}

	}

	public function fechareportepdv(){
		$datos_menu = $this->datosMenu();	
		$punto_venta_model= new Puntoventamodel();	

		$datos_punto_venta=$punto_venta_model->getPuntoventa();

		$datos_enviar=array(
			'datos_punto_venta'=>$datos_punto_venta,
		);

		echo view("layouts/header");
		echo view("layouts/aside",$datos_menu);
		echo view("reporte/fechareportepdv",$datos_enviar);
		echo view("layouts/footer");
	}

	public function reportepdv(){
		$datos_menu = $this->datosMenu();	
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('mes'))&&!empty($this->request->getPost('puvid'))){
			$mes=$this->request->getPost('mes');
			$puv_id=$this->request->getPost('puvid');
			$mes_inicio=$mes.'-01';
			$mes_fin=$mes.'-30';
			$post_convenio_valor_model=new Postconveniovalormodel();
			$venta_model=new Ventamodel();
			$comision_model=new Comisionmodel();
            $descuento_mensual_model=new Descuentomensualmodel();
			$descuento_mensual_valor_model=new Descuentomensualvalormodel();
			$descuento_pdv_tipo_franquicia_model=new Descuentospdvtipofranquiciamodel();
			$punto_venta=new Puntoventamodel();
			$resultado_venta_model=$venta_model->getVentasegunpuvidmes($puv_id,$mes);
			$observacion=$punto_venta->getObservacionReporteMensualPDV($mes_inicio,$puv_id);

			if(empty($resultado_venta_model)){
				$session->setFlashdata('mensaje_malo', 'No hay datos de venta');
				return redirect()->to(base_url('Reporte/fechareportepdv')); 
			}

			$auxmes=date('Y-m-d',strtotime($mes));		
			$mes_aux=date("Y-m", strtotime($mes));

			$base_comisiones_model= new Basecomisionesmodel();

			$resultado_base_comisiones=$base_comisiones_model->getBasecomisionespormespuvid($puv_id,$auxmes);
			

			if(empty($resultado_base_comisiones)){
				$session->setFlashdata('mensaje_malo', 'No hay datos de base comisiones');
				return redirect()->to(base_url('Reporte/fechareportepdv'));
			}

			$convenio_model=new Conveniomodel();
			$convenio_porcentaje_model=new Convenioporcentajemodel();

			//$resultado_convenio=$convenio_model->getConveniopormes($mes);
			$resultado_convenio=$convenio_model->getConveniodesdehasta($mes_inicio,$mes_fin);
			if(empty($resultado_convenio)){
				$session->setFlashdata('mensaje_malo', 'No hay datos de CONVENIOS'.$mes_inicio);
				return redirect()->to(base_url('Reporte/fechareportepdv'));
			}
			$datos_convenio_porentaje_puvid=[];
			foreach ($resultado_convenio as $value) {
				$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($puv_id,$value['cov_id'],$mes_inicio);
				
				if(!empty($resultado_convenio_porcentaje[0])){
					$datos_convenio_porentaje_puvid[]=array(
						'cov_nombre'=>$value['cov_nombre'],
						'cov_porcentaje'=>$value['cov_porcentaje'],
						'cop_valor_vendido'=>$resultado_convenio_porcentaje[0]['cop_valor_vendido'],
						'cop_porciento'=>$resultado_convenio_porcentaje[0]['cop_porciento'],
					);
				}
			}
			
			$datos_comision=[];
			
			$total_pesado=$resultado_base_comisiones[0]['bac_pesado_adm']+$resultado_base_comisiones[0]['bac_pesado_mayorista'];
			$pesado=$resultado_base_comisiones[0]['bac_pesado']- $total_pesado-$resultado_base_comisiones[0]['bac_ventas_especiales_sin_comision_pesado'];
			$devolucion_saldo_favor=$resultado_base_comisiones[0]['bac_devolucion_saldo_favor'];
			

			
			$total_ferreteria=$resultado_base_comisiones[0]['bac_ferreteria_adm']+$resultado_base_comisiones[0]['bac_ferreteria_mayorista'];
			
			$ferreteria=$resultado_base_comisiones[0]['bac_ferreteria']-$total_ferreteria;
			
			
			foreach ($resultado_convenio as $value) {
				$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($resultado_base_comisiones[0]['puv_id'],$value['cov_id'],$mes_inicio);
				$valor_convenio=0;
				if(!empty($resultado_convenio_porcentaje[0]['cop_valor_vendido'])){
					$valor_convenio=$resultado_convenio_porcentaje[0]['cop_valor_vendido'];
					if($value['cov_tipo']==1)
					{
				        $ferreteria=$ferreteria-$valor_convenio;
					}
					else
					{
					    $pesado=$pesado-$valor_convenio;
					}
				}					
				
			}
			$ferreteria=$ferreteria-$resultado_base_comisiones[0]['bac_venta_especial_ferreteria'];
			
			$ferreteria=$ferreteria-$resultado_base_comisiones[0]['bac_ventas_especiales_sin_comision_ferreteria'];
			
			$ferreteria=$ferreteria-$resultado_base_comisiones[0]['bac_venta_material_petreo'];
			
			$ferreteria=number_format($ferreteria, 2, '.', '');
			$pesado=number_format($pesado, 2, '.', '');
			
			$dos_porciento_material_pesado=$pesado*0.02;
			$dos_porciento_material_pesado=number_format($dos_porciento_material_pesado, 2, '.', '');
			
			$datos_comision[]=array(						
				'Rubros'=>'Devolución saldo favor',
				'%Comision'=>'',
				'Valor'=>$devolucion_saldo_favor,
				'Comision'=>$devolucion_saldo_favor,						
			);
			
			
			/*$datos_comision[]=array(						
				'Rubros'=>'Material Pesado 2%',
				'%Comision'=>'2%',
				'Valor'=>$pesado,
				'Comision'=>$dos_porciento_material_pesado,						
			);*/
			
			
            
            
			
			$aux=($ferreteria*($resultado_base_comisiones[0]['pco_porcentaje']/100));//+($resultado_base_comisiones[0]['bac_venta_especial_ferreteria']/0.035);
			
			//$aux=($ferreteria*($resultado_base_comisiones[0]['pco_porcentaje']/100))-($resultado_base_comisiones[0]['bac_venta_especial_ferreteria']);
			
			
			$comision=floatval($aux);

			//$comision=$comision;
			$comision=number_format($comision, 2, '.', '');
			
			//POSTCONVENIO
			$datos_comision[]=array(						
				'Rubros'=>'Ferretería 10%',
				'%Comision'=>$resultado_base_comisiones[0]['pco_porcentaje'].'%',
				'Valor'=>$ferreteria,
				'Comision'=>$comision,
			);
			
			//COMISIONES 
			
			$valorcomision=0;
			$com=$comision_model->getComision();
			foreach($com as $c)
			{
			    $value=eval('return $'. $c['com_campo_base_comisiones'] . ';');//'$'.$c['com_campo_base_comisiones'];
			    $valorcomision=number_format($value, 2, '.', '')*($c['com_porcentaje']/100);
			    $datos_comision[]=array(						
    				'Rubros'=>$c['com_titulo_reporte_pdv'],
    				'%Comision'=>$c['com_porcentaje'].'%',
    				'Valor'=>$value,
    				'Comision'=>$valorcomision,
    			);
			}
			 
			/*
			$ocho_porciento_ferre_may=$resultado_base_comisiones[0]['bac_ferreteria_mayorista']*0.08;
			$ocho_porciento_ferre_may=number_format($ocho_porciento_ferre_may, 2, '.', '');
			$datos_comision[]=array(						
				'Rubros'=>'Precio Mayorista Ferretería 8%',
				'%Comision'=>'8%',
				'Valor'=>$resultado_base_comisiones[0]['bac_ferreteria_mayorista'],
				'Comision'=>$ocho_porciento_ferre_may,
			);	
			
			$uno_pesado_mayorista=$resultado_base_comisiones[0]['bac_pesado_mayorista']*0.01;
			$uno_pesado_mayorista=number_format($uno_pesado_mayorista, 2, '.', '');
			$datos_comision[]=array(						
				'Rubros'=>'Pesado Mayorista Pesado 1%',
				'%Comision'=>'1%',
				'Valor'=>$resultado_base_comisiones[0]['bac_pesado_mayorista'],
				'Comision'=>$uno_pesado_mayorista,						
			);


            $cinco_adm=$resultado_base_comisiones[0]['bac_ferreteria_adm']*0.05;
			$cinco_adm=number_format($cinco_adm, 2, '.', '');
			$datos_comision[]=array(						
				'Rubros'=>'Precio Administrador Ferretería 5%',
				'%Comision'=>'5%',
				'Valor'=>$resultado_base_comisiones[0]['bac_ferreteria_adm'],
				'Comision'=>$cinco_adm,						
			);
			
			
			$convenio_material_pesado=$resultado_base_comisiones[0]['bac_pesado_adm']*0.005;
			$cinco_porciento_pesado_adm=number_format($convenio_material_pesado, 2, '.', '');
			$datos_comision[]=array(						
				'Rubros'=>'Precio Administrador Pesado 0,5%',
				'%Comision'=>'0.5%',
				'Valor'=>$resultado_base_comisiones[0]['bac_pesado_adm'],
				'Comision'=>$cinco_porciento_pesado_adm,
			);
			
			$convenio_material_petreo=$resultado_base_comisiones[0]['bac_venta_material_petreo']*0.25;
			$convenio_material_petreo=number_format($convenio_material_petreo, 2, '.', '');
			$datos_comision[]=array(						
				'Rubros'=>'Material Pétreo',
				'%Comision'=>'25%',
				'Valor'=>$resultado_base_comisiones[0]['bac_venta_material_petreo'],
				'Comision'=>$convenio_material_petreo,
			);
			*/
			
			if($resultado_base_comisiones[0]['bac_facturacion_directa_de_cemento']!=0){
    			$datos_comision[]=array(	
    				'Rubros'=>'Facturación - Cemento/Estibaje',
    				'%Comision'=>'',
    				'Valor'=>0,
    				'Comision'=>$resultado_base_comisiones[0]['bac_facturacion_directa_de_cemento'],
    			);
			}
			
			if($resultado_base_comisiones[0]['bac_facturacion_transporte']!=0){
    			$datos_comision[]=array(	
    				'Rubros'=>'Facturación por Transporte',
    				'%Comision'=>'',
    				'Valor'=>0,
    				'Comision'=>$resultado_base_comisiones[0]['bac_facturacion_transporte'],
    			);
			}
			foreach ($datos_convenio_porentaje_puvid as $key => $value) {
				//if($value['cop_valor_vendido']!=0 && $value['cop_porciento']!=0 ){
					$datos_comision[]=array(						
						'Rubros'=>$value['cov_nombre'],
						'%Comision'=>$value['cov_porcentaje'],
						'Valor'=>$value['cop_valor_vendido'],
						'Comision'=>$value['cop_porciento'],
					);

				//}

			}
			$post_convenio_model=new Postconveniomodel();
			$resultado_post_convenio= $post_convenio_model->getPostConveniodesdehasta($mes_fin,$mes_inicio);
			foreach ($resultado_post_convenio as $value) {
				$resultado_post_convenio_valor=$post_convenio_valor_model->getpostconvenioporcentajeid($resultado_base_comisiones[0]['puv_id'],$value['poc_id'],$mes_inicio);
				$valor_post_convenio=0;
				if(!empty($resultado_post_convenio_valor)){
					foreach ($resultado_post_convenio_valor as $key => $valuepostconvenio) {
						if($valuepostconvenio['pcv_valor']!=0){
							$datos_comision[]=array(	
								'Rubros'=>$valuepostconvenio['poc_nombre'],
								'%Comision'=>'',
								'Valor'=>0,
								'Comision'=>$valuepostconvenio['pcv_valor'],
							);
						}
					}
					
				}
				

			}
			$datos_comision_total_valor=0;
			$datos_comision_total_comision=0;
			foreach ($datos_comision as $key => $value) {
				$datos_comision_total_valor=$datos_comision_total_valor+$value['Valor'];
				$datos_comision_total_comision=$datos_comision_total_comision+$value['Comision'];
			}
			$datos_comision_total_valor=number_format($datos_comision_total_valor, 2, '.', '');
			$datos_comision_total_comision=number_format($datos_comision_total_comision, 2, '.', '');
			$datos_comision[]=array(	
				'Rubros'=>'Total',
				'%Comision'=>'',
				'Valor'=>$datos_comision_total_valor,
				'Comision'=>$datos_comision_total_comision,
			);

			
			


			$descuentos_model=new Descuentosmodel();
			//$resultado_descuentos_prefacturacion=$descuentos_model->getDescuentosprefacturacion();
			//$resultado_descuentos_postfacturacion=$descuentos_model->getDescuentospostfacturacion();
			$resultado_descuentos_prefacturacion_indefinido=$descuentos_model->getDescuentosindefinidosprefacturacion();
					
			$resultado_descuentos_prefacturacion_mensual=$descuentos_model->getDescuentosmensualprefacturacion($mes_fin,$mes_inicio);	

			$resultado_descuentos_prefacturacion=array_merge($resultado_descuentos_prefacturacion_indefinido,$resultado_descuentos_prefacturacion_mensual);


			$resultado_descuentos_postfacturacion_indefinido=$descuentos_model->getDescuentosindefinidospostfacturacion();
			$resultado_descuentos_postfacturacion_mensual=$descuentos_model->getDescuentosmensualpostfacturacion($mes_fin,$mes_inicio);

			$resultado_descuentos_postfacturacion=array_merge($resultado_descuentos_postfacturacion_indefinido,$resultado_descuentos_postfacturacion_mensual);

			$descuentos_antes_facturar=[];
			

			foreach ($resultado_descuentos_prefacturacion as $valuepre) {				
				
				$valor_descuento=0;				
				$cuota_descuento=0;
				if($valuepre['des_nombre_franquicias']=='Tipo Franquicia'){
					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$resultado_base_comisiones[0]['tfc_id'],$resultado_base_comisiones[0]['puv_id'],$valuepre['des_nombre_franquicias']);										
					if(!empty($descuentopresegunpdv)){
						$valor_descuento=$valuepre['des_valor'];

						if(date('Y-m',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']))==$mes_aux){
							$dias_totales=date('t',strtotime($mes_aux));
							$dias_inicio=date('d',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']));
							$dias_cobro=$dias_totales-$dias_inicio;

							$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;

							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;

							$valor_descuento=number_format($valor_descuento, 2, '.', '');
						}
						if($resultado_base_comisiones[0]['puv_propio']==1){
							$valor_descuento=0;
						}
						$mes_cuota=0;
						$cuotas_totales=0;
						$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);

						$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);

						if($mes_cuota==0){
							$valor_descuento=0;
							$cuota_descuento='';
						}else{
							if($mes_cuota<=$cuotas_totales){
							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
						    }
						    else
						    {
						        $cuota_descuento='';
						    }
						}
					}

				}else{
					if($valuepre['des_nombre_franquicias']=='PDV'){
						
						$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$resultado_base_comisiones[0]['tfc_id'],$resultado_base_comisiones[0]['puv_id'],$valuepre['des_nombre_franquicias']);
						if(!empty($descuentopresegunpdv)){
							$valor_descuento=$valuepre['des_valor'];
							
							if(date('Y-m',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']))==$mes_aux){
								$dias_totales=date('t',strtotime($mes_aux));
								$dias_inicio=date('d',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']));
								$dias_cobro=$dias_totales-$dias_inicio;

								$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;

								$valor_descuento=$valor_cobro_por_dia*$dias_cobro;

								$valor_descuento=number_format($valor_descuento, 2, '.', '');
							}
							if($resultado_base_comisiones[0]['puv_propio']==1){
								$valor_descuento=0;
							}
							$mes_cuota=0;
							$cuotas_totales=0;
							$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);

							$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);

							if($mes_cuota==0){
								$valor_descuento=0;
								$cuota_descuento='';
							}else{
								if($mes_cuota<=$cuotas_totales){
    							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    						    }
    						    else
    						    {
    						        $cuota_descuento='';
    						    }
							}
						}
					}
					
				}

				if($valuepre['des_frecuencia']=='indefinido'){
					$cuota_descuento=0;
				}
				if($valor_descuento!=0){
					$motivo='';
					if($cuota_descuento!=0){
						$motivo= $valuepre['des_nombre'].' '.$cuota_descuento;
					}else{
						$motivo= $valuepre['des_nombre'];
					}

					$descuentos_antes_facturar[]=array(
						'Motivo'=>$motivo,
						'Valor'=>$valor_descuento,
					);
				}

				
				
			}


			$resultado_descuentos_mensual_prefacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Pre-Facturacion',$mes_fin,$mes_inicio);

			foreach ($resultado_descuentos_mensual_prefacturacion_mensual as $value) {
				$valor_descuento=0;
				$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($resultado_base_comisiones[0]['puv_id'],$value['dem_id'],$mes_inicio);
				if(!empty($descuentomensualvalor[0]['dmv_valor'])){
					$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
				}
				if($valor_descuento!=0){	
					$descuentos_antes_facturar[]=array(
						'Motivo'=>$value['dem_nombre'],
						'Valor'=>$valor_descuento,
					);
				}	
			}

			$descuentos_antes_facturar_total=0;
			foreach ($descuentos_antes_facturar as $value) {
				$descuentos_antes_facturar_total=$descuentos_antes_facturar_total+$value['Valor'];
			}
			$descuentos_antes_facturar[]=array(
				'Motivo'=>'Total',
				'Valor'=>$descuentos_antes_facturar_total,//number_format($descuentos_antes_facturar_total,2),
			);

			


			$factura_pago=[];
			
			$valor_comision_total=$datos_comision_total_comision-$descuentos_antes_facturar_total;
			$factura_pago[]=array(
				'Motivo'=>'Factura',
				'Detalle'=>'Comisión',
				'Valor'=>$valor_comision_total,
			);
			$iva=$valor_comision_total*($resultado_base_comisiones[0]['irp_iva']/100);
			$iva=number_format($iva, 2, '.', '');
			$factura_pago[]=array(
				'Motivo'=>'',
				'Detalle'=>'Iva',
				'Valor'=>$iva,
			);
			$total_factura=$valor_comision_total+$iva;
			$total_factura=number_format($total_factura, 2, '.', '');
			$factura_pago[]=array(
				'Motivo'=>'',
				'Detalle'=>'Total Factura',
				'Valor'=>$total_factura,
			);
			//$reduccion_renta=$valor_comision_total*0.08;
			$reduccion_renta=$valor_comision_total*($resultado_base_comisiones[0]['irp_retencion_renta']/100);
			$reduccion_renta=number_format($reduccion_renta, 2, '.', '');
			$factura_pago[]=array(
				'Motivo'=>'Reducciones Pago',
				'Detalle'=>'Reducción renta '.$resultado_base_comisiones[0]['irp_retencion_renta'].'%',
				'Valor'=>$reduccion_renta,
			);
			//$reduccion_iva=$iva*0.7;
			$reduccion_iva=$iva*($resultado_base_comisiones[0]['irp_retencion_iva']/100);
			$reduccion_iva=number_format($reduccion_iva, 2, '.', '');
			$factura_pago[]=array(
				'Motivo'=>'',
				'Detalle'=>'Reducción Iva '.$resultado_base_comisiones[0]['irp_retencion_iva'].'%',
				'Valor'=>$reduccion_iva,
			);
			$total_recibor_dedicciones_pago=$total_factura-$reduccion_renta-$reduccion_iva;
			$total_recibor_dedicciones_pago=number_format($total_recibor_dedicciones_pago, 2, '.', '');
			$factura_pago[]=array(
				'Motivo'=>'',
				'Detalle'=>'Total a Recibir',
				'Valor'=>$total_recibor_dedicciones_pago,
			);
			$total_transferir=0;
			$total_transferir=$total_recibor_dedicciones_pago;
			$prestamos_model=new Prestamosmodel();
			$resultado_prestamos =$prestamos_model->getPrestamosdesdehasta($mes_fin,$mes_inicio);
			foreach ($resultado_prestamos as $value) {
				$valor_prestamo=0;
				$cuotas=0;
				$datos_prestamos=$prestamos_model->getUnPrestamosidpuvid($value['pre_id'],$resultado_base_comisiones[0]['puv_id']);

				if(!empty($datos_prestamos[0])){
					if(($auxmes>=$datos_prestamos[0]['pre_fecha_desde'] && $auxmes <=$datos_prestamos[0]['pre_fecha_hasta'])){
						$valor_prestamo=$datos_prestamos[0]['pre_pago_mensual'];
					}else{
						$valor_prestamo=0;
					}
					
					if('2022-06-01'>=$datos_prestamos[0]['pre_fecha_desde'] && '2022-06-01' <=$datos_prestamos[0]['pre_fecha_hasta']){//SE CONDICIONA PORQUE EL MES DE JUNIO NO SE VA A COBRAR PRÊSTAMOS DEBIDO AL PARO
    				    $valor_prestamo=$datos_prestamos[0]['pre_pago_mensual'];
    				    if($mes>'2022-06')
    				    {
    				        $mes_gracia=true;
    				    }
    				    else{
    				        $mes_gracia=false;
    				    }
    				}
    				
    				$mes_gracia=false;
					$cuotas=$this->obtenercuotas($datos_prestamos[0]['pre_fecha_desde'],$auxmes);
					
					if($mes_gracia==true)
					{
					    $cuotas=$cuotas-1;
					    $mes_gracia=false;
					}
					
					if($cuotas==0){
						$valor_prestamo=0;
					}else{
						if($cuotas<=$datos_prestamos[0]['pre_cuotas']){
						    $cuotas=$cuotas." de ".$datos_prestamos[0]['pre_cuotas'];
					    }
					    else
					    {
					        $cuotas='';
					    }
					}
				}

				if($valor_prestamo!=0){
				    if($mes!='2022-06'){ //SE CONDICIONA PORQUE EL MES DE JUNIO NO SE VA A COBRAR PRÊSTAMOS DEBIDO AL PARO
					    $total_transferir=$total_transferir-$valor_prestamo;
				    }
					$motivo='';
					if($cuotas!=0){
						$motivo= $value['pre_nombre'].' '.$cuotas;
					}else{
						$motivo= $value['pre_nombre'];
					}
                        
                        
                //SE CONDICIONA PORQUE EL MES DE JUNIO NO SE VA A COBRAR PRÊSTAMOS DEBIDO AL PARO
                if($mes!='2022-06'){
					$factura_pago[]=array(
						'Motivo'=>'',
						'Detalle'=>$motivo,
						'Valor'=>$valor_prestamo,
					);
                }
                else{
					$factura_pago[]=array(
						'Motivo'=>'',
						'Detalle'=>$motivo.'prestamo',
						'Valor'=>"Esta cuota se cobrará al final, debido al acuerdo creado con los franquiciados por el paro",
					);
                }
				}

				

				

			}
			
			foreach ($resultado_descuentos_postfacturacion as $valuepost) {
				$valor_descuento=0;
				$cuota_descuento=0;
				if($valuepost['des_nombre_franquicias']=='Tipo Franquicia'){
					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$resultado_base_comisiones[0]['tfc_id'],$resultado_base_comisiones[0]['puv_id'],$valuepost['des_nombre_franquicias']);
					if(!empty($descuentopresegunpdv)){
						$valor_descuento=$valuepost['des_valor'];
						
						if(date('Y-m',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']))==$mes_aux){
							$dias_totales=date('t',strtotime($mes_aux));
							$dias_inicio=date('d',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']));
							$dias_cobro=$dias_totales-$dias_inicio;

							$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;

							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;

							$valor_descuento=number_format($valor_descuento, 2, '.', '');
						}
						if($resultado_base_comisiones[0]['puv_propio']==1){
							$valor_descuento=0;
						}
						$mes_cuota=0;
						$cuotas_totales=0;
						$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);

						$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);

						if($mes_cuota==0){
							$valor_descuento=0;
							$cuota_descuento='';
						}else{
							if($mes_cuota<=$cuotas_totales){
    							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    						    }
    						    else
    						    {
    						        $cuota_descuento='';
    						    }
						}
					}
				}else{
					if($valuepost['des_nombre_franquicias']=='PDV'){
						$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$resultado_base_comisiones[0]['tfc_id'],$resultado_base_comisiones[0]['puv_id'],$valuepost['des_nombre_franquicias']);
						if(!empty($descuentopresegunpdv)){
							$valor_descuento=$valuepost['des_valor'];
							
							if(date('Y-m',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']))==$mes_aux){
								$dias_totales=date('t',strtotime($mes_aux));
								$dias_inicio=date('d',strtotime($resultado_base_comisiones[0]['puv_fecha_apertura']));
								$dias_cobro=$dias_totales-$dias_inicio;

								$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;

								$valor_descuento=$valor_cobro_por_dia*$dias_cobro;

								$valor_descuento=number_format($valor_descuento, 2, '.', '');
							}
							if($resultado_base_comisiones[0]['puv_propio']==1){
								$valor_descuento=0;
							}
							$mes_cuota=0;
							$cuotas_totales=0;
							$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);

							$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);

							if($mes_cuota==0){
								$valor_descuento=0;
								$cuota_descuento='';
							}else{
								if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
							}
						}
					}
				}
				if($valuepost['des_frecuencia']=='indefinido'){
					$cuota_descuento=0;
				}
				
				if($valor_descuento!=0){
					$total_transferir=$total_transferir-$valor_descuento;
					$motivo='';
					if($cuota_descuento!=0){
						$motivo= $valuepost['des_nombre'].' '.$cuota_descuento;
					}else{
						$motivo= $valuepost['des_nombre'];
					}

					$factura_pago[]=array(
						'Motivo'=>'',
						'Detalle'=>$motivo,
						'Valor'=>$valor_descuento,
					);
				}
			}
			
			$resultado_descuentos_mensual_postfacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Post-Facturacion',$mes_fin,$mes_inicio);

			foreach ($resultado_descuentos_mensual_postfacturacion_mensual as $value) {
				$valor_descuento=0;
				$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($resultado_base_comisiones[0]['puv_id'],$value['dem_id'],$mes_inicio);

				if(!empty($descuentomensualvalor[0]['dmv_valor'])){
					$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
				}

				if($valor_descuento!=0){
					$total_transferir=$total_transferir-$valor_descuento;					
					$factura_pago[]=array(
						'Motivo'=>'',
						'Detalle'=>$value['dem_nombre'],
						'Valor'=>$valor_descuento,
					);
				}
			}
			
			$total_transferir=number_format($total_transferir, 2, '.', '');
			$factura_pago[]=array(
				'Motivo'=>'',
				'Detalle'=>'Total a Transferir',
				'Valor'=>$total_transferir,
			);
			
			$datos_enviar=array(
				'datos_venta'=>$resultado_venta_model,
				'datos_comision'=>$datos_comision,
				'datos_descuentos_antes_facturar'=>$descuentos_antes_facturar,
				'datos_factura_pago'=>$factura_pago,
				'puv_punto_venta'=>$resultado_base_comisiones[0]['puv_punto_venta'],
				'puv_ciudad'=>$resultado_base_comisiones[0]['puv_ciudad'],
				'puv_franquiciado'=>$resultado_base_comisiones[0]['puv_franquiciado'],
				'puv_direccion'=>$resultado_base_comisiones[0]['puv_direccion'],
				'puv_telefono_personal'=>$resultado_base_comisiones[0]['puv_telefono_personal'],
				'puv_correo_empresa'=>$resultado_base_comisiones[0]['puv_correo_personal'],
				'periodo'=>$mes,
				'puv_id'=>$resultado_base_comisiones[0]['puv_id'],
				'observacion'=>$observacion[0]['cpo_observacion']
			);

			

			
			echo view("layouts/header");
			echo view("layouts/aside",$datos_menu);
			echo view("reporte/reportepdv",$datos_enviar);
			echo view("layouts/footer");

		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione el punto de venta y el mes');
			return redirect()->to(base_url('Reporte/fechareportepdv')); 
		}

		
	}
	
	public function agregarobservacionreportemensualpdv(){
	    
	    $session = \Config\Services::session();	
	    $datos_menu = $this->datosMenu();
	    $punto_venta_model= new Puntoventamodel();	
	    
	    $puv_id=$this->request->getPost('puv_id');
	    $mes=$this->request->getPost('mes');
	    $observacion=$this->request->getPost('observacion');
	    
	    $datos_enviar=array(
			'cpo_fecha'=>$mes,
			'puv_id'=>$puv_id,
			'cpo_observacion'=>$observacion,
		);
		
		$resultado=$punto_venta_model->insertarObservacionReporteMensualPDV($datos_enviar);
		if(empty($resultado)){
		    $session->setFlashdata('mensaje_bueno', 'Observación agregada correctamente');
			return redirect()->to(base_url('Reporte/fechareportepdv'));
		}
		else
		{
		    $session->setFlashdata('mensaje_malo', 'Error');
			return redirect()->to(base_url('Reporte/fechareportepdv')); 
		}
	    
	}
	
	public function actualizarobservacionreportemensualpdv(){
	    
	    $session = \Config\Services::session();	
	    $datos_menu = $this->datosMenu();
	    $punto_venta_model= new Puntoventamodel();	
	    
	    $puv_id=$this->request->getPost('puv_idedit');
	    $mes=$this->request->getPost('mesedit');
	    $observacion=$this->request->getPost('observacionedit');
	
	    $datos_enviar=array(
			'cpo_observacion'=>$observacion,
		);
		
		$resultado=$punto_venta_model->actualizarObservacionReporteMensualPDV($datos_enviar,$puv_id,$mes);
		if(($resultado==1)){
		    $session->setFlashdata('mensaje_bueno', 'Observación modificada correctamente');
			return redirect()->to(base_url('Reporte/fechareportepdv'));
		}
		else
		{
		    $session->setFlashdata('mensaje_malo', $resultado);
			return redirect()->to(base_url('Reporte/fechareportepdv')); 
		}
	    
	}
	
	public function agregardocumento(){
		$session = \Config\Services::session();		
		$email = \Config\Services::email();
		
		/*$config['protocol'] = 'sendmail';
		$config['mailPath'] = 'C:/xampp/sendmail';
		$config['charset']  = 'iso-8859-1';
		$config['wordWrap'] = true;

		$email->initialize($config);*/
		
		
		$documento_enviado_model=new Documentoenviadomodel();
		$puv_id=$this->request->getPost('puvidcorreoenviar');
		$correo=$this->request->getPost('datocorreo');
		$doe_mes=$this->request->getPost('mescorreoenviar');
		$doe_mes=date('Y-m-01',strtotime($doe_mes));
		$resultado=$documento_enviado_model->getDocumentoenviado($doe_mes,$puv_id);
		$doe_mes1=date('Y-m',strtotime($doe_mes));
		if(empty($resultado)){
			$file = $this->request->getFile('doc');
			if($file!=null){
				$nombre_documento = $file->getRandomName();			
				$file->move(ROOTPATH.'public/upload/comisiones/', $nombre_documento);
				$doe_link=base_url().'/public/upload/comisiones/'.$nombre_documento;
				$datos_documento_enviado=array(				
					'doe_link'=>$doe_link,
					'puv_id'=>$puv_id,
					'doe_mes'=>$doe_mes,
					'doe_estado'=>1,
				);				
				$documento_enviado_model->insertar($datos_documento_enviado);
				$message  = "<html><body>";
				$mensaje=$message.'Estimado,<br/><br/>';
				$mensaje=$mensaje.'Adjunto encontrará el reporte de comisiones correspondiente al mes '.$doe_mes1.'<br/><br/><br/>';
				$mensaje=$mensaje.'Solicito su ayuda con la emisión <b>urgente</b> de la factura correspondiente,vía Whatsapp y la original por Servientrega.';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'Se recuerda que, para ser canceladas las comisiones es necesaria la llegada del documento original (en caso de facturas físicas).';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'Favor tomar en cuenta las recomendaciones que a continuación se detalla:';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'1. Enviar la factura original según el cronograma. Recuerde sin ella no se puede proceder con el pago.';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'2. Llenar la factura con fecha 8 del mes correspondiente, si por cualquier razón la envía pasada esa fecha, deberá ir con la fecha del día de envío de la misma. ';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'<b>CONSULTAS Y RECTIFICACIONES</b>';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'En caso de tener dudas sobre sus descuentos, por favor comunicarse con la persona encargada de operaciones de su punto de venta.<br/> Cualquier rectificación de valores deberá ser solicitada máximo 48 horas después (días laborables) de recibir su reporte. ';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'<b>SOBREGIROS</b>';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'En el caso de observar en su detalle de comisiones TOTAL A RECIBIR, este es un valor en negativo y no será cancelado; por lo tanto, al ser un valor adeudado con Megaprofer el mismo será cobrado en las próximas comisiones o a su vez debitado de saldos a su favor de ser el caso. ';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'<b>Saludos cordiales,</b>';
				$mensaje=$mensaje.'<br/><br/><br/><br/>';
				$mensaje=$mensaje.'<b>Departamento de Operaciones</b>';
				$mensaje=$mensaje.'</body></html>';
				
				$file_to_attach = $doe_link;
                $email->attach( $file_to_attach , $doe_mes );
        		$email->setFrom('info.tics@megaprofer.com', 'Comisiones Megaprofer');
        		$email->setTo($correo);
        
        		$email->setSubject('Comisiones mensuales');
        		$email->setMessage($mensaje);
        
        		$email->send();
				$session->setFlashdata('mensaje_bueno', 'Enviado link: <a target="_blank" href="'.$doe_link.'">'.$doe_link.'</a>');
				
				return redirect()->to(base_url('Reporte/fechareportepdv')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'No enviado');
				return redirect()->to(base_url('Reporte/fechareportepdv')); 
			}
		}else{
			$session->setFlashdata('mensaje_malo', 'Documento ya enviado link: <a target="_blank" href="'.$resultado[0]['doe_link'].'">'.$resultado[0]['doe_link'].'</a>');
			return redirect()->to(base_url('Reporte/fechareportepdv')); 
		}
		
		
	}
	
	public function guardardatosmes(){
		$session = \Config\Services::session();
		$comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
		$mes= $this->request->getPost('reportedatosmes');
		if(empty($mes)){
			$session->setFlashdata('mensaje_malo', 'Ingrese mes');
			return redirect()->to(base_url('Reporte')); 
		}
		
		$mes_inicio=date('Y-m-1',strtotime($mes));
		$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
		if(!empty($resultado)){
			$session->setFlashdata('mensaje_malo', 'Ya existen datos guardados');
			return redirect()->to(base_url('Reporte')); 
		}

		$titulos= $this->request->getPost('reportetitulos');		
		$datos= $this->request->getPost('reportedatos');
		$imprimir= $this->request->getPost('reportedatosimprimir');		
		

		$titulos=base64_decode($titulos);
		$datos=base64_decode($datos);
		$imprimir=base64_decode($imprimir);
		



		$datos_guardar=array(
			'titulos'=>$titulos,
			'datos'=>$datos,
			'imprimir_datos_csv'=>$imprimir,			
		);
		$datos_guardar=json_encode($datos_guardar,JSON_UNESCAPED_UNICODE);
		$datos_guardar=base64_encode($datos_guardar);
		$link=base_url().'/public/upload/reportecomisionmensual/'.$mes.'.txt';
		$archivo=fopen('public//upload/reportecomisionmensual/'.$mes.'.txt', 'w');
		fputs($archivo,$datos_guardar);
		fclose($archivo);

		$datos=array(
			'cmf_link'=>$link,
			'cmf_mes'=>$mes_inicio,
			'cmf_estado'=>1
		);
		$comision_mes_finalizado_model->insertar($datos);
		$session->setFlashdata('mensaje_bueno', 'Datos Guardados');
		return redirect()->to(base_url('Reporte')); 

	}

    public function reportecomparacion(){
        $datos_menu = $this->datosMenu();
        $session = \Config\Services::session();
	    $resultadoComparacion=[];
	    $meses=$this->request->getPost('meses');
	    $tipo=$this->request->getPost('tipo');
	    if(empty($meses)){
			$session->setFlashdata('mensaje_malo', 'Ingrese los meses a comparar');
			return redirect()->to(base_url('reporte/fechareportecomparacion'));
		}
		else
		{
		    
		    $m=explode(',',$meses);
		    $m=array_unique($m);
		    arsort($m);
		    array_pop($m);
    	    //print_r($m);
    	    foreach($m as $mes)
    	    {
    	        if($mes!=''){
        	        $mes_aux=date("Y-m", strtotime($mes));
    		        $mes_inicio=date("Y-m-1", strtotime($mes));
        	        $comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
            		//$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
            		if(1==0){
            			
            		}
            		else{
            	        $enviar_datos=$this->obtenerReporteGeneralMes($mes,'fechareportecomparacion',$tipo);
            	        if($enviar_datos=='no')
            	        {
            	            return redirect()->to(base_url('Reporte/fechareportecomparacion')); 
            	        }
                    	array_push($resultadoComparacion,$enviar_datos);
            		}
    	        }
    	    }
    	    $inf_pdv=[];
    	    ////echo count($m);
    	    $pdv_model=new Puntoventamodel();
    	    $pdv1=$pdv_model->getNombrePuntoventaDueno($tipo);
    	    $comprobacion_pdv=false;
    	    $pdv_diferencia_comision=0;
    	    $pdv_diferencia_venta=0;
    	    $pdv_suma=0;
    	    $precios_comisiones=0;
    	    $total_comision=0;
    	    $comision_pesado=0;
            $comision_ferreteria=0;
    	    foreach($pdv1 as $pdv)
    	    {
    	        $comprobacion_pdv=false;
    	        $pdv_total=[];
    	        $pdv_valor=0;
    	        array_push($pdv_total,$pdv['puv_punto_venta']);
    	        $ubicacion_base_ferreteria=0;
    	        $ubicacion_base_pesado=0;
    	        $ubicacion_comision_pesado=0;
    	        $ubicacion_comision_ferreteria=0;
    	        $ubicacion_total_general=0;
    	        $ubicacion_comision=0;
    	        $ubicacion_comisiones=[];
        	    for($i=0;$i<count($m);$i++)
        	    {
        	        $datos=json_decode($resultadoComparacion[$i]['datos']);?><?php //echo '<pre'; print_r(json_decode($resultadoComparacion[$i]['titulos'])); echo '<pre>';?><?php 
        	        $titulos=json_decode($resultadoComparacion[$i]['titulos']);
        	        for($l=0;$l<count($titulos);$l++)
            	    {
            	        
            	        if($titulos[$l]=='Base ferreteria')
            	        {
            	            $ubicacion_base_ferreteria=$l;
            	        }
            	        if($titulos[$l]=='Base pesado')
            	        {
            	            $ubicacion_base_pesado=$l;
            	        }
            	        if($titulos[$l]=='2% comisión (0.5% especiales)')
            	        {
            	            $ubicacion_comision_pesado=$l;
            	        }
            	        if($titulos[$l]=='Comisión')
            	        {
            	            $ubicacion_comision_ferreteria=$l;
            	        }
            	        if($titulos[$l]=='Total General')
            	        {
            	            $ubicacion_total_general=$l;
            	        }
            	        if(trim($titulos[$l])=='Comisión')
            	        {
            	            $ubicacion_comision=$l;
            	        }
            	        if(trim($titulos[$l])=='Total Comisión')
            	        {
            	            $ubicacion_comision_total=$l;
            	        }
            	    }
            	    for($j=0;$j<count($datos);$j++)
            	    {
            	        $base_ferreteria=$datos[$j]->{$ubicacion_base_ferreteria}; 
            	        $base_pesado=$datos[$j]->{$ubicacion_base_pesado}; 
            	        if($datos[$j]->{1}==$pdv['puv_punto_venta'])
            	        {
            	            //echo 'entra';
            	            $comprobacion_pdv=true;
            	            $pdv_ferreteria=$base_ferreteria+0.00;
                	        $pdv_pesado=$base_pesado+0.00;
                	        $comision_pesado=$datos[$j]->{$ubicacion_comision_pesado};
                	        $comision_ferreteria=$datos[$j]->{$ubicacion_comision_ferreteria};
                	        $precios_comisiones=0;
                	        /*for($k=$ubicacion_total_general+1;$k<$ubicacion_comision;$k++)
                	        {
                	            $precios_comisiones+=$datos[$j]->{$k};
                	            //echo $precios_comisiones+=$datos[$j]->{$k};;
                	        }*/
                	        $precios_comisiones+=$datos[$j]->{$ubicacion_comision_total};
            	            $total_comision=$precios_comisiones;
            	            $cf=$comision_ferreteria;
            	            $cp=$comision_pesado;
            	            $precios_comisiones=$precios_comisiones-$comision_ferreteria-$comision_pesado;
                	        $pdv_suma=$pdv_ferreteria+$pdv_pesado+0.00;
                	        if($i==0)
                	        {
                	            $pdv_diferencia_comision=$total_comision;
                	            $pdv_diferencia_venta=$pdv_suma;
                	        }
                	        else
                	        {
                    	        $pdv_diferencia_comision=$pdv_diferencia_comision-$total_comision;
                    	        $pdv_diferencia_venta=$pdv_diferencia_venta-$pdv_suma;
                	        }
            	            break;
            	        }   
            	        else
            	        {
            	            $pdv_ferreteria=0;
    	                    $pdv_pesado=0;
    	                    $pdv_suma=0;
            	            $pdv_valor=0;
            	            $total_comision=0;
            	            if($i==0)
                	        {
                	            $pdv_diferencia_comision=$pdv_valor;
                	            $pdv_diferencia_venta=$pdv_suma;
                	        }
                	        else
                	        {
                    	        $pdv_diferencia_comision=$pdv_diferencia_comision-$total_comision;
                    	        $pdv_diferencia_venta=$pdv_diferencia_venta-$pdv_suma;
                	        }
            	        }
            	    }
            	    array_push($pdv_total,(string)$pdv_ferreteria);
            	    array_push($pdv_total,(string)$pdv_pesado);
            	    array_push($pdv_total,(string)$pdv_suma);
            	    array_push($pdv_total,(string)$precios_comisiones);
            	    array_push($pdv_total,(string)$comision_pesado);
            	    array_push($pdv_total,(string)$comision_ferreteria);
            	    array_push($pdv_total,(string)$total_comision);
            	    
        	    }
        	        $pdv_ferreteria=0;
                    $pdv_pesado=0;
                    $pdv_suma=0;
    	            $pdv_valor=0;
    	            $precios_comisiones=0;
    	            $total_comision=0;
    	            $comision_pesado=0;
                	$comision_ferreteria=0;
    	            array_push($pdv_total,(string)$pdv_diferencia_venta);
    	            array_push($pdv_total,(string)$pdv_diferencia_comision);
    	            array_push($inf_pdv,$pdv_total);
            	    //print_r($inf_pdv); 
            	    $pdv_diferencia_venta=0;
            	    $pdv_diferencia_comision=0;
    	    }
    	    $resultadoComparacion=array(
    	        'meses'=>$m,
    	        'info'=>$inf_pdv,
    	        );
    	    
    	    //print_r($inf_pdv[1]); 
    	    //echo $ubicacion_comision;
    	    echo view("layouts/header");
			echo view("layouts/aside",$datos_menu);
			echo view("reporte/reportecomparacion",$resultadoComparacion);
			echo view("layouts/footer");
		}
	    
	    
	}
	
	function obtenerReporteGeneralMes($mes,$reporte,$tipo)
	{
	    $mensaje='';
	    $enviar_datos=[];
	    $base_comisiones_model= new Basecomisionesmodel();
    	$convenio_model=new Conveniomodel();
    	$convenio_porcentaje_model=new Convenioporcentajemodel();
    	$descuentos_model=new Descuentosmodel();
    	$prestamos_model=new Prestamosmodel();
    
    	$post_convenio_model=new Postconveniomodel();
    	$post_convenio_valor_model=new Postconveniovalormodel();
    	
    	$descuento_mensual_model=new Descuentomensualmodel();
    	$descuento_mensual_valor_model=new Descuentomensualvalormodel();
    	$descuento_pdv_tipo_franquicia_model=new Descuentospdvtipofranquiciamodel();
    
        $comision_model=new Comisionmodel();
        
    	$session = \Config\Services::session();
    
    	
    
    	$mes=date("Y-m-d", strtotime($mes));
    
    	$resultado_base_comisiones=$base_comisiones_model->getBasecomisionespormes($mes,$tipo);
        
        $mes_aux=date("Y-m", strtotime($mes));
    	$mes_inicio=date("Y-m-d", strtotime($mes));
    	$mes_fin=date("Y-m-t", strtotime($mes));
    
    	//$resultado_convenio=$convenio_model->getConveniopormes($mes_aux);
    
    	$resultado_convenio=$convenio_model->getConveniodesdehasta($mes_fin,$mes_inicio);
    	$resultado_convenio=$convenio_model->getConveniodesdehasta($mes_fin,$mes_inicio);
    			
    
    	if(empty($resultado_base_comisiones)){
    		$mes=date("Y-m", strtotime($mes));
    		$session->setFlashdata('mensaje_malo', 'No hay datos del mes: '.$mes);
    		return "no";//redirect()->to(base_url('Reporte/'.$reporte)); 
    	}
        else
        {
    	
    	
    	
    
    	$resultado_descuentos_prefacturacion_indefinido=$descuentos_model->getDescuentosindefinidosprefacturacion();
    			
    	$resultado_descuentos_prefacturacion_mensual=$descuentos_model->getDescuentosmensualprefacturacion($mes_fin,$mes_inicio);	
    
    	$resultado_descuentos_prefacturacion=array_merge($resultado_descuentos_prefacturacion_indefinido,$resultado_descuentos_prefacturacion_mensual);
    	
    
    	$resultado_descuentos_postfacturacion_indefinido=$descuentos_model->getDescuentosindefinidospostfacturacion();
    	$resultado_descuentos_postfacturacion_mensual=$descuentos_model->getDescuentosmensualpostfacturacion($mes_fin,$mes_inicio);
    
    	$resultado_descuentos_postfacturacion=array_merge($resultado_descuentos_postfacturacion_indefinido,$resultado_descuentos_postfacturacion_mensual);
    	
    	$resultado_prestamos =$prestamos_model->getPrestamosdesdehastaDistinct($mes_fin,$mes_inicio);
    	$resultado_prestamos2 =$prestamos_model->getPrestamosdesdehastaDistinct($mes_fin,$mes_inicio,$pre_nombre);
    	
        $resultado_descuentos_mensual_postfacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Post-Facturacion',$mes_fin,$mes_inicio);
    	$resultado_descuentos_mensual_prefacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Pre-Facturacion',$mes_fin,$mes_inicio);
    	
    	$titulos=[];
    	
    
    
    	array_push($titulos, "ID", "PDV","Franquiciado","Estatus", "Base pesado", "Pesado","Ventas Especiales Pesado", "Pesado ADM", "Pesado May", "Total Pesado", "Base ferreteria", "Ferreteria", "Ferreteria ADM", "Ferreteria May", "Total Ferreteria","Ventas Especiales Ferreteria",'Devolución saldo a favor');
    
    	foreach ($resultado_convenio as $value) {
    		array_push($titulos,$value['cov_nombre']);
    	}
    	array_push($titulos,'Vta Mate Petreo');
    	array_push($titulos,'Vta sin Comisi Pesado');
    	array_push($titulos,'Vta sin Comisi Ferreteria');
    	array_push($titulos,'Total General');
    	
    	$com=$comision_model->getComision(); //obtiene los titulos, porcentajes y campos para calcular de la base de comisiones
		foreach($com as $c)
		{
		    array_push($titulos,$c['com_titulo_reporte_general']);
		}
    	
    	/*
    	array_push($titulos,'Com. 5% Ferr ADM');
    	array_push($titulos,'Com. 8% Ferr MAY');
    	array_push($titulos,'Com. 0.5% Pesa. ADM');
    	array_push($titulos,'Com. 1% Pesa. MAY');
    	array_push($titulos,'2% comisión (0.5% especiales)');
        array_push($titulos,'25% Ventas Material Petreo');
        */
        
        
    	foreach ($resultado_convenio as $value) {
    		array_push($titulos,$value['cov_porcentaje']."%"." ".$value['cov_nombre']." ");
    	}
    	
    	array_push($titulos,'Comisión');
    	array_push($titulos,'Fact. direc. Cemento/estibaje');
    	array_push($titulos,'Fact. transporte');
    
    
    	$resultado_post_convenio= $post_convenio_model->getPostConveniodesdehasta($mes_fin,$mes_inicio);
    
    
    	foreach ($resultado_post_convenio as $value) {
    		array_push($titulos,$value['poc_nombre']);
    	}
    
    	array_push($titulos,'Total Comisión');
    
    
    
    
    	///Descuentos pre-facturacion
    	foreach ($resultado_descuentos_prefacturacion as $value) {
    		array_push($titulos,$value['des_nombre']);
    		array_push($titulos,'Cuotas '.$value['des_nombre']);
    		
    	}
    	///Descuentos pre-facturacion MENSUAL
    	foreach ($resultado_descuentos_mensual_prefacturacion_mensual as $value) {
    		array_push($titulos,$value['dem_nombre']);
    	}
    
    	array_push($titulos,'Total Descuentos');
    
    	array_push($titulos,'Total Facturar');
    	array_push($titulos,'IVA');
    	array_push($titulos,'Total');
    	array_push($titulos,'Retención Renta');
    	array_push($titulos,'Retención IVA');
    	array_push($titulos,'Total Recibir');
    
    	///Descuentos post-facturacion
    	foreach ($resultado_descuentos_postfacturacion as $value) {
    		array_push($titulos,$value['des_nombre']);
    		array_push($titulos,'Cuotas '.$value['des_nombre']);
    	}
    	///Descuentos post-facturacion MENSUAL
    	foreach ($resultado_descuentos_mensual_postfacturacion_mensual as $value) {
    		array_push($titulos,$value['dem_nombre']);
    	}
    
    	///Prestamos
    	foreach ($resultado_prestamos as $value) {
    		array_push($titulos,$value['pre_nombre']);
    		array_push($titulos,'Cuotas de '.$value['pre_nombre']);
    	}
    
    	array_push($titulos,'Total Descuento Post Fact');
    	array_push($titulos,'Total a Recibir');
    
    
        
    	
    
    	$datos=[];
    	for ($i=0; $i < sizeof($resultado_base_comisiones) ; $i++) { 
    		$total_general=0;
    		//PESADO
    		$total_pesado=$resultado_base_comisiones[$i]['bac_pesado_adm']+$resultado_base_comisiones[$i]['bac_pesado_mayorista'];//Formula total pesado
    		$pesado=$resultado_base_comisiones[$i]['bac_pesado']-$total_pesado-$resultado_base_comisiones[$i]['bac_ventas_especiales_sin_comision_pesado'];//formula pesado
    		$total_general=$total_general+$pesado;
    		$total_pesado=number_format($total_pesado, 2, '.', '');
    		$total_general=$total_general+$total_pesado;
    		$pesado=number_format($pesado, 2, '.', '');
    		$datos[$i][0]=$resultado_base_comisiones[$i]['puv_id'];//id
    		$datos[$i][1]=$resultado_base_comisiones[$i]['puv_punto_venta'];//punto venta
    		$datos[$i][2]=$resultado_base_comisiones[$i]['puv_franquiciado'];//Franquiciado
    		$propio='';
    		if($resultado_base_comisiones[$i]['puv_propio']==1){
    			$propio='Propio';
    		}else{
    			$propio='Franquicia';
    		}
    		$datos[$i][3]=$propio;//propio
    		$datos[$i][4]=$resultado_base_comisiones[$i]['bac_pesado'];//base pasado
    		
    		$datos[$i][6]=$resultado_base_comisiones[$i]['bac_venta_especial_pesado'];//venta especial pesado
    		$datos[$i][7]=$resultado_base_comisiones[$i]['bac_pesado_adm'];//pesado precio adm
    		$datos[$i][8]=$resultado_base_comisiones[$i]['bac_pesado_mayorista'];//pesado precio mayorista
    		$datos[$i][9]=$total_pesado;//Total pesado
    		//Ferreteria
    		$total_ferreteria=$resultado_base_comisiones[$i]['bac_ferreteria_adm']+$resultado_base_comisiones[$i]['bac_ferreteria_mayorista'];
    		
    
    		$total_ferreteria=number_format($total_ferreteria, 2, '.', '');
    		$total_general=$total_general+$total_ferreteria;
    		$datos[$i][10]=$resultado_base_comisiones[$i]['bac_ferreteria'];//Base ferreteria
    		$datos[$i][12]=$resultado_base_comisiones[$i]['bac_ferreteria_adm'];//Precio admin ferreteria
    		$datos[$i][13]=$resultado_base_comisiones[$i]['bac_ferreteria_mayorista'];//Precio mayorista ferreteria
    		$datos[$i][14]=$total_ferreteria;//Total ferreteria
    		$datos[$i][15]=$resultado_base_comisiones[$i]['bac_venta_especial_ferreteria'];//venta especial pesado
    		$datos[$i][16]=$resultado_base_comisiones[$i]['bac_devolucion_saldo_favor'];
    		$j=16;
    		$total_general=$total_general+$resultado_base_comisiones[$i]['bac_venta_especial_ferreteria'];
    
    		$ferreteria=$resultado_base_comisiones[$i]['bac_ferreteria']-$total_ferreteria;
    		foreach ($resultado_convenio as $value) {
    			$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($resultado_base_comisiones[$i]['puv_id'],$value['cov_id'],$mes_inicio);
    			$valor_convenio=0;
    			if(!empty($resultado_convenio_porcentaje[0]['cop_valor_vendido'])){
    				$valor_convenio=$resultado_convenio_porcentaje[0]['cop_valor_vendido'];
    			}
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_convenio;
    			if($value['cov_tipo']==1)
    			{
    			    $ferreteria=$ferreteria-$valor_convenio;
    			}
    			else
    			{
    			    $pesado=$pesado-$valor_convenio;
    			}
    			$total_general=$total_general+$valor_convenio;
    		}
    		$ferreteria=$ferreteria-$resultado_base_comisiones[$i]['bac_venta_especial_ferreteria'];
    		$ferreteria=$ferreteria-$resultado_base_comisiones[$i]['bac_ventas_especiales_sin_comision_ferreteria'];
    		$ferreteria=$ferreteria-$resultado_base_comisiones[$i]['bac_venta_material_petreo'];
    		$ferreteria=number_format($ferreteria, 2, '.', '');
    		$datos[$i][5]=$pesado;//pesado
    		$datos[$i][11]=$ferreteria;		
    		$total_general=$total_general+$ferreteria;
    
    		$j=$j+1;
    		$datos[$i][$j]=$resultado_base_comisiones[$i]['bac_venta_material_petreo'];//venta material petreo
    		$j=$j+1;
    		$datos[$i][$j]=$resultado_base_comisiones[$i]['bac_ventas_especiales_sin_comision_pesado'];//venta sin comision pesado
    		$j=$j+1;
    		$datos[$i][$j]=$resultado_base_comisiones[$i]['bac_ventas_especiales_sin_comision_ferreteria'];//venta sin comision ferreteria
    		
    		$total_general=$total_general+$resultado_base_comisiones[$i]['bac_ventas_especiales_sin_comision_pesado'];
    		$total_general=$total_general+$resultado_base_comisiones[$i]['bac_ventas_especiales_sin_comision_ferreteria'];
    		$total_general=$total_general+$resultado_base_comisiones[$i]['bac_venta_material_petreo'];
    		$total_general=number_format($total_general, 2, '.', '');
    		$j=$j+1;
    		$datos[$i][$j]=$total_general;
    
    
    		$total_comision=0;
            $total_comision=$total_comision+$resultado_base_comisiones[$i]['bac_devolucion_saldo_favor'];
            
            
            $valorcomision=0;
			$com=$comision_model->getComision();
			foreach($com as $c)
			{
			    $value=eval('return $'. $c['com_campo_base_comisiones_rgeneral'] . ';');//'$'.$c['com_campo_base_comisiones'];
			    $valorcomision=number_format($value, 2, '.', '')*($c['com_porcentaje']/100);
			    $j=$j+1;
			    $datos[$i][$j]=$valorcomision;
                $total_comision=$total_comision+$valorcomision;
			}
            
            /*
    		$j=$j+1;
    		$comision_cinco_ferreteria_adm=$resultado_base_comisiones[$i]['bac_ferreteria_adm']*0.05;
    		$comision_cinco_ferreteria_adm=number_format($comision_cinco_ferreteria_adm, 2, '.', '');
    		$datos[$i][$j]=$comision_cinco_ferreteria_adm;
    
    		$total_comision=$total_comision+$comision_cinco_ferreteria_adm;
    		
    
    		$j=$j+1;
    		$comision_ocho_ferreteria_may=$resultado_base_comisiones[$i]['bac_ferreteria_mayorista']*0.08;
    		$comision_ocho_ferreteria_may=number_format($comision_ocho_ferreteria_may, 2, '.', '');
    		$datos[$i][$j]=$comision_ocho_ferreteria_may;
    
    		$total_comision=$total_comision+$comision_ocho_ferreteria_may;
    
    		$j=$j+1;
    		$comision_cinco_pesado_admin=$resultado_base_comisiones[$i]['bac_pesado_adm']*0.005;
    		$comision_cinco_pesado_admin=number_format($comision_cinco_pesado_admin, 2, '.', '');
    		$datos[$i][$j]=$comision_cinco_pesado_admin;
    
    		$total_comision=$total_comision+$comision_cinco_pesado_admin;
    
    		$j=$j+1;
    		$comision_uno_pesado_admin=$resultado_base_comisiones[$i]['bac_pesado_mayorista']*0.01;
    		$comision_uno_pesado_admin=number_format($comision_uno_pesado_admin, 2, '.', '');
    		$datos[$i][$j]=$comision_uno_pesado_admin;
    
    		$total_comision=$total_comision+$comision_uno_pesado_admin;
    
    		$j=$j+1;
    		$comision_dos_especial=$pesado*0.02;
    		$comision_dos_especial=number_format($comision_dos_especial, 2, '.', '');
    		$datos[$i][$j]=$comision_dos_especial;
    
    		$total_comision=$total_comision+$comision_dos_especial;
    
            $veinte_porciento_material_petreo=$resultado_base_comisiones[$i]['bac_venta_material_petreo']*0.25;			
    		$veinte_porciento_material_petreo=number_format($veinte_porciento_material_petreo, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$veinte_porciento_material_petreo;
    		$total_comision=$total_comision+$veinte_porciento_material_petreo;
                */
    
    
    		foreach ($resultado_convenio as $value) {
    			$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($resultado_base_comisiones[$i]['puv_id'],$value['cov_id'],$mes_inicio);
    			$valor_convenio=0;
    			if(!empty($resultado_convenio_porcentaje[0]['cop_porciento'])){
    				$valor_convenio=$resultado_convenio_porcentaje[0]['cop_porciento'];
    			}
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_convenio;			
    			$total_comision=$total_comision+$valor_convenio;	
    		}
    
    
    
    
    		//$comision_diez_porciento=$ferreteria*0.10;			
    		$comision_diez_porciento=($ferreteria*($resultado_base_comisiones[$i]['pco_porcentaje']/100));//+($resultado_base_comisiones[$i]['bac_venta_especial_ferreteria']/0.035);
    		$comision_diez_porciento=number_format($comision_diez_porciento, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$comision_diez_porciento;
    
    
    
    		$j=$j+1;				
    		$datos[$i][$j]=$resultado_base_comisiones[$i]['bac_facturacion_directa_de_cemento'];
    
    
    		
    		
    		$total_comision=$total_comision+$comision_diez_porciento;
    
    		$total_comision=$total_comision+$resultado_base_comisiones[$i]['bac_facturacion_directa_de_cemento'];	
    
    		$j=$j+1;				
    		$datos[$i][$j]=$resultado_base_comisiones[$i]['bac_facturacion_transporte'];	
    
    		$total_comision=$total_comision+$resultado_base_comisiones[$i]['bac_facturacion_transporte'];
    
    
    		foreach ($resultado_post_convenio as $value) {
    			$resultado_post_convenio_valor=$post_convenio_valor_model->getpostconvenioporcentajeid($resultado_base_comisiones[$i]['puv_id'],$value['poc_id'],$mes_inicio);
    			$valor_post_convenio=0;
    			if(!empty($resultado_post_convenio_valor[0]['pcv_valor'])){
    				$valor_post_convenio=$resultado_post_convenio_valor[0]['pcv_valor'];
    			}
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_post_convenio;			
    			$total_comision=$total_comision+$valor_post_convenio;	
    		}
    
    
    		$total_comision=number_format($total_comision, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_comision;
    
    		$total_descuentos=0;
    
    		
    		
    		foreach ($resultado_descuentos_prefacturacion as $valuepre) {					
    			$valor_descuento=0;			
    			$cuota_descuento=0;
    			if($valuepre['des_nombre_franquicias']=='Tipo Franquicia'){
    				$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$resultado_base_comisiones[$i]['tfc_id'],$resultado_base_comisiones[$i]['puv_id'],$valuepre['des_nombre_franquicias']);										
    				if(!empty($descuentopresegunpdv)){
    					$valor_descuento=$valuepre['des_valor'];						
    					if(date('Y-m',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']))==$mes_aux){
    						$dias_totales=date('t',strtotime($mes_aux));
    						$dias_inicio=date('d',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']));
    						$dias_cobro=$dias_totales-$dias_inicio;
    
    						$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;
    
    						$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    						$valor_descuento=number_format($valor_descuento, 2, '.', '');
    					}
    					if($resultado_base_comisiones[$i]['puv_propio']==1){
    						$valor_descuento=0;
    					}
    					$mes_cuota=0;
    					$cuotas_totales=0;
    					$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);
    
    					$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);
    
    					if($mes_cuota==0){
    						$valor_descuento=0;
    						$cuota_descuento='';
    					}else{
    					    if($mes_cuota<=$cuotas_totales){
    						$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    					    }
    					    else
    					    {
    					        $cuota_descuento='';
    					    }
    					}
    					
    				}
    
    			}else{
    				if($valuepre['des_nombre_franquicias']=='PDV'){
    					
    					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$resultado_base_comisiones[$i]['tfc_id'],$resultado_base_comisiones[$i]['puv_id'],$valuepre['des_nombre_franquicias']);
    					if(!empty($descuentopresegunpdv)){
    						$valor_descuento=$valuepre['des_valor'];
    						
    						if(date('Y-m',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']))==$mes_aux){
    							$dias_totales=date('t',strtotime($mes_aux));
    							$dias_inicio=date('d',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']));
    							$dias_cobro=$dias_totales-$dias_inicio;
    
    							$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;
    
    							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    							$valor_descuento=number_format($valor_descuento, 2, '.', '');
    						}
    						if($resultado_base_comisiones[$i]['puv_propio']==1){
    							$valor_descuento=0;
    						}
    						$mes_cuota=0;
    						$cuotas_totales=0;
    						$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);
    
    						$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);
    
    						if($mes_cuota==0){
    							$valor_descuento=0;
    							$cuota_descuento='';
    						}else{
    							    if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
    						}
    
    
    					}
    				}
    				
    			}
    
    			if($valuepre['des_frecuencia']=='indefinido'){
    				$cuota_descuento=0;
    			}
    			
    
    			$total_descuentos=$total_descuentos+$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_descuento;
    
    			$j=$j+1;				
    			$datos[$i][$j]=$cuota_descuento;
    
    			
    			
    		}
    
    		foreach ($resultado_descuentos_mensual_prefacturacion_mensual as $value) {
    			$valor_descuento=0;
    			$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($resultado_base_comisiones[$i]['puv_id'],$value['dem_id'],$mes_inicio);
    
    			if(!empty($descuentomensualvalor[0]['dmv_valor'])){
    				$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
    			}
    
    			$total_descuentos=$total_descuentos+$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_descuento;
    		}
    
    		$total_descuentos=number_format($total_descuentos, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_descuentos;
    
    		$total_facturar=0;
    		$total_facturar=$total_comision-$total_descuentos;
    		$total_facturar=number_format($total_facturar, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_facturar;
    
    		$iva=0;
    		$iva=$total_facturar*($resultado_base_comisiones[$i]['irp_iva']/100);
    		$iva=number_format($iva, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$iva;
    
    		$total=0;
    		$total=$total_facturar+$iva;
    		$total=number_format($total, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total;
    
    		$retencion_renta=0;
    		//$retencion_renta=$total_facturar*0.08;
    		$retencion_renta=$total_facturar*($resultado_base_comisiones[$i]['irp_retencion_renta']/100);
    		$retencion_renta=number_format($retencion_renta, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$retencion_renta;
    
    		$retencion_iva=0;
    		//$retencion_iva=$iva*0.7;
    		$retencion_iva=$iva*($resultado_base_comisiones[$i]['irp_retencion_iva']/100);
    		$retencion_iva=number_format($retencion_iva, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$retencion_iva;
    
    		$total_recibir=0;
    		$total_recibir=$total-$retencion_renta-$retencion_iva;
    		$total_recibir=number_format($total_recibir, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_recibir;
    
    		
    		$total_descuentos_post_facturacion=0;
    
    		foreach ($resultado_descuentos_postfacturacion as $valuepost) {
    			$valor_descuento=0;
    			$cuota_descuento=0;
    			if($valuepost['des_nombre_franquicias']=='Tipo Franquicia'){
    				$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$resultado_base_comisiones[$i]['tfc_id'],$resultado_base_comisiones[$i]['puv_id'],$valuepost['des_nombre_franquicias']);
    				if(!empty($descuentopresegunpdv)){
    					$valor_descuento=$valuepost['des_valor'];
    					
    
    					if(date('Y-m',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']))==$mes_aux){
    						$dias_totales=date('t',strtotime($mes_aux));
    						$dias_inicio=date('d',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']));
    						$dias_cobro=$dias_totales-$dias_inicio;
    
    						$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;
    
    						$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    						$valor_descuento=number_format($valor_descuento, 2, '.', '');
    					}
    					if($resultado_base_comisiones[$i]['puv_propio']==1){
    						$valor_descuento=0;
    					}
    					$mes_cuota=0;
    					$cuotas_totales=0;
    					$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);
    
    					$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);
    
    					if($mes_cuota==0){
    						$valor_descuento=0;
    						$cuota_descuento='';
    					}else{
    						if($mes_cuota<=$cuotas_totales){
    						$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    					    }
    					    else
    					    {
    					        $cuota_descuento='';
    					    }
    					}
    
    					
    				}
    			}else{
    				if($valuepost['des_nombre_franquicias']=='PDV'){
    					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$resultado_base_comisiones[$i]['tfc_id'],$resultado_base_comisiones[$i]['puv_id'],$valuepost['des_nombre_franquicias']);
    					if(!empty($descuentopresegunpdv)){
    						$valor_descuento=$valuepost['des_valor'];
    						
    						if(date('Y-m',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']))==$mes_aux){
    							$dias_totales=date('t',strtotime($mes_aux));
    							$dias_inicio=date('d',strtotime($resultado_base_comisiones[$i]['puv_fecha_apertura']));
    							$dias_cobro=$dias_totales-$dias_inicio;
    
    							$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;
    
    							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    							$valor_descuento=number_format($valor_descuento, 2, '.', '');
    						}
    						if($resultado_base_comisiones[$i]['puv_propio']==1){
    							$valor_descuento=0;
    						}
    						$mes_cuota=0;
    						$cuotas_totales=0;
    						$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);
    
    						$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);
    
    						if($mes_cuota==0){
    							$valor_descuento=0;
    							$cuota_descuento='';
    						}else{
    							if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
    						}
    					}
    				}
    			}
    
    			if($valuepost['des_frecuencia']=='indefinido'){
    				$cuota_descuento=0;
    			}
    
    
    			
    			$total_descuentos_post_facturacion=$total_descuentos_post_facturacion+$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$cuota_descuento;
    			
    			
    			
    		}
    
    		foreach ($resultado_descuentos_mensual_postfacturacion_mensual as $value) {
    			$valor_descuento=0;
    			$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($resultado_base_comisiones[$i]['puv_id'],$value['dem_id'],$mes_inicio);
    
    			if(!empty($descuentomensualvalor[0]['dmv_valor'])){
    				$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
    			}
    
    			$total_descuentos_post_facturacion=$total_descuentos_post_facturacion+$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_descuento;
    		}
    
    
    		///Prestamos
    		
    		foreach ($resultado_prestamos as $value) {
    			$valor_prestamo=0;
    			$cuotas=0;
    			$datos_prestamos=$prestamos_model->getUnPrestamosnombrepuvid($value['pre_nombre'],$resultado_base_comisiones[$i]['puv_id']);
    			if(!empty($datos_prestamos[0])){
    				if($mes>=$datos_prestamos[0]['pre_fecha_desde'] && $mes<=$datos_prestamos[0]['pre_fecha_hasta']){
    					$valor_prestamo=$datos_prestamos[0]['pre_pago_mensual']; 
    				}else{
    					$valor_prestamo=0;
    				}
    				
    				$mes_gracia=false;
    				if('2022-06-01'>=$datos_prestamos[0]['pre_fecha_desde'] && '2022-06-01' <=$datos_prestamos[0]['pre_fecha_hasta']){//SE CONDICIONA PORQUE EL MES DE JUNIO NO SE VA A COBRAR PRÊSTAMOS DEBIDO AL PARO
    				    $valor_prestamo=$datos_prestamos[0]['pre_pago_mensual']; 
    				    if($mes>'2022-06-01')
    				    {
    				        $mes_gracia=true; //if($value['pre_nombre']=='Préstamo por construcción' &&$resultado_base_comisiones[$i]['puv_id']==88)echo 'entra';
    				    }
    				    else{
    				        $mes_gracia=false;
    				    }
    				}
    				
    				$cuotas=0;
    				$cuotas=$this->obtenercuotas($datos_prestamos[0]['pre_fecha_desde'],$mes);
    				
    				if($mes_gracia==true)//SE CONDICIONA PORQUE EL MES DE JUNIO NO SE VA A COBRAR PRÊSTAMOS DEBIDO AL PARO
    				{
    				    $cuotas=$cuotas-1;
    				}
    				
    				if($cuotas==0){
    					$valor_prestamo=0;
    				}else{
    				    if($cuotas<=$datos_prestamos[0]['pre_cuotas']){
    					    $cuotas=$cuotas." de ".$datos_prestamos[0]['pre_cuotas'];
    				    }
    				    else
    				    {
    				        $cuotas=0;
    				        $valor_prestamo=0;
    				    }
    				}
    			}
                //SE CONDICIONA PORQUE EL MES DE JUNIO NO SE VA A COBRAR PRÊSTAMOS DEBIDO AL PARO
                if($mes_aux!='2022-06'){
    			$total_descuentos_post_facturacion=$total_descuentos_post_facturacion+$valor_prestamo;
                }
    			$j=$j+1;
    			if($mes_aux!='2022-06'){
    			$datos[$i][$j]=$valor_prestamo;
    			}
    			else
    			{
    			    $datos[$i][$j]=0;
    			}
    			$j=$j+1;
    			if($mes_aux!='2022-06'){
    			$datos[$i][$j]=$cuotas;
    			}
    			else
    			{
    			    if($cuotas!=''){
    			    $datos[$i][$j]="No se cobrará la cuota debido al paro";
    			    }
    			    else{
    			        $datos[$i][$j]="";
    			    }
    			    
    			}
    		}
    			
    
    		
    
    
    
    
    
    		$total_descuentos_post_facturacion=number_format($total_descuentos_post_facturacion, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_descuentos_post_facturacion;
    
    		$total_recibir_post_facturacion=0;
    		$total_recibir_post_facturacion=$total_recibir-$total_descuentos_post_facturacion;
    		$total_recibir_post_facturacion=number_format($total_recibir_post_facturacion, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_recibir_post_facturacion;
            //Borrar//
    		$j=$j+1;			
    		$datos[$i][$j]='';
    		//Borrar//
    	}
    	
    	$nuevos_datos=[];
    	
    	foreach ($titulos as $key => $value) {
    		$nuevos_datos[0][$key]=$value;
    	}
    	$nuevos_datos[0][sizeof($titulos)]=0;
    	$imprimir_datos_csv=array_merge($nuevos_datos,$datos);
    	
    	
    	$titulos=json_encode($titulos,JSON_UNESCAPED_UNICODE);
    	$datos=json_encode($datos,JSON_UNESCAPED_UNICODE);
    	$enviar_datos=array(
    		'titulos'=>$titulos,
    		'datos'=>$datos,
    		'imprimir_datos_csv'=>$imprimir_datos_csv,
    		'mes'=>$mes_aux,
    		'finalizado'=>false,
    		'tipo'=>$tipo
    	);
    	return $enviar_datos;
        }		
        		
	}

}