<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Tipotacticasmodel;

class Tipotacticas extends BaseController
{

	public function index(){
		$tipo_tacticas_model= new Tipotacticasmodel();
		$datos_tipo_tacticas=$tipo_tacticas_model->getTipotacticas();


		$enviar_datos=array(
			'datos_tipo_tacticas' => !empty($datos_tipo_tacticas)?$datos_tipo_tacticas:null , 
		);

		$datos = $this->datosMenu();
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("tipotacticas/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipo_tacticas_model= new Tipotacticasmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('tactica'))){
				$tac_tacticas=$this->request->getPost('tactica');
				$ingresar_datos=array(
					'tac_tacticas'=>$tac_tacticas,
					'tac_estado'=>1
				);
				$tipo_tacticas_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Tipotacticas')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipotacticas')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$tipo_tacticas_model= new Tipotacticasmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('edittacticas')) && !empty($this->request->getPost('edittacid'))){
				$tac_tacticas=$this->request->getPost('edittacticas');
				$tac_id=$this->request->getPost('edittacid');
				$editar_datos=array(
					'tac_tacticas'=>$tac_tacticas,
					'tac_estado'=>1
				);
				$tipo_tacticas_model->actualizar($tac_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Tipotacticas')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipotacticas')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$tipo_tacticas_model= new Tipotacticasmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tac_estado'=>0
				);
				$tipo_tacticas_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Tipotacticas')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipotacticas')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}