<?php namespace App\Models;

use CodeIgniter\Model;

class PdvModel extends Model
{
    protected $DBGroup    = 'postgres';
    protected $table      = 'public.tbl_pdv';
    protected $primaryKey = 'pdv_id'; // el PK real de tu tabla
    protected $returnType = 'array';
    protected $allowedFields = ['pdv_codigo','pdv_nombre','created_at','updated_at'];

    /**
     * Inserta o actualiza un PDV según pdv_codigo
     * Compatible con PHP 7.3 (sin tipos de argumentos)
     */
    public function upsertOne($codigo, $nombre)
    {
        $codigo = (string) $codigo;
        $nombre = (string) $nombre;

        $sql = "
            INSERT INTO public.tbl_pdv (pdv_codigo, pdv_nombre, created_at, updated_at)
            VALUES (?, ?, NOW(), NOW())
            ON CONFLICT (pdv_codigo)
            DO UPDATE SET
                pdv_nombre = EXCLUDED.pdv_nombre,
                updated_at = NOW()
        ";
        $this->db->query($sql, array($codigo, $nombre));
    }
}
