<?php namespace App\Models;

use CodeIgniter\Model;

class PdvPrecioHistModel extends Model
{
    protected $DBGroup    = 'postgres';
    protected $table      = 'public.tbl_pdv_precios_hist';
    protected $primaryKey = 'pph_id';
    protected $returnType = 'array';
    protected $allowedFields = []; // usamos SQL crudo

    public function insertBatchIfChanged($pdvRecId, array $items)
    {
        if (empty($items)) return ['inserted' => 0, 'ignored' => 0];

        // Normaliza filas
        $rows = [];
        foreach ($items as $r) {
            $rows[] = [
                'pro_codigo'            => isset($r['pro_codigo']) ? (string)$r['pro_codigo'] : null,
                'lpr_rec_id'            => isset($r['lpr_rec_id']) ? $r['lpr_rec_id'] : null,
                'product_uuid_txt'      => isset($r['product_uuid']) ? (string)$r['product_uuid'] : null,
                'measury_reference_id'  => isset($r['measury_reference_id']) ? (string)$r['measury_reference_id'] : null,
                'product_name'          => isset($r['product_name']) ? (string)$r['product_name'] : null,
                'measury_unit'          => isset($r['measury_unit']) ? (string)$r['measury_unit'] : null,
                'measury_unit_base_i'   => isset($r['measury_unit_base']) ? (int)(bool)$r['measury_unit_base'] : null,
                'is_heavy_i'            => isset($r['is_heavy']) ? (int)(bool)$r['is_heavy'] : null,
                'mark'                  => isset($r['mark']) ? (string)$r['mark'] : null,
                'is_approved_i'         => isset($r['is_approved']) ? (int)(bool)$r['is_approved'] : null,
                'is_modified_i'         => isset($r['is_modified']) ? (int)(bool)$r['is_modified'] : null,
                'is_hook_i'             => isset($r['is_hook']) ? (int)(bool)$r['is_hook'] : null,
                'margin_price_pdv'      => (isset($r['margin_price_pdv']) && $r['margin_price_pdv'] !== null) ? round((float)$r['margin_price_pdv'], 2) : null,
                'price'                 => isset($r['price']) ? $this->n4($r['price']) : null,
                'price_limit'           => isset($r['price_limit']) ? $this->n4($r['price_limit']) : null,
                'normal_price'          => isset($r['normal_price']) ? $this->n4($r['normal_price']) : null,
                'wholesaler_price'      => isset($r['wholesaler_price']) ? $this->n4($r['wholesaler_price']) : null,
                'special_price'         => isset($r['special_price']) ? $this->n4($r['special_price']) : null,
                'administrator_price'   => isset($r['administrator_price']) ? $this->n4($r['administrator_price']) : null,
                'base_price'            => isset($r['base_price']) ? $this->n4($r['base_price']) : null,
                'updated_api_at'        => !empty($r['updated_api_at']) ? (string)$r['updated_api_at'] : null,
                'diff_hash'             => isset($r['diff_hash']) ? (string)$r['diff_hash'] : null,
                'raw_json'              => isset($r['raw_json']) ? (string)$r['raw_json'] : null,
            ];
        }

        // JSON embebido (evita ?::json). Escapamos comillas.
        $json = json_encode($rows, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        $json = $this->db->escapeString($json);

        // Inyectamos pdv_rec_id como entero literal (sin placeholder)
        $pdv = (int)$pdvRecId;

        $sql = "
        WITH v AS (
            SELECT
                (x->>'pro_codigo')                          AS pro_codigo,
                NULLIF(x->>'lpr_rec_id','')::bigint         AS lpr_rec_id,
                NULLIF(x->>'product_uuid_txt','')           AS product_uuid_txt,
                (x->>'measury_reference_id')                AS measury_reference_id,
                (x->>'product_name')                        AS product_name,
                (x->>'measury_unit')                        AS measury_unit,
                ((NULLIF(x->>'measury_unit_base_i','')::int) = 1) AS measury_unit_base,
                ((NULLIF(x->>'is_heavy_i','')::int) = 1)          AS is_heavy,
                (x->>'mark')                                      AS mark,
                ((NULLIF(x->>'is_approved_i','')::int) = 1)       AS is_approved,
                ((NULLIF(x->>'is_modified_i','')::int) = 1)       AS is_modified,
                ((NULLIF(x->>'is_hook_i','')::int) = 1)           AS is_hook,
                NULLIF(x->>'margin_price_pdv','')::numeric(12,2)   AS margin_price_pdv,
                NULLIF(x->>'price','')::numeric(18,4)              AS price,
                NULLIF(x->>'price_limit','')::numeric(18,4)        AS price_limit,
                NULLIF(x->>'normal_price','')::numeric(18,4)       AS normal_price,
                NULLIF(x->>'wholesaler_price','')::numeric(18,4)   AS wholesaler_price,
                NULLIF(x->>'special_price','')::numeric(18,4)      AS special_price,
                NULLIF(x->>'administrator_price','')::numeric(18,4)AS administrator_price,
                NULLIF(x->>'base_price','')::numeric(18,4)         AS base_price,
                NULLIF(x->>'updated_api_at','')::timestamptz       AS updated_api_at,
                (x->>'diff_hash')                                  AS diff_hash,
                (x->>'raw_json')::jsonb                            AS raw_json
            FROM json_array_elements('{$json}'::json) AS x
        ),
        v2 AS (
            SELECT
                v.pro_codigo,
                v.lpr_rec_id,
                v.product_uuid_txt,
                v.measury_reference_id,
                v.product_name,
                v.measury_unit,
                v.measury_unit_base,
                v.is_heavy,
                v.mark,
                v.is_approved,
                v.is_modified,
                v.is_hook,
                v.margin_price_pdv,
                v.price, v.price_limit, v.normal_price, v.wholesaler_price, v.special_price,
                v.administrator_price, v.base_price,
                v.updated_api_at,
                v.diff_hash,
                v.raw_json,
                p.pro_reference_id
            FROM v
            JOIN public.tbl_producto p
              ON p.pro_codigo = v.pro_codigo
        )
        INSERT INTO public.tbl_pdv_precios_hist (
            pdv_rec_id,
            lpr_rec_id,
            pro_reference_id,
            product_uuid,
            measury_reference_id,
            product_name,
            measury_unit,
            measury_unit_base,
            is_heavy,
            mark,
            is_approved,
            is_modified,
            is_hook,
            margin_price_pdv,
            price,
            price_limit,
            normal_price,
            wholesaler_price,
            special_price,
            administrator_price,
            base_price,
            updated_api_at,
            diff_hash,
            raw_json,
            pro_codigo
        )
        SELECT
            {$pdv},                     -- pdv_rec_id (literal entero)
            v2.lpr_rec_id,
            v2.pro_reference_id,
            CASE
              WHEN v2.product_uuid_txt ~* '^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$'
              THEN v2.product_uuid_txt::uuid
              ELSE NULL
            END,
            v2.measury_reference_id,
            v2.product_name,
            v2.measury_unit,
            v2.measury_unit_base,
            v2.is_heavy,
            v2.mark,
            v2.is_approved,
            v2.is_modified,
            v2.is_hook,
            v2.margin_price_pdv,
            v2.price, v2.price_limit, v2.normal_price, v2.wholesaler_price, v2.special_price,
            v2.administrator_price, v2.base_price,
            v2.updated_api_at,
            v2.diff_hash,
            v2.raw_json,
            v2.pro_codigo
        FROM v2
        ON CONFLICT (pdv_rec_id, pro_codigo, diff_hash) DO NOTHING
        RETURNING 1
        ";

        // Ya no hay placeholders => simpleQuery
        $res = $this->db->query($sql)->getResultArray();
        $inserted = is_array($res) ? count($res) : 0;
        $ignored  = count($rows) - $inserted;

        return ['inserted' => $inserted, 'ignored' => $ignored];
    }

    private function n4($v)
    {
        return $v === null ? null : round((float)$v, 4);
    }
}
