<?php namespace App\Models;

use CodeIgniter\Model;

class ProductoModel extends Model
{
    protected $DBGroup    = 'postgres';
    protected $table      = 'public.tbl_producto';   // <--- schema calificado
    protected $primaryKey = 'pro_reference_id';
    protected $returnType = 'array';

    protected $allowedFields = [
        'pro_reference_id','pro_codigo','pro_barcode',
        'pro_descripcion','pro_detalle','pro_familia','pro_sublinea','pro_marca',
        'pro_proveedor_habitual','pro_categorizacion',
        'pro_unidad_nombre','pro_unidad_simbolo','pro_iva_nombre',
        'pro_peso','pro_iva_valor','pro_cost','pro_price_cost','pro_payed_price',
        'pro_stock','pro_authorized_discount',
        'pro_activo','pro_es_pesado','pro_es_especial','pro_need_validate_stock','pro_is_supply',
        'pro_location','pro_updated_api','pro_seen_at','pro_inactive_at','pro_hash','pro_json'
    ];

    public function upsertBatchWithHash(array $rows): array
    {
        if (empty($rows)) return ['inserted'=>0,'updated'=>0];

        $sql = "
        INSERT INTO public.tbl_producto (
            pro_reference_id, pro_codigo, pro_barcode,
            pro_descripcion, pro_detalle, pro_familia, pro_sublinea, pro_marca,
            pro_proveedor_habitual, pro_categorizacion,
            pro_unidad_nombre, pro_unidad_simbolo, pro_iva_nombre,
            pro_peso, pro_iva_valor, pro_cost, pro_price_cost, pro_payed_price,
            pro_stock, pro_authorized_discount,
            pro_activo, pro_es_pesado, pro_es_especial, pro_need_validate_stock, pro_is_supply,
            pro_location, pro_updated_api, pro_seen_at, pro_inactive_at, pro_hash, pro_json
        ) VALUES %s
        ON CONFLICT (pro_reference_id) DO UPDATE SET
            pro_codigo              = EXCLUDED.pro_codigo,
            pro_barcode             = EXCLUDED.pro_barcode,
            pro_descripcion         = EXCLUDED.pro_descripcion,
            pro_detalle             = EXCLUDED.pro_detalle,
            pro_familia             = EXCLUDED.pro_familia,
            pro_sublinea            = EXCLUDED.pro_sublinea,
            pro_marca               = EXCLUDED.pro_marca,
            pro_proveedor_habitual  = EXCLUDED.pro_proveedor_habitual,
            pro_categorizacion      = EXCLUDED.pro_categorizacion,
            pro_unidad_nombre       = EXCLUDED.pro_unidad_nombre,
            pro_unidad_simbolo      = EXCLUDED.pro_unidad_simbolo,
            pro_iva_nombre          = EXCLUDED.pro_iva_nombre,
            pro_peso                = EXCLUDED.pro_peso,
            pro_iva_valor           = EXCLUDED.pro_iva_valor,
            pro_cost                = EXCLUDED.pro_cost,
            pro_price_cost          = EXCLUDED.pro_price_cost,
            pro_payed_price         = EXCLUDED.pro_payed_price,
            pro_stock               = EXCLUDED.pro_stock,
            pro_authorized_discount = EXCLUDED.pro_authorized_discount,
            pro_activo              = TRUE,
            pro_es_pesado           = EXCLUDED.pro_es_pesado,
            pro_es_especial         = EXCLUDED.pro_es_especial,
            pro_need_validate_stock = EXCLUDED.pro_need_validate_stock,
            pro_is_supply           = EXCLUDED.pro_is_supply,
            pro_location            = EXCLUDED.pro_location,
            pro_updated_api         = EXCLUDED.pro_updated_api,
            pro_seen_at             = EXCLUDED.pro_seen_at,
            pro_hash                = EXCLUDED.pro_hash,
            pro_json                = EXCLUDED.pro_json
        WHERE public.tbl_producto.pro_hash IS DISTINCT FROM EXCLUDED.pro_hash
        RETURNING (xmax = 0) AS inserted;
        ";

        $ph = [];
        $params = [];
        foreach ($rows as $r) {
            $ph[] = '(' . implode(',', array_fill(0, 31, '?')) . ')';

            $params[] = $r['pro_reference_id'];
            $params[] = $r['pro_codigo'];
            $params[] = $r['pro_barcode'];
            $params[] = $r['pro_descripcion'] ?? '';
            $params[] = $r['pro_detalle'] ?? '';
            $params[] = $r['pro_familia'] ?? '';
            $params[] = $r['pro_sublinea'] ?? '';
            $params[] = $r['pro_marca'] ?? '';
            $params[] = $r['pro_proveedor_habitual'] ?? '';
            $params[] = $r['pro_categorizacion'] ?? '';
            $params[] = $r['pro_unidad_nombre'] ?? '';
            $params[] = $r['pro_unidad_simbolo'] ?? '';
            $params[] = $r['pro_iva_nombre'] ?? '';
            $params[] = $r['pro_peso'];
            $params[] = $r['pro_iva_valor'];
            $params[] = $r['pro_cost'];
            $params[] = $r['pro_price_cost'];
            $params[] = $r['pro_payed_price'];
            $params[] = $r['pro_stock'];
            $params[] = $r['pro_authorized_discount'];
            $params[] = $r['pro_activo'] ?? true;
            $params[] = $r['pro_es_pesado'];
            $params[] = $r['pro_es_especial'];
            $params[] = $r['pro_need_validate_stock'];
            $params[] = $r['pro_is_supply'];
            $params[] = $r['pro_location'] ?? '';
            $params[] = $r['pro_updated_api'];
            $params[] = $r['pro_seen_at'];
            $params[] = $r['pro_inactive_at'];
            $params[] = $r['pro_hash'];
            $params[] = $r['pro_json'];
        }

        $q   = sprintf($sql, implode(',', $ph));
        $res = $this->db->query($q, $params)->getResultArray();

        $inserted=0; $updated=0;
        foreach ($res as $row) ($row['inserted'] ? $inserted++ : $updated++);
        return ['inserted'=>$inserted,'updated'=>$updated];
    }

    public function inactivateNotSeenSince(string $ts): int
    {
        $this->db->query(
            "UPDATE public.tbl_producto
                SET pro_activo = FALSE,
                    pro_inactive_at = NOW()
              WHERE pro_activo = TRUE
                AND (pro_seen_at IS NULL OR pro_seen_at < ?)",
            [$ts]
        );
        return $this->db->affectedRows();
    }
    public function existeCodigo(string $codigo): bool
    {
        return (bool) $this->where('pro_codigo', $codigo)->select('pro_codigo')->first();
    }
}
