<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model
{
    protected $DBGroup      = 'postgres';
    protected $table        = 'tbl_usuario';
    protected $primaryKey   = 'usu_id';
    protected $returnType   = 'array';
    protected $allowedFields= ['usu_usuario','usu_nombre','usu_email','usu_password_hash','usu_estado','created_at','updated_at'];
    protected $useTimestamps= false;

    public function buscarPorCorreo(string $correo): ?array
    {
        return $this->asArray()
                    ->where('usu_email', $correo)
                    ->where('usu_estado', 1)
                    ->first();
    }

    public function rolesDeUsuario(int $usuId): array
    {
        $sql = "SELECT r.rol_nombre
                  FROM tbl_usuario_rol ur
                  JOIN tbl_rol r ON r.rol_id = ur.rol_id
                 WHERE ur.usu_id = ?";
        $rows = $this->db->query($sql, [$usuId])->getResultArray();
        return array_map(static function($r){ return $r['rol_nombre']; }, $rows);
    }

    public function verificarCredenciales(string $correo, string $clave): ?array
    {
        $usuario = $this->buscarPorCorreo($correo);
        if (!$usuario) {
            return null;
        }
        $hash = isset($usuario['usu_password_hash']) ? (string)$usuario['usu_password_hash'] : '';
        if (!password_verify($clave, $hash)) {
            return null;
        }
        return $usuario;
    }

    public function marcarUltimoLogin(int $usuId): bool
    {
        // ejemplo de operación en BD desde el modelo (sin SQL en controlador)
        return $this->db->table($this->table)
                        ->set('updated_at', 'now()', false)
                        ->where('usu_id', $usuId)
                        ->update();
    }
}
