<!-- ========== INICIO: VISTA PARÁMETROS DE PRECIOS ========== -->
<style>
  /* --- Estilos encapsulados para no chocar con tu tema --- */
  .precios-ui{ --pri:#2563eb; --mut:#6b7280; --border:#e5e7eb; }
  .precios-ui .band{
    background: linear-gradient(180deg,#ffffff 0%, #f7f9ff 100%);
    color:#1f2937; border-radius:12px; padding:16px 18px;
    border:1px solid var(--border); box-shadow:0 6px 16px rgba(0,0,0,.06);
    position:relative;
  }
  .precios-ui .band .title{ font-weight:800; letter-spacing:.2px; margin:0; }
  .precios-ui .pill{ background:#fff; color:#111; padding:.25rem .6rem; border-radius:999px; font-size:.75rem; font-weight:600; }

  .precios-ui .card-s{
    background:#fff; border:1px solid var(--border); border-radius:12px;
    box-shadow:0 8px 18px rgba(0,0,0,.05); margin-bottom:14px;
  }
  .precios-ui .card-s .card-header{
    padding:14px 22px; background:linear-gradient(180deg,#fff,#fafbff);
    border-bottom:1px solid var(--border); border-top-left-radius:12px; border-top-right-radius:12px;
  }
  .precios-ui .card-s .card-body{ padding:18px 22px; }

  .precios-ui .muted{ color:var(--mut); }
  .precios-ui .hint{ color:var(--mut); font-size:.85rem; }
  .precios-ui .badge-soft{ background:#eaf3ff; color:#2563eb; border:1px solid #dbe8ff; }
  .precios-ui .badge-inc{ background:#e7f8ee; color:#129b50; border:1px solid #c8efd9; }
  .precios-ui .badge-dec{ background:#ffeced; color:#c43636; border:1px solid #ffd2d6; }
  .precios-ui .table thead th{ font-size:.8rem; letter-spacing:.04em; text-transform:uppercase; }
  .precios-ui .input-group>.input-group-text{ background:#f7f9ff; }
  .precios-ui .btn-primary{ background:#2563eb; border-color:#2563eb; }
  .precios-ui .list-clean .list-group-item{ border:0; border-bottom:1px dashed #e6e8ef; padding:.7rem .25rem; }
  .precios-ui .k{ min-width:120px; font-weight:600; color:#111; }
</style>

<div class="precios-ui">

  <!-- Banda superior -->
  <div class="band d-flex align-items-center justify-content-between mb-15">
    <div>
      <h3 class="title">Parámetros de Precios</h3>
      <small class="opacity-90">Descuentos por tipo y margen base del <b>Precio Hoy</b>.</small>
    </div>
    <span class="pill"><i class="fa fa-calculator"></i> 4 decimales</span>
  </div>

  <!-- Resumen vigente -->
  <div class="card-s mb-3">
    <div class="card-header d-flex align-items-center justify-content-between">
      <div class="fw-bold"><i class="fa fa-info-circle text-primary"></i> Resumen vigente</div>
      <span class="badge badge-soft">Global</span>
    </div>
    <div class="card-body pt-2 px-3">
      <div class="row">
        <div class="col-lg-9 ps-lg-3">
          <ul class="list-group list-clean ms-1">
            <?php 
              $icons = [
                'NORMAL'=>'fa-tag', 'LIMITE'=>'fa-scissors', 'ADMINISTRADOR'=>'fa-user-cog',
                'MAYORISTA'=>'fa-users', 'ESPECIAL'=>'fa-star'
              ];
              foreach ($activos as $tipo=>$row): ?>
              <li class="list-group-item d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center gap-2">
                  <i class="fa <?= $icons[$tipo] ?? 'fa-circle' ?> text-primary"></i>
                  <span class="k"><?= esc($tipo) ?></span>
                </div>
                <div class="text-end">
                  <span class="me-3"><?= esc(number_format((float)$row['dpr_porcentaje'],4,'.','')) ?>%</span>
                  <span class="me-3 muted small">Margen: <?= esc(number_format((float)($row['dpr_margen'] ?? 0),4,'.','')) ?></span>
                  <?php if(($row['dpr_sentido']??'D')==='I'): ?>
                    <span class="badge badge-inc">Incremento</span>
                  <?php else: ?>
                    <span class="badge badge-dec">Decremento</span>
                  <?php endif; ?>
                </div>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
        <div class="col-lg-3">
          <div class="ps-lg-3 mt-3 mt-lg-0">
            <div class="small muted">Margen hoy activo</div>
            <?php $mhoActivo = number_format((float)$margenActivo['mho_margen'],4,'.',''); ?>
            <div class="h4 mb-0"><?= esc($mhoActivo) ?></div>
            <div class="hint"><?= esc($margenActivo['mho_observacion'] ?? '') ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Formularios -->
  <div class="row">

    <!-- Descuentos -->
    <div class="col-lg-8">
      <div class="card-s">
        <div class="card-header">
          <div class="fw-bold">Descuentos por tipo de precio</div>
          <div class="hint">Al guardar, el set anterior queda inactivo y este set pasa a activo.</div>
        </div>
        <div class="card-body">
          <form method="post" action="<?= base_url('precios/descuentos/guardar') ?>">
            <?= csrf_field() ?>
            <!-- Margen hoy activo (para recálculo en vivo) -->
            <input type="hidden" id="mhoActivo" value="<?= esc($mhoActivo) ?>">

            <div class="table-responsive">
              <table class="table table-hover align-middle">
                <thead>
                  <tr>
                    <th>Tipo</th>
                    <th style="width:18%">% (0–100)</th>
                    <th style="width:18%">Margen calc.</th> <!-- NUEVA -->
                    <th style="width:20%">Sentido</th>
                    <th>Observación</th>
                  </tr>
                </thead>
                <tbody>
                <?php 
                  $map = [
                    'NORMAL'=>'PriceList','LIMITE'=>'PriceLimit',
                    'ADMINISTRADOR'=>'administratorPrice','MAYORISTA'=>'wholesalerPrice',
                    'ESPECIAL'=>'specialPrice',
                  ];
                  foreach ($activos as $tipo=>$row):
                    $margenCalc = number_format((float)($row['dpr_margen'] ?? 0),4,'.','');
                ?>
                  <tr data-tipo="<?= esc($tipo) ?>">
                    <td>
                      <div class="fw-semibold"><?= esc($tipo) ?></div>
                      <div class="muted small"><?= esc($map[$tipo]) ?></div>
                    </td>
                    <td>
                      <div class="input-group">
                        <input type="number" step="0.0001" min="0" class="form-control js-pct"
                               name="dpr[<?= esc($tipo) ?>][porcentaje]"
                               value="<?= esc(number_format((float)$row['dpr_porcentaje'],4,'.','')) ?>">
                        <span class="input-group-text">%</span>
                      </div>
                    </td>
                    <td>
                      <input type="text" class="form-control js-margen" value="<?= esc($margenCalc) ?>" readonly>
                    </td>
                    <td>
                      <select class="form-select js-sentido" name="dpr[<?= esc($tipo) ?>][sentido]">
                        <option value="D" <?= ($row['dpr_sentido']??'D')==='D'?'selected':'' ?>>Decremento</option>
                        <option value="I" <?= ($row['dpr_sentido']??'D')==='I'?'selected':'' ?>>Incremento</option>
                      </select>
                    </td>
                    <td>
                      <input type="text" maxlength="300" class="form-control"
                             name="dpr[<?= esc($tipo) ?>][observacion]"
                             placeholder="Ej. Política comercial Q4"
                             value="<?= esc($row['dpr_observacion'] ?? '') ?>">
                    </td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex justify-content-between align-items-center">
              <span class="hint"><i class="fa fa-shield"></i> Se guardará como nuevo set activo.</span>
              <div class="d-flex gap-2">
                <button class="btn btn-outline-secondary" type="reset"><i class="fa fa-eraser"></i> Limpiar</button>
                <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i> Guardar descuentos</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Margen hoy -->
    <div class="col-lg-4">
      <div class="card-s">
        <div class="card-header">
          <div class="fw-bold">Margen del Precio Hoy</div>
          <div class="hint">Ej.: 0.3500 = 35%.</div>
        </div>
        <div class="card-body">
          <form method="post" action="<?= base_url('precios/margen/guardar') ?>">
            <?= csrf_field() ?>
            <div class="mb-3">
              <label class="form-label">Margen hoy (0–1, 4 decimales)</label>
              <div class="input-group">
                <span class="input-group-text"><i class="fa fa-line-chart"></i></span>
                <input type="number" step="0.0001" min="0" class="form-control"
                       name="mho_margen"
                       value="<?= esc($mhoActivo) ?>">
              </div>
            </div>
            <div class="mb-3">
              <label class="form-label">Observación</label>
              <input type="text" maxlength="300" class="form-control" name="mho_observacion"
                     placeholder="Ej. Ajuste por temporada"
                     value="<?= esc($margenActivo['mho_observacion'] ?? '') ?>">
            </div>
            <div class="d-grid">
              <button class="btn btn-primary" type="submit"><i class="fa fa-check-circle"></i> Guardar margen hoy</button>
            </div>
            <div class="hint mt-2">Al guardar, el margen anterior pasa a inactivo y se recalculan los márgenes de cada tipo.</div>
          </form>
        </div>
      </div>
    </div>

  </div><!-- /row formularios -->

  <!-- Historiales -->
  <div class="row">
    <div class="col-lg-8">
      <div class="card-s">
        <div class="card-header"><div class="fw-bold">Historial de Descuentos</div></div>
        <div class="card-body">
          <div class="table-responsive">
            <table id="tblHistDpr" class="table table-striped align-middle">
              <thead>
                <tr>
                  <th>ID</th><th>Tipo</th><th>%</th><th>Margen</th><th>Sentido</th><th>Obs</th><th>Activo</th><th>Creado</th><th>Actualizado</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach($histDescuentos as $r): ?>
                <tr>
                  <td><?= esc($r['dpr_id']) ?></td>
                  <td><?= esc($r['dpr_tipo']) ?></td>
                  <td><?= esc(number_format((float)$r['dpr_porcentaje'],4,'.','')) ?></td>
                  <td><?= esc(number_format((float)$r['dpr_margen'],4,'.','')) ?></td>
                  <td>
                    <?php if($r['dpr_sentido']==='I'): ?>
                      <span class="badge badge-inc">Incremento</span>
                    <?php else: ?>
                      <span class="badge badge-dec">Decremento</span>
                    <?php endif; ?>
                  </td>
                  <td><?= esc($r['dpr_observacion']) ?></td>
                  <?php
                    $isActive = ($r['dpr_activo'] === true)
                             || ($r['dpr_activo'] === 1) || ($r['dpr_activo'] === '1')
                             || ($r['dpr_activo'] === 't') || ($r['dpr_activo'] === 'true');
                  ?>
                  <td><?= $isActive ? '<span class="badge bg-success">Sí</span>' : '<span class="badge bg-secondary">No</span>' ?></td>
                  <td><?= esc($r['dpr_created_at']) ?></td>
                  <td><?= esc($r['dpr_updated_at']) ?></td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-4">
      <div class="card-s">
        <div class="card-header"><div class="fw-bold">Historial Margen Hoy</div></div>
        <div class="card-body">
          <div class="table-responsive">
            <table id="tblHistMho" class="table table-striped align-middle">
              <thead>
                <tr>
                  <th>ID</th><th>Margen</th><th>Obs</th><th>Activo</th><th>Creado</th><th>Actualizado</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach($histMHo as $r): ?>
                <tr>
                  <td><?= esc($r['mho_id']) ?></td>
                  <td><?= esc(number_format((float)$r['mho_margen'],4,'.','')) ?></td>
                  <td><?= esc($r['mho_observacion']) ?></td>
                  <?php
                    $isActive = ($r['mho_activo'] === true)
                             || ($r['mho_activo'] === 1) || ($r['mho_activo'] === '1')
                             || ($r['mho_activo'] === 't') || ($r['mho_activo'] === 'true');
                  ?>
                  <td><?= $isActive ? '<span class="badge bg-success">Sí</span>' : '<span class="badge bg-secondary">No</span>' ?></td>
                  <td><?= esc($r['mho_created_at']) ?></td>
                  <td><?= esc($r['mho_updated_at']) ?></td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <div class="hint mt-2">
            Fórmula: <code>Margen_tipo = Margen_hoy × (1 ± Porcentaje)</code> (− para Decremento, + para Incremento).
          </div>
        </div>
      </div>
    </div>
  </div><!-- /row historiales -->

</div>
<!-- ========== FIN: VISTA PARÁMETROS DE PRECIOS ========== -->

<script>
  // Inicializa DataTables con los assets ya cargados en el layout
  $(function(){
    if ($.fn.DataTable) {
      $('#tblHistDpr, #tblHistMho').DataTable({
        order:[[0,'desc']], pageLength:10, dom:'Bfrtip',
        buttons:['excelHtml5','csvHtml5','pdfHtml5'],
        language:{ url:'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
      });
    }

    // Recalcular "Margen calc." en vivo cuando cambie % o sentido
    const mho = parseFloat($('#mhoActivo').val() || '0');
    $('.table').on('input change', '.js-pct, .js-sentido', function(){
      const $row = $(this).closest('tr');
      const pct = parseFloat(($row.find('.js-pct').val() || '0').replace(',', '.'));
      const sentido = $row.find('.js-sentido').val(); // 'D' o 'I'
      const factor = sentido === 'D' ? (1 - pct/100) : (1 + pct/100);
      const margen = (mho * factor);
      $row.find('.js-margen').val(margen.toFixed(4));
    });
  });
</script>
