<?php /* app/Views/productos/matriz_precios.php */ ?>
<style>
  .mat-precios .card{ border:1px solid #e5e7eb; border-radius:12px; box-shadow:0 6px 18px rgba(0,0,0,.05); background:#fff; }
  .mat-precios .card-header{ background:#fff; border-bottom:1px solid #e5e7eb; padding:14px 18px; }
  .mat-precios .muted{ color:#6b7280; }
  .mat-precios .table thead th{ font-size:.8rem; text-transform:uppercase; letter-spacing:.04em; }
  .mat-precios .text-end{ text-align:right !important; }
  /* Modal grande compatible con BS3/4 */
  .modal-xxl .modal-dialog{ width: 95%; max-width: 1200px; }
  @media (max-width: 1200px){ .modal-xxl .modal-dialog{ width: 98%; } }
  /* Pills de descuento en la grilla */
.pill{display:inline-flex;align-items:center;padding:.15rem .45rem;border-radius:999px;
  font-size:.72rem;font-weight:600;border:1px solid; line-height:1}
.pill.dec{color:#b45309;background:#fff7ed;border-color:#fed7aa}  /* Decremento */
.pill.inc{color:#065f46;background:#ecfdf5;border-color:#a7f3d0}  /* Incremento */
.num-mono{font-variant-numeric: tabular-nums;}
.dt-flex-end{display:flex;justify-content:flex-end;align-items:center;gap:.4rem;}

</style>

<div class="mat-precios">
  <div class="card mb-3">
    <div class="card-header d-flex align-items-center justify-content-between">
      <div>
        <div class="h5 mb-1">Matriz de Precios por Producto</div>
        <div class="muted small">
          Se usa el <code>base_price</code> más reciente (unidad base) y se calcula: <code>precio = base / (1 - margen)</code>.
        </div>
      </div>
      <span class="badge bg-light text-dark border">4 decimales</span>
    </div>

    <div class="card-body">
      <!-- Filtros -->
      <form id="frmFiltros" class="row g-2 mb-3">
        <div class="col-md-3">
          <label class="form-label">Código</label>
          <input type="text" class="form-control" name="codigo" placeholder="Ej. ABC123">
        </div>
        <div class="col-md-4">
          <label class="form-label">Descripción</label>
          <input type="text" class="form-control" name="descripcion" placeholder="Contiene...">
        </div>
        <div class="col-md-3">
          <label class="form-label">Lista (lpr_ref_id)</label>
          <input type="text" class="form-control" name="lista" placeholder="Opcional">
        </div>
        <div class="col-md-2 d-grid align-items-end">
          <button type="submit" class="btn btn-primary"><i class="fa fa-filter"></i> Filtrar</button>
        </div>
      </form>

      <!-- Tabla -->
      <div class="table-responsive">
        <table id="tblMatriz" class="table table-striped table-bordered align-middle" style="width:100%">
          <thead>
            <tr>
              <th data-data="pro_codigo">Código</th>
              <th data-data="pro_descripcion">Descripción</th>
              <th data-data="lpr_nombre">Lista</th>
              <th data-data="base_price" class="text-end">Base</th>

              <th data-data="margen_hoy" class="text-end">M.Hoy</th>
              <th data-data="margen_normal" class="text-end">M.Normal</th>
              <th data-data="margen_limite" class="text-end">M.Límite</th>
              <th data-data="margen_admin" class="text-end">M.Admin</th>
              <th data-data="margen_mayorista" class="text-end">M.Mayor</th>
              <th data-data="margen_especial" class="text-end">M.Esp</th>

              <th data-data="precio_hoy" class="text-end">Precio Hoy</th>
              <th data-data="precio_normal" class="text-end">Precio Normal</th>
              <th data-data="precio_limite" class="text-end">Precio Límite</th>
              <th data-data="precio_administrador" class="text-end">Precio Admin</th>
              <th data-data="precio_mayorista" class="text-end">Precio Mayor</th>
              <th data-data="precio_especial" class="text-end">Precio Esp.</th>
              <th data-data="imported_at">Importado</th>
              <th data-data="_acciones">Acciones</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>

      <div class="small muted mt-2">
        Toma el registro con <strong>measury_unit_base = true</strong> y mayor <code>imported_at</code> por producto/lista.
      </div>
    </div>
  </div>
</div>

<!-- ========= Sleek Product Modal (UX/UI refinado) ========= -->
<style>
  /* Contenedor & tarjeta */
  .modal-sleek .modal-dialog{ max-width: 920px; width: calc(100% - 2rem); margin: 1.25rem auto; }
  .modal-sleek .modal-content{ border:1px solid #e5e7eb; border-radius:14px; overflow:hidden; background:#fff; box-shadow:0 18px 50px rgba(0,0,0,.14); }

  /* Header compacto */
  .modal-sleek .modal-header{ border-bottom:1px solid #eef1f5; padding:12px 14px; background:linear-gradient(180deg,#fff 0%,#f8fafc 100%); }
  .modal-sleek .modal-title{ display:flex; align-items:baseline; gap:.5rem; margin:0; font-weight:700; letter-spacing:.2px; }
  .modal-sleek .modal-title small{ color:#6b7280; font-weight:600; }

  /* Chip de resumen */
  .modal-sleek .chip{ display:flex; gap:.75rem; align-items:center; padding:12px 14px; border-bottom:1px solid #f0f2f6; background:#fff; }
  .modal-sleek .img-plate{ width:64px;height:64px;border-radius:10px;overflow:hidden;background:#f3f4f6;display:flex;align-items:center;justify-content:center;border:1px solid #eef1f5; }
  .modal-sleek .img-plate img{width:100%;height:100%;object-fit:contain}
  .modal-sleek .meta .k{color:#111827;font-weight:600;margin-right:.35rem}
  .modal-sleek .meta .v{color:#6b7280}

  /* Grid del cuerpo */
  .modal-sleek .body-grid{ display:grid; gap:12px; padding:12px; grid-template-columns: 1.1fr .9fr; }
  @media (max-width: 900px){ .modal-sleek .body-grid{ grid-template-columns:1fr; } }

  /* Tarjetas mini */
  .modal-sleek .card-min{ background:#fff; border:1px solid #eef1f5; border-radius:12px; box-shadow:0 6px 16px rgba(0,0,0,.04); }
  .modal-sleek .card-min .card-header{ padding:10px 12px; border-bottom:1px solid #eef1f5; background:#fff; font-weight:600; }
  .modal-sleek .card-min .card-body{ padding:12px; }

  /* Tabla-Form */
  .modal-sleek table thead th{ font-size:.78rem; text-transform:uppercase; letter-spacing:.04em; color:#475569; }
  .modal-sleek .text-end{ text-align:right !important; }
  .modal-sleek input[type=number]{ text-align:right; }
  .modal-sleek input[type=number]::-webkit-outer-spin-button,
  .modal-sleek input[type=number]::-webkit-inner-spin-button{ -webkit-appearance: none; margin: 0; }
  .modal-sleek input[type=number]{ -moz-appearance:textfield; }
  .modal-sleek .form-compact .form-control, .modal-sleek .form-compact .form-select{ height:38px; }
  .modal-sleek .form-control:focus, .modal-sleek .form-select:focus{ box-shadow:0 0 0 3px rgba(59,130,246,.15); border-color:#93c5fd; }

  /* Price chips */
  .price-grid{ display:grid; gap:10px; grid-template-columns: repeat(2,1fr); }
  .price-item{ background:#f8fafc; border:1px solid #eef1f5; border-radius:10px; padding:10px 12px; display:flex; justify-content:space-between; align-items:center; }
  .price-item .k{ color:#64748b; font-size:.8rem; }
  .price-item .v{ font-weight:700; }

  /* Ayuda */
  .hint{ color:#6b7280; font-size:.85rem; }

  /* Barra acciones */
  .modal-sleek .actionbar{ position: sticky; bottom:-1px; background:#fff; border-top:1px solid #eef1f5; padding:10px 12px; display:flex; justify-content:space-between; align-items:center; }

  /* Botón cerrar (BS3/4) */
.modal-sleek .close{ line-height:1; font-size:24px; opacity:.6; }
.modal-sleek .close:hover{ opacity:1; }

/* Layout del cuerpo: UNA sola columna */
.modal-sleek .body-grid{
  display:grid;
  gap:12px;
  padding:12px;
  grid-template-columns: 1fr !important; /* fuerza 1 columna */
}
@media (max-width: 900px){
  .modal-sleek .body-grid{ grid-template-columns: 1fr !important; }
}

@media (max-width: 900px){ .modal-sleek .body-grid{ grid-template-columns:1fr; } }
</style>

<div class="modal fade modal-xxl modal-sleek" id="mdlProducto" tabindex="-1" role="dialog" aria-hidden="true" aria-labelledby="md-titulo">
  <div class="modal-dialog modal-dialog-scrollable">
    <div class="modal-content">

      <!-- Header -->
      <div class="modal-header">
        <h5 class="modal-title">
          <span id="md-titulo">Producto</span>
          <small class="text-muted ms-2" id="md-sub"></small>
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar" title="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <!-- Chip -->
      <div class="chip">
        <div class="img-plate">
          <img id="md-img"
               src="data:image/svg+xml;utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='64' height='64'%3E%3Crect width='100%25' height='100%25' fill='%23f3f4f6'/%3E%3Ctext x='50%25' y='50%25' dominant-baseline='middle' text-anchor='middle' fill='%239aa3af' font-family='Arial' font-size='12'%3EIMG%3C/text%3E%3C/svg%3E"
               alt="Imagen del producto">
        </div>
        <div class="meta">
          <div><span class="k">Código:</span><span class="v" id="md-codigo">—</span></div>
          <div class="v" id="md-desc">—</div>
          <div class="v" id="md-extra">—</div>
        </div>
      </div>

      <!-- Body -->
      <div class="body-grid">

        <!-- Izquierda: parámetros -->
        <div class="card-min">
          <div class="card-header">Parámetros del producto</div>
          <div class="card-body">
            <div class="hint mb-2">
              Al guardar, se inactiva el set anterior y este queda <b>activo</b>. Fórmula:
              <code>m_tipo = m_hoy × (1 − descuento/100)</code>
            </div>

            <form id="frmProducto" class="mb-0 form-compact">
              <?= csrf_field() ?>
              <input type="hidden" name="pro_codigo" id="in-codigo">

              <div class="d-flex justify-content-between align-items-center mb-2">
                <div>
                  <div class="small text-muted">Base (último)</div>
                  <div class="h2 mb-0" id="md-base">0.00</div>
                </div>
                <small class="text-muted" id="md-lista">—</small>
              </div>

              <label class="form-label small">Observación</label>
              <input type="text" maxlength="300" class="form-control" name="observacion" id="in-obs" placeholder="Ej. Ajuste por temporada" aria-label="Observación">

              <div class="table-responsive mt-2">
                <table class="table table-sm align-middle">
                  <thead>
                    <tr>
                      <th>Tipo</th>
                      <th class="text-end">% Desc.</th>
                      <th>Sentido</th>
                      <th class="text-end">Margen calc.</th>
                      <th class="text-end">Precio</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>Hoy</td>
                      <!-- ID corregido para no duplicar -->
                      <td>
                        <input type="number" step="0.1" min="0" value="0.00" class="form-control text-end" id="in-dhoy" readonly title="% descuento sobre Hoy (solo lectura)">
                      </td>
                      <td>
                        <select class="form-control form-select" id="in-shoy" disabled>
                          <option value="D">Decremento</option>
                          <option value="I">Incremento</option>
                        </select>
                      </td>
                      <td class="text-end">
                        <input type="number" step="0.1" min="0" class="form-control" name="mho" id="in-mho" aria-label="Margen hoy">
                      </td>
                      <td class="text-end"><div class="v" id="md-phoy">0.00</div></td>
                    </tr>

                    <tr>
                      <td>Normal</td>
                      <td><input type="number" step="0.1" min="0" class="form-control text-end" name="desc_normal" id="in-dn" aria-label="% desc. normal"></td>
                      <td>
                        <select class="form-control form-select" name="sent_normal" id="in-sn" aria-label="Sentido normal">
                          <option value="D">Decremento</option>
                          <option value="I">Incremento</option>
                        </select>
                      </td>
                      <td class="text-end"><span id="m-normal">0.00</span></td>
                      <td class="text-end"><div class="v" id="md-pnor">0.00</div></td>
                    </tr>

                    <tr>
                      <td>Límite</td>
                      <td><input type="number" step="0.1" min="0" class="form-control text-end" name="desc_limite" id="in-dl" aria-label="% desc. límite"></td>
                      <td>
                        <select class="form-control form-select" name="sent_limite" id="in-sl">
                          <option value="D">Decremento</option>
                          <option value="I">Incremento</option>
                        </select>
                      </td>
                      <td class="text-end"><span id="m-lim">0.00</span></td>
                      <td class="text-end"><div class="v" id="md-plim">0.00</div></td>
                    </tr>

                    <tr>
                      <td>Administrador</td>
                      <td><input type="number" step="0.1" min="0" class="form-control text-end" name="desc_admin" id="in-da" aria-label="% desc. administrador"></td>
                      <td>
                        <select class="form-control form-select" name="sent_admin" id="in-sa">
                          <option value="D">Decremento</option>
                          <option value="I">Incremento</option>
                        </select>
                      </td>
                      <td class="text-end"><span id="m-adm">0.00</span></td>
                      <td class="text-end"><div class="v" id="md-padm">0.00</div></td>
                    </tr>

                    <tr>
                      <td>Mayorista</td>
                      <td><input type="number" step="0.1" min="0" class="form-control text-end" name="desc_mayorista" id="in-dy" aria-label="% desc. mayorista"></td>
                      <td>
                        <select class="form-control form-select" name="sent_mayorista" id="in-sy">
                          <option value="D">Decremento</option>
                          <option value="I">Incremento</option>
                        </select>
                      </td>
                      <td class="text-end"><span id="m-may">0.00</span></td>
                      <td class="text-end"><div class="v" id="md-pmay">0.00</div></td>
                    </tr>

                    <tr>
                      <td>Especial</td>
                      <td><input type="number" step="0.1" min="0" class="form-control text-end" name="desc_especial" id="in-de" aria-label="% desc. especial"></td>
                      <td>
                        <select class="form-control form-select" name="sent_especial" id="in-se">
                          <option value="D">Decremento</option>
                          <option value="I">Incremento</option>
                        </select>
                      </td>
                      <td class="text-end"><span id="m-esp">0.00</span></td>
                      <td class="text-end"><div class="v" id="md-pesp">0.00</div></td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <!-- Actionbar -->
              <div class="actionbar">
                <span class="hint">Revisa los márgenes calculados antes de guardar.</span>
                <button class="btn btn-primary" id="btnGuardarProd"><i class="fa fa-save"></i> Guardar</button>
              </div>
            </form>
          </div>
        </div>

        <!-- Derecha: resumen precios (solo lectura) -->
        

        <!-- Historial (full width en móvil) -->
        <div class="card-min" style="grid-column:1 / -1;">
          <div class="card-header">Historial del producto</div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-sm" id="tblHistProd">
                <thead>
                  <tr>
                    <th>ID</th><th>Margen Hoy</th><th>%N</th><th>%L</th><th>%A</th><th>%M</th><th>%E</th><th>Obs</th><th>Activo</th><th>Actualizado</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>

      </div><!-- /body-grid -->
    </div>
  </div>
</div>
<!-- ===== /Sleek Product Modal ===== -->



<script>
$(function(){

  // ====== Helpers ======
  function isNumericKey(key){ return [
    'base_price','margen_hoy','margen_normal','margen_limite','margen_admin','margen_mayorista','margen_especial',
    'precio_hoy','precio_normal','precio_limite','precio_administrador','precio_mayorista','precio_especial'
  ].includes(key); }

  function f4(v){ return (v==null||v==='') ? '0.00' : parseFloat(v).toFixed(2); }

  // Placeholder para usar también desde JS como fallback
  const PLACEHOLDER_IMG = "data:image/svg+xml;utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='84' height='84'%3E%3Crect width='100%25' height='100%25' fill='%23f1f3f5'/%3E%3Ctext x='50%25' y='50%25' dominant-baseline='middle' text-anchor='middle' fill='%2399a1a8' font-family='Arial' font-size='14'%3EIMG%3C/text%3E%3C/svg%3E";

  function setProductImage(url){
    if (typeof url === 'string' && url.trim() !== '' && !/^(null|undefined)$/i.test(url)) {
      $('#md-img').attr('src', url.trim());
    } else {
      $('#md-img').attr('src', PLACEHOLDER_IMG);
    }
  }

  // === Reemplazo: cálculo de márgenes + precios (con Sentido) ===
// === Cálculo de márgenes + precios (precio = base / (1 - margen)) ===
// === Cálculo con márgenes en porcentaje ===
// precio = base / (1 - (margen% / 100))
function calcMargenesUI(){
  const base = parseFloat(($('#md-base').text() || '0').replace(/,/g,'')) || 0;

  // Margen Hoy: puede venir como 0.30 (decimal) o 30 (porcentaje)
  let mhoPerc = parseFloat($('#in-mho').val() || 0);
  if (mhoPerc <= 1.2) { // heurística: si es <=1.2 interpretamos que vino en decimal
    mhoPerc = mhoPerc * 100;
  }

  // Descuentos %
  const dn = parseFloat($('#in-dn').val() || 0);
  const dl = parseFloat($('#in-dl').val() || 0);
  const da = parseFloat($('#in-da').val() || 0);
  const dy = parseFloat($('#in-dy').val() || 0);
  const de = parseFloat($('#in-de').val() || 0);

  // Sentidos
  const sn = ($('#in-sn').val() || 'D').toUpperCase();
  const sl = ($('#in-sl').val() || 'D').toUpperCase();
  const sa = ($('#in-sa').val() || 'D').toUpperCase();
  const sy = ($('#in-sy').val() || 'D').toUpperCase();
  const se = ($('#in-se').val() || 'D').toUpperCase();

  // Aplica %desc sobre el margen HOY (todo en porcentaje)
  const applyPerc = (mPerc, dPerc, sentido) =>
    mPerc * (sentido === 'I' ? (1 + dPerc/100) : (1 - dPerc/100));

  // Márgenes por tipo (en %)
  const m_normalP = applyPerc(mhoPerc, dn, sn);
  const m_limP    = applyPerc(mhoPerc, dl, sl);
  const m_admP    = applyPerc(mhoPerc, da, sa);
  const m_mayP    = applyPerc(mhoPerc, dy, sy);
  const m_espP    = applyPerc(mhoPerc, de, se);

  // Pintar márgenes (como % con dos decimales)
  $('#m-normal').text( f4(m_normalP) );
  $('#m-lim').text(    f4(m_limP) );
  $('#m-adm').text(    f4(m_admP) );
  $('#m-may').text(    f4(m_mayP) );
  $('#m-esp').text(    f4(m_espP) );

  // Helper precio seguro
  const priceOfPerc = (b, mPerc) => {
    const den = 1 - (mPerc/100);
    if (!isFinite(den) || Math.abs(den) < 1e-9) return '—';
    return f4(b / den);
  };

  // Precios (incluye HOY usando mhoPerc)
  $('#md-phoy').text( priceOfPerc(base, mhoPerc) );
  $('#md-pnor').text( priceOfPerc(base, m_normalP) );
  $('#md-plim').text( priceOfPerc(base, m_limP) );
  $('#md-padm').text( priceOfPerc(base, m_admP) );
  $('#md-pmay').text( priceOfPerc(base, m_mayP) );
  $('#md-pesp').text( priceOfPerc(base, m_espP) );
}

// Recalcular en vivo
$('#in-mho,#in-dn,#in-dl,#in-da,#in-dy,#in-de').on('input', calcMargenesUI);
$('#in-sn,#in-sl,#in-sa,#in-sy,#in-se').on('change', calcMargenesUI);



  // ====== Construir columnas a partir de los <th> ======
  const columns = [];
  $('#tblMatriz thead th').each(function(){
    const key = $(this).data('data') || $(this).text();

    if (key === '_acciones') {
      columns.push({
        data: null, orderable:false, searchable:false,
        render: function(_, __, row){
          const code   = row.pro_codigo;
          const lprRef = row.lpr_ref_id || '';
          return `
            <button class="btn btn-sm btn-outline-primary btn-ver-prod"
                    data-codigo="${code}" data-lista="${lprRef}">
              <i class="fa fa-eye"></i> Ver / Editar
            </button>`;
        }
      });
      return;
    }

    columns.push({
  data: key,
  render: function(data, type, row){
    // Márgenes con pill
    if (isMarginCol(key)) {
      if (type === 'display' || type === 'filter') {
        const v = (data==null || data==='') ? '' : parseFloat(data).toFixed(2);
        // Para M.Hoy NO mostramos pill; en los demás sí, comparando contra M.Hoy
        const pill = (key === 'margen_hoy') ? '' : renderDiscountPill(row, key);
        return `<div class="dt-flex-end"><span class="num-mono">${v}</span>${pill}</div>`;
      }
      return data;
    }

    // Números de precio alineados
    if (isNumericKey(key)) {
      if (type === 'display' || type === 'filter') {
        if (data===null || data===undefined || data==='') return '<div class="text-end"></div>';
        const v = parseFloat(data).toFixed(2);
        return '<div class="text-end num-mono">'+v+'</div>';
      }
      return data;
    }

    if (key === 'imported_at') {
      if (!data) return '';
      try { return new Date(data).toLocaleString(); } catch(e){ return data; }
    }
    return data;
  }
});

  });

  // ====== DataTable ======
  const table = $('#tblMatriz').DataTable({
    processing:true, serverSide:true,
    ajax:{
      url: '<?= base_url('productos/matriz/data') ?>',
      data: function(d){
        const q = Object.fromEntries(new FormData(document.getElementById('frmFiltros')).entries());
        return $.extend({}, d, q);
      }
    },
    columns: columns,
    pageLength: 25,
    order:[[0,'asc']],
    dom:'Bfrtip',
    buttons:['excelHtml5','csvHtml5','pdfHtml5'],
    language:{ url:'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
  });

  $('#frmFiltros').on('submit', function(e){
    e.preventDefault();
    table.ajax.reload();
  });

  // ====== Modal: abrir (jQuery API BS3/4) ======
  $(document).on('click', '.btn-ver-prod', function(){
    const codigo = $(this).data('codigo');
    const lista  = $(this).data('lista') || '';

    $.get('<?= base_url('productos/matriz/detail') ?>', { codigo, lista }, function(r){
      // Encabezado
      $('#md-titulo').text(r.producto.pro_codigo || '');
      $('#md-sub').text(r.producto.pro_unidad_nombre || '');
      $('#md-codigo').text(r.producto.pro_codigo || '');
      $('#md-desc').text(r.producto.pro_descripcion || '');
      $('#md-extra').text([r.producto.pro_marca, r.producto.pro_familia].filter(Boolean).join(' · '));

      setProductImage(r.producto.pro_imagen_url);

      // Base/precios
      if (r.calculo){
        $('#md-base').text(f4(r.calculo.base_price));
        $('#md-lista').text((r.calculo.price_list_name||r.calculo.lpr_ref_id||'') + (r.calculo.imported_at ? ' · ' + new Date(r.calculo.imported_at).toLocaleString() : ''));
        $('#md-phoy').text(f4(r.calculo.precio_hoy));
        $('#md-pnor').text(f4(r.calculo.precio_normal));
        $('#md-plim').text(f4(r.calculo.precio_limite));
        $('#md-padm').text(f4(r.calculo.precio_admin));
        $('#md-pmay').text(f4(r.calculo.precio_mayorista));
        $('#md-pesp').text(f4(r.calculo.precio_especial));
      } else {
        $('#md-base,#md-phoy,#md-pnor,#md-plim,#md-padm,#md-pmay,#md-pesp').text('0.00');
        $('#md-lista').text('Sin base');
      }

      // Formulario
      $('#in-codigo').val(r.producto.pro_codigo);
      $('#in-mho').val(f4(r.parametros.ppr_margen_hoy));
      $('#in-obs').val(r.parametros.ppr_observacion || '');

      $('#in-dn').val(f4(r.parametros.ppr_desc_normal));
      $('#in-dl').val(f4(r.parametros.ppr_desc_limite));
      $('#in-da').val(f4(r.parametros.ppr_desc_admin));
      $('#in-dy').val(f4(r.parametros.ppr_desc_mayorista));
      $('#in-de').val(f4(r.parametros.ppr_desc_especial));

      $('#in-sn').val(r.parametros.ppr_sentido_normal || 'D');
      $('#in-sl').val(r.parametros.ppr_sentido_limite || 'D');
      $('#in-sa').val(r.parametros.ppr_sentido_admin || 'D');
      $('#in-sy').val(r.parametros.ppr_sentido_mayorista || 'D');
      $('#in-se').val(r.parametros.ppr_sentido_especial || 'D');

      calcMargenesUI();

      // Historial
      const tb = $('#tblHistProd tbody').empty();
      (r.historial||[]).forEach(h=>{
        const activo = (h.ppr_activo===true||h.ppr_activo==='t'||h.ppr_activo==='1') ? '<span class="badge bg-success">Sí</span>' : '<span class="badge bg-secondary">No</span>';
        tb.append(`<tr>
          <td>${h.ppr_id}</td>
          <td>${f4(h.ppr_margen_hoy)}</td>
          <td>${f4(h.ppr_desc_normal)}</td>
          <td>${f4(h.ppr_desc_limite)}</td>
          <td>${f4(h.ppr_desc_admin)}</td>
          <td>${f4(h.ppr_desc_mayorista)}</td>
          <td>${f4(h.ppr_desc_especial)}</td>
          <td>${h.ppr_observacion||''}</td>
          <td>${activo}</td>
          <td>${h.ppr_updated_at||''}</td>
        </tr>`);
      });

      $('#mdlProducto').modal('show');
    });
  });

  // recalcular márgenes en vivo
  $('#in-mho,#in-dn,#in-dl,#in-da,#in-dy,#in-de').on('input', calcMargenesUI);

  // guardar (jQuery)
  $('#btnGuardarProd').on('click', function(e){
    e.preventDefault();
    const data = $('#frmProducto').serialize();
    $.post('<?= base_url('productos/matriz/save') ?>', data, function(r){
      if(r && r.ok){
        $('#tblMatriz').DataTable().ajax.reload(null,false);
        $('#mdlProducto').modal('hide');
      } else {
        alert('No se pudo guardar');
      }
    }).fail(function(xhr){
      alert('Error al guardar: '+(xhr.responseJSON?.error || xhr.statusText));
    });
  });

});

// Calcula pill comparando un margen con M.Hoy
function renderDiscountPill(row, key){
  const mho = parseFloat(row.margen_hoy ?? 0);
  const mt  = parseFloat(row[key] ?? 0);
  if (!isFinite(mho) || mho === 0 || !isFinite(mt)) return ''; // sin base para comparar

  const ratio = mt / mho;
  let perc, cls, sign, icon;
  if (ratio <= 1){          // Decremento (desc)
    perc = (1 - ratio) * 100;
    cls  = 'dec'; sign = '−'; icon = '&#8595;'; // ↓
  } else {                  // Incremento
    perc = (ratio - 1) * 100;
    cls  = 'inc'; sign = '+'; icon = '&#8593;'; // ↑
  }
  return `<span class="pill ${cls}" title="Ajuste vs. M.Hoy">${icon} ${sign}${perc.toFixed(2)}%</span>`;
}

// ¿Es una columna de margen de la grilla?
function isMarginCol(key){
  return ['margen_hoy','margen_normal','margen_limite','margen_admin','margen_mayorista','margen_especial']
         .includes(key);
}

</script>
