<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Cargomodel;

class Cargo extends BaseController
{

	public function index(){
		$cargo_model= new Cargomodel();
		$datos_cargo=$cargo_model->getCargo();


		$enviar_datos=array(
			'datos_cargo' => !empty($datos_cargo)?$datos_cargo:null , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("cargo/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$cargo_model= new Cargomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('cargo'))){
				$car_cargo=$this->request->getPost('cargo');
				$ingresar_datos=array(
					'car_cargo'=>$car_cargo,
					'car_estado'=>1
				);
				$cargo_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Cargo')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Cargo')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$cargo_model= new Cargomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editcargo')) && !empty($this->request->getPost('editcarid'))){
				$car_cargo=$this->request->getPost('editcargo');
				$car_id=$this->request->getPost('editcarid');
				$editar_datos=array(
					'car_cargo'=>$car_cargo,
					'car_estado'=>1
				);
				$cargo_model->actualizar($car_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Cargo')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Cargo')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$cargo_model= new Cargomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'car_estado'=>0
				);
				$cargo_model->actualizar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Cargo')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Cargo')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}