<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Comisionmodel;

class Comisionesgenerales extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_CORREO')!=null){
    		$comison_model= new Comisionmodel();
    		$datos_comision_grupo=$comison_model->getGrupos();
    		$enviar_datos=array(
    			'datos_comision_grupo' => !empty($datos_comision_grupo)?$datos_comision_grupo:[] , 
    		);
    
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("comisionesgenerales/list",$enviar_datos);
    		echo view("layouts/footer");
    		echo view("comisionesgenerales/footer");
	    }else{

			return redirect()->to(base_url()); 
		}
	}

	
	public function getComisionGrupoPorcentajeBYCOG_ID(){
	    $cog_id=$this->request->getPost('cog_id');
		$comison_model= new Comisionmodel();
		$datos_comision=$comison_model->getComisionGrupoPorcentajeBYCOG_ID($cog_id);
		return json_encode($datos_comision);
	}
	
	public function getPuntodeVentaporGrupo(){
	    $cog_id=$this->request->getPost('cog_id');
		$comison_model= new Comisionmodel();
		$datos_comision=$comison_model->getPuntosdeVentaporGrupos($cog_id);
		return json_encode($datos_comision);
	}

	public function edit(){
		$session = \Config\Services::session();
		$comision_model= new Comisionmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editidgrupo'))&&!empty($this->request->getPost('editnombregrupo')) && !empty($this->request->getPost('edit8'))&& !empty($this->request->getPost('edit9'))&& !empty($this->request->getPost('edit10'))&& !empty($this->request->getPost('edit11'))&& !empty($this->request->getPost('edit12'))&& !empty($this->request->getPost('edit13'))&& !empty($this->request->getPost('edit14'))){
				
				$id_grupo=$this->request->getPost('editidgrupo');
				$nombregrupo=$this->request->getPost('editnombregrupo');
				$descripcion=$this->request->getPost('editdescripcion');
				$editar_datos=array(
    				'cog_nombre'=>$nombregrupo,
    				'cog_observacion'=>$descripcion,
    			);
    			
				$comision_model->actualizarComisionGrupo($id_grupo,$editar_datos);
				
				$editar_datos=array(
    				'cgp_estado'=>0,
    			);
				$comision_model->actualizarComisionGrupoPorcentaje($id_grupo,$editar_datos);
				
				$PrecioAdministradorFerretera=$this->request->getPost('edit8');
			
    			$ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>8,
        				'cgp_porcentaje'=>floatval($PrecioAdministradorFerretera),
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
        		print_r($ingresar_datos);
        		
                $PrecioMayoristaFerretera=$this->request->getPost('edit9');
                
                $ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>9,
        				'cgp_porcentaje'=>$PrecioMayoristaFerretera,
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
        		
                $PrecioAdministradorPesado=$this->request->getPost('edit10');
                
                $ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>10,
        				'cgp_porcentaje'=>$PrecioAdministradorPesado,
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
        		
                $PesadoMayoristaPesado=$this->request->getPost('edit11');
                
                $ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>11,
        				'cgp_porcentaje'=>$PesadoMayoristaPesado,
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
        		
                $MaterialPesado=$this->request->getPost('edit12');
                
                $ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>12,
        				'cgp_porcentaje'=>$MaterialPesado,
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
        		
                $MaterialPtreo=$this->request->getPost('edit13');
                
                $ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>13,
        				'cgp_porcentaje'=>$MaterialPtreo,
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
        		
                $Ferretera=$this->request->getPost('edit14');
                
                $ingresar_datos=array(
        				'cog_id'=>$id_grupo,
        				'com_id'=>14,
        				'cgp_porcentaje'=>$Ferretera,
        				'cgp_estado'=>1,
        				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
        		);
        		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
				
				$session->setFlashdata('mensaje_bueno', 'Comisiones editadas satisfactoriamente');
				return redirect()->to(base_url('Comisionesgenerales')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Existió un error');
				return redirect()->to(base_url('Comisionesgenerales')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function add(){		
		
		$session = \Config\Services::session();
		
		if($session->get('USU_CORREO')!=null){
		    $comision_model= new Comisionmodel();
		    $Nombredelgrupo=$this->request->getPost('nombregrupo');
		    $descripcion=$this->request->getPost('descripcion');
		    
		    $ingresar_datos=array(
				'cog_nombre'=>$Nombredelgrupo,
				'cog_observacion'=>$descripcion,
				'cog_estado'=>1
			);
			print_r($ingresar_datos);
			$id_grupo=$comision_model->insertarGrupo($ingresar_datos);
			$id_grupo=$id_grupo[0]['cog_id'];
			
			
			$PrecioAdministradorFerretera=$this->request->getPost('8');
			
			$ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>8,
    				'cgp_porcentaje'=>floatval($PrecioAdministradorFerretera),
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
    		print_r($ingresar_datos);
    		
            $PrecioMayoristaFerretera=$this->request->getPost('9');
            
            $ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>9,
    				'cgp_porcentaje'=>$PrecioMayoristaFerretera,
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
    		
            $PrecioAdministradorPesado=$this->request->getPost('10');
            
            $ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>10,
    				'cgp_porcentaje'=>$PrecioAdministradorPesado,
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
    		
            $PesadoMayoristaPesado=$this->request->getPost('11');
            
            $ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>11,
    				'cgp_porcentaje'=>$PesadoMayoristaPesado,
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
    		
            $MaterialPesado=$this->request->getPost('12');
            
            $ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>12,
    				'cgp_porcentaje'=>$MaterialPesado,
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
    		
            $MaterialPtreo=$this->request->getPost('13');
            
            $ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>13,
    				'cgp_porcentaje'=>$MaterialPtreo,
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
    		
            $Ferretera=$this->request->getPost('14');
            
            $ingresar_datos=array(
    				'cog_id'=>$id_grupo,
    				'com_id'=>14,
    				'cgp_porcentaje'=>$Ferretera,
    				'cgp_estado'=>1,
    				'cgp_usuario_cambio'=>$session->get('USU_CORREO'),
    		);
    		$comision_model->insertarComisionGrupoPorcentaje($ingresar_datos);
			$session->setFlashdata('mensaje_bueno', 'Comisiones editadas satisfactoriamente');
			return redirect()->to(base_url('Comisionesgenerales')); 
			
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}