<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Descuentosmodel;
use App\Models\Tipofranquiciacomisionesmodel;
use App\Models\Descuentospdvtipofranquiciamodel;
use App\Models\Comisionmesfinalizadomodel;
use App\Models\Descuentomensualmodel;
use App\Models\Descuentomensualvalormodel;
class Descuentos extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    		$punto_venta_model=new Puntoventamodel();
    		$descuentos_model=new Descuentosmodel();
    		$tipo_franquicia_comisiones_model=new Tipofranquiciacomisionesmodel();
    
    		$datos_punto_venta = $punto_venta_model->getPuntoventa();
    		$datos_descuento= $descuentos_model->getDescuentos();
    		$datos_tipo_franquicia_comisiones= $tipo_franquicia_comisiones_model->getTipofranquiciacomisiones();
    
    		$enviar_datos=array(
    			'datos_punto_venta'=>$datos_punto_venta,
    			'datos_descuento'=>$datos_descuento,
    			'datos_tipo_franquicia_comisiones'=>$datos_tipo_franquicia_comisiones,
    		);
    
    		echo view("layouts/header");
    		echo view("layouts/aside", $datos);
    		echo view("descuentos/list",$enviar_datos);
    		echo view("layouts/footer");
    	}
    	    else{
    	        return redirect()->to(base_url());
    	    }
    	}

	public function add(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('arraylistadescuento'))){

			$descuentos_model=new Descuentosmodel();
			$descuentos_pdv_tipo_franquicia_model= new Descuentospdvtipofranquiciamodel();
			$lista_descuento=json_decode($this->request->getPost('arraylistadescuento'),true);
			$todos_nombre='';
			foreach ($lista_descuento as $value) {

				
				$busqueda='';
				if($value['lista_franquicias'][0]=='Todos'){
					$busqueda='Tipo Franquicia';
				}else{
					$busqueda='PDV';
					
				}
				
				$datos=array(
					'des_nombre'=>$value['nombre_descuento'],
					'des_fecha_inicio'=>$value['fecha_inicio'],
					'des_frecuencia'=>$value['frecuencia'],
					'des_fecha_desde'=>$value['fecha_desde'],
					'des_fecha_hasta'=>$value['fecha_hasta'],
					'des_nombre_franquicias'=>$busqueda,
					'des_tipo'=>$value['tipo'],
					'des_valor'=>$value['valor'],
					'des_estado'=>1,
				);
				$descuentos_model->insertar($datos);
				$des_id =$descuentos_model->getDescuentosmaxid();
				$des_id =$des_id[0]['des_id'];
				

				if($busqueda=='Tipo Franquicia'){
					foreach ($value['lista_tipos_franquicias'] as $item) {
						$descuento_pdv_tipo_franquicia=array(
							'tfc_id'=>$item['tfc_id'],
							'puv_id'=>0,
							'des_id'=>$des_id,
						);
						$descuentos_pdv_tipo_franquicia_model->insertar($descuento_pdv_tipo_franquicia);
					}
				}
				if($busqueda=='PDV'){
					foreach ($value['lista_franquicias'] as $item) {
						$descuento_pdv_tipo_franquicia=array(
							'tfc_id'=>0,
							'puv_id'=>$item['puv_id'],
							'des_id'=>$des_id,
						);
						$descuentos_pdv_tipo_franquicia_model->insertar($descuento_pdv_tipo_franquicia);
					}
				}
			}
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos')); 
		}
	}
	public function edit(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('editdesid')) && !empty($this->request->getPost('editdescuento')) && !empty($this->request->getPost('editfechainiciodescuento')) && !empty($this->request->getPost('editfrecuencia')) && !empty($this->request->getPost('editvalordescuento')) && !empty($this->request->getPost('tipo'))  ){

			$descuentos_model=new Descuentosmodel();
			$des_id=$this->request->getPost('editdesid');
			$des_nombre=$this->request->getPost('editdescuento');
			$des_fecha_inicio=$this->request->getPost('editfechainiciodescuento');
			$des_frecuencia=$this->request->getPost('editfrecuencia');
			$des_tipo=$this->request->getPost('tipo');
			$des_valor=$this->request->getPost('editvalordescuento');

			if($des_frecuencia=='mensual'){
				if(empty($this->request->getPost('editfechadesde')) && empty($this->request->getPost('editfechahasta'))){
					$session->setFlashdata('mensaje_malo', 'No hay Fechas');
					return redirect()->to(base_url('Descuentos')); 
				}
				$des_fecha_desde=$this->request->getPost('editfechadesde');
				$des_fecha_hasta=$this->request->getPost('editfechahasta');

			}else{
				$des_fecha_desde='0000-00-00';
				$des_fecha_hasta='0000-00-00';
			}

			$datos=array(

				'des_nombre'=>$des_nombre,
				'des_fecha_inicio'=>$des_fecha_inicio,
				'des_frecuencia'=>$des_frecuencia,
				'des_fecha_desde'=>$des_fecha_desde,
				'des_fecha_hasta'=>$des_fecha_hasta,
				'des_tipo'=>$des_tipo,
				'des_valor'=>$des_valor,
				'des_estado'=>1,
			);

			$descuentos_model->actualizar($des_id,$datos);
			$session->setFlashdata('mensaje_bueno', 'Dato Editado');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentos')); 
		}
	}
	public function eliminar($des_id){
		$session = \Config\Services::session();
		
		if(!empty($des_id)){

			$descuentos_model=new Descuentosmodel();
			$datos_descuento=array(
				'des_estado'=>0,
			);
			$descuentos_model->actualizar($des_id, $datos_descuento);
			$session->setFlashdata('mensaje_bueno', 'Se ha inactivado el descuento');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentos')); 
		}
	}
	public function activar($des_id){
		$session = \Config\Services::session();
		
		if(!empty($des_id)){

			$descuentos_model=new Descuentosmodel();
			$datos_descuento=array(
				'des_estado'=>1,
			);
			$descuentos_model->actualizar($des_id, $datos_descuento);
			$session->setFlashdata('mensaje_bueno', 'Se ha activado el descuento');
			return redirect()->to(base_url('Descuentos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentos')); 
		}
	}

	public function leerdescuento(){
		$datos = $this->datosMenu();		
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("descuentos/leerdescuento");
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		

		
		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('DESCUENTOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "DESCUENTOS"');
				return redirect()->to(base_url('Descuentos/leerdescuento'));
			}    

			$data=[];

			$pdv_no_encontrados='';
			$des_nombre_franquicias='';
			$des_nombre='';
			$des_fecha_inicio= '';
			$des_frecuencia=  '';
			$des_fecha_desde=  '';
			$des_fecha_has= '';
			$des_tipo=  '';
			$des_valor=  '';
			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{

					

					if($row==2){
						$des_nombre = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
						$des_fecha_inicio= $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						if(empty($des_fecha_inicio)){
							$session->setFlashdata('mensaje_malo', 'Ingrese fecha de inicio');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						if(empty($des_nombre)){
							$session->setFlashdata('mensaje_malo', 'Ingrese nombre del descuento');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						$des_fecha_inicio = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($des_fecha_inicio);            
						$des_fecha_inicio =$des_fecha_inicio->format('Y-m-d');



						$des_frecuencia= $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						if($des_frecuencia=='indefinido'||$des_frecuencia=='mensual'){
							
						}else{
							$session->setFlashdata('mensaje_malo', 'Frecuencia : indefinido o  mensual');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						
						if($des_frecuencia=='mensual'){
							$des_fecha_desde= $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
							if(empty($des_fecha_desde)){
								$session->setFlashdata('mensaje_malo', 'Ingrese fecha desde');
								return redirect()->to(base_url('Descuentos/leerdescuento'));
							}
							$des_fecha_desde = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($des_fecha_desde);           
							$des_fecha_desde =$des_fecha_desde->format('Y-m-d');
							$des_fecha_hasta= $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
							if(empty($des_fecha_hasta)){
								$session->setFlashdata('mensaje_malo', 'Ingrese fecha hasta');
								return redirect()->to(base_url('Descuentos/leerdescuento'));
							}
							$des_fecha_hasta = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($des_fecha_hasta);           
							$des_fecha_hasta =$des_fecha_hasta->format('Y-m-d');

							if($des_fecha_hasta<$des_fecha_desde){
								$session->setFlashdata('mensaje_malo', 'fecha hasta es menor que fecha desde');
								return redirect()->to(base_url('Descuentos/leerdescuento'));
							}
						}else{
							$des_fecha_desde='0000-00-00';
							$des_fecha_hasta='0000-00-00';
						}

						$des_tipo= $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
						if($des_tipo=='Post-Facturacion'||$des_tipo=='Pre-Facturacion'){
							
						}else{
							$session->setFlashdata('mensaje_malo', 'Tipo : Post-Facturacion o  Pre-Facturacion');
							return redirect()->to(base_url('Descuentos/leerdescuento'));
						}
						$des_valor= $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
						if(!is_numeric($des_valor)){
							$des_valor=0;
						}
					}
					$nombre = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue(); 

					
					

					$puv_id= $punto_venta_model->getPuntoventasegunnombre($nombre);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($puv_id!=0){
						$des_nombre_franquicias=$des_nombre_franquicias." ".$nombre.",";						
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados."-".$nombre;
					}



				}
				break;

			}
			$datos = $this->datosMenu();
			$data[]=array(
				'des_nombre'=>$des_nombre,
				'des_fecha_inicio'=>$des_fecha_inicio,
				'des_frecuencia'=>$des_frecuencia,
				'des_fecha_desde'=>$des_fecha_desde,
				'des_fecha_hasta'=>$des_fecha_hasta,
				'des_tipo'=>$des_tipo,
				'des_valor'=>$des_valor,
				'des_nombre_franquicias'=>$des_nombre_franquicias,
			);
			$enviar_datos=array(        
				'mensaje'=>$pdv_no_encontrados,
				'data'=>$data,
			);

			

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("descuentos/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos')) ){
			$descuentos_model=new Descuentosmodel();
			$datos =$this->request->getPost('datos');		
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			

			foreach ($datos as $value) {

				$datos_descuento=array(

					'des_nombre'=>$value['des_nombre'],
					'des_fecha_inicio'=>$value['des_fecha_inicio'],
					'des_frecuencia'=>$value['des_frecuencia'],
					'des_fecha_desde'=>$value['des_fecha_desde'],
					'des_fecha_hasta'=>$value['des_fecha_hasta'],
					'des_tipo'=>$value['des_tipo'],
					'des_valor'=>$value['des_valor'],
					'des_nombre_franquicias'=>$value['des_nombre_franquicias'],
					'des_estado'=>1,

				);				
				$descuentos_model->insertar($datos_descuento);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}

	}



	public function mostrardatosundescuento()
	{
		$descuentos_pdv_tipo_franquicia_model= new Descuentospdvtipofranquiciamodel();

		$des_id= $this->request->getPost('des_id');
		$tipo= $this->request->getPost('tipo');
		
		$resultado=[];
		if(!empty($des_id)&&!empty($tipo)){
			$resultado= $descuentos_pdv_tipo_franquicia_model->getDescuentomensualdesid($des_id,$tipo);
		}
		

		return json_encode($resultado);
	}
	
	public function reportedescuentos(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
	        $descuentos_model=new Descuentosmodel();
    		$datos = $this->datosMenu();
            $desde=$this->request->getPost('desde');
            $hasta=$this->request->getPost('hasta');
            $estado=$this->request->getPost('estado');
            
            $desde=$desde.'-01';
            $hasta=date("Y-m-t", strtotime($hasta.'-01')); 
            $datos_descuento=$descuentos_model->getDescuentosFiltro($estado);
            
    		$descuento=array();
    		foreach($datos_descuento as $item)
    		{
    		    $a=0;
    		    if($item['des_frecuencia']=='indefinido'){
    		        $a=2; 
    		        $item['des_fecha_hasta']='';
    		        $item['des_fecha_desde']='';
    		    }else{
        		    if(date("Y-m-t", strtotime($item['des_fecha_hasta']))<=$hasta){
        		        $a=1; 
        		    }
        		    if(date("Y-m-t", strtotime($item['des_fecha_hasta']))>=$desde){
    		            $a++; 
    		        }
    		        if($a==1){
    		            if(date("Y-m-01", strtotime($item['des_fecha_desde']))>=$desde && date("Y-m-01", strtotime($item['des_fecha_desde']))<=$hasta){
        		            $a++; 
        		        }
        		        if($desde>=date("Y-m-01", strtotime($item['des_fecha_desde'])) && $desde<=date("Y-m-01", strtotime($item['des_fecha_hasta']))){
        		            $a++; 
        		        }
    		        }
    		        $item['des_fecha_desde']=date("Y-m", strtotime($item['des_fecha_desde']));
    		        $item['des_fecha_hasta']=date("Y-m", strtotime($item['des_fecha_desde']));
    		        
    		    }
    		    $item['des_fecha_inicio']=date("Y-m", strtotime($item['des_fecha_inicio']));
    		    if($item['des_nombre_franquicias']=='Tipo Franquicia'){
    		        $item['a']='Aplica a todos los pdv';
    		    }
		        if($a>1){
		            $c=array(
		                'des_nombre'=>$item['des_nombre'],
		                'des_fecha_desde'=>$item['des_fecha_desde'],
		                'des_fecha_hasta'=>$item['des_fecha_hasta'],
		                'des_fecha_inicio'=>$item['des_fecha_inicio'],
		                'des_frecuencia'=>$item['des_frecuencia'],
		                'a'=>$item['a'],
		                'des_tipo'=>$item['des_tipo'],
		                'des_valor'=>$item['des_valor'],
		                'des_estado'=>$item['des_estado']);
		          array_push($descuento, $c);
		        }
    		} 
            $enviar_datos=array(
    			'datos_descuento'=>$descuento,
    		);
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("descuentos/reporte",$enviar_datos);
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function filtroreporte(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("descuentos/filtroreporte");
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function filtrodescuentosreporte(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
            $descuentos_model=new Descuentosmodel();
		    $descuentos=$descuentos_model->getDescuentos();
		    $datos_descuentos=array(
    			'datos_descuentos'=>$descuentos,
    		);
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("descuentos/filtrodescuentosreporte",$datos_descuentos);
    		echo view("layouts/footer");
    		echo view("descuentos/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function filtrodescuentosmensualesreporte(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
            $descuentos_model=new Descuentomensualmodel();
		    $descuentos=$descuentos_model->getDescuentomensual();
		    $datos_descuentos=array(
    			'datos_descuentos'=>$descuentos,
    		);
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("descuentos/filtrodescuentosmensualesreporte",$datos_descuentos);
    		echo view("layouts/footer");
    		echo view("descuentos/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function reporteespecifico(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    	    
            $datos_menu = $this->datosMenu();
    		$meses=$this->request->getPost('meses');
    		$descuentos=$this->request->getPost('descuentos'); 
    		$datos_finales=array();
    		$tit=array();
    		array_push($tit,'');
    		$pdv_model=new Puntoventamodel();
        	$pdv1=$pdv_model->getNombrePuntoventaDueno(0); //solo obtiene franquicia
        	if(empty($meses)){
    			$session->setFlashdata('mensaje_malo', 'Seleccione los meses para generar el reporte');
    			return redirect()->to(base_url('descuentos/filtrodescuentosreporte'));
    		}
    		else
    		{
    		    $m=explode(',',$meses);
    		    $m=array_unique($m);
    		    arsort($m);
    		    array_pop($m);
    		    //print_r($m);
    		    $cont_meses=0;
    		    foreach($m as $mes)
        	    {
        	        array_push($tit,$mes);
        	        $cont_meses=$cont_meses+1;
        	    }
    		    foreach($pdv1 as $pdv){
            	    $valor='0.00';
            	    $contador=0;
            	    $valores=array();
            	    array_push($valores,$pdv['puv_punto_venta']);
            	    
        		    foreach($m as $mes)
            	    {
            	        $valor='0.00';
            	        
                		$mes_aux=date("Y-m", strtotime($mes));
                		$mes_inicio=date("Y-m-1", strtotime($mes));
                
                		$comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
                		$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio); 
                		
                		if(!empty($resultado)){
                			$datos_registrados = file_get_contents($resultado[0]['cmf_link']);
                			$datos_registrados = base64_decode($datos_registrados);
                			$datos_registrados = json_decode($datos_registrados,true);
                			$titulos=$datos_registrados['titulos'];
                			$titulos=json_decode($titulos);
                			$id_posconvenio = array_search($descuentos, $titulos);
                			$datos=$datos_registrados['datos'];
                			$datos=json_decode($datos);
                			$id=1;
                			foreach($datos as $d){
                			    if($d->$id==$pdv['puv_punto_venta'])
                			    {
                			        $valor=$d->$id_posconvenio;
                			        $contador++;
                    			}
                			}
                			array_push($valores,$valor);
            		}
            		else{
            		    array_push($valores,'No existen datos guardados');
            		}
    		    }
    		    array_push($datos_finales,$valores);
            		
        		}
        		$datos_menu = $this->datosMenu();
        		$enviar_datos=array(
        		    'titulos'=>$tit,
        		    'datos'=>$datos_finales,
        		    'meses'=>$cont_meses,
        		    'busqueda'=>$descuentos
        		    );
    			echo view("layouts/header");
    			echo view("layouts/aside",$datos_menu);
    			echo view("descuentos/reportemes",$enviar_datos);
    			echo view("layouts/footer");
    			return;
                
    		}
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
	
	public function comprobarExisteDescuento(){
	    $nombreDescuento=$this->request->getPost('nombreDescuento');
		$descuentos_model=new Descuentomensualvalormodel();
		$a=$descuentos_model->buscarDescuentoPorNombre($nombreDescuento);
		if($a=="")
		{
		    return "Descuento: $nombreDescuento no encontrado ";
		}
		else
		{
		    return "no";
		}
	}
}