<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Gestiondocumentalmodel;
class Gestiondocumental extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    		$punto_venta_model=new Puntoventamodel();
            
            
    		$datos_punto_venta = $punto_venta_model->getPuntoventa();
            
    		$enviar_datos=array(
    			'datos_punto_venta'=>$datos_punto_venta,
    			'datos_tipo_franquicia_comisiones'=>$datos_tipo_franquicia_comisiones,
    			'datos_iva_renta_pdv'=>$datos_iva_renta_pdv,
    			'datos_porcentaje_comision'=>$datos_porcentaje_comision,
    		);
    
    		echo view("layouts/header");
    		echo view("layouts/aside", $datos);
    		echo view("gestiondocumental/list",$enviar_datos);
    		echo view("layouts/footer");
    		echo view("gestiondocumental/footer");
    	}
	    else{
	        return redirect()->to(base_url());
	    }
	}
    
    public function agregardocumento(){
		$session = \Config\Services::session();
		$gestion_documental_model= new Gestiondocumentalmodel();
		if(!empty($this->request->getPost('puvid'))){	
			$puv_id=$this->request->getPost('puvid');	
			$mes=$this->request->getPost('mes').'-01';	
			$nombre=$this->request->getPost('nombre');	
			$observacion=$this->request->getPost('observacion');	
			
			$archivo = $_FILES['archivo']['name'];
    	    if ($archivo==!'') {
    	        $imagen=$this->guardarImagen('archivo');
    	        if($imagen==false)
    	        {
    	            $session->setFlashdata('mensaje_malo', 'Existió un problema al guardar la imagen seleccionada');
        		    return redirect()->to(base_url('Gestiondocumental')); 
    	        }
    	    }
							
					
			$datos_gestion_documental=array(
				'puv_id'=>$puv_id,
				'ged_nombre_archivo'=>$nombre,
				'ged_estado'=>1,
				'ged_ruta'=>$archivo,
				'ged_observacion'=>$observacion,
				'ged_mes'=>$mes,
			);
            print_r($datos_gestion_documental);
			$gestion_documental_model->insertar($datos_gestion_documental);	
			$session->setFlashdata('mensaje_bueno', 'Documento ingresado exitosamente');
			return redirect()->to(base_url('Gestiondocumental')); 				
					

			

		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Gestiondocumental')); 
		}
		
	}
	
    public function guardarImagen($nombre)
	{
        //Si se quiere subir una imagen
        
           //Recogemos el archivo enviado por el formulario
           $archivo = $_FILES[$nombre]['name'];
           //Si el archivo contiene algo y es diferente de vacio
           if (isset($archivo) && $archivo != "") {
              //Obtenemos algunos datos necesarios sobre el archivo
              $tipo = $_FILES[$nombre]['type'];
              $tamano = $_FILES[$nombre]['size'];
              $temp = $_FILES[$nombre]['tmp_name'];
              //Se comprueba si el archivo a cargar es correcto observando su extensión y tamaño
             if (!((strpos($tipo, "gif") || strpos($tipo, "jpeg") || strpos($tipo, "jpg") || strpos($tipo, "png") || strpos($tipo, "pdf")) && ($tamano < 2000000))) {
               // echo '<div><b>Error. La extensión o el tamaño de los archivos no es correcta.<br/>
               // - Se permiten archivos .gif, .jpg, .png. y de 200 kb como máximo.</b></div>';
                return false;
             }
             else {
                //Si la imagen es correcta en tamaño y tipo
                //Se intenta subir al servidor
                if (move_uploaded_file($temp, 'public/documentos/'.$archivo)) {
                    //Cambiamos los permisos del archivo a 777 para poder modificarlo posteriormente
                    chmod('public/documentos/'.$archivo, 0777);
                    //Mostramos el mensaje de que se ha subido co éxito
                    //echo '<div><b>Se ha subido correctamente la imagen.</b></div>';
                    //Mostramos la imagen subida
                    //echo '<p><img src="images/'.$archivo.'"></p>';
                    return true;
                }
                else {
                   //Si no se ha podido subir la imagen, mostramos un mensaje de error
                   //echo '<div><b>Ocurrió algún error al subir el fichero. No pudo guardarse.</b></div>';
                  return false;
                }
              }
           }
        
	}	
    
    public function getDocumentosByPDVMes(){
	    $puv_id=$this->request->getPost('puvid');
	    $mes=$this->request->getPost('mes').'-01';
		$gestion_documental_model= new Gestiondocumentalmodel();
		$datos_documento=$gestion_documental_model->getArchivos($mes,$puv_id);
		return json_encode($datos_documento);
	}
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}