<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Ventamodel;
use App\Models\Comisionmesfinalizadomodel;
class Home extends BaseController
{
	public $session = null;
	

	public function __construct()
	{
		$this->session = \Config\Services::session();		
	}

	public function index()
	{
		if($this->session->get('USU_CORREO')==null){
			return redirect()->to(base_url());
		}
        
        $meses_anio=array("January","February","March","April","May","June","July","August","September","October","November","December");
        $ventas_model=new Ventamodel();
        $ventas_anio=$ventas_model->getTotalVentasMes();
        $ventas_mes_pdv=$ventas_model->getTotalVentasMesPDV();
        
        $ventas_anio_mes="";
        $cantidad=0;
        $i=0;
        foreach($meses_anio as $m)
        {
            $cantidad=0;
            foreach($ventas_anio as $c)
            {
                if(trim($c['mes'])==trim($m))
                {
                    $cantidad=$c['valor'];
                    break;
                }
                else
                {
                    $cantidad=0;
                }
            }
            if($i==0)
            {
                $ventas_anio_mes=$cantidad;
                $i++;
            }
            else
            {
                $ventas_anio_mes=$ventas_anio_mes.','.$cantidad;
            }
        }
        
        $enviar_datos=array(
			'rol_id'=>$this->session->get('ROL_ID'),
			'ventas_anio'=>$ventas_anio_mes,
			'ventas_pdv'=>$ventas_mes_pdv
		);
		$session = \Config\Services::session();
		$mes=date("Y-m").'-01';
        $nuevafecha = date("Y-m-d",strtotime($mes."- 2 month"));
		$comisionguardadamodel=new Comisionmesfinalizadomodel();
		$comisionguardada=$comisionguardadamodel->getUnComisionmesfinalizadopormes($nuevafecha);
		if(empty($comisionguardada))
		{
		    $session->setFlashdata('mensaje_malo', 'Le recordamos que aun no guarda el reporte del mes anterior '.$nuevafecha);
		}
		$datos = $this->datosMenu();
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("dashboard",$enviar_datos);
		echo view("layouts/footer"); 
	}
	

	public function datosMenu()
	{
		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($this->session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
	
}
