<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Porcentajecomisionmodel;

class Porcentajecomision extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$porcentaje_comision_model= new Porcentajecomisionmodel();
    		$datos_porcentaje_comision_=$porcentaje_comision_model->getPorcentajecomision();
    
    
    		$enviar_datos=array(
    			'datos_porcentaje_comision_' => !empty($datos_porcentaje_comision_)?$datos_porcentaje_comision_:[] , 
    		);
    
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("porcentajecomision/list",$enviar_datos);
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}

	
	public function add(){
		$session = \Config\Services::session();
		$porcentaje_comision_model= new Porcentajecomisionmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('pcoporcentaje'))){
				$pco_porcentaje=$this->request->getPost('pcoporcentaje');
				$ingresar_datos=array(
					'pco_porcentaje'=>$pco_porcentaje,
					'pco_estado'=>1
				);
				$porcentaje_comision_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Porcentajecomision')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Porcentajecomision')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$porcentaje_comision_model= new Porcentajecomisionmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editpcoporcentaje')) && !empty($this->request->getPost('editpcoid'))){
				$pco_porcentaje=$this->request->getPost('editpcoporcentaje');
				$pco_id=$this->request->getPost('editpcoid');
				$editar_datos=array(
					'pco_porcentaje'=>$pco_porcentaje,
					'pco_estado'=>1
				);
				$porcentaje_comision_model->actualizar($pco_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Porcentajecomision')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Porcentajecomision')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$porcentaje_comision_model= new Porcentajecomisionmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'pco_estado'=>0
				);
				$porcentaje_comision_model->actualizar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Se ha inactivado el registro');
				return redirect()->to(base_url('Porcentajecomision')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Porcentajecomision')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	public function activar($id){		
		
		$session = \Config\Services::session();
		$porcentaje_comision_model= new Porcentajecomisionmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'pco_estado'=>1
				);
				$porcentaje_comision_model->actualizar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Se ha activado el registro');
				return redirect()->to(base_url('Porcentajecomision')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Porcentajecomision')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}