<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Prestamosmodel;
use App\Models\Prestamoamortizacionmodel;
use App\Models\Prestamoamortizaciondetallemodel;
use App\Models\Prestamopendientepagomodel;
use App\Models\Prestamomesgraciamodel;
use App\Models\Prestamoabonocuotamodel;
class Prestamos extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$punto_venta_model= new Puntoventamodel();
    		$prestamos_model= new  Prestamosmodel();
    		$datos_punto_venta=$punto_venta_model->getPuntoventa();
    		$datos_prestamos=$prestamos_model->getPrestamos();
            
    		$enviar_datos=array(
    			'datos_punto_venta' => !empty($datos_punto_venta)?$datos_punto_venta:null , 
    			'datos_prestamos' => !empty($datos_prestamos)?$datos_prestamos:null , 
    		);
    
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("prestamos/list",$enviar_datos);
    		echo view("layouts/footer");
    		echo view("prestamos/footer");
    		echo view("prestamos/excel");
    	}else{
	        return redirect()->to(base_url());
	    }
	}
    public function getTablasAmortizacionByPreId(){
	    $pre_id=$this->request->getPost('pre_id');
		$prestamo_amortizacion_model=new Prestamoamortizacionmodel();
    	$prestamo_amortizacion_detalle_model=new Prestamoamortizaciondetallemodel();
		$tablas_amortizacion=$prestamo_amortizacion_model->getTablasAmortizacionByPreId($pre_id);
		$tablas=array();
		foreach($tablas_amortizacion as $value)
		{
		    $tablas_amortizacion_detalle=$prestamo_amortizacion_detalle_model->getDetalleTablasAmortizacionByPraId($value['pra_id']);
		    $t=array(
		        'pra_id'=>$value['pra_id'],
		        'pra_fecha_carga'=>$value['pra_fecha_carga'],
		        'pre_id'=>$value['pre_id'],
		        'pra_estado'=>$value['pra_estado'],
		        'pra_observacion_cierre'=>$value['pra_observacion_cierre'],
		        'pra_observacion_creacion'=>$value['pra_observacion_creacion'],
		        'detalle'=>$tablas_amortizacion_detalle,
		        );
		    array_push($tablas, $t);
		}
		
		return json_encode($tablas);
	}
	public function getPrestamoById(){
	    $pre_id=$this->request->getPost('pre_id');
		$prestamos_model= new  Prestamosmodel();
		$datos_prestamo=$prestamos_model->getPrestamosById($pre_id);
		return json_encode($datos_prestamo);
	}
	
	public function getPrestamoMesGraciaByPreid(){
	    $pre_id=$this->request->getPost('pre_id');
		$prestamomesgracia_model= new  Prestamomesgraciamodel();
		$datos_prestamo=$prestamomesgracia_model->getMesGraciaByPreid($pre_id);
		return json_encode($datos_prestamo);
	}
	
	public function insertPrestamoMesGracia(){
	    $session = \Config\Services::session();
	    $pre_id=$this->request->getPost('pre_id');
	    $mesano=$this->request->getPost('mesdegracia');
	    $motivo=$this->request->getPost('motivomesdegracia');
	    $fecha=date('Y-m-d');
	    $mes=explode('-',$mesano)[1];
	    $ano=explode('-',$mesano)[0];
		$prestamomesgracia_model= new  Prestamomesgraciamodel();
		$datos_prestamo=array(
            'pre_id'=>$pre_id,
			'meg_mes'=>$mes,
			'meg_ano'=>$ano,
			'meg_motivo'=>$motivo,
			'meg_estado'=>1,
			'meg_fecha_registro'=>$fecha,
		);
		//print_r($datos_prestamo);
		$max_id=$prestamomesgracia_model->insertar($datos_prestamo);
		
		$datos=array(
            'meg_id'=>$max_id[0]['meg_id'],
		);
		$prestamomesgracia_model->registrarMesGraciaTablaAmortizacionDetalle($datos,$max_id[0]['meg_mes'],$max_id[0]['meg_ano'],$pre_id);
		$session->setFlashdata('mensaje_bueno', 'Mes de gracia creado correctamente');
		return redirect()->to(base_url('Prestamos')); 
	}
	
	public function add(){
		$session = \Config\Services::session();



		//if(!empty($this->request->getPost('prestamo')) && !empty($this->request->getPost('puvid')) && !empty($this->request->getPost('valor')) && !empty($this->request->getPost('fechadesde')) && !empty($this->request->getPost('fechahasta')) && !empty($this->request->getPost('auxcuotas')) && !empty($this->request->getPost('valorpagomensual')) ){
			$prestamos_model= new  Prestamosmodel();
			$prestamo_amortizacion_model= new  Prestamoamortizacionmodel();
			$prestamo_amortizacion_detalle_model= new  Prestamoamortizaciondetallemodel();
			$pre_nombre=$this->request->getPost('prestamo');
			$puv_id=$this->request->getPost('puvid');
			$pre_valor=$this->request->getPost('valor');
			$pre_fecha_desde=$this->request->getPost('fechadesde');
			$pre_fecha_hasta=$this->request->getPost('fechahasta');
			$pre_cuotas=$this->request->getPost('cuotas');
			$pre_porcentaje=$this->request->getPost('porcentaje');
			$pre_pago_mensual=$this->request->getPost('valorpagomensual');
			$pre_observacion=$this->request->getPost('observacion');
			$pre_observacion_tabla=$this->request->getPost('observacionamortizacion');
			$pre_detalle_amortizacion=$this->request->getPost('detalleamortizacion');
            $fecha_actual = date("Y-m-d h:i:s");
			$pre_estado=1;

			$pre_tipo=$this->request->getPost('opcionestipo');
            $amortizacion=json_decode($pre_detalle_amortizacion, true); //print_r($amortizacion);
            //print_r($amortizacion);
            
			$datos_prestamo=array(

				'pre_nombre'=>$pre_nombre,
				'puv_id'=>$puv_id,
				'pre_valor'=>$pre_valor,
				'pre_fecha_desde'=>$pre_fecha_desde,
				'pre_fecha_hasta'=>$pre_fecha_hasta,
				'pre_cuotas'=>$pre_cuotas,
				'pre_porcentaje'=>$pre_porcentaje,
				'pre_estado'=>1,
				'pre_tipo'=>$pre_tipo,
				'pre_pago_mensual'=>$pre_pago_mensual,
				'pre_observacion'=>$pre_observacion,
			);
			//print_r($datos_prestamo);
			
			$pre_id=$prestamos_model->insertar($datos_prestamo);
			
			$datos_prestamo_amortizacion=array(
                'pre_id'=>$pre_id[0]['pre_id'],
				'pra_fecha_carga'=>$fecha_actual,
				'pra_estado'=>1,
				'pra_observacion_creacion'=>$pre_observacion_tabla,
				'pra_valor'=>$pre_valor,
				'pra_tipo'=>$pre_tipo,
			);
			//print_r($datos_prestamo_amortizacion);
			$pra_id=$prestamo_amortizacion_model->insertar($datos_prestamo_amortizacion);
			
			foreach($amortizacion as $item)
            {
                for($i=0;$i<count($item);$i++){
                    $datos_prestamo_amortizacion_detalle=array(
                    'pra_id'=>$pra_id[0]['pra_id'],
    				'prd_mes_estimado'=>$item[$i]['0'],
    				'prd_ano_estimado'=>$item[$i][1],
    				'prd_numero_cuota'=>$item[$i][2],
    				'prd_valor_capital'=>floatval($item[$i][3]),
    				'prd_valor_interes'=>floatval($item[$i][4]),
    				'prd_cuota_total'=>floatval($item[$i][5]),
    			);
    			//print_r($item);
    			//print_r($datos_prestamo_amortizacion_detalle);
    			$prestamo_amortizacion_detalle_model->insertar($datos_prestamo_amortizacion_detalle);
                }
            }
            
			
			
			$session->setFlashdata('mensaje_bueno', 'Nuevo préstamo creado correctamente');
			return redirect()->to(base_url('Prestamos')); 

		/*}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Prestamos')); 
		}*/
		


	}
	
	public function refinanciar(){
		$session = \Config\Services::session();
        if( !empty($this->request->getPost('refpreid')) && !empty($this->request->getPost('refprestamo')) && !empty($this->request->getPost('refpuvid')) && !empty($this->request->getPost('refvalor'))  && !empty($this->request->getPost('reffechadesde')) && !empty($this->request->getPost('reffechahasta')) && !empty($this->request->getPost('reftipo')) ){
			$prestamos_model= new  Prestamosmodel();
			$prestamo_amortizacion_model= new  Prestamoamortizacionmodel();
			$prestamo_amortizacion_detalle_model= new  Prestamoamortizaciondetallemodel();
			$pre_id=$this->request->getPost('refpreid');
			$pre_nombre=$this->request->getPost('refprestamo');
			$puv_id=$this->request->getPost('refpuvid');
			$pre_pago_mensual=$this->request->getPost('refpagomensual');
			$pre_porcentaje=$this->request->getPost('refporcentaje');
			$pre_fecha_desde=$this->request->getPost('reffechadesde');
			$pre_fecha_hasta=$this->request->getPost('reffechahasta');
			$pre_tipo=$this->request->getPost('reftipo');
			$pre_valor=$this->request->getPost('refvalor');
            $pre_observacion_tabla=$this->request->getPost('refobservacionamortizacion');
			$pre_detalle_amortizacion=$this->request->getPost('refdetalleamortizacion');
            $amortizacion=json_decode($pre_detalle_amortizacion, true);
            $fecha_actual = date("Y-m-d h:i:s");
            $observacion_cierre=$this->request->getPost('refobservacionamortizacioncierre');
            
			if($pre_tipo=='Con Intereses'){
				if(empty($this->request->getPost('refporcentaje'))){
					$session->setFlashdata('mensaje_malo', 'Ingrese porcentaje');
					return redirect()->to(base_url('Prestamos')); 
				}
				$pre_porcentaje=$this->request->getPost('refporcentaje');
			}else{
				$pre_porcentaje=0;
			}
			$pre_cuotas=$this->obtenercuotas($pre_fecha_desde,$pre_fecha_hasta);
			$datos_prestamo=array(

				'pre_nombre'=>$pre_nombre,
				'puv_id'=>$puv_id,
				'pre_valor'=>$pre_valor,
				'pre_fecha_desde'=>$pre_fecha_desde,
				'pre_fecha_hasta'=>$pre_fecha_hasta,
				'pre_cuotas'=>$pre_cuotas,
				'pre_porcentaje'=>$pre_porcentaje,
				'pre_pago_mensual'=>$pre_pago_mensual,
				'pre_estado'=>1,
				'pre_tipo'=>$pre_tipo,
			);
			$prestamos_model->actualizar($pre_id,$datos_prestamo);
			
			$datos_prestamo_amortizacion=array(
				'pra_estado'=>2,
				'pra_observacion_cierre'=>$observacion_cierre
			);
			$prestamo_amortizacion_model->refinanciar($pre_id,$datos_prestamo_amortizacion);
			
			$datos_prestamo_amortizacion=array(
                'pre_id'=>$pre_id,
				'pra_fecha_carga'=>$fecha_actual,
				'pra_estado'=>1,
				'pra_observacion_creacion'=>$pre_observacion_tabla,
				'pra_valor'=>$pre_valor,
				'pra_tipo'=>$pre_tipo,
			);
			//print_r($datos_prestamo_amortizacion);
			$pra_id=$prestamo_amortizacion_model->insertar($datos_prestamo_amortizacion);
			
			foreach($amortizacion as $item)
            {
                for($i=0;$i<count($item);$i++){
                    $datos_prestamo_amortizacion_detalle=array(
                    'pra_id'=>$pra_id[0]['pra_id'],
    				'prd_mes_estimado'=>$item[$i]['0'],
    				'prd_ano_estimado'=>$item[$i][1],
    				'prd_numero_cuota'=>$item[$i][2],
    				'prd_valor_capital'=>floatval($item[$i][3]),
    				'prd_valor_interes'=>floatval($item[$i][4]),
    				'prd_cuota_total'=>floatval($item[$i][5]),
    			);
    			//print_r($item);
    			print_r($datos_prestamo_amortizacion_detalle);
    			$prestamo_amortizacion_detalle_model->insertar($datos_prestamo_amortizacion_detalle);
                }
            }
            
			//$session->setFlashdata('mensaje_bueno', 'Préstamo refinanciado correctamente');
			//return redirect()->to(base_url('Prestamos')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Prestamos')); 
		}
		


	}
	
	public function edit(){
		$session = \Config\Services::session();

		if( !empty($this->request->getPost('editpreid')) && !empty($this->request->getPost('editprestamo')) && !empty($this->request->getPost('editpuvid')) && !empty($this->request->getPost('editvalor'))  && !empty($this->request->getPost('editfechadesde')) && !empty($this->request->getPost('editfechahasta')) && !empty($this->request->getPost('edittipo')) ){
			$prestamos_model= new  Prestamosmodel();
			$pre_id=$this->request->getPost('editpreid');
			$pre_nombre=$this->request->getPost('editprestamo');
			$puv_id=$this->request->getPost('editpuvid');
			$pre_pago_mensual=$this->request->getPost('editpagomensual');
			$pre_porcentaje=$this->request->getPost('editporcentaje');
			$pre_fecha_desde=$this->request->getPost('editfechadesde');
			$pre_fecha_hasta=$this->request->getPost('editfechahasta');
			$pre_tipo=$this->request->getPost('edittipo');
			$pre_valor=$this->request->getPost('editvalor');
			$pre_observacion=$this->request->getPost('editobservacion');


			if($pre_tipo=='Con Intereses'){
				if(empty($this->request->getPost('editporcentaje'))){
					$session->setFlashdata('mensaje_malo', 'Ingrese porcentaje');
					return redirect()->to(base_url('Prestamos')); 
				}
				$pre_porcentaje=$this->request->getPost('editporcentaje');
			}else{
				$pre_porcentaje=0;
			}
			$pre_cuotas=$this->obtenercuotas($pre_fecha_desde,$pre_fecha_hasta);
			$datos_prestamo=array(

				'pre_nombre'=>$pre_nombre,
				'puv_id'=>$puv_id,
				'pre_valor'=>$pre_valor,
				'pre_fecha_desde'=>$pre_fecha_desde,
				'pre_fecha_hasta'=>$pre_fecha_hasta,
				'pre_cuotas'=>$pre_cuotas,
				'pre_porcentaje'=>$pre_porcentaje,
				'pre_pago_mensual'=>$pre_pago_mensual,
				'pre_estado'=>1,
				'pre_tipo'=>$pre_tipo,
				'pre_observacion'=>$pre_observacion,
			);
			//print_r($datos_prestamo);
			$prestamos_model->actualizar($pre_id,$datos_prestamo);
			$session->setFlashdata('mensaje_bueno', 'Datos Editado');
			return redirect()->to(base_url('Prestamos')); 

		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Prestamos')); 
		}
		


	}
	
	public function getAmortizacionActiva(){
	    $pre_id=$this->request->getPost('pre_id');
		$prestamoamortizaciondetalle_model= new  Prestamoamortizaciondetallemodel();
		$datos_prestamo=$prestamoamortizaciondetalle_model->getTablaAmortizacionActivaByIdPrestamo($pre_id);
		return json_encode($datos_prestamo);
	}
	
	public function eliminar($pre_id){
		$session = \Config\Services::session();
		if( !empty($pre_id)){
			$prestamos_model= new  Prestamosmodel();
			$datos_prestamo=array(
                'pre_estado'=>0,
			);
			$prestamos_model->actualizar($pre_id,$datos_prestamo);
			$session->setFlashdata('mensaje_bueno', 'Se ha inactivado el préstamo');
			return redirect()->to(base_url('Prestamos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Prestamos')); 
		}	
	}
    public function activar($pre_id){
		$session = \Config\Services::session();
		if( !empty($pre_id)){
			$prestamos_model= new  Prestamosmodel();
			$datos_prestamo=array(
                'pre_estado'=>1,
			);
			$prestamos_model->actualizar($pre_id,$datos_prestamo);
			$session->setFlashdata('mensaje_bueno', 'Se ha activado el préstamo');
			return redirect()->to(base_url('Prestamos')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Prestamos')); 
		}	
	}
	public function leerprestamo(){
		$datos = $this->datosMenu();		
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("prestamos/leerprestamo");
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		

		
		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('PRESTAMOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "PRESTAMOS"');
				return redirect()->to(base_url('Prestamos/leerprestamo'));
			}    

			$data=[];

			$pdv_no_encontrados='';
			
			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{

					
					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
					$pre_nombre = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();

					$pre_valor= $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
					if(!is_numeric($pre_valor)){
						$pre_valor=0;
					}

					$pre_fecha_desde= $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
					if(!empty($pre_fecha_desde)){
						$pre_fecha_desde = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($pre_fecha_desde);           
						$pre_fecha_desde =$pre_fecha_desde->format('Y-m-d');
					}


					$pre_fecha_hasta= $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
					if(!empty($pre_fecha_hasta)){
						$pre_fecha_hasta = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($pre_fecha_hasta);           
						$pre_fecha_hasta =$pre_fecha_hasta->format('Y-m-d');
					}


					$pre_tipo = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();



					$pre_pago_mensual = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
					if(!is_numeric($pre_pago_mensual)){
						$pre_pago_mensual=0;
					}

					if($pre_tipo=='Con Intereses'||$pre_tipo=='Sin Intereses'){
						if($pre_tipo=='Con intereses'){
							$pre_porcentaje = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
							if(!is_numeric($pre_porcentaje)){
								$pre_porcentaje=0;
							}
						}else{
							$pre_porcentaje=0;
						}
					}else{
						$pre_tipo='';
					}
					$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($pre_nombre!=''  && $pre_fecha_desde!='' && $pre_fecha_hasta!=''  && $pre_fecha_desde<=$pre_fecha_hasta && $pre_tipo!='' && $puv_id!=0){
						$pre_cuotas=$this->obtenercuotas($pre_fecha_desde,$pre_fecha_hasta);
						$data[]=array(
							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'pre_nombre'=>$pre_nombre,
							'pre_valor'=>$pre_valor,
							'pre_fecha_desde'=>$pre_fecha_desde,
							'pre_fecha_hasta'=>$pre_fecha_hasta,
							'pre_cuotas'=>$pre_cuotas,
							'pre_porcentaje'=>$pre_porcentaje,
							'pre_tipo'=>$pre_tipo,
							'pre_pago_mensual'=>$pre_pago_mensual,
						);
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados." ".$row.",";
					}

				}
				break;

			}
			$datos = $this->datosMenu();
			
			$enviar_datos=array(        
				'mensaje'=>$pdv_no_encontrados,
				'data'=>$data,
			);

			

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("prestamos/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos')) ){
			$prestamos_model= new  Prestamosmodel();
			$datos =$this->request->getPost('datos');		
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			

			foreach ($datos as $value) {

				$datos_prestamo=array(

					'pre_nombre'=>$value['pre_nombre'],
					'puv_id'=>$value['puv_id'],
					'pre_valor'=>$value['pre_valor'],
					'pre_fecha_desde'=>$value['pre_fecha_desde'],
					'pre_fecha_hasta'=>$value['pre_fecha_hasta'],
					'pre_cuotas'=>$value['pre_cuotas'],
					'pre_porcentaje'=>$value['pre_porcentaje'],
					'pre_tipo'=>$value['pre_tipo'],
					'pre_pago_mensual'=>$value['pre_pago_mensual'],
					'pre_estado'=>1,

				);				
				$prestamos_model->insertar($datos_prestamo);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
		}

	}
	

	public function obtenercuotas($desde,$hasta)
	{
		$desde=date('Y-m',strtotime($desde));
		$hasta=date('Y-m',strtotime($hasta));
		$cuotas=0;

		while($desde<$hasta){
			
			$desde=date("Y-m",strtotime($desde."+ 1 month")); 
			$cuotas=$cuotas+1;
		}

		return $cuotas;
	}
	public function sumarmesesaunafecha()
	{		
		$fecha=$this->request->getPost('fecha');
		$mesessumar=$this->request->getPost('numero');
		$dia=date("d",strtotime($fecha));
		if($dia>=29){
			$fecha=date("Y-m-28",strtotime($fecha));
		}

		$inicio=1;
		while($inicio<=$mesessumar){
			
			$fecha=date("Y-m-d",strtotime($fecha."+ 1 month")); 
			$inicio=$inicio+1;
		}
		return json_encode();
	}
    
    public function pagarCuota()
	{
	    $session = \Config\Services::session();
	    $prd_id=$this->request->getPost('prd_id');	
	    $pre_id=$this->request->getPost('pres_id');
	    $pra_id=$this->request->getPost('pra_id');
	    $observacion=$this->request->getPost('observacion');
	    $saldo=$this->request->getPost('saldo');
	    $abono=$this->request->getPost('abono');
	    $valor=$this->request->getPost('valorpagocuota');
	    $puvid=$this->request->getPost('puv_id');
	    $abonos=$abono+$valor;
	    $saldo=$saldo-$abonos;
	    $prestamo_amortizacion_detalle_model=new Prestamoamortizaciondetallemodel();
	    $prestamo_abono_cuota_model=new Prestamoabonocuotamodel();
	    $prestamo_pago_pendiente_model=new Prestamopendientepagomodel();
	    $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($prd_id);
	    $mesActual = date('m');
        $anoActual = date('Y');
	    $prestamo_abono_cuota_model->insertAbonoCuotaManual($pre_id,$pra_id,$prd_id,$mesActual,$anoActual,$valor,$saldo,$observacion,'M');
	    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
	        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
	            $prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($prd_id,'Pago parcial $ '.$abonos.' / saldo $'.$saldo, $valpendiente['ppp_transaccion'], $puvid,3);
	        }
	    }
	    if($saldo==0){
	        //$prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],$numero_mes,$numero_ano,$abonos,$saldo,1);
		    $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']);
		    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
		        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
		            $prestamo_pago_pendiente_model->pagarCuotaPendiente($valpendiente['ppp_id'],$numero_mes,$numero_ano);
		        }
		    }
		    
	    }
	    else{
	        //$prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],null,null,$abonos,$saldo,2);
	        $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']); 
		    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
		        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){//echo 'Hace update';
		            $prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($prd_id,'Pago parcial $ '.$abonos.' / saldo $'.$saldo, $valpendiente['ppp_transaccion'], $puvid,3);
		        }
		    }
		    else
		    {   $prestamo_pago_pendiente_model->insertCuotaPendiente($pre_id,$pra_id,$prd_id,'Pago parcial $ '.$abonos.' / saldo $'.$saldo, 0, $puvid,3);
		        
		    }
	    }
	    $res=$prestamo_amortizacion_detalle_model->insertAbonoCuota($prd_id,null,null,$abonos,$saldo,0);
	    if($res==1)
	    {
	        $session->setFlashdata('mensaje_bueno', 'La cuota ha sido pagada manualmente con éxito');
			return redirect()->to(base_url('Prestamos')); 
	    }
	    else{
	        $session->setFlashdata('mensaje_malo', 'No se ha podido registrar el pago');
			return redirect()->to(base_url('Prestamos/leerprestamo')); 
	    }
	    
	}
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}