<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Basecomisionesmodel;
use App\Models\Conveniomodel;
use App\Models\Comisionmodel;
use App\Models\Convenioporcentajemodel;
use App\Models\Descuentosmodel;
use App\Models\Prestamosmodel;
use App\Models\Prestamoamortizaciondetallemodel;
use App\Models\Prestamopendientepagomodel;
use App\Models\Prestamomesgraciamodel;
use App\Models\Puntoventamodel;
use App\Models\Ventamodel;
use App\Models\Postconveniomodel;
use App\Models\Postconveniovalormodel;
use App\Models\Descuentomensualmodel;
use App\Models\Descuentomensualvalormodel;
use App\Models\Descuentospdvtipofranquiciamodel;
use App\Models\Documentoenviadomodel;
use App\Models\Comisionmesfinalizadomodel;
use App\Models\Descuentopendientepagomodel;
use App\Models\Prestamoabonocuotamodel;
use App\Models\Comisionmodelfinal;
use App\Models\Sobregirosmodel;

class Reporte extends BaseController
{

	public function index(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("reporte/fechareportegeneral");
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	public function fechareportecomparacion(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("reporte/fechareportecomparacion");
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	public function reportegeneral(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    	    if(empty($this->request->getPost('mes'))){
    			$session->setFlashdata('mensaje_malo', 'Ingrese Mes');
    			return redirect()->to(base_url('Reporte'));
    		}
    		$mes=$this->request->getPost('mes').'-01';
	        $nuevafecha = date("Y-m-d",strtotime($mes."- 1 month"));
    		$comisionguardadamodel=new Comisionmesfinalizadomodel();
    		$comisionguardada=$comisionguardadamodel->getUnComisionmesfinalizadopormes($nuevafecha);
    		if(empty($comisionguardada))
    		{
    		    $session->setFlashdata('mensaje_malo', 'Aun no guarda el reporte del mes anterior '.$nuevafecha.', imposible generar el reporte solicitado');
    			return redirect()->to(base_url('Reporte'));
    		}
            $datos_menu = $this->datosMenu();
    		$mes=$this->request->getPost('mes');
    		$tipo=$this->request->getPost('tipo');
    		$mes_aux=date("Y-m", strtotime($mes));
    		$mes_inicio=date("Y-m-1", strtotime($mes));
    
    		$comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
    		$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
    		if(!empty($resultado)){
    			$datos_registrados = file_get_contents($resultado[0]['cmf_link']);
    			$datos_registrados = base64_decode($datos_registrados);
    			$datos_registrados = json_decode($datos_registrados,true);
    			$titulos=$datos_registrados['titulos'];
    			$datos=$datos_registrados['datos'];
    			$imprimir_datos_csv=json_decode($datos_registrados['imprimir_datos_csv'],true);	
    			$enviar_datos=array(
    				'titulos'=>$titulos,
    				'datos'=>$datos,
    				'imprimir_datos_csv'=>$imprimir_datos_csv,
    				'mes'=>$mes_aux,
    				'finalizado'=>true,
    				'tipo'=>$tipo
    			);		
    			$datos_menu = $this->datosMenu();
    			echo view("layouts/header");
    			echo view("layouts/aside",$datos_menu);
    			echo view("reporte/list",$enviar_datos);
    			echo view("layouts/footer");
    			return;
    		}
    
            $enviar_datos=$this->obtenerReporteGeneralMes($mes,'fechareportegeneral',$tipo);
            if($enviar_datos=='no')
            {
                return redirect()->to(base_url('Reporte')); 
            }
    	    echo view("layouts/header");
    		echo view("layouts/aside",$datos_menu);
    		echo view("reporte/list",$enviar_datos);
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function obtenercuotas($desde,$hasta)
	{
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$desde=date('Y-m',strtotime($desde));
    		$hasta=date('Y-m',strtotime($hasta));
    		$cuotas=0;
    
    		while($desde<$hasta){
    			
    			$desde=date("Y-m",strtotime($desde."+ 1 month")); 
    			$cuotas=$cuotas+1;
    		}
    
    		return $cuotas;
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}

	public function fechasreporteventa(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos_menu = $this->datosMenu();		
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos_menu);
    		echo view("reporte/fechareporteventa");
		    echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}

	public function tabla()
	{
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$punto_venta_model =new Puntoventamodel();
    		$nombre_archivo=null;
    		$mes='';
    		if(!empty($this->request->getPost('mes'))){
    			$mes= $this->request->getPost('mes');
    		}
    
    		
    
    		if(!empty($_FILES["archivoseleccionado"]["name"])){
    			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
    		}   
    		if($nombre_archivo!=null ){            
    
    			$path = $_FILES["archivoseleccionado"]["tmp_name"];
    			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    			$reader->setReadDataOnly(true);
    			$spreadsheet = $reader->load($path);
    			$sheet = $spreadsheet->getSheetByName('Hoja1');        
    
    			if(empty($sheet)){
    				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "Hoja1"');
    				return redirect()->to(base_url('Reporte/fechareporteventa'));
    			}    
    
    			$data=[];
    
    			$pdv_no_encontrados='';
    
    			foreach ($sheet->getRowIterator() as $row) {
    				$cellIterator = $row->getCellIterator();
    				$cellIterator->setIterateOnlyExistingCells(false); 
    				$highestRow = $sheet->getHighestDataRow();               
    
    				$highestColumn = $sheet->getHighestDataColumn();            
    				for($row=5; $row<=$highestRow; $row++)				
    				{
    
    					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
    					$fechacontable = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
    					if($pdv=='(en blanco)' && $fechacontable=='(en blanco)'){
    						break;
    					}
    					
    					if(!empty($fechacontable) && $fechacontable!='(en blanco)'){
    						$fechacontable = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fechacontable);  
    						$fechacontable =$fechacontable->format('Y-m-d');						
    
    						$sum_ventas_netas = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
    						$sum_iva = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
    						$sum_total = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();	
    						$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
    						$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;
    
    						if($puv_id!=0){						
    							$data[]=array(						
    								'puv_id'=>$puv_id,
    								'pdv'=>$pdv,
    								'fechacontable'=>$fechacontable,
    								'sum_ventas_netas'=>$sum_ventas_netas,
    								'sum_iva'=>$sum_iva,
    								'sum_total'=>$sum_total,													
    							);
    						}else{
    							$pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
    						}
    					}else{
    						$sum_ventas_netas = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
    						$sum_iva = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
    						$sum_total = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();						
    						$puv_id=$data[sizeof($data)-1]['puv_id'];						
    						$data[]=array(						
    
    							'puv_id'=>$puv_id,
    							'pdv'=>$pdv,
    							'fechacontable'=>$fechacontable,
    							'sum_ventas_netas'=>$sum_ventas_netas,
    							'sum_iva'=>$sum_iva,
    							'sum_total'=>$sum_total,													
    						);
    					}
    
    				}
    				break;
    			}			
    			
    			$datos = $this->datosMenu();
    			$enviar_datos=array(            
    				'data'=>$data,
    				'mensaje'=>$pdv_no_encontrados,
    				'mes'=>$mes,
    			);
    
    			echo view("layouts/header");
    			echo view("layouts/aside",$datos);
    			echo view("reporte/tabla",$enviar_datos);
    			echo view("layouts/footer");
    		}else{
    			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
    			return redirect()->to(base_url('Formatocarga')); 
    		}
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	public function finalizar (){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		if(!empty($this->request->getPost('datos')) && !empty($this->request->getPost('mes'))){
    			$venta_model=new Ventamodel();
    			$datos =$this->request->getPost('datos');
    			$mes =$this->request->getPost('mes');			           
    			//echo '<pre>'; print_r($mes); echo '</pre>';
    			$datos=base64_decode($datos);
    			$datos=json_decode($datos,true);	
    
    			foreach ($datos as $value) {
    				if(empty($value['fechacontable'])){
    					$value['fechacontable']='0000-00-00';
    				}
    				$datos_venta=array(				
    					'puv_id'=>$value['puv_id'],
    					'puv_punto_venta_nombre'=>$value['pdv'],
    					'ven_fecha_contable'=>$value['fechacontable'],
    					'ven_venta_neta'=>$value['sum_ventas_netas'],
    					'ven_iva'=>$value['sum_iva'],
    					'ven_total'=>$value['sum_total'],
    					'ven_mes'=>$mes,
    				);				
    				$venta_model->insertar($datos_venta);
    			}		
    			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
    			return redirect()->to(base_url('Reporte/fechasreporteventa')); 
    		}else{
    			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
    			return redirect()->to(base_url('Reporte/fechasreporteventa')); 
    		}
        }
        else{
	        return redirect()->to(base_url());
	    }
	}

	public function fechareportepdv(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
		$datos_menu = $this->datosMenu();	
		$punto_venta_model= new Puntoventamodel();	

		$datos_punto_venta=$punto_venta_model->getPuntoventa();

		$datos_enviar=array(
			'datos_punto_venta'=>$datos_punto_venta,
		);

		echo view("layouts/header");
		echo view("layouts/aside",$datos_menu);
		echo view("reporte/fechareportepdv",$datos_enviar);
		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}

    public function reportepdv(){
		$datos_menu = $this->datosMenu();	
		$session = \Config\Services::session();
		$puv_id=0;
	    if($session->get('USU_ID')!=''){
	        
    		if(!empty($this->request->getPost('mes'))&&!empty($this->request->getPost('puvid'))){ 
    		    $mes=$this->request->getPost('mes').'-01';
    	        $nuevafecha = date("Y-m-d",strtotime($mes."- 1 month"));
        		$comisionguardadamodel=new Comisionmesfinalizadomodel();
        		$comisionguardada=$comisionguardadamodel->getUnComisionmesfinalizadopormes($nuevafecha);
        		if(empty($comisionguardada))
        		{
        		    $session->setFlashdata('mensaje_malo', 'Aun no guarda el reporte del mes anterior '.$nuevafecha.', imposible generar el reporte solicitado');
        			return redirect()->to(base_url('Reporte/fechareportepdv'));
        		}
    			$mes=$this->request->getPost('mes');
    			$puv_id=$this->request->getPost('puvid');
    			$mes_inicio=$mes.'-01';
    			$mes_fin=date("Y-m-t", strtotime($mes . "-01"));
    			
    			$comision_mes_finalizado_model=new Comisionmesfinalizadomodel();
    			$cierre_mes=$comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
    			//print_r($cierre_mes);die();
    			if(!empty($cierre_mes)){
        			$documento=new Documentoenviadomodel();
        			$pdf=$documento->getDocumentoenviado($mes_inicio,$puv_id);
        			
        			if(!empty($pdf)){
            			foreach($pdf as $p)
            			{
            			    return redirect()->to($p['doe_link']); 
            			}
        			}else{
        			    $session->setFlashdata('mensaje_malo', 'No se ha guardado el pdf del mes anterior');
        			    return redirect()->to(base_url('Reporte/fechareportepdv'));
        			}
    			}
    			
    			$post_convenio_valor_model=new Postconveniovalormodel();
    			$venta_model=new Ventamodel();
    			$comision_model=new Comisionmodel();
                $descuento_mensual_model=new Descuentomensualmodel();
    			$descuento_mensual_valor_model=new Descuentomensualvalormodel();
    			$descuento_pdv_tipo_franquicia_model=new Descuentospdvtipofranquiciamodel();
    			$punto_venta=new Puntoventamodel();
    			$descuento_pago_pendiente_model= new Descuentopendientepagomodel();
    			$comisionModel = new Comisionmodelfinal();
    			$sobregiroModel = new Sobregirosmodel();
    			
    
    			$auxmes=date('Y-m-d',strtotime($mes));		
    			$mes_aux=date("Y-m", strtotime($mes));
                $base_comisiones_model= new Basecomisionesmodel();
                
                $pdv_info=$punto_venta->getPuntoventasegunId($puv_id);
                
                
                $resultado_venta_model=$comisionModel->ventasDiariasPDV($mes_aux,$pdv_info[0]['puv_punto_venta']);
    			$observacion=$punto_venta->getObservacionReporteMensualPDV($mes_inicio,$puv_id);
    			$prestamo_abono_cuota_model=new Prestamoabonocuotamodel();
    
    			if(empty($resultado_venta_model)){
    				$session->setFlashdata('mensaje_malo', 'No hay datos de venta');
    				return redirect()->to(base_url('Reporte/fechareportepdv')); 
    			}
    			
                
                

                // Obtener las comisiones del mes
                $resultado_comisiones = $comisionModel->calcularComisionesPorMesPDV($mes_aux,$pdv_info[0]['puv_punto_venta']);
                $resultado_nota_credito = $comisionModel->calcularNotasCreditoPorMesPDV($mes_aux,$pdv_info[0]['puv_punto_venta']); 
                $resultado_base_comisiones = [];
                foreach ($resultado_comisiones as $item1) {
                    $itemPushed = false; // Para rastrear si se hizo un push del item combinado
                
                    if (!empty($resultado_nota_credito)) {
                        foreach ($resultado_nota_credito as $item2) {
                            if (
                                isset($item1['trc_nombre_almacen'], $item2['ncc_nombre_almacen']) &&
                                $item1['trc_nombre_almacen'] === $item2['ncc_nombre_almacen']
                            ) {
                                // Unir los dos arrays con los datos coincidentes
                                $mergedItem = array_merge($item1, $item2);
                                array_push($resultado_base_comisiones, $mergedItem);
                                $itemPushed = true; // Marcar que se hizo push de este item combinado
                            }
                        }
                    }
                
                    // Si no hubo coincidencias o $resultado_nota_credito está vacío, agregar $item1
                    if (!$itemPushed) {
                        array_push($resultado_base_comisiones, $item1);
                    }
                }

    			
    			//echo $puv_id.'  '.$auxmes;
    
    			if(empty($resultado_base_comisiones)){
    				$session->setFlashdata('mensaje_malo', 'No hay datos de base comisiones');
    				//return redirect()->to(base_url('Reporte/fechareportepdv'));
    			}
    
    			$convenio_model=new Conveniomodel();
    			$convenio_porcentaje_model=new Convenioporcentajemodel();
    
    			//$resultado_convenio=$convenio_model->getConveniopormes($mes);
    			$resultado_convenio=$convenio_model->getConveniodesdehasta($mes_inicio,$mes_fin);
    			
    			$datos_convenio_porentaje_puvid=[];
    			foreach ($resultado_convenio as $value) {
    				$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($puv_id,$value['cov_id'],$mes_inicio);
    				
    				if(!empty($resultado_convenio_porcentaje[0])){
    					$datos_convenio_porentaje_puvid[]=array(
    						'cov_nombre'=>$value['cov_nombre'],
    						'cov_porcentaje'=>$value['cov_porcentaje'],
    						'cop_valor_vendido'=>$resultado_convenio_porcentaje[0]['cop_valor_vendido'],
    						'cop_porciento'=>$resultado_convenio_porcentaje[0]['cop_porciento'],
    					);
    				}
    			}
    			
    			$datos_comision=[];
    			
    			$ferreteria=0;
    			$pesado=0;
    			foreach ($resultado_convenio as $value) {
    				$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($pdv_info[0]['puv_id'],$value['cov_id'],$mes_inicio);
    				$valor_convenio=0;
    				if(!empty($resultado_convenio_porcentaje[0]['cop_valor_vendido'])){
    					$valor_convenio=$resultado_convenio_porcentaje[0]['cop_valor_vendido'];
    					if($value['cov_tipo']==1)
    					{
    				        $ferreteria=$ferreteria-$valor_convenio;
    					}
    					else
    					{
    					    $pesado=$pesado-$valor_convenio;
    					}
    				}					
    				
    			}
    			
    			
    			$ferreteria=number_format($ferreteria, 2, '.', '');
    			$pesado=number_format($pesado, 2, '.', '');
    			
    			$malCobro = $comisionModel->sinCotizacionMenorPrecio($mes,$pdv_info[0]['puv_punto_venta']);//valores que se cobraron menos que el precio base pero no tienen cotizacion
    			//echo '<pre';print_r($malCobro);die();
    			$cotizaciones = $comisionModel->cotizacionesPDV($mes,$pdv_info[0]['puv_punto_venta']);
                //sumamos los valores que se cobraron mal uy no teien comisiones
                if (is_array($cotizaciones) && !empty($cotizaciones)) {
                    foreach ($cotizaciones as $m) {
                        // Verifica si $m tiene la clave 'total_transacciones_dia'
                        if (is_array($m) && isset($m['trc_nombre_almacen'])) {
                            $resultado_base_comisiones[0]['comision_cotizacion_ferreteria'] += (float) $m['total_comision_cotizacion_ferreteria'];
                            $resultado_base_comisiones[0]['comision_cotizacion_pesado'] += (float) $m['total_comision_cotizacion_pesado'];
                        } else {
                            log_message('error', 'Estructura inesperada en $malCobro.');
                        }
                    }
                } else{
                    $resultado_base_comisiones[0]['comision_cotizacion_ferreteria'] = 0;
                    $resultado_base_comisiones[0]['comision_cotizacion_pesado'] = 0;
                }
    			//ferreteria
    			$datos_comision[]=array(						
    				'Rubros'=>'<b>Ventas Ferretería</b>',
    				'%Comision'=>'',
    				'Valor'=>'',
    				'Comision'=>'',
    			);
    			$resultado_base_comisiones[0]['valor_ferreteria_precio_mayor']=$resultado_base_comisiones[0]['valor_ferreteria_precio_mayor']-$resultado_base_comisiones[0]['nc_valor_ferreteria_precio_mayor'];
    			if (is_array($malCobro) && !empty($malCobro)) {
                foreach ($malCobro as $m) {
                    // Verifica si $m tiene la clave 'total_transacciones_dia'
                    if (is_array($m) && isset($m['total_transacciones_dia'])) {
    			    $resultado_base_comisiones[0]['valor_ferreteria_precio_mayor']=$resultado_base_comisiones[0]['valor_ferreteria_precio_mayor']+$m['total_transacciones_dia'];
    			}}}
    			$resultado_base_comisiones[0]['comision_ferreteria_precio_mayor']=$resultado_base_comisiones[0]['comision_ferreteria_precio_mayor']-$resultado_base_comisiones[0]['nc_comision_ferreteria_precio_mayor'];
    			$datos_comision[]=array(						
    				'Rubros'=>'Mayor al precio base',
    				'%Comision'=>'80%',
    				'Valor'=>$resultado_base_comisiones[0]['valor_ferreteria_precio_mayor'],
    				'Comision'=>$resultado_base_comisiones[0]['comision_ferreteria_precio_mayor'],
    			);
    			$resultado_base_comisiones[0]['valor_ferreteria_precio_igual']=$resultado_base_comisiones[0]['valor_ferreteria_precio_igual']-$resultado_base_comisiones[0]['nc_valor_ferreteria_precio_igual'];
    			$resultado_base_comisiones[0]['comision_ferreteria_precio_igual']=$resultado_base_comisiones[0]['comision_ferreteria_precio_igual']-$resultado_base_comisiones[0]['nc_comision_ferreteria_precio_igual'];
    			$datos_comision[]=array(						
    				'Rubros'=>'Igual al precio base',
    				'%Comision'=>'0.5%',
    				'Valor'=>$resultado_base_comisiones[0]['valor_ferreteria_precio_igual'],
    				'Comision'=>$resultado_base_comisiones[0]['comision_ferreteria_precio_igual'],
    			);
    			
    			$datos_comision[]=array(						
    				'Rubros'=>'Menor al precio base (cotización)',
    				'%Comision'=>'',
    				'Valor'=>'',
    				'Comision'=>$resultado_base_comisiones[0]['comision_cotizacion_ferreteria'],
    			);
    			
    			//pesado
    			$datos_comision[]=array(						
    				'Rubros'=>'<b>Ventas Pesado</b>',
    				'%Comision'=>'',
    				'Valor'=>'',
    				'Comision'=>'',
    			);
    			$resultado_base_comisiones[0]['valor_pesado_precio_mayor']=$resultado_base_comisiones[0]['valor_pesado_precio_mayor']-$resultado_base_comisiones[0]['nc_valor_pesado_precio_mayor'];
    			$resultado_base_comisiones[0]['comision_pesado_precio_mayor']=$resultado_base_comisiones[0]['comision_pesado_precio_mayor']-$resultado_base_comisiones[0]['nc_comision_pesado_precio_mayor'];
    			$datos_comision[]=array(						
    				'Rubros'=>'Mayor al precio base',
    				'%Comision'=>'80%',
    				'Valor'=>$resultado_base_comisiones[0]['valor_pesado_precio_mayor'],
    				'Comision'=>$resultado_base_comisiones[0]['comision_pesado_precio_mayor'],
    			);
    			$resultado_base_comisiones[0]['valor_pesado_precio_igual']=$resultado_base_comisiones[0]['valor_pesado_precio_igual']-$resultado_base_comisiones[0]['nc_valor_pesado_precio_igual'];
    			$resultado_base_comisiones[0]['comision_pesado_precio_igual']=$resultado_base_comisiones[0]['comision_pesado_precio_igual']-$resultado_base_comisiones[0]['nc_comision_pesado_precio_igual'];
    			$datos_comision[]=array(						
    				'Rubros'=>'Igual al precio base',
    				'%Comision'=>'0.25%',
    				'Valor'=>$resultado_base_comisiones[0]['valor_pesado_precio_igual'],
    				'Comision'=>$resultado_base_comisiones[0]['comision_pesado_precio_igual'],
    			);
    			$datos_comision[]=array(						
    				'Rubros'=>'Menor al precio base (cotización)',
    				'%Comision'=>'',
    				'Valor'=>'',
    				'Comision'=>$resultado_base_comisiones[0]['comision_cotizacion_pesado'],
    			);
    			
    			
    			//COMISIONES 
    			
    			$valorcomision=0;
    			$com=$comision_model->getComisionGrupoPorcentajeBYPUV_ID($puv_id);
    			foreach($com as $c)
    			{
    			    $value=eval('return $'. $c['com_campo_base_comisiones'] . ';');//'$'.$c['com_campo_base_comisiones'];
    			    $valorcomision=number_format($value, 2, '.', '')*($c['cgp_porcentaje']/100);
    			    if($valorcomision!=0){
        			    $datos_comision[]=array(						
            				'Rubros'=>$c['com_titulo_reporte_pdv'],
            				'%Comision'=>$c['cgp_porcentaje'].'%',
            				'Valor'=>$value,
            				'Comision'=>$valorcomision,
            			);
    			    }
    			}
    			
    			
    			foreach ($datos_convenio_porentaje_puvid as $key => $value) {
    				//if($value['cop_valor_vendido']!=0 && $value['cop_porciento']!=0 ){
    				if($value['cop_porciento']!=0){
    					$datos_comision[]=array(						
    						'Rubros'=>$value['cov_nombre'],
    						'%Comision'=>$value['cov_porcentaje'],
    						'Valor'=>$value['cop_valor_vendido'],
    						'Comision'=>$value['cop_porciento'],
    					);
    				}
    
    				//}
    
    			}
    			$post_convenio_model=new Postconveniomodel();
    			$resultado_post_convenio= $post_convenio_model->getPostConveniodesdehasta($mes_fin,$mes_inicio);
    			foreach ($resultado_post_convenio as $value) {
    				$resultado_post_convenio_valor=$post_convenio_valor_model->getpostconvenioporcentajeid($pdv_info[0]['puv_id'],$value['poc_id'],$mes_inicio);
    				$valor_post_convenio=0;
    				if(!empty($resultado_post_convenio_valor)){
    					foreach ($resultado_post_convenio_valor as $key => $valuepostconvenio) {
    						if($valuepostconvenio['pcv_valor']!=0){
    							$datos_comision[]=array(	
    								'Rubros'=>$valuepostconvenio['poc_nombre'],
    								'%Comision'=>'',
    								'Valor'=>0,
    								'Comision'=>$valuepostconvenio['pcv_valor'],
    							);
    						}
    					}
    					
    				}
    				
    
    			}
    			/*$resultado_base_comisiones[0]['comision_nota_credito']=$resultado_base_comisiones[0]['comision_nota_credito']*-1;
    			$resultado_base_comisiones[0]['valor_nota_credito']=(float)$resultado_base_comisiones[0]['valor_total_nota_credito']*-1;
    			
    			$datos_comision[]=array(
					'Rubros'=>'<b>Notas de crédito</b>',
					'%Comision'=>'',
					'Valor'=>(float)$resultado_base_comisiones[0]['valor_total_nota_credito']*-1,
					'Comision'=>$resultado_base_comisiones[0]['comision_nota_credito'],
				);*/
    			$datos_comision_total_valor=0;
    			$datos_comision_total_comision=0;
    			//echo '<pre>';print_r($datos_comision);die();
    			foreach ($datos_comision as $key => $value) {
    			    if($value['Valor']==''){$value['Valor']=0;}
    			    if($value['Comision']==''){$value['Comision']=0;}
    				$datos_comision_total_valor=$datos_comision_total_valor+$value['Valor'];
    				$datos_comision_total_comision=$datos_comision_total_comision+$value['Comision'];
    			}
    			$datos_comision_total_valor=number_format($datos_comision_total_valor, 2, '.', '');
    			$datos_comision_total_comision=number_format($datos_comision_total_comision, 2, '.', '');
    			$datos_comision[]=array(	
    				'Rubros'=>'Total',
    				'%Comision'=>'',
    				'Valor'=>$datos_comision_total_valor,
    				'Comision'=>$datos_comision_total_comision,
    			);
    
    			
    			$descuentos_model=new Descuentosmodel();
    			$resultado_descuentos_prefacturacion_indefinido=$descuentos_model->getDescuentosindefinidosprefacturacion($mes_inicio);
    					
    			$resultado_descuentos_prefacturacion_mensual=$descuentos_model->getDescuentosmensualprefacturacion($mes_fin,$mes_inicio);
    
    			$resultado_descuentos_prefacturacion=array_merge($resultado_descuentos_prefacturacion_indefinido,$resultado_descuentos_prefacturacion_mensual);
    
    
    			$resultado_descuentos_postfacturacion_indefinido=$descuentos_model->getDescuentosindefinidospostfacturacion();
    			$resultado_descuentos_postfacturacion_mensual=$descuentos_model->getDescuentosmensualpostfacturacion($mes_fin,$mes_inicio);
    
    			$resultado_descuentos_postfacturacion=array_merge($resultado_descuentos_postfacturacion_indefinido,$resultado_descuentos_postfacturacion_mensual);
    
    			$descuentos_antes_facturar=[];
    			
    
    			foreach ($resultado_descuentos_prefacturacion as $valuepre) {				
    				
    				$valor_descuento=0;				
    				$cuota_descuento=0;
    				if($valuepre['des_nombre_franquicias']=='Tipo Franquicia'){
    					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepre['des_nombre_franquicias']);										
    					if(!empty($descuentopresegunpdv)){
    						$valor_descuento=$valuepre['des_valor'];
    
    						if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    							$dias_totales=date('t',strtotime($mes_aux));
    							$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    							$dias_cobro=$dias_totales-$dias_inicio;
    
    							$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;
    
    							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    							$valor_descuento=number_format($valor_descuento, 2, '.', '');
    						}
    						if($pdv_info[0]['puv_propio']==1){
    							$valor_descuento=0;
    						}
    						$mes_cuota=0;
    						$cuotas_totales=0;
    						$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);
    
    						$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);
    
    						if($mes_cuota==0){
    							$valor_descuento=0;
    							$cuota_descuento='';
    						}else{
    							if($mes_cuota<=$cuotas_totales){
    							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    						    }
    						    else
    						    {
    						        $cuota_descuento='';
    						    }
    						}
    					}
    
    				}else{
    					if($valuepre['des_nombre_franquicias']=='PDV'){
    						
    						$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepre['des_nombre_franquicias']);
    						if(!empty($descuentopresegunpdv)){
    							$valor_descuento=$valuepre['des_valor'];
    							
    							if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    								$dias_totales=date('t',strtotime($mes_aux));
    								$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    								$dias_cobro=$dias_totales-$dias_inicio;
    
    								$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;
    
    								$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    								$valor_descuento=number_format($valor_descuento, 2, '.', '');
    							}
    							if($pdv_info[0]['puv_propio']==1){
    								$valor_descuento=0;
    							}
    							$mes_cuota=0;
    							$cuotas_totales=0;
    							$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);
    
    							$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);
    
    							if($mes_cuota==0){
    								$valor_descuento=0;
    								$cuota_descuento='';
    							}else{
    								if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
    							}
    						}
    					}
    					
    				}
    
    				if($valuepre['des_frecuencia']=='indefinido'){
    					$cuota_descuento=0;
    				}
    				if($valor_descuento!=0){
    					$motivo='';
    					if($cuota_descuento!=0){
    						$motivo= $valuepre['des_nombre'].' '.$cuota_descuento;
    					}else{
    						$motivo= $valuepre['des_nombre'];
    					}
    
    					$descuentos_antes_facturar[]=array(
    						'Motivo'=>$motivo,
    						'Valor'=>$valor_descuento,
    					);
    				}
    
    				
    				
    			}
    
    
    			$resultado_descuentos_mensual_prefacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Pre-Facturacion',$mes_fin,$mes_inicio); //print_r($resultado_descuentos_mensual_prefacturacion_mensual); die();
    
    			foreach ($resultado_descuentos_mensual_prefacturacion_mensual as $value) {
    				$valor_descuento=0;
    				$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($pdv_info[0]['puv_id'],$value['dem_id'],$mes_inicio);
    				if(!empty($descuentomensualvalor[0]['dmv_valor'])){
    					$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
    				}
    				if($valor_descuento!=0){	
    					$descuentos_antes_facturar[]=array(
    						'Motivo'=>$value['dem_nombre'],
    						'Valor'=>$valor_descuento,
    					);
    				}	
    			}
                
    			$descuentos_antes_facturar_total=0;
    			foreach ($descuentos_antes_facturar as $value) {
    				$descuentos_antes_facturar_total=$descuentos_antes_facturar_total+$value['Valor'];
    			}
    			$descuentos_antes_facturar[]=array(
    				'Motivo'=>'Total',
    				'Valor'=>$descuentos_antes_facturar_total,
    			);
    
    			
    			$factura_pago=[];
    			
    			$valor_comision_total=$datos_comision_total_comision-$descuentos_antes_facturar_total;
    			$factura_pago[]=array(
    				'Motivo'=>'Factura',
    				'Detalle'=>'Comisión',
    				'Valor'=>$valor_comision_total,
    			);
    			$iva=$valor_comision_total*($pdv_info[0]['irp_iva']/100);
    			$iva=number_format($iva, 2, '.', '');
    			$factura_pago[]=array(
    				'Motivo'=>'',
    				'Detalle'=>'Iva',
    				'Valor'=>$iva,
    			);
    			$total_factura=$valor_comision_total+$iva;
    			$total_factura=number_format($total_factura, 2, '.', '');
    			$factura_pago[]=array(
    				'Motivo'=>'',
    				'Detalle'=>'Total Factura',
    				'Valor'=>$total_factura,
    			);
    			//$reduccion_renta=$valor_comision_total*0.08;
    			$reduccion_renta=$valor_comision_total*($pdv_info[0]['irp_retencion_renta']/100);
    			$reduccion_renta=number_format($reduccion_renta, 2, '.', '');
    			$factura_pago[]=array(
    				'Motivo'=>'Reducciones Pago',
    				'Detalle'=>'Reducción renta '.$pdv_info[0]['irp_retencion_renta'].'%',
    				'Valor'=>$reduccion_renta,
    			);
    			//$reduccion_iva=$iva*0.7;
    			$reduccion_iva=$iva*($pdv_info[0]['irp_retencion_iva']/100);
    			$reduccion_iva=number_format($reduccion_iva, 2, '.', '');
    			$factura_pago[]=array(
    				'Motivo'=>'',
    				'Detalle'=>'Reducción Iva '.$pdv_info[0]['irp_retencion_iva'].'%',
    				'Valor'=>$reduccion_iva,
    			);
    			$total_recibor_dedicciones_pago=$total_factura-$reduccion_renta-$reduccion_iva;
    			$total_recibor_dedicciones_pago=number_format($total_recibor_dedicciones_pago, 2, '.', '');
    			$factura_pago[]=array(
    				'Motivo'=>'',
    				'Detalle'=>'Total a Recibir',
    				'Valor'=>$total_recibor_dedicciones_pago,
    			);
    			$total_transferir=0;
    			$total_transferir=$total_recibor_dedicciones_pago;
    			
    			
    			
    			foreach ($resultado_descuentos_postfacturacion as $valuepost) {
    				$valor_descuento=0;
    				$cuota_descuento=0;
    				if($valuepost['des_nombre_franquicias']=='Tipo Franquicia'){
    					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepost['des_nombre_franquicias']);
    					if(!empty($descuentopresegunpdv)){
    						$valor_descuento=$valuepost['des_valor'];
    						
    						if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    							$dias_totales=date('t',strtotime($mes_aux));
    							$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    							$dias_cobro=$dias_totales-$dias_inicio;
    
    							$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;
    
    							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    							$valor_descuento=number_format($valor_descuento, 2, '.', '');
    						}
    						if($pdv_info[0]['puv_propio']==1){
    							$valor_descuento=0;
    						}
    						$mes_cuota=0;
    						$cuotas_totales=0;
    						$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);
    
    						$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);
    
    						if($mes_cuota==0){
    							$valor_descuento=0;
    							$cuota_descuento='';
    						}else{
    							if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
    						}
    					}
    				}else{
    					if($valuepost['des_nombre_franquicias']=='PDV'){
    						$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepost['des_nombre_franquicias']);
    						if(!empty($descuentopresegunpdv)){
    							$valor_descuento=$valuepost['des_valor'];
    							
    							if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    								$dias_totales=date('t',strtotime($mes_aux));
    								$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    								$dias_cobro=$dias_totales-$dias_inicio;
    
    								$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;
    
    								$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    								$valor_descuento=number_format($valor_descuento, 2, '.', '');
    							}
    							if($pdv_info[0]['puv_propio']==1){
    								$valor_descuento=0;
    							}
    							$mes_cuota=0;
    							$cuotas_totales=0;
    							$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);
    
    							$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);
    
    							if($mes_cuota==0){
    								$valor_descuento=0;
    								$cuota_descuento='';
    							}else{
    								if($mes_cuota<=$cuotas_totales){
            							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
            						    }
            						    else
            						    {
            						        $cuota_descuento='';
            						    }
    							}
    						}
    					}
    				}
    				if($valuepost['des_frecuencia']=='indefinido'){
    					$cuota_descuento=0;
    				}
    				
    				if($valor_descuento!=0){
    					
    					$motivo='';
    					if($cuota_descuento!=0){
    						$motivo= $valuepost['des_nombre'].' '.$cuota_descuento;
    					}else{
    						$motivo= $valuepost['des_nombre'];
    					}
                        
    					
    					
    					if($total_transferir>=$valor_descuento){ //echo 'entra';
                			$total_transferir=$total_transferir-$valor_descuento;
                			$descuento_pago_pendiente_model->updateRegistroCuotaPendienteActualDes($valuepost['des_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano ); 
                			$factura_pago[]=array(
        						'Motivo'=>'',
        						'Detalle'=>$motivo,
        						'Valor'=>$valor_descuento,
        					);
            			}
    					else
            			{
            			    $cuota_no_pagada[]=array(
        						'Motivo'=>'Descuento',
        						'Detalle'=>$motivo.', no cobrado, comisión insuficiente',
        						'Valor'=>$valor_descuento,
        					);
                			
                			$comprobar_cuota_en_no_pagadas=$descuento_pago_pendiente_model->getCuotaPendienteByDESID($valuepost['des_id'],$numero_mes,$numero_ano);
                			    
                			if($comprobar_cuota_en_no_pagadas[0]['dpp_id']!=''){
                			    foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
                    			    $descuento_pago_pendiente_model->updateRegistroAnteriorCuotaPendienteDes($valuepost['des_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano );
                            		$descuento_pago_pendiente_model->insertCuotaPendiente($valuepost['des_id'], NULL,'Valor a cobrar de comisión insuficiente', $valpendiente['dpp_transaccion'], $pdv_info[0]['puv_id'] , $valor_descuento,$numero_mes, $numero_ano);
                    			}
                			}
                			else
                			{ 
                			    $descuento_pago_pendiente_model->insertCuotaPendiente($valuepost['des_id'], NULL,'Valor a cobrar de comisión insuficiente', 0, $pdv_info[0]['puv_id'],$valor_descuento,$numero_mes, $numero_ano );
        
                			}
            			}
    					
    					
    					
    					
    					
    				}
    			}
    			
    			$resultado_descuentos_mensual_postfacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Post-Facturacion',$mes_fin,$mes_inicio);
    
    			foreach ($resultado_descuentos_mensual_postfacturacion_mensual as $value) {
    				$valor_descuento=0;
    				$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($pdv_info[0]['puv_id'],$value['dem_id'],$mes_inicio);
    
    				if(!empty($descuentomensualvalor[0]['dmv_valor'])){
    					$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
    				}
    
    				if($valor_descuento!=0){
    				    
    				    if($total_transferir>=$valor_descuento){ //echo 'entra';
                			$total_transferir=$total_transferir-$valor_descuento;
                			$descuento_pago_pendiente_model->updateRegistroCuotaPendienteActualDes($value['dem_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano ); 
                			$factura_pago[]=array(
        						'Motivo'=>'',
        						'Detalle'=>$value['dem_nombre'],
        						'Valor'=>$valor_descuento,
        					);
            			}
    					else
            			{
            			    $cuota_no_pagada[]=array(
        						'Motivo'=>'Descuento',
        						'Detalle'=>$value['dem_nombre'].', no cobrado, comisión insuficiente',
        						'Valor'=>$valor_descuento,
        					);
                			
                			$comprobar_cuota_en_no_pagadas=$descuento_pago_pendiente_model->getCuotaPendienteByDESID($value['dem_id'],$numero_mes,$numero_ano);
                			    
                			if($comprobar_cuota_en_no_pagadas[0]['dpp_id']!=''){
                			    foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
                    			    $descuento_pago_pendiente_model->updateRegistroAnteriorCuotaPendienteDes($value['dem_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano );
                            		$descuento_pago_pendiente_model->insertCuotaPendiente($value['dem_id'], NULL,'Valor a cobrar de comisión insuficiente', $valpendiente['dpp_transaccion'], $pdv_info[0]['puv_id'] , $valor_descuento,$numero_mes, $numero_ano);
                    			}
                			}
                			else
                			{ 
                			    $descuento_pago_pendiente_model->insertCuotaPendiente($value['dem_id'], NULL,'Valor a cobrar de comisión insuficiente', 0, $pdv_info[0]['puv_id'],$valor_descuento,$numero_mes, $numero_ano );
        
                			}
            			}
    				    
    				}
    			}
    			
    			
    			//sobregiros
    			$sobregiroModel->reiniciarAbonoSobregiros($puv_id,$mes_inicio);
    			$sobregiros=$sobregiroModel->getSobregirosPUVID($puv_id,$mes);
    			foreach($sobregiros as $sob){
    			    $abono_sobregiro=0;
    			    if($total_transferir!=0){
        			    if($total_transferir>=$sob['sob_saldo']){
        			        $sobregiros=$sobregiroModel->insertarAbonosSobregiros($sob['sob_id'],$mes_inicio,$sob['sob_saldo'],'Abono correspondiente al mes '.$mes);
        			        $total_transferir=$total_transferir-$sob['sob_saldo'];
        			        $abono_sobregiro=$sob['sob_saldo'];
        			        $factura_pago[]=array(
        						'Motivo'=>'',
        						'Detalle'=>'Pago del sobregiro correspondiente al mes '.$sob['sob_mes'],
        						'Valor'=>$abono_sobregiro,
        					);
        			    }else{
        			        $sobregiros=$sobregiroModel->insertarAbonosSobregiros($sob['sob_id'],$mes_inicio,$total_transferir,'Abono correspondiente al mes '.$mes);
        			        $abono_sobregiro=$total_transferir;
        			        $total_transferir=$total_transferir-$total_transferir;
        			        $factura_pago[]=array(
        						'Motivo'=>'',
        						'Detalle'=>'Abono del sobregiro correspondiente al mes '.$sob['sob_mes'],
        						'Valor'=>$abono_sobregiro,
        					);
        			    }
        			    $total_abono_sobregiro=$sob['sob_abono']+$abono_sobregiro;
        			    $saldo_sobregiro=$sob['sob_saldo']-$abono_sobregiro;
        			    $estado_sobregiro=0;
        			    if($saldo_sobregiro===0){
        			        $estado_sobregiro=1;
        			    }
        			    $sobregiroModel->updateSaldos($sob['sob_id'],$total_abono_sobregiro,$saldo_sobregiro,$estado_sobregiro);
        			    if($saldo_sobregiro!=0){
        			        $cuota_no_pagada[]=array(
        						'Motivo'=>'Sobregiro',
        						'Detalle'=>'Saldo sobregiro correspondiente al mes '.$sob['sob_mes'],
        						'Valor'=>$saldo_sobregiro,
        					);
        			    }
    			    }else{
    			    $cuota_no_pagada[]=array(
						'Motivo'=>'Sobregiro',
						'Detalle'=>'Sobregiro correspondiente al mes '.$sob['sob_mes'],
						'Valor'=>$sob['sob_saldo'],
					);
    			        
    			    }
    			}
    			
    			//Prestamos pdv
    			$cobrar_mes_gracia=false;
    			$prestamos_model=new Prestamosmodel();
    			$prestamo_pago_pendiente_model=new Prestamopendientepagomodel();
    			$prestamo_amortizacion_detalle_model=new Prestamoamortizaciondetallemodel();
    			$resultado_prestamos_pendientes=$prestamos_model->getPrestamosPendientesPDV($puv_id);  //echo '<pre>';print_r($resultado_prestamos_pendientes);echo '</pre>';
    			$prestamo_amortizacion_detalle_model=new Prestamoamortizaciondetallemodel();
    			$prestamo_mes_gracia_model=new Prestamomesgraciamodel();
    			
    			$fecha_separada=explode('-',$mes);
        		$numero_mes=intval($fecha_separada[1]);
        		$numero_ano=$fecha_separada[0];
        		$mesunido=$numero_ano.ltrim($numero_mes);
        		$cobrado=0;
        		//echo '<pre>';print_r($resultado_prestamos_pendientes);echo '</pre>';
    			foreach($resultado_prestamos_pendientes as $value){//echo $value['pre_id'];
    			    $cobrado=0;
    			    $valor_prestamo=0;
    				$cuotas=0;
    			    $datos_prestamo=$prestamo_amortizacion_detalle_model->getCuotasPendientesPrestamoByPDV($value['pre_nombre'],$pdv_info[0]['puv_id'], $numero_mes, $numero_ano);//echo 'CUOTAS PENDIENTES'; echo '<pre>';print_r($datos_prestamo);echo '</pre>';die();
    			    $datos_prestamo_pagado_pendientes_anteriores=$prestamo_amortizacion_detalle_model->getCuotasPendientesPrestamoByPDVPagadasMesActual($value['pre_nombre'],$pdv_info[0]['puv_id'], $numero_mes, $numero_ano); //echo 'CUOTAS PENDIENTES ANTERIORES PAGADO MES ACTUAL'; echo '<pre>';print_r($datos_prestamo_pagado_pendientes_anteriores);echo '</pre>';
    			    $datos_prestamo_pendiente=$prestamo_amortizacion_detalle_model->getCuotasAnterioresPendientesByPRAID($value['pre_nombre'],$pdv_info[0]['puv_id'], $numero_mes, $numero_ano); //echo 'CUOTAS PENDIENTES MESES ANTERIORES'; echo '<pre>';print_r($datos_prestamo_pendiente);echo '</pre>';
    			    $datos_prestamo_pendiente_mes_gracia=$prestamo_amortizacion_detalle_model->getCuotasMesGracia($value['pre_nombre'],$pdv_info[0]['puv_id'], $mesunido);// echo 'CUOTAS MES DE GRACIA'; echo '<pre>';print_r($datos_prestamo_pendiente_mes_gracia);echo '</pre>';
    			    $result1 = array_merge($datos_prestamo, $datos_prestamo_pagado_pendientes_anteriores, $datos_prestamo_pendiente, $datos_prestamo_pendiente_mes_gracia);

                    $uniqueResult = [];
                    $prd_ids = [];
                    
                    foreach ($result1 as $item) {
                        // Si el 'prd_id' no está ya en el array, lo añadimos
                        if (!in_array($item['prd_id'], $prd_ids)) {
                            $prd_ids[] = $item['prd_id'];
                            $uniqueResult[] = $item;
                        }
                    }
                    
                    // Ordenar por 'prd_id'
                    usort($uniqueResult, function ($a, $b) {
                        return $a['prd_id'] <=> $b['prd_id']; // Comparación basada en 'prd_id'
                    });
                    
                    $result = $uniqueResult;
    			    $total_recibir_sin_descuentos=$total_transferir;
    			    $cuotas=''; 
        			foreach($result as $value_prestamo){
        			    $mes_gracia=false;
        			    $cobrar_mes_gracia=false;
        			    $prestamo_amortizacion_detalle_model->reiniciarPagoCuota($value_prestamo['prd_id']);  //echo 'VALORES IMP'.$value['pre_id'].' '.$value_prestamo['prd_mes_estimado'].' '.$value_prestamo['prd_ano_estimado'].' '.$puv_id;
        			    $resultado_mes_gracia=$prestamo_mes_gracia_model->getMesGraciaByPreidMes($value_prestamo['pre_id'],$value_prestamo['prd_mes_estimado'],$value_prestamo['prd_ano_estimado'],$puv_id);// echo 'CUOTAS MES DE GRACIA2'; echo '<pre>';print_r($resultado_mes_gracia);echo '</pre>';
    			    
        			    if(!empty($resultado_mes_gracia)){
        			        $mes_gracia=true; //echo 'si hay mes de gracia'.$mes_gracia.'';
        			        $cuotas_pendientes_sin_mes_gracia=$prestamo_amortizacion_detalle_model->getCuotasPendientesPrestamoSINMesGracia($value['pre_nombre'],$pdv_info[0]['puv_id'], $meg[0]['meg_mes'], $meg[0]['meg_ano']); //echo 'CUOTAS PENSIENTES SIN MES DE GRACIA'; echo '<pre>';print_r($cuotas_pendientes_sin_mes_gracia);echo '</pre>';
        			        if(empty($cuotas_pendientes_sin_mes_gracia)){
                            //echo $numero_ano.$numero_mes.'==='.$value_prestamo['pra_id'];
        			        $resultado_cobrar_mes_gracia=$prestamo_mes_gracia_model->getCobrarMesGracia($numero_ano.$numero_mes,$value_prestamo['pra_id']);
        			        //echo '<pre> Comprobar si se cobra';print_r($resultado_cobrar_mes_gracia);echo '</pre>';
            			        if(empty($resultado_cobrar_mes_gracia))
            			        {
            			            $cobrar_mes_gracia=true;
            			           // echo 'Si debe cobrar';
            			        }
        			        }
        			        else
        			        {
        			           // echo 'Hay cuotas pendientes';
        			        }
        			        
        			    }
        			   // echo '</br>'.$mes_gracia.'...';
        			    $total_recibir_sin_descuentos=floatval($total_recibir_sin_descuentos);//print_r($prestamo_abono_cuota_model->getTotalAbonoCuotaPRDID($value_prestamo['prd_id'],$numero_mes,$numero_ano));
        			    
        			    
        			    
        			    $abonos=($prestamo_abono_cuota_model->getTotalAbonoCuotaPRDID($value_prestamo['prd_id'],$numero_mes,$numero_ano))[0]['saldo'];
        			    //echo '<pre> Detalle abonos ';print_r($abonos);echo '</pre>';
        			    $valor_cuota=$value_prestamo['prd_cuota_total']-$abonos; //echo 'valor cuota: '.$valor_cuota;die();
        			    $saldocuota=$value_prestamo['prd_cuota_total']-$abonos;
        			    //echo 'el saldo es='.$saldocuota;
        			    if($abonos==null){
        			        $abonos=0;
        			    }
        			    $prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],null,null,$abonos,$saldocuota,0);
        			    $prestamo_abono_cuota_model->reiniciarAbonoCuotaPRDID($value_prestamo['prd_id'],$numero_mes,$numero_ano);
        			    if(($total_recibir_sin_descuentos>0 && $mes_gracia==false)||($total_recibir_sin_descuentos>0 && $cobrar_mes_gracia==true)){
        			        $cobrado++;
        			        if($abonos=="")
        			        {
        			            $abonos=0;
        			        }
            			    if($valor_cuota<=$total_recibir_sin_descuentos){ //echo ' valor cuota mayor o igual que valor disponible';
            			        $cuotas.='('.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' cobrada), ';
            			        $valor_prestamo+=$valor_cuota;
            			        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$valor_cuota;
            			        $abonos+=$valor_cuota; 
            			        $saldocuota=$value_prestamo['prd_cuota_total']-$abonos;
            			        $prestamo_abono_cuota_model->insertAbonoCuotaPRDID($value_prestamo['pre_id'],$value_prestamo['pra_id'],$value_prestamo['prd_id'],$numero_mes,$numero_ano,$valor_cuota,$saldocuota,'A');
            			    }
            			    else{//echo ' valor cuota menor que valor disponible';
            			        $valor_prestamo+=$total_recibir_sin_descuentos;
            			        $abonos+=$total_recibir_sin_descuentos;
            			        $saldocuota=$value_prestamo['prd_cuota_total']-$abonos;
            			        $prestamo_abono_cuota_model->insertAbonoCuotaPRDID($value_prestamo['pre_id'],$value_prestamo['pre_id'],$value_prestamo['prd_id'],$numero_mes,$numero_ano,$total_recibir_sin_descuentos,$saldocuota,'A');
            			        $cuotas.='('.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' cobro parcial $'.$total_recibir_sin_descuentos.' / saldo $'.$saldocuota.'), ';
            			        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$total_recibir_sin_descuentos;
            			    }
            			    //echo '\n saldo'.$saldocuota;
            			    //echo '\n abonos'.$abonos;
            			    
            			    if($saldocuota==0){//echo '\n entra en saldo cuota 0';
            			        //Registrar pago cuota
            			        $prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],$numero_mes,$numero_ano,$abonos,$saldocuota,1);
            			        
                			    $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']);
                			    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
                			        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
                			            $prestamo_pago_pendiente_model->pagarCuotaPendiente($valpendiente['ppp_id'],$numero_mes,$numero_ano);
                			        }
                			    }
            			    }
            			    else{
            			        //echo '\n entra en saldo cuota mayor a 0';die();
            			        $prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],null,null,$abonos,$saldocuota,2);
            			        $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']); 
                			    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
                			        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){//echo 'Hace update';
                			            $prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($value_prestamo['prd_id'],'Pago parcial $ '.$abonos.' / saldo $'.$saldocuota, $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'],3,'A');
                			        }
                			    }
                			    else
                			    { //echo 'Hace insert';
                			        $prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Pago parcial $ '.$abonos.' / saldo $'.$saldocuota, 0, $value_prestamo['puv_id'],3 );
                			        
                			    }
            			    
            			        $cuota_no_pagada[]=array(
            						'Motivo'=>'Préstamo',
            						'Detalle'=>$value['pre_nombre'].' (cuota '.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' total abonos $ '.$abonos.'), ',
            						'Valor'=>$saldocuota,
            					);
                			    
            			        
            			    }//die();
        			    }
        			    else
        			    {
        			        
        			        //Registrar observacion no pago cuota 
        			       // echo $mes_gracia.'yy';
        			        if($mes_gracia==false){ //echo 'entra 1';
        			        if($abonos > 0){
        			            $cuotas.='(cuota '.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' saldo no cobrado, comisión insuficiente, total abono meses anteriores $'.$abonos.'), ';
        			        }
        			        else{
        			            $cuotas.='(cuota '.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' no cobrada, comisión insuficiente), ';
        			        }
            			        $prestamo_amortizacion_detalle_model->insertarMotivoNoPagoCuota($value_prestamo['prd_id'],'Valor a cobrar de comisión insuficiente',0);
        			        }
        			        else{// echo 'entra 2';
        			            $cuotas.='(cuota '.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' no cobrada, mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'].'), ';
        			            $prestamo_amortizacion_detalle_model->insertarMotivoNoPagoCuota($value_prestamo['prd_id'],'Mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'],0);
        			        }
            			    $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']);//echo 'COMPROBAR EN NO PAGADAS'; echo '<pre>';print_r($comprobar_cuota_en_no_pagadas);echo '</pre>';
            			    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
            			        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
            			            if($mes_gracia==false){
            			                $prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($value_prestamo['prd_id'],'Valor a cobrar de comisión insuficiente', $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'],0);
            			            }else{
            			                //$prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'], $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'] );
            			                $prestamo_mes_gracia_model->otorgarMesGracia($resultado_mes_gracia[0]['meg_id']); 
            			            }
            			        }
            			    }
            			    else
            			    {
            			        if($mes_gracia==false){
            			            $prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Valor a cobrar de comisión insuficiente', 0, $value_prestamo['puv_id'],0 );
            			        }if($mes_gracia==true || $mes_gracia==1) {
            			            //$prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'], 0, $value_prestamo['puv_id'] );
            			            $prestamo_mes_gracia_model->otorgarMesGracia($resultado_mes_gracia[0]['meg_id']);
            			        }
            			    }
            			    if($abonos=='')
            			    {
            			        $abonos=0;
            			    }
            			    if($mes_gracia==false){ //echo 'entra 3';
                			    $cuota_no_pagada[]=array(
            						'Motivo'=>'Préstamo',
            						'Detalle'=>$value['pre_nombre'].' (cuota '.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' no cobrada, total abono meses anteriores $'.$abonos.'), ',
            						'Valor'=>$saldocuota,
            					);
            			    }
            			    if($mes_gracia==true || $mes_gracia==1)  {// echo 'entra 4';
            			        $cuota_no_pagada[]=array(
            						'Motivo'=>'Préstamo',
            						'Detalle'=>$value['pre_nombre'].' (cuota '.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' no cobrada, mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'].'), ',
            						'Valor'=>$saldocuota,
            					);
            			    }
        			    }
        			}
        			    $total_transferir=$total_transferir-$valor_prestamo; 
        			    if($cobrado>0){
        					$factura_pago[]=array(
        						'Motivo'=>'',
        						'Detalle'=>$value['pre_nombre'].' '.$cuotas,
        						'Valor'=>$valor_prestamo,
        					);
        			    }
                    
    			}
    			$total_transferir=number_format($total_transferir, 2, '.', '');
    			
    			//Si el valor es negativo se emite un sobregiro
    			$val_sobregiro=0; 
    			if($valor_comision_total<0){
    			    //$val_sobregiro=$total_transferir;
    			    $val_sobregiro=$valor_comision_total;
    			    $sobregiroModel->insertar($puv_id,$val_sobregiro*-1,'Sobregiro correspondiente al mes '.$mes,$mes_inicio);
    			}
    			
    			
    			$factura_pago[]=array(
    				'Motivo'=>'',
    				'Detalle'=>'Total a Transferir',
    				'Valor'=>$total_transferir,
    			);
    			
    			if($val_sobregiro!=0){
    			    $cuota_no_pagada[]=array(
    				'Motivo'=>'Sobregiro',
        			'Detalle'=>'Se ha creado un sobregiro del mes '.$mes,
    				'Valor'=>$val_sobregiro*-1,
    			);
    			}
    			
    			$datos_enviar=array(
    				'datos_venta'=>$resultado_venta_model,
    				'datos_comision'=>$datos_comision,
    				'datos_descuentos_antes_facturar'=>$descuentos_antes_facturar,
    				'datos_factura_pago'=>$factura_pago,
    				'cuotas_no_pagadas'=>$cuota_no_pagada,
    				'puv_punto_venta'=>$pdv_info[0]['puv_punto_venta'],
    				'puv_ciudad'=>$pdv_info[0]['puv_ciudad'],
    				'puv_franquiciado'=>$pdv_info[0]['puv_franquiciado'],
    				'puv_direccion'=>$pdv_info[0]['puv_direccion'],
    				'puv_telefono_personal'=>$pdv_info[0]['puv_telefono_personal'],
    				'puv_correo_empresa'=>$pdv_info[0]['puv_correo_personal'],
    				'periodo'=>$mes,
    				'puv_id'=>$pdv_info[0]['puv_id'],
    				'observacion'=>$observacion[0]['cpo_observacion'],
    				'datos_sobregiro'=>$sobregiro
    			);
    
    			
   
    			
    			echo view("layouts/header");
    			echo view("layouts/aside",$datos_menu);
    			echo view("reporte/reportepdv",$datos_enviar);
    			echo view("layouts/footer");
    			echo view("reporte/footer");
    
    		}else{
    			$session->setFlashdata('mensaje_malo', 'Seleccione el punto de venta y el mes');
    			return redirect()->to(base_url('Reporte/fechareportepdv')); 
    		}
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}	
	
	public function agregarobservacionreportemensualpdv(){
	    
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    	    $datos_menu = $this->datosMenu();
    	    $punto_venta_model= new Puntoventamodel();	
    	    
    	    $puv_id=$this->request->getPost('puv_id');
    	    $mes=$this->request->getPost('mes');
    	    $observacion=$this->request->getPost('observacion');
    	    
    	    $datos_enviar=array(
    			'cpo_fecha'=>$mes,
    			'puv_id'=>$puv_id,
    			'cpo_observacion'=>$observacion,
    		);
    		
    		$resultado=$punto_venta_model->insertarObservacionReporteMensualPDV($datos_enviar);
    		if(empty($resultado)){
    		    $session->setFlashdata('mensaje_bueno', 'Observación agregada correctamente');
    			return redirect()->to(base_url('Reporte/fechareportepdv'));
    		}
    		else
    		{
    		    $session->setFlashdata('mensaje_malo', 'Error');
    			return redirect()->to(base_url('Reporte/fechareportepdv')); 
    		}
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function actualizarobservacionreportemensualpdv(){
	    
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    	    $datos_menu = $this->datosMenu();
    	    $punto_venta_model= new Puntoventamodel();	
    	    
    	    $puv_id=$this->request->getPost('puv_idedit');
    	    $mes=$this->request->getPost('mesedit');
    	    $observacion=$this->request->getPost('observacionedit');
    	
    	    $datos_enviar=array(
    			'cpo_observacion'=>$observacion,
    		);
    		
    		$resultado=$punto_venta_model->actualizarObservacionReporteMensualPDV($datos_enviar,$puv_id,$mes);
    		if(($resultado==1)){
    		    $session->setFlashdata('mensaje_bueno', 'Observación modificada correctamente');
    			return redirect()->to(base_url('Reporte/fechareportepdv'));
    		}
    		else
    		{
    		    $session->setFlashdata('mensaje_malo', $resultado);
    			return redirect()->to(base_url('Reporte/fechareportepdv')); 
    		}
	    }  
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function agregardocumento(){
		$session = \Config\Services::session();		
		$email = \Config\Services::email();
		
		/*$config['protocol'] = 'sendmail';
		$config['mailPath'] = 'C:/xampp/sendmail';
		$config['charset']  = 'iso-8859-1';
		$config['wordWrap'] = true;

		$email->initialize($config);*/
		
		
		$documento_enviado_model=new Documentoenviadomodel();
		$puv_id=$this->request->getPost('puvidcorreoenviar');
		$correo=$this->request->getPost('datocorreo');
		$doe_mes=$this->request->getPost('mescorreoenviar');
		$doe_mes=date('Y-m-01',strtotime($doe_mes));
		$resultado=$documento_enviado_model->getDocumentoenviado($doe_mes,$puv_id);
		$doe_mes1=date('Y-m',strtotime($doe_mes));
		if(empty($resultado)){
			$file = $this->request->getFile('doc');
			if($file!=null){
				$nombre_documento = $file->getRandomName();			
				$file->move(ROOTPATH.'public/upload/comisiones/', $nombre_documento);
				$doe_link=base_url().'/public/upload/comisiones/'.$nombre_documento;
				$datos_documento_enviado=array(				
					'doe_link'=>$doe_link,
					'puv_id'=>$puv_id,
					'doe_mes'=>$doe_mes,
					'doe_estado'=>1,
				);				
				$documento_enviado_model->insertar($datos_documento_enviado);
				$message  = "<html><body>";
				$mensaje=$message.'Estimado,<br/><br/>';
				$mensaje=$mensaje.'Adjunto encontrará el reporte de comisiones correspondiente al mes '.$doe_mes1.'<br/><br/><br/>';
				$mensaje=$mensaje.'Solicito su ayuda con la emisión <b>urgente</b> de la factura correspondiente, vía Whatsapp y la original por Servientrega.';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'Se recuerda que, para ser canceladas las comisiones es necesaria la llegada del documento original (en caso de facturas físicas).';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'Favor tomar en cuenta las recomendaciones que a continuación se detalla:';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'1. Enviar la factura original según el cronograma. Recuerde sin ella no se puede proceder con el pago.';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'2. Llenar la factura con fecha 8 del mes correspondiente, si por cualquier razón la envía pasada esa fecha, deberá ir con la fecha del día de envío de la misma. ';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'<b>CONSULTAS Y RECTIFICACIONES</b>';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'En caso de tener dudas sobre sus descuentos, por favor comunicarse con la persona encargada de operaciones de su punto de venta.<br/> Cualquier rectificación de valores deberá ser solicitada máximo 48 horas después (días laborables) de recibir su reporte. ';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'<b>SOBREGIROS</b>';
				$mensaje=$mensaje.'<br/><br/>';
				$mensaje=$mensaje.'En el caso de observar en su detalle de comisiones TOTAL A RECIBIR, este es un valor en negativo y no será cancelado; por lo tanto, al ser un valor adeudado con Megaprofer el mismo será cobrado en las próximas comisiones o a su vez debitado de saldos a su favor de ser el caso. ';
				$mensaje=$mensaje.'<br/><br/><br/>';
				$mensaje=$mensaje.'<b>Saludos cordiales,</b>';
				$mensaje=$mensaje.'<br/><br/><br/><br/>';
				$mensaje=$mensaje.'<b>Departamento de Operaciones</b>';
				$mensaje=$mensaje.'</body></html>';
				
				$file_to_attach = $doe_link;
                $email->attach( $file_to_attach , $doe_mes );
        		$email->setFrom('info.tics@megaprofer.com', 'Comisiones Megaprofer');
        		$email->setTo($correo);
        
        		$email->setSubject('Comisiones mensuales');
        		$email->setMessage($mensaje);
        
        		$email->send();
				$session->setFlashdata('mensaje_bueno', 'Enviado link: <a target="_blank" href="'.$doe_link.'">'.$doe_link.'</a>');
				
				return redirect()->to(base_url('Reporte/fechareportepdv')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'No enviado');
				return redirect()->to(base_url('Reporte/fechareportepdv')); 
			}
		}else{
			$session->setFlashdata('mensaje_malo', 'Documento ya enviado link: <a target="_blank" href="'.$resultado[0]['doe_link'].'">'.$resultado[0]['doe_link'].'</a>');
			return redirect()->to(base_url('Reporte/fechareportepdv')); 
		}
		
		
	}
	
	public function guardardatosmes(){
		$session = \Config\Services::session();
		$comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
		$mes= $this->request->getPost('reportedatosmes');
		if(empty($mes)){
			$session->setFlashdata('mensaje_malo', 'Ingrese mes');
			return redirect()->to(base_url('Reporte')); 
		}
		
		$mes_inicio=date('Y-m-1',strtotime($mes));
		$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
		if(!empty($resultado)){
			$session->setFlashdata('mensaje_malo', 'Ya existen datos guardados');
			return redirect()->to(base_url('Reporte')); 
		}

		$titulos= $this->request->getPost('reportetitulos');		
		$datos= $this->request->getPost('reportedatos');
		$imprimir= $this->request->getPost('reportedatosimprimir');		
		

		$titulos=base64_decode($titulos);
		$datos=base64_decode($datos);
		$imprimir=base64_decode($imprimir);
		



		$datos_guardar=array(
			'titulos'=>$titulos,
			'datos'=>$datos,
			'imprimir_datos_csv'=>$imprimir,			
		);
		$datos_guardar=json_encode($datos_guardar,JSON_UNESCAPED_UNICODE);
		$datos_guardar=base64_encode($datos_guardar);
		$link=base_url().'/public/upload/reportecomisionmensual/'.$mes.'.txt';
		$archivo=fopen('public//upload/reportecomisionmensual/'.$mes.'.txt', 'w');
		fputs($archivo,$datos_guardar);
		fclose($archivo);

		$datos=array(
			'cmf_link'=>$link,
			'cmf_mes'=>$mes_inicio,
			'cmf_estado'=>1
		);
		$comision_mes_finalizado_model->insertar($datos);
		$session->setFlashdata('mensaje_bueno', 'Datos Guardados');
		return redirect()->to(base_url('Reporte')); 

	}

    public function reportecomparacion(){
        $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
            $datos_menu = $this->datosMenu();
            
    	    $resultadoComparacion=[];
    	    $meses=$this->request->getPost('meses');
    	    $tipo=$this->request->getPost('tipo');
    	    if(empty($meses)){
    			$session->setFlashdata('mensaje_malo', 'Ingrese los meses a comparar');
    			return redirect()->to(base_url('reporte/fechareportecomparacion'));
    		}
    		else
    		{
    		    
    		    $m=explode(',',$meses);
    		    $m=array_unique($m);
    		    arsort($m);
    		    array_pop($m);
        	    //print_r($m);
        	    foreach($m as $mes)
        	    {
        	        if($mes!=''){
            	        $mes_aux=date("Y-m", strtotime($mes));
        		        $mes_inicio=date("Y-m-1", strtotime($mes));
            	        $comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
                		//$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio);
                		if(1==0){
                			
                		}
                		else{
                	        $enviar_datos=$this->obtenerReporteGeneralMes($mes,'fechareportecomparacion',$tipo);
                	        if($enviar_datos=='no')
                	        {
                	            return redirect()->to(base_url('Reporte/fechareportecomparacion')); 
                	        }
                        	array_push($resultadoComparacion,$enviar_datos);
                		}
        	        }
        	    }
        	    $inf_pdv=[];
        	    ////echo count($m);
        	    $pdv_model=new Puntoventamodel();
        	    $pdv1=$pdv_model->getNombrePuntoventaDueno($tipo);
        	    $comprobacion_pdv=false;
        	    $pdv_diferencia_comision=0;
        	    $pdv_diferencia_venta=0;
        	    $pdv_suma=0;
        	    $precios_comisiones=0;
        	    $total_comision=0;
        	    $comision_pesado=0;
                $comision_ferreteria=0;
        	    foreach($pdv1 as $pdv)
        	    {
        	        $comprobacion_pdv=false;
        	        $pdv_total=[];
        	        $pdv_valor=0;
        	        array_push($pdv_total,$pdv['puv_punto_venta']);
        	        $ubicacion_base_ferreteria=0;
        	        $ubicacion_base_pesado=0;
        	        $ubicacion_comision_pesado=0;
        	        $ubicacion_comision_ferreteria=0;
        	        $ubicacion_total_general=0;
        	        $ubicacion_comision=0;
        	        $ubicacion_comisiones=[];
            	    for($i=0;$i<count($m);$i++)
            	    {
            	        $datos=json_decode($resultadoComparacion[$i]['datos']);?><?php //echo '<pre'; print_r(json_decode($resultadoComparacion[$i]['titulos'])); echo '<pre>';?><?php 
            	        $titulos=json_decode($resultadoComparacion[$i]['titulos']);
            	        for($l=0;$l<count($titulos);$l++)
                	    {
                	        
                	        if($titulos[$l]=='Base ferreteria')
                	        {
                	            $ubicacion_base_ferreteria=$l;
                	        }
                	        if($titulos[$l]=='Base pesado')
                	        {
                	            $ubicacion_base_pesado=$l;
                	        }
                	        if($titulos[$l]=='2% comisión (0.5% especiales)')
                	        {
                	            $ubicacion_comision_pesado=$l;
                	        }
                	        if($titulos[$l]=='Comisión')
                	        {
                	            $ubicacion_comision_ferreteria=$l;
                	        }
                	        if($titulos[$l]=='Total General')
                	        {
                	            $ubicacion_total_general=$l;
                	        }
                	        if(trim($titulos[$l])=='Comisión')
                	        {
                	            $ubicacion_comision=$l;
                	        }
                	        if(trim($titulos[$l])=='Total Comisión')
                	        {
                	            $ubicacion_comision_total=$l;
                	        }
                	    }
                	    for($j=0;$j<count($datos);$j++)
                	    {
                	        $base_ferreteria=$datos[$j]->{$ubicacion_base_ferreteria}; 
                	        $base_pesado=$datos[$j]->{$ubicacion_base_pesado}; 
                	        if($datos[$j]->{1}==$pdv['puv_punto_venta'])
                	        {
                	            //echo 'entra';
                	            $comprobacion_pdv=true;
                	            $pdv_ferreteria=$base_ferreteria+0.00;
                    	        $pdv_pesado=$base_pesado+0.00;
                    	        $comision_pesado=$datos[$j]->{$ubicacion_comision_pesado};
                    	        $comision_ferreteria=$datos[$j]->{$ubicacion_comision_ferreteria};
                    	        $precios_comisiones=0;
                    	        /*for($k=$ubicacion_total_general+1;$k<$ubicacion_comision;$k++)
                    	        {
                    	            $precios_comisiones+=$datos[$j]->{$k};
                    	            //echo $precios_comisiones+=$datos[$j]->{$k};;
                    	        }*/
                    	        $precios_comisiones+=$datos[$j]->{$ubicacion_comision_total};
                	            $total_comision=$precios_comisiones;
                	            $cf=$comision_ferreteria;
                	            $cp=$comision_pesado;
                	            $precios_comisiones=$precios_comisiones-$comision_ferreteria-$comision_pesado;
                    	        $pdv_suma=$pdv_ferreteria+$pdv_pesado+0.00;
                    	        if($i==0)
                    	        {
                    	            $pdv_diferencia_comision=$total_comision;
                    	            $pdv_diferencia_venta=$pdv_suma;
                    	        }
                    	        else
                    	        {
                        	        $pdv_diferencia_comision=$pdv_diferencia_comision-$total_comision;
                        	        $pdv_diferencia_venta=$pdv_diferencia_venta-$pdv_suma;
                    	        }
                	            break;
                	        }   
                	        else
                	        {
                	            $pdv_ferreteria=0;
        	                    $pdv_pesado=0;
        	                    $pdv_suma=0;
                	            $pdv_valor=0;
                	            $total_comision=0;
                	            if($i==0)
                    	        {
                    	            $pdv_diferencia_comision=$pdv_valor;
                    	            $pdv_diferencia_venta=$pdv_suma;
                    	        }
                    	        else
                    	        {
                        	        $pdv_diferencia_comision=$pdv_diferencia_comision-$total_comision;
                        	        $pdv_diferencia_venta=$pdv_diferencia_venta-$pdv_suma;
                    	        }
                	        }
                	    }
                	    array_push($pdv_total,(string)$pdv_ferreteria);
                	    array_push($pdv_total,(string)$pdv_pesado);
                	    array_push($pdv_total,(string)$pdv_suma);
                	    array_push($pdv_total,(string)$precios_comisiones);
                	    array_push($pdv_total,(string)$comision_pesado);
                	    array_push($pdv_total,(string)$comision_ferreteria);
                	    array_push($pdv_total,(string)$total_comision);
                	    
            	    }
            	        $pdv_ferreteria=0;
                        $pdv_pesado=0;
                        $pdv_suma=0;
        	            $pdv_valor=0;
        	            $precios_comisiones=0;
        	            $total_comision=0;
        	            $comision_pesado=0;
                    	$comision_ferreteria=0;
        	            array_push($pdv_total,(string)$pdv_diferencia_venta);
        	            array_push($pdv_total,(string)$pdv_diferencia_comision);
        	            array_push($inf_pdv,$pdv_total);
                	    //print_r($inf_pdv); 
                	    $pdv_diferencia_venta=0;
                	    $pdv_diferencia_comision=0;
        	    }
        	    $resultadoComparacion=array(
        	        'meses'=>$m,
        	        'info'=>$inf_pdv,
        	        );
        	    
        	    //print_r($inf_pdv[1]); 
        	    //echo $ubicacion_comision;
        	    echo view("layouts/header");
    			echo view("layouts/aside",$datos_menu);
    			echo view("reporte/reportecomparacion",$resultadoComparacion);
    			echo view("layouts/footer");
    		}
    	    
        }
        else{
	        return redirect()->to(base_url());
	    }
	}
	
	
	function obtenerReporteGeneralMes($mes,$reporte,$tipo)
	{
	    $mes1=$mes;
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
	    $mensaje='';
	    $enviar_datos=[];
	    $base_comisiones_model= new Basecomisionesmodel();
    	$convenio_model=new Conveniomodel();
    	$convenio_porcentaje_model=new Convenioporcentajemodel();
    	$descuentos_model=new Descuentosmodel();
    	$prestamos_model=new Prestamosmodel();
    	$prestamo_amortizacion_detalle_model=new Prestamoamortizaciondetallemodel();
    	$prestamo_pago_pendiente_model=new Prestamopendientepagomodel();
    	$prestamo_mes_gracia_model=new Prestamomesgraciamodel();
    	$prestamo_abono_cuota_model=new Prestamoabonocuotamodel();
    
    	$post_convenio_model=new Postconveniomodel();
    	$post_convenio_valor_model=new Postconveniovalormodel();
    	
    	$descuento_mensual_model=new Descuentomensualmodel();
    	$descuento_mensual_valor_model=new Descuentomensualvalormodel();
    	$descuento_pdv_tipo_franquicia_model=new Descuentospdvtipofranquiciamodel();
    	$descuento_pago_pendiente_model= new Descuentopendientepagomodel();
    	$sobregiro_model=new SobregirosModel();
    
        $comision_model=new Comisionmodel();
        
    	$session = \Config\Services::session();
    
    	
    
    	$mes=date("Y-m-d", strtotime($mes));
    
    	//$resultado_base_comisiones=$base_comisiones_model->getBasecomisionespormes($mes,$tipo);
    	//$resultado_base_comisiones=$base_comisiones_model->getBasecomisionespormes($mes,$tipo);
        
        $mes_aux=date("Y-m", strtotime($mes));
    	$mes_inicio=date("Y-m-d", strtotime($mes));
    	$mes_fin=date("Y-m-t", strtotime($mes));
    	
    	$comisionModel = new Comisionmodelfinal();

        // Obtener las comisiones del mes
        $resultado_comisiones = $comisionModel->calcularComisionesPorMes($mes1);
        $resultado_nota_credito = $comisionModel->calcularNotasCreditoPorMes($mes1);
        
        $resultado_base_comisiones = [];
        foreach ($resultado_comisiones as $item1) {
            $itemPushed = false; // Para rastrear si se hizo un push del item combinado
        
            if (!empty($resultado_nota_credito)) {
                foreach ($resultado_nota_credito as $item2) {
                    if (
                        isset($item1['trc_nombre_almacen'], $item2['ncc_nombre_almacen']) &&
                        $item1['trc_nombre_almacen'] === $item2['ncc_nombre_almacen']
                    ) {
                        // Unir los dos arrays con los datos coincidentes
                        $mergedItem = array_merge($item1, $item2);
                        array_push($resultado_base_comisiones, $mergedItem);
                        $itemPushed = true; // Marcar que se hizo push de este item combinado
                    }
                }
            }
        
            // Si no hubo coincidencias o $resultado_nota_credito está vacío, agregar $item1
            if (!$itemPushed) {
                array_push($resultado_base_comisiones, $item1);
            }
        }
    	//$resultado_convenio=$convenio_model->getConveniopormes($mes_aux);
    
    	//$resultado_convenio=$convenio_model->getConveniodesdehasta($mes_fin,$mes_inicio);
    	$resultado_convenio=$convenio_model->getConveniodesdehasta($mes_inicio,$mes_fin);
    			
    
    	if(empty($resultado_base_comisiones)){
    		$mes=date("Y-m", strtotime($mes));
    		$session->setFlashdata('mensaje_malo', 'No hay datos del mes: '.$mes);
    		return "no";//redirect()->to(base_url('Reporte/'.$reporte)); 
    	}
        else
        {
    	
    	$resultado_descuentos_prefacturacion_indefinido=$descuentos_model->getDescuentosindefinidosprefacturacion($mes_inicio);
    			
    	$resultado_descuentos_prefacturacion_mensual=$descuentos_model->getDescuentosmensualprefacturacion($mes_fin,$mes_inicio);	
    
    	$resultado_descuentos_prefacturacion=array_merge($resultado_descuentos_prefacturacion_indefinido,$resultado_descuentos_prefacturacion_mensual);
    	
    
    	$resultado_descuentos_postfacturacion_indefinido=$descuentos_model->getDescuentosindefinidospostfacturacion();
    	$resultado_descuentos_postfacturacion_mensual=$descuentos_model->getDescuentosmensualpostfacturacion($mes_fin,$mes_inicio);
    
    	$resultado_descuentos_postfacturacion=array_merge($resultado_descuentos_postfacturacion_indefinido,$resultado_descuentos_postfacturacion_mensual);
    	
    	$fecha_separada=explode('-',$mes);
		$numero_mes=intval($fecha_separada[1]);
		$numero_ano=$fecha_separada[0];
		$resultado_prestamos_pendientes=$prestamos_model->getPrestamosPendientes();
    	$resultado_cuotas_pendientes_prestamo =$prestamo_amortizacion_detalle_model->getPrestamosCuotasPendientes($numero_mes,$numero_ano);
    	$resultado_prestamos =$prestamos_model->getPrestamosdesdehastaDistinct($mes_fin,$mes_inicio);
    	$resultado_prestamos2 =$prestamos_model->getPrestamosdesdehastaDistinct($mes_fin,$mes_inicio,$pre_nombre);
    	
        $resultado_descuentos_mensual_postfacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Post-Facturacion',$mes_fin,$mes_inicio);
    	$resultado_descuentos_mensual_prefacturacion_mensual= $descuento_mensual_model->getDescuentomensualdesdehastatipo('Pre-Facturacion',$mes_fin,$mes_inicio);
    	
    	$titulos=[];
    	
    
    
    	array_push($titulos, "ID", "PDV","Franquiciado","Estatus", "Venta ferretería mayor precio base","Venta ferretería igual precio base","Venta pesado mayor precio base","Venta pesado igual precio base");
    
    	foreach ($resultado_convenio as $value) {
    		array_push($titulos,$value['cov_nombre']);
    	}
    	
    	array_push($titulos,'Total General');
    	
    	array_push($titulos, "Comisión ferretería mayor precio base","Comisión ferretería igual precio base","Comisión cotización ferretería","Comisión pesado mayor precio base","Comisión pesado igual precio base", "Comisión cotización pesado");
    
    
    	foreach ($resultado_convenio as $value) {
    		array_push($titulos,$value['cov_porcentaje']."%"." ".$value['cov_nombre']." ");
    	}
    	
    	
    	$resultado_post_convenio= $post_convenio_model->getPostConveniodesdehasta($mes_fin,$mes_inicio);
    
    
    	foreach ($resultado_post_convenio as $value) {
    		array_push($titulos,$value['poc_nombre']);
    	}
    
    	array_push($titulos,'Total Comisión');
    
    
    
    
    	///Descuentos pre-facturacion
    	foreach ($resultado_descuentos_prefacturacion as $value) {
    		array_push($titulos,$value['des_nombre']);
    		array_push($titulos,'Cuotas '.$value['des_nombre']);
    		
    	}
    	///Descuentos pre-facturacion MENSUAL
    	foreach ($resultado_descuentos_mensual_prefacturacion_mensual as $value) {
    		array_push($titulos,$value['dem_nombre']);
    	}
    
    	array_push($titulos,'Total Descuentos');
    
    	array_push($titulos,'Total Facturar');
    	array_push($titulos,'IVA');
    	array_push($titulos,'Total');
    	array_push($titulos,'Retención Renta');
    	array_push($titulos,'Retención IVA');
    	array_push($titulos,'Total Recibir');
    
    	///Descuentos post-facturacion
    	foreach ($resultado_descuentos_postfacturacion as $value) {
    		array_push($titulos,$value['des_nombre']);
    		array_push($titulos,'Cuotas '.$value['des_nombre']);
    	}
    	///Descuentos post-facturacion MENSUAL
    	foreach ($resultado_descuentos_mensual_postfacturacion_mensual as $value) {
    		array_push($titulos,$value['dem_nombre']);
    	}
    	
    	array_push($titulos,'Descuentos pendientes meses anteriores');
        array_push($titulos,'Descripción descuentos pendientes meses anteriores');
        
        //Sobregiros
        
        $sobregiro_model->reiniciarAbonoSobregirosTodos($mes_inicio);
    	$sobregiros_pendientes=$sobregiro_model->getSobregirosPendientes($mes);
        foreach($sobregiros_pendientes as $sob){
             
            array_push($titulos,'Sobregiro pendiente del mes '.date('m-Y', strtotime($sob['sob_mes'])));
    		array_push($titulos,'Detalle pago sobregiro pendiente '.date('m-Y', strtotime($sob['sob_mes'])));
        }
        
    	///Prestamos
    	//echo '<pre>';print_r($resultado_prestamos_pendientes);echo '</pre>';
    	foreach ($resultado_prestamos_pendientes as $value) {
    		array_push($titulos,$value['pre_nombre']);
    		array_push($titulos,'Cuotas de '.$value['pre_nombre']);
    	}
    
    	array_push($titulos,'Total Descuento Post Fact');
    	array_push($titulos,'Total a Recibir');
    	array_push($titulos,'Sobregiro mes actual');
    
    
        
    	//echo '<pre>';print_r($titulos);echo '</pre>';
    	
    	
    	$punto_venta_model =new Puntoventamodel();
    	
    	
    
    	$datos=[];
    	$i=-1;
    	foreach($resultado_base_comisiones as $rbc) { 
    	    $i++;
    	    $pdv_info=$punto_venta_model->getPuntoventasegunnombre($rbc['trc_nombre_almacen']); 
    	    
    	    $pdv_id=$pdv_info[0]['puv_id'];
    		$total_general=0;
    		//PESADO
    		
    		$datos[$i][0]=$pdv_info[0]['puv_id'];//id
    		$datos[$i][1]=$pdv_info[0]['puv_punto_venta'];//punto venta
    		$datos[$i][2]=$pdv_info[0]['puv_franquiciado'];//Franquiciado
    		$propio='';
    		if($pdv_info[0]['puv_propio']==1){
    			$propio='Propio';
    		}else{
    			$propio='Franquicia';
    		}
    		$datos[$i][3]=$propio;//propio
    		
    		//RESTAMOS LOS VALORES DE COMISION DE NOTAS DE CREDITO A LAS VENTAS
            $rbc['valor_ferreteria_precio_mayor']=$rbc['valor_ferreteria_precio_mayor']-$rbc['nc_valor_ferreteria_precio_mayor'];
            $malCobro = $comisionModel->sinCotizacionMenorPrecio($mes,$pdv_info[0]['puv_punto_venta']);
            //sumamos los valores que se cobraron mal uy no teien comisiones
            if (is_array($malCobro) && !empty($malCobro)) {
                foreach ($malCobro as $m) {
                    // Verifica si $m tiene la clave 'total_transacciones_dia'
                    if (is_array($m) && isset($m['total_transacciones_dia'])) {
                        $rbc['valor_ferreteria_precio_mayor'] += (float) $m['total_transacciones_dia'];
                    } else {
                        log_message('error', 'Estructura inesperada en $malCobro.');
                    }
                }
            } 
            $rbc['comision_cotizacion_ferreteria'] = 0;
                $rbc['comision_cotizacion_pesado'] = 0;
            $cotizaciones = $comisionModel->cotizacionesPDV($mes_aux,$pdv_info[0]['puv_punto_venta']);
            //sumamos los valores que se cobraron mal uy no teien comisiones
            if (is_array($cotizaciones) && !empty($cotizaciones)) {
                foreach ($cotizaciones as $m) {
                    // Verifica si $m tiene la clave 'total_transacciones_dia'
                    if (is_array($m) && isset($m['trc_nombre_almacen'])) {
                        $rbc['comision_cotizacion_ferreteria'] += (float) $m['total_comision_cotizacion_ferreteria'];
                        $rbc['comision_cotizacion_pesado'] += (float) $m['total_comision_cotizacion_pesado'];
                    } else {
                        log_message('error', 'Estructura inesperada en $malCobro.');
                    }
                }
            } else{
                $rbc['comision_cotizacion_ferreteria'] = 0;
                $rbc['comision_cotizacion_pesado'] = 0;
            }
            
            $rbc['valor_pesado_precio_mayor']=$rbc['valor_pesado_precio_mayor']-$rbc['nc_valor_pesado_precio_mayor'];
            $rbc['valor_ferreteria_precio_igual']=$rbc['valor_ferreteria_precio_igual']-$rbc['nc_valor_pesado_precio_igual'];
            $rbc['valor_pesado_precio_igual']=$rbc['valor_pesado_precio_igual']-$rbc['nc_valor_pesado_precio_igual'];
    		
    		$datos[$i][4]=$rbc['valor_ferreteria_precio_mayor'];
    		$datos[$i][5]=$rbc['valor_ferreteria_precio_igual'];
    		$datos[$i][6]=$rbc['valor_pesado_precio_mayor'];
    		$datos[$i][7]=$rbc['valor_pesado_precio_igual'];
    		//$rbc['valor_total_nota_credito']=($rbc['valor_total_nota_credito']*-1);
    		//$datos[$i][8]=$rbc['valor_total_nota_credito'];
    		$total_general=$rbc['valor_ferreteria_precio_mayor']+$rbc['valor_ferreteria_precio_igual']+$rbc['valor_pesado_precio_mayor']+$rbc['valor_pesado_precio_igual'];
    		//$datos[$i][8]=$total_general;
    		$j=8;
    		
    		$ferreteria=0; //preguntasr de donde se obtienen estos datos o si ya no se usa
    		$pesado=0;
    		foreach ($resultado_convenio as $value) {
    			$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($pdv_info[0]['puv_id'],$value['cov_id'],$mes_inicio);
    			$valor_convenio=0;
    			if(!empty($resultado_convenio_porcentaje[0]['cop_valor_vendido'])){
    				$valor_convenio=$resultado_convenio_porcentaje[0]['cop_valor_vendido'];
    			}
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_convenio;
    			if($value['cov_tipo']==1)
    			{
    			    $ferreteria=$ferreteria-$valor_convenio;
    			}
    			else
    			{
    			    $pesado=$pesado-$valor_convenio;
    			}
    			$total_general=$total_general+$valor_convenio;
    		}
    		
    		$j++;
    		$datos[$i][$j]=$total_general;
            
    
    		$total_comision=0;
            
            
            $valorcomision=0;
    		$j++;	
                
                
        
        
        		foreach ($resultado_convenio as $value) {
        			$resultado_convenio_porcentaje=$convenio_porcentaje_model->getconvenioporcentajeid($pdv_info[0]['puv_id'],$value['cov_id'],$mes_inicio);
        			$valor_convenio=0;
        			if(!empty($resultado_convenio_porcentaje[0]['cop_porciento'])){
        				$valor_convenio=$resultado_convenio_porcentaje[0]['cop_porciento'];
        			}
        							
        			$datos[$i][$j]=$valor_convenio;			
        			$total_comision=$total_comision+$valor_convenio;
        			$j=$j+1;
        		}
        
            //RESTAMOS LOS VALORES DE COMISION DE NOTAS DE CREDITO A LAS VENTAS
            $rbc['comision_ferreteria_precio_mayor']=$rbc['comision_ferreteria_precio_mayor']-$rbc['nc_comision_ferreteria_precio_mayor'];
            $rbc['comision_pesado_precio_mayor']=$rbc['comision_pesado_precio_mayor']-$rbc['nc_comision_pesado_precio_mayor'];
            $rbc['comision_ferreteria_precio_igual']=$rbc['comision_ferreteria_precio_igual']-$rbc['nc_comision_ferreteria_precio_igual'];
            $rbc['comision_pesado_precio_igual']=$rbc['comision_pesado_precio_igual']-$rbc['nc_comision_pesado_precio_igual'];
            
            
            $datos[$i][$j]=$rbc['comision_ferreteria_precio_mayor'];$j++;
    		$datos[$i][$j]=$rbc['comision_ferreteria_precio_igual'];$j++;
    		$datos[$i][$j]=$rbc['comision_cotizacion_ferreteria'];$j++;
    		$datos[$i][$j]=$rbc['comision_pesado_precio_mayor'];$j++;
    		$datos[$i][$j]=$rbc['comision_pesado_precio_igual'];$j++;
    		$datos[$i][$j]=$rbc['comision_cotizacion_pesado'];$j++;
    		//$rbc['comision_nota_credito']=$rbc['comision_nota_credito']*-1;
    		//$datos[$i][$j]=$rbc['comision_nota_credito'];
        
        	$total_comision=$rbc['comision_ferreteria_precio_mayor']+$rbc['comision_ferreteria_precio_igual']+$rbc['comision_cotizacion_ferreteria']+$rbc['comision_pesado_precio_mayor']+$rbc['comision_pesado_precio_igual']+$rbc['comision_cotizacion_pesado'] ;
        	
        	
    		foreach ($resultado_post_convenio as $value) {
    			$resultado_post_convenio_valor=$post_convenio_valor_model->getpostconvenioporcentajeid($pdv_info[0]['puv_id'],$value['poc_id'],$mes_inicio);
    			$valor_post_convenio=0;
    			if(!empty($resultado_post_convenio_valor[0]['pcv_valor'])){
    				$valor_post_convenio=$resultado_post_convenio_valor[0]['pcv_valor'];
    			}
    				$j=$j+1;			
    			$datos[$i][$j]=$valor_post_convenio;			
    			$total_comision=$total_comision+$valor_post_convenio;	
    			
    		}
    
            
    		$total_comision=number_format($total_comision, 2, '.', '');
    		$total_recibir_sin_descuentos=$total_comision;
    		$j=$j+1;				
    		$datos[$i][$j]=$total_comision;
   
    		
    		
    		
    		foreach ($resultado_descuentos_prefacturacion as $valuepre) {					
    			$valor_descuento=0;			
    			$cuota_descuento=0;
    			if($valuepre['des_nombre_franquicias']=='Tipo Franquicia'){
    				$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepre['des_nombre_franquicias']);										
    				if(!empty($descuentopresegunpdv)){
    					$valor_descuento=$valuepre['des_valor'];						
    					if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    						$dias_totales=date('t',strtotime($mes_aux));
    						$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    						$dias_cobro=$dias_totales-$dias_inicio;
    
    						$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;
    
    						$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    						$valor_descuento=number_format($valor_descuento, 2, '.', '');
    					}
    					if($pdv_info[0]['puv_propio']==1){
    						$valor_descuento=0;
    					}
    					$mes_cuota=0;
    					$cuotas_totales=0;
    					$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);
    
    					$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);
    
    					if($mes_cuota==0){
    						$valor_descuento=0;
    						$cuota_descuento='';
    					}else{
    					    if($mes_cuota<=$cuotas_totales){
    						$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    					    }
    					    else
    					    {
    					        $cuota_descuento='';
    					    }
    					}
    					
    				}
    
    			}else{
    				if($valuepre['des_nombre_franquicias']=='PDV'){
    					
    					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepre['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepre['des_nombre_franquicias']);
    					if(!empty($descuentopresegunpdv)){
    						$valor_descuento=$valuepre['des_valor'];
    						
    						if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    							$dias_totales=date('t',strtotime($mes_aux));
    							$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    							$dias_cobro=$dias_totales-$dias_inicio;
    
    							$valor_cobro_por_dia=$valuepre['des_valor']/$dias_totales;
    
    							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    							$valor_descuento=number_format($valor_descuento, 2, '.', '');
    						}
    						if($pdv_info[0]['puv_propio']==1){
    							$valor_descuento=0;
    						}
    						$mes_cuota=0;
    						$cuotas_totales=0;
    						$mes_cuota=$this->obtenercuotas($valuepre['des_fecha_desde'],$mes);
    
    						$cuotas_totales=$this->obtenercuotas($valuepre['des_fecha_desde'],$valuepre['des_fecha_hasta']);
    
    						if($mes_cuota==0){
    							$valor_descuento=0;
    							$cuota_descuento='';
    						}else{
    							    if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
    						}
    
    
    					}
    				}
    				
    			}
    
    			if($valuepre['des_frecuencia']=='indefinido'){
    				$cuota_descuento=0;
    			}
    			
     
    			$total_descuentos=$total_descuentos+$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_descuento;
    
    			$j=$j+1;				
    			$datos[$i][$j]=$cuota_descuento;
   
    			
    			
    		}
            
    		foreach ($resultado_descuentos_mensual_prefacturacion_mensual as $value) {
    			$valor_descuento=0;
    			$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($pdv_info[0]['puv_id'],$value['dem_id'],$mes_inicio);
    
    			if(!empty($descuentomensualvalor[0]['dmv_valor'])){
    				$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
    			}
    
    			$total_descuentos=$total_descuentos+$valor_descuento;
    			$j=$j+1;				
    			$datos[$i][$j]=$valor_descuento;
    		}
    
    		$total_descuentos=number_format($total_descuentos, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_descuentos;
     
    		$total_facturar=0;
    		$total_facturar=$total_comision-$total_descuentos;
    		$total_facturar=number_format($total_facturar, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_facturar;
    
    		$iva=0;
    		$iva=$total_facturar*($pdv_info[0]['irp_iva']/100);
    		$iva=number_format($iva, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$iva;
    
    		$total=0;
    		$total=$total_facturar+$iva;
    		$total=number_format($total, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total;
    		
    		$retencion_renta=0;
    		//$retencion_renta=$total_facturar*0.08;
    		$retencion_renta=$total_facturar*($pdv_info[0]['irp_retencion_renta']/100);
    		$retencion_renta=number_format($retencion_renta, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$retencion_renta;
    
    		$retencion_iva=0;
    		//$retencion_iva=$iva*0.7;
    		$retencion_iva=$iva*($pdv_info[0]['irp_retencion_iva']/100);
    		$retencion_iva=number_format($retencion_iva, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$retencion_iva;
    
    		$total_recibir=0;
    		$total_recibir=$total-$retencion_renta-$retencion_iva;
    		$total_recibir=number_format($total_recibir, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_recibir;
    
    		
    		$total_descuentos_post_facturacion=0;
    		
    		$total_descuentos=0;
            //$total_recibir_sin_descuentos=100000000000; // borrar
            
            //OBTIENE LOS DESCUENTOS  PENDIENTES E INTENTA COBRARLES
    		$descuentos_pendientes_meses_anteriores=$descuento_pago_pendiente_model->getCuotasPendienteDescuento($numero_mes, $numero_ano, $pdv_info[0]['puv_id']);
    		//echo '<pre> descuentos pendientes';print_r($descuentos_pendientes_meses_anteriores);echo '</pre>';
    		$detalle_descuento_anterior_cobrado="";
    		$valor_descuento_anterior_cobrado=0;
    		foreach ($descuentos_pendientes_meses_anteriores as $dpma)
    		{
    		    if($total_recibir_sin_descuentos>=$dpma['dpp_valor']){
    		        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$dpma['dpp_valor'];
    		        $detalle_descuento_anterior_cobrado=$detalle_descuento_anterior_cobrado." (".$dpma['des_nombre'].' / '.$dpma['dpp_ano_cobro'].'-'.$dpma['dpp_mes_cobro'].' => '.$dpma['dpp_valor'].")";
    		        $valor_descuento_anterior_cobrado=$valor_descuento_anterior_cobrado+$dpma['dpp_valor'];
    		        $descuento_pago_pendiente_model->pagarDescuentoPendiente($dpma['dpp_id'],$numero_mes, $numero_ano);
    		    }
    		}
    		//echo $detalle_descuento_anterior_cobrado;
    		//echo $valor_descuento_anterior_cobrado;
    		
    		
    		//OBTIENE LOS DESCUENTOS MENSUALES PENDIENTES E INTENTA COBRARLES
    		$descuentos_pendientes_meses_anteriores=$descuento_pago_pendiente_model->getCuotasPendienteDescuentoMensual($numero_mes, $numero_ano, $pdv_info[0]['puv_id']);
    		//echo '<pre> descuentos pendientes mensuales';print_r($descuentos_pendientes_meses_anteriores);echo '</pre>';
    		foreach ($descuentos_pendientes_meses_anteriores as $dpma)
    		{
    		    if($total_recibir_sin_descuentos>=$dpma['dpp_valor']){
    		        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$dpma['dpp_valor'];
    		        $detalle_descuento_anterior_cobrado=$detalle_descuento_anterior_cobrado." (".$dpma['dem_nombre'].' / '.$dpma['dpp_ano_cobro'].'-'.$dpma['dpp_mes_cobro'].' => '.$dpma['dpp_valor'].")";
    		        $valor_descuento_anterior_cobrado=$valor_descuento_anterior_cobrado+$dpma['dpp_valor'];
    		        $descuento_pago_pendiente_model->pagarDescuentoPendiente($dpma['dpp_id'],$numero_mes, $numero_ano);
    		    }
    		}
    		//echo $detalle_descuento_anterior_cobrado;
    		//echo $valor_descuento_anterior_cobrado;
    
    		foreach ($resultado_descuentos_postfacturacion as $valuepost) {
    			$valor_descuento=0;
    			$cuota_descuento=0;
    			if($valuepost['des_nombre_franquicias']=='Tipo Franquicia'){
    				$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepost['des_nombre_franquicias']);
    				if(!empty($descuentopresegunpdv)){
    					$valor_descuento=$valuepost['des_valor'];
    					
    
    					if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    						$dias_totales=date('t',strtotime($mes_aux));
    						$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    						$dias_cobro=$dias_totales-$dias_inicio;
    
    						$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;
    
    						$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    						$valor_descuento=number_format($valor_descuento, 2, '.', '');
    					}
    					if($pdv_info[0]['puv_propio']==1){
    						$valor_descuento=0;
    					}
    					$mes_cuota=0;
    					$cuotas_totales=0;
    					$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);
    
    					$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);
    
    					if($mes_cuota==0){
    						$valor_descuento=0;
    						$cuota_descuento='';
    					}else{
    						if($mes_cuota<=$cuotas_totales){
    						$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
    					    }
    					    else
    					    {
    					        $cuota_descuento='';
    					    }
    					}
    
    					
    				}
    			}else{
    				if($valuepost['des_nombre_franquicias']=='PDV'){
    					$descuentopresegunpdv=$descuento_pdv_tipo_franquicia_model->getDescuentomensualpuvididmes($valuepost['des_id'],$pdv_info[0]['tfc_id'],$pdv_info[0]['puv_id'],$valuepost['des_nombre_franquicias']);
    					if(!empty($descuentopresegunpdv)){
    						$valor_descuento=$valuepost['des_valor'];
    						
    						if(date('Y-m',strtotime($pdv_info[0]['puv_fecha_apertura']))==$mes_aux){
    							$dias_totales=date('t',strtotime($mes_aux));
    							$dias_inicio=date('d',strtotime($pdv_info[0]['puv_fecha_apertura']));
    							$dias_cobro=$dias_totales-$dias_inicio;
    
    							$valor_cobro_por_dia=$valuepost['des_valor']/$dias_totales;
    
    							$valor_descuento=$valor_cobro_por_dia*$dias_cobro;
    
    							$valor_descuento=number_format($valor_descuento, 2, '.', '');
    						}
    						if($pdv_info[0]['puv_propio']==1){
    							$valor_descuento=0;
    						}
    						$mes_cuota=0;
    						$cuotas_totales=0;
    						$mes_cuota=$this->obtenercuotas($valuepost['des_fecha_desde'],$mes);
    
    						$cuotas_totales=$this->obtenercuotas($valuepost['des_fecha_desde'],$valuepost['des_fecha_hasta']);
    
    						if($mes_cuota==0){
    							$valor_descuento=0;
    							$cuota_descuento='';
    						}else{
    							if($mes_cuota<=$cuotas_totales){
        							$cuota_descuento=$mes_cuota.' de '.$cuotas_totales;
        						    }
        						    else
        						    {
        						        $cuota_descuento='';
        						    }
    						}
    					}
    				}
    			}
    
    			if($valuepost['des_frecuencia']=='indefinido'){
    				$cuota_descuento=0;
    			}
    			//antes
    			$total_recibir_sin_descuentos=$total_recibir;
    			if($total_recibir_sin_descuentos>=$valor_descuento){ //echo 'entra';
        			$total_descuentos_post_facturacion=$total_descuentos_post_facturacion+$valor_descuento; 
        			$j=$j+1;				
        			$datos[$i][$j]=$valor_descuento;
        			$j=$j+1;				
        			$datos[$i][$j]=$cuota_descuento;
        			$total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$valor_descuento;
        			$descuento_pago_pendiente_model->updateRegistroCuotaPendienteActualDes($valuepost['des_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano ); 
    			}
    			else
    			{
    			    $j=$j+1;				
        			$datos[$i][$j]=0;
        			$j=$j+1;				
        			$datos[$i][$j]='('.$cuota_descuento.' no pagada, valor a cobrar comisión insuficiente), ';
        			
        			$comprobar_cuota_en_no_pagadas=$descuento_pago_pendiente_model->getCuotaPendienteByDESID($valuepost['des_id'],$numero_mes,$numero_ano);
        			
        			
        			    
        			if($comprobar_cuota_en_no_pagadas[0]['dpp_id']!=''){
        			    foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
            			    $descuento_pago_pendiente_model->updateRegistroAnteriorCuotaPendienteDes($valuepost['des_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano );
                    		$descuento_pago_pendiente_model->insertCuotaPendiente($valuepost['des_id'], NULL,'Valor a cobrar de comisión insuficiente', $valpendiente['dpp_transaccion'], $pdv_info[0]['puv_id'] , $valor_descuento,$numero_mes, $numero_ano);
            			}
        			}
        			else
        			{ 
        			    $descuento_pago_pendiente_model->insertCuotaPendiente($valuepost['des_id'], NULL,'Valor a cobrar de comisión insuficiente', 0, $pdv_info[0]['puv_id'],$valor_descuento,$numero_mes, $numero_ano );

        			}
    			}
    			//echo $total_recibir_sin_descuentos;
    		
    			
    		}
    		
    		
    
    		foreach ($resultado_descuentos_mensual_postfacturacion_mensual as $value) {
    			$valor_descuento=0;
    			$descuentomensualvalor=$descuento_mensual_valor_model->getDescuentomensualpuvididmes($pdv_info[0]['puv_id'],$value['dem_id'],$mes_inicio);
    
    			if(!empty($descuentomensualvalor[0]['dmv_valor'])){
    				$valor_descuento=$descuentomensualvalor[0]['dmv_valor'];
    			}
                
                if($total_recibir_sin_descuentos>=$valor_descuento){
        			$total_descuentos_post_facturacion=$total_descuentos_post_facturacion+$valor_descuento; 
        			$j=$j+1;				
        			$datos[$i][$j]=$valor_descuento;
        			$total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$valor_descuento;
        			$descuento_pago_pendiente_model->updateRegistroCuotaPendienteActualDem($value['dem_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano );
                }
                else{
        			$j=$j+1;				
        			$datos[$i][$j]=$valor_descuento. 'No pagado, comisión insuficiente ';
        			$comprobar_cuota_en_no_pagadas=$descuento_pago_pendiente_model->getCuotaPendienteByDEMID($value['dem_id'],$numero_mes,$numero_ano);
        			if($comprobar_cuota_en_no_pagadas[0]['dpp_id']!=''){
        			    foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
            			    $descuento_pago_pendiente_model->updateRegistroAnteriorCuotaPendienteDem($value['dem_id'],$pdv_info[0]['puv_id'],$numero_mes,$numero_ano );
                    		$descuento_pago_pendiente_model->insertCuotaPendiente(NULL,$value['dem_id'],'Valor a cobrar de comisión insuficiente', $valpendiente['dpp_transaccion'], $pdv_info[0]['puv_id'],$valor_descuento,$numero_mes, $numero_ano );
            			}
        			}
        			else
        			{ 
        			    $descuento_pago_pendiente_model->insertCuotaPendiente(NULL,$value['dem_id'], 'Valor a cobrar de comisión insuficiente', 0,  $pdv_info[0]['puv_id'],$valor_descuento,$numero_mes, $numero_ano );

        			}
                }
    		}
    
            $j=$j+1;				
        	$datos[$i][$j]=$valor_descuento_anterior_cobrado; // para poner los valores de descuentos de meses anteriores
        	$j=$j+1;				
        	$datos[$i][$j]=$detalle_descuento_anterior_cobrado; // para poner los descuentos de meses anteriores
        	
        	
        	//Sobregiros
        	$sobregirosTotal=0;
        	foreach($sobregiros_pendientes as $so){
        	    $sobregiros_puv=$sobregiro_model->getSobregirosPUVID_SOBMES($pdv_info[0]['puv_id'],$so['sob_mes']);
        	    if (!empty($sobregiros_puv)) {
        	        foreach($sobregiros_puv as $sob){
            	        if($total_recibir_sin_descuentos!=0){
            			    if($total_recibir_sin_descuentos>=$sob['sob_saldo']){
            			        $sobregiros=$sobregiro_model->insertarAbonosSobregiros($sob['sob_id'],$mes_inicio,$sob['sob_saldo'],'Abono correspondiente al mes '.$mes);
            			        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$sob['sob_saldo'];
            			        $abono_sobregiro=$sob['sob_saldo'];
            			        $j=$j+1;
                    			$datos[$i][$j]=$abono_sobregiro;
                    			
            			    }else{
            			        $sobregiros=$sobregiro_model->insertarAbonosSobregiros($sob['sob_id'],$mes_inicio,$total_recibir_sin_descuentos,'Abono correspondiente al mes '.$mes);
            			        $abono_sobregiro=$total_recibir_sin_descuentos;
            			        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$total_recibir_sin_descuentos;
            			        $j=$j+1;
                    			$datos[$i][$j]=$abono_sobregiro;
            			    }
            			    $sobregirosTotal+=$abono_sobregiro;
            			    $total_abono_sobregiro=$sob['sob_abono']+$abono_sobregiro;
            			    $saldo_sobregiro=$sob['sob_saldo']-$abono_sobregiro;
            			    $estado_sobregiro=0;
            			    if($saldo_sobregiro===0){
            			        $estado_sobregiro=1;
            			    }
            			    $sobregiro_model->updateSaldos($sob['sob_id'],$total_abono_sobregiro,$saldo_sobregiro,$estado_sobregiro);
            	    		$j=$j+1;
                			$datos[$i][$j]='Saldo sobregiro '.$saldo_sobregiro;
        			    }else{
        			        $j=$j+1;
                    		$datos[$i][$j]=0.00;
        			        $j=$j+1;
                			$datos[$i][$j]='Comisión insuficiente, saldo sobregiro '.$sob['sob_saldo'];
        			    }
        	        }
        	    }
        	    else{
    			        $j=$j+1;
                		$datos[$i][$j]=0.00;
    			        $j=$j+1;
            			$datos[$i][$j]='No tiene sobregiros pendientes en esta fecha';
    			    }
        	}
        	
    		///Prestamos
    		//echo '<pre>';print_r($resultado_prestamos_pendientes);echo '</pre>';
    		//if($pdv_info[0]['puv_id']==113){
    		foreach($resultado_prestamos_pendientes as $value){
    		    $valor_prestamo=0;
    			$cuotas=0;
    			$mesunido=$numero_ano.ltrim($numero_mes); 
    			
    			//echo "//////".$value['pre_nombre']."//////";
    			
    			$datos_prestamo=$prestamo_amortizacion_detalle_model->getCuotasPendientesPrestamoByPDV($value['pre_nombre'],$pdv_info[0]['puv_id'], $numero_mes, $numero_ano);
    			//echo '<pre> cuotas pendientes';print_r($datos_prestamo);echo '</pre>';
    			$datos_prestamo_pagado_pendientes_anteriores=$prestamo_amortizacion_detalle_model->getCuotasPendientesPrestamoByPDVPagadasMesActual($value['pre_nombre'],$pdv_info[0]['puv_id'], $numero_mes, $numero_ano);
    			//echo '<pre> datos_prestamo_pagado_pendientes_anteriores';print_r($datos_prestamo_pagado_pendientes_anteriores);echo '</pre>';
    			$datos_prestamo_pendiente=$prestamo_amortizacion_detalle_model->getCuotasAnterioresPendientesByPRAID($value['pre_nombre'],$pdv_info[0]['puv_id'], $numero_mes, $numero_ano);
    			//echo '<pre> cuotas pendientes anteriores';print_r($datos_prestamo_pendiente);echo '</pre>';
    			$datos_prestamo_pendiente_mes_gracia=$prestamo_amortizacion_detalle_model->getCuotasMesGracia($value['pre_nombre'],$pdv_info[0]['puv_id'],$mesunido);
    			//echo '<pre> cuotas pendientes mes gracia';print_r($datos_prestamo_pendiente_mes_gracia);echo '</pre>';
    			$cuotas='';
    			$result1 = array_merge($datos_prestamo, $datos_prestamo_pagado_pendientes_anteriores, $datos_prestamo_pendiente, $datos_prestamo_pendiente_mes_gracia);

                $uniqueResult = [];
                $prd_ids = [];
                
                foreach ($result1 as $item) {
                    // Si el 'prd_id' no está ya en el array, lo añadimos
                    if (!in_array($item['prd_id'], $prd_ids)) {
                        $prd_ids[] = $item['prd_id'];
                        $uniqueResult[] = $item;
                    }
                }
                
                // Ordenar por 'prd_id'
                usort($uniqueResult, function ($a, $b) {
                    return $a['prd_id'] <=> $b['prd_id']; // Comparación basada en 'prd_id'
                });
                
                $result = $uniqueResult;
    			
    			
    			
    			//echo 'valor disponible '.$total_recibir_sin_descuentos; echo '<pre> union';print_r($result);echo '</pre>';
    			foreach($result as $value_prestamo){ 
    			    $mes_gracia=false;
    			    $cobrar_mes_gracia=false;
    			    
    			    $resultado_mes_gracia=$prestamo_mes_gracia_model->getMesGraciaByPreidMes($value_prestamo['pre_id'],$value_prestamo['prd_mes_estimado'],$value_prestamo['prd_ano_estimado'],$pdv_info[0]['puv_id'],$value_prestamo['prd_id']);
    			    //echo '<pre> Mes gracia cpmprobacion';print_r($resultado_mes_gracia);echo '</pre>';
    			    //echo $numero_ano.$numero_mes;
    			    
    			    
    			    if(!empty($resultado_mes_gracia)){
    			        $mes_gracia=true;
    			        $cuotas_pendientes_sin_mes_gracia=$prestamo_amortizacion_detalle_model->getCuotasPendientesPrestamoSINMesGracia($value['pre_nombre'],$pdv_info[0]['puv_id'], $meg[0]['meg_mes'], $meg[0]['meg_ano']);
                        //echo '<pre> Cuotas pendientes sin mg';print_r($cuotas_pendientes_sin_mes_gracia);echo '</pre>';
                        if(empty($cuotas_pendientes_sin_mes_gracia)){
                            //echo $numero_ano.$numero_mes.'==='.$value_prestamo['pra_id'];
        			        $resultado_cobrar_mes_gracia=$prestamo_mes_gracia_model->getCobrarMesGracia($numero_ano.$numero_mes,$value_prestamo['pra_id']);
        			        //echo '<pre> Comprobar si se cobra';print_r($resultado_cobrar_mes_gracia);echo '</pre>';
        			        if(empty($resultado_cobrar_mes_gracia))
        			        {
        			            $cobrar_mes_gracia=true;
        			            //echo 'Si debe cobrar';
        			        }
    			        }
    			        else
    			        {
    			            //echo 'Hay cuotas pendientes';
    			        }
    			        
    			    }//echo $mes_gracia;
    			    $prestamo_amortizacion_detalle_model->reiniciarPagoCuota($value_prestamo['prd_id']);
        			    $total_recibir_sin_descuentos=floatval($total_recibir_sin_descuentos);
        			    $abonos=($prestamo_abono_cuota_model->getTotalAbonoCuotaPRDID($value_prestamo['prd_id'],$numero_mes,$numero_ano))[0]['saldo'];
        			    
        			   // echo '<pre> Detalle abonos ';print_r($abonos);echo '</pre>';
        			    $valor_cuota=$value_prestamo['prd_cuota_total']-$abonos; //echo 'valor cuota: '.$valor_cuota;
        			    $saldocuota=$value_prestamo['prd_cuota_total']-$abonos;
        			    if($abonos==null){
        			        $abonos=0;
        			    }
        			    $prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],null,null,$abonos,$saldocuota,0);
        			    $prestamo_abono_cuota_model->reiniciarAbonoCuotaPRDID($value_prestamo['prd_id'],$numero_mes,$numero_ano);
        			    //if($pdv_info[0]['puv_id']==108){echo $total_recibir_sin_descuentos.'---'.$valor_cuota.'///';}
        			    //if(($total_recibir_sin_descuentos>=$valor_cuota && $mes_gracia==false)||($total_recibir_sin_descuentos>=$valor_cuota && $cobrar_mes_gracia==true)){
        			    if(($total_recibir_sin_descuentos>0 && $mes_gracia==false)||($total_recibir_sin_descuentos>0 && $cobrar_mes_gracia==true)){
        			        
        			        if($abonos=="")
        			        {
        			            $abonos=0;
        			        }
            			    if($valor_cuota<=$total_recibir_sin_descuentos){ //echo ' valor cuota mayor o igual que valor disponible';
            			        $cuotas.='('.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' cobrada), ';
            			        $valor_prestamo+=$valor_cuota;
            			        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$valor_cuota;
            			        //echo ' </br>queda $'.$total_recibir_sin_descuentos.'</br>';
            			        $abonos+=$valor_cuota;
            			        $saldocuota=$value_prestamo['prd_cuota_total']-$abonos;
            			        $prestamo_abono_cuota_model->insertAbonoCuotaPRDID($value_prestamo['pre_id'],$value_prestamo['pra_id'],$value_prestamo['prd_id'],$numero_mes,$numero_ano,$valor_cuota,$saldocuota,'A');
            			    }
            			    else{//echo ' </br> valor cuota menor que valor disponible';
            			        $valor_prestamo+=$total_recibir_sin_descuentos;
            			        $abonos+=$total_recibir_sin_descuentos;
            			        $saldocuota=$value_prestamo['prd_cuota_total']-$abonos;
            			        
            			        $prestamo_abono_cuota_model->insertAbonoCuotaPRDID($value_prestamo['pre_id'],$value_prestamo['pre_id'],$value_prestamo['prd_id'],$numero_mes,$numero_ano,$total_recibir_sin_descuentos,$saldocuota,'A');
            			        $cuotas.='('.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' cobro parcial $'.$total_recibir_sin_descuentos.' / saldo $'.$saldocuota.'), ';
            			        $total_recibir_sin_descuentos=$total_recibir_sin_descuentos-$total_recibir_sin_descuentos;
            			        //echo ' </br>queda $'.$total_recibir_sin_descuentos.'</br>';
            			    }
            			    //echo '</br> saldo'.$saldocuota;
            			    //echo '</br> abonos'.$abonos;
            			    if($saldocuota==0){//echo '</br>entra en saldo cuota 0';
            			        //Registrar pago cuota
                			    $prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],$numero_mes,$numero_ano,$abonos,$saldocuota,1);
                			    $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']);
                			    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
                			        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
                			            $prestamo_pago_pendiente_model->pagarCuotaPendiente($valpendiente['ppp_id'],$numero_mes,$numero_ano);
                			        }
                			    }
            			    }
            			    else{
            			        //echo '</br> entra en saldo cuota mayor a 0';
            			        $prestamo_amortizacion_detalle_model->insertAbonoCuota($value_prestamo['prd_id'],null,null,$abonos,$saldocuota,2);
            			        $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']); 
                			    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
                			        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){//echo 'Hace update';
                			            $prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($value_prestamo['prd_id'],'Pago parcial $ '.$abonos.' / saldo $'.$saldocuota, $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'],3);
                			        }
                			    }
                			    else
                			    {   $prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Pago parcial $ '.$abonos.' / saldo $'.$saldocuota, 0, $value_prestamo['puv_id'],3 );
                			        
                			    }
            			    
            			        
            			        
            			    }//die();
        			    }
        			    else
        			    {
        			        
        			        
        			        //Registrar observacion no pago cuota
        			        if($mes_gracia==false){
            			        $prestamo_amortizacion_detalle_model->insertarMotivoNoPagoCuota($value_prestamo['prd_id'],'Valor a cobrar de comisión insuficiente',0);
            			        $cuotas.='('.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' valor a cobrar comisión insuficiente), ';
        			        }
        			        else{
        			            $cuotas.='('.$value_prestamo['prd_numero_cuota']." de ".$value_prestamo['pre_cuotas'].' no cobrada mes, de gracia: '.$resultado_mes_gracia[0]['meg_motivo'].'),';
        			            $prestamo_amortizacion_detalle_model->insertarMotivoNoPagoCuota($value_prestamo['prd_id'],'Mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'],0);
        			        }
            			    $comprobar_cuota_en_no_pagadas=$prestamo_pago_pendiente_model->getCuotaPendienteByPRDID($value_prestamo['prd_id']);
            			    if($comprobar_cuota_en_no_pagadas[0]['ppp_id']!=''){
            			        foreach($comprobar_cuota_en_no_pagadas as $valpendiente){
            			            if($mes_gracia==false){
                			            $prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($value_prestamo['prd_id'],'Valor a cobrar de comisión insuficiente', $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'],0);
                			           // $prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Valor a cobrar de comisión insuficiente', $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'] );
            			            }
            			            else
            			            {
            			                $prestamo_mes_gracia_model->otorgarMesGracia($mes_gracia[0]['meg_id']);
            			                //$prestamo_pago_pendiente_model->updateRegistroAnteriorCuotaPendiente($value_prestamo['prd_id']);
                			            //$prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'], $valpendiente['ppp_transaccion'], $value_prestamo['puv_id'] );
            			            }
            			        }
            			    }
            			    else
            			    {
            			        if($mes_gracia==false){
            			            $prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'4Valor a cobrar de comisión insuficiente', 0, $value_prestamo['puv_id'],0 );
            			        }
            			        else{
            			            //$prestamo_pago_pendiente_model->insertCuotaPendiente($value_prestamo['pre_id'], $value_prestamo['pra_id'], $value_prestamo['prd_id'],'Mes de gracia: '.$resultado_mes_gracia[0]['meg_motivo'], 0, $value_prestamo['puv_id'] );
            			            $prestamo_mes_gracia_model->otorgarMesGracia($mes_gracia[0]['meg_id']);
            			        }
            			    }
        			    }
    			    //echo $mes_gracia[0]['meg_id'];
    			    
    			        
    			    
    			
    			   // echo 'valor disponible '.$total_recibir_sin_descuentos;
    			}
    			    
    			
    			$j=$j+1;
    			$datos[$i][$j]=$valor_prestamo;
    			//echo $valor_prestamo;
    			$j=$j+1;
    			$datos[$i][$j]='Cuota '.$cuotas;
    			$total_descuentos_post_facturacion=$total_descuentos_post_facturacion+$valor_prestamo;
    			//echo $total_descuentos_post_facturacion;
    		}
    		
            $total_descuentos_post_facturacion+=$sobregirosTotal;
    		$total_descuentos_post_facturacion=number_format($total_descuentos_post_facturacion, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_descuentos_post_facturacion;
    
    		$total_recibir_post_facturacion=0;
    		$total_recibir_post_facturacion=$total_recibir-$total_descuentos_post_facturacion;
    		//echo '<pre> total recibir post'.$total_recibir_post_facturacion.'</pre>';
    		$total_recibir_post_facturacion=number_format($total_recibir_post_facturacion, 2, '.', '');
    		$j=$j+1;				
    		$datos[$i][$j]=$total_recibir_post_facturacion;
    		//echo '<pre> total recibir post2'.$total_recibir_post_facturacion.'</pre>';
    		$val_sobregiro=0; 
			if($total_facturar<0){
			    //$val_sobregiro=$total_transferir;
			    $val_sobregiro=$total_facturar;
			    $sobregiro_model->insertar($pdv_info[0]['puv_id'],$val_sobregiro*-1,'Sobregiro correspondiente al mes '.$mes_aux,$mes_inicio);
			}
			$j=$j+1;				
    		$datos[$i][$j]=$val_sobregiro;
            
    	}
    	
    	$nuevos_datos=[];
    	
    	foreach ($titulos as $key => $value) {
    		$nuevos_datos[0][$key]=$value;
    	}
    	$nuevos_datos[0][sizeof($titulos)]=0;
    	$imprimir_datos_csv=array_merge($nuevos_datos,$datos);
    	
    	
    	$titulos=json_encode($titulos,JSON_UNESCAPED_UNICODE);
    	$datos=json_encode($datos,JSON_UNESCAPED_UNICODE);
    	
    
    	$enviar_datos=array(
    		'titulos'=>$titulos,
    		'datos'=>$datos,
    		'imprimir_datos_csv'=>$imprimir_datos_csv,
    		'mes'=>$mes_aux,
    		'finalizado'=>false,
    		'tipo'=>$tipo
    	);
    	//print_r($enviar_datos);
    	return $enviar_datos;
        }		
        		
	}
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	
	
	
	
	

}
