<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Tipofranquiciacomisionesmodel;

class Tipofranquiciacomisiones extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$tipo_franquicia_comisiones_model= new Tipofranquiciacomisionesmodel();
    		$datos_tipo_franquicia_comisiones=$tipo_franquicia_comisiones_model->getTipofranquiciacomisiones();
    
    		$enviar_datos=array(
    			'datos_tipo_franquicia_comisiones' => !empty($datos_tipo_franquicia_comisiones)?$datos_tipo_franquicia_comisiones:[] , 
    		);
    
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("tipofranquiciacomisiones/list",$enviar_datos);
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipo_franquicia_comisiones_model= new Tipofranquiciacomisionesmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('tipo'))){
				$tfc_nombre=$this->request->getPost('tipo');
				$ingresar_datos=array(
					'tfc_nombre'=>$tfc_nombre,
					'tfc_estado'=>1
				);
				$tipo_franquicia_comisiones_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$tipo_franquicia_comisiones_model= new Tipofranquiciacomisionesmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('edittipo')) && !empty($this->request->getPost('edittfcid'))){
				$tfc_nombre=$this->request->getPost('edittipo');
				$tfc_id=$this->request->getPost('edittfcid');
				$editar_datos=array(
					'tfc_nombre'=>$tfc_nombre,
					'tfc_estado'=>1
				);
				$tipo_franquicia_comisiones_model->actualizar($tfc_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$tipo_franquicia_comisiones_model= new Tipofranquiciacomisionesmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tfc_estado'=>0
				);
				$tipo_franquicia_comisiones_model->actualizar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Se ha inactivado el registro');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function activar($id){		
		
		$session = \Config\Services::session();
		$tipo_franquicia_comisiones_model= new Tipofranquiciacomisionesmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tfc_estado'=>1
				);
				$tipo_franquicia_comisiones_model->actualizar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Se ha activado el registro');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipofranquiciacomisiones')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}