<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Basecomisionesmodel;
use App\Models\Conveniomodel;
use App\Models\Convenioporcentajemodel;
use App\Models\Descuentosmodel;
use App\Models\Prestamosmodel;
use App\Models\Puntoventamodel;
use App\Models\Ventamodel;
use App\Models\Postconveniomodel;
use App\Models\Postconveniovalormodel;
class Ventas extends BaseController
{

	public function index(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("venta/fechasventa");
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	public function ventasmes(){
		$session = \Config\Services::session();
		$datos = $this->datosMenu();
		if(empty($this->request->getPost('mes'))){
			$session->setFlashdata('mensaje_malo', 'seleccione el mes');
			return redirect()->to(base_url('Ventas'));
		}

		$mes=$this->request->getPost('mes');
		$venta_model=new Ventamodel();
		$respuesta=$venta_model->getVentaspormes($mes);
		if(empty($respuesta)){
			$session->setFlashdata('mensaje_malo', 'No hay datos del mes seleccionado');
			return redirect()->to(base_url('Ventas'));
		}
		$enviar_datos=array(
			'datos_venta'=>$respuesta,
			'mes'=>$mes,
		);
		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("venta/list",$enviar_datos);
		echo view("layouts/footer");
	}

	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}

	public function fechasreporteventa(){
		$datos_menu = $this->datosMenu();		
		echo view("layouts/header");
		echo view("layouts/aside",$datos_menu);
		echo view("venta/fechareporteventa");
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		$mes='';
		if(!empty($this->request->getPost('mes'))){
			$mes= $this->request->getPost('mes');
		}

		

		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('Hoja1');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "Hoja1"');
				return redirect()->to(base_url('Ventas/fechasreporteventa'));
			}    

			$data=[];

			$pdv_no_encontrados='';

			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=5; $row<=$highestRow; $row++)				
				{

					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
					$fechacontable = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
					if($pdv=='(en blanco)' && $fechacontable=='(en blanco)'){
						break;
					}
					
					if(!empty($fechacontable) && $fechacontable!='(en blanco)'){
						$fechacontable = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fechacontable);  
						$fechacontable =$fechacontable->format('Y-m-d');						

						$sum_ventas_netas = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						$sum_iva = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue(); 
						if($sum_iva==''||$sum_iva==' '){
						    $sum_iva=0;
						}
						$sum_total = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();	
						if($sum_total==''||$sum_total==' '){
						    $sum_total=0;
						}
						$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
						$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

						if($puv_id!=0){						
							$data[]=array(						
								'puv_id'=>$puv_id,
								'pdv'=>$pdv,
								'fechacontable'=>$fechacontable,
								'sum_ventas_netas'=>$sum_ventas_netas,
								'sum_iva'=>$sum_iva,
								'sum_total'=>$sum_total,													
							);
						}else{
							$pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
						}
					}else{
						$sum_ventas_netas = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						$sum_iva = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						if($sum_iva==''||$sum_iva==' '){
						    $sum_iva=0;
						}
						$sum_total = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();		
						if($sum_total==''||$sum_total==' '){
						    $sum_total=0;
						}
						$puv_id=$data[sizeof($data)-1]['puv_id'];						
						$data[]=array(						

							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'fechacontable'=>$fechacontable,
							'sum_ventas_netas'=>$sum_ventas_netas,
							'sum_iva'=>$sum_iva,
							'sum_total'=>$sum_total,													
						);
					}

				}
				break;
			}			
			
			$datos = $this->datosMenu();
			$enviar_datos=array(            
				'data'=>$data,
				'mensaje'=>$pdv_no_encontrados,
				'mes'=>$mes,
			);

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("venta/tabla",$enviar_datos);
			echo view("layouts/footer");
		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Ventas/fechasreporteventa')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();
		if(!empty($this->request->getPost('datos')) && !empty($this->request->getPost('mes'))){
			$venta_model=new Ventamodel();
			$datos =$this->request->getPost('datos');
			$mes =$this->request->getPost('mes');			           
			echo '<pre>'; print_r($mes); echo '</pre>';
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);	

			foreach ($datos as $value) {
				if(empty($value['fechacontable'])){
					$value['fechacontable']='0000-00-00';
				}
				$datos_venta=array(				
					'puv_id'=>$value['puv_id'],
					'puv_punto_venta_nombre'=>$value['pdv'],
					'ven_fecha_contable'=>$value['fechacontable'],
					'ven_venta_neta'=>$value['sum_ventas_netas'],
					'ven_iva'=>$value['sum_iva'],
					'ven_total'=>$value['sum_total'],
					'ven_mes'=>$mes,
				);				
				$venta_model->insertar($datos_venta); 
			}		
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Ventas/fechasreporteventa')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Ventas/fechasreporteventa')); 
		}

	}
	public function edit(){
		$session = \Config\Services::session();
		if(!empty($this->request->getPost('venid')) && !empty($this->request->getPost('venta')) && !empty($this->request->getPost('iva'))  && !empty($this->request->getPost('total'))){
			$venta_model=new Ventamodel();
			
			$ven_id=$this->request->getPost('venid');
			$ven_venta_neta=$this->request->getPost('venta');
			$ven_iva=$this->request->getPost('iva');
			$ven_total=$this->request->getPost('total');
			
			$datos_venta=array(			
				'ven_venta_neta'=>$ven_venta_neta,
				'ven_iva'=>$ven_iva,
				'ven_total'=>$ven_total,
			);				
			$venta_model->actualizar($ven_id,$datos_venta);

			$session->setFlashdata('mensaje_bueno', 'Dato Actualizado');
			return redirect()->to(base_url('Ventas')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Faltan datos');
			return redirect()->to(base_url('Ventas')); 
		}

	}
	public function eliminar(){
		$session = \Config\Services::session();
		if(!empty($this->request->getPost('meseliminar'))){
			$venta_model=new Ventamodel();
			
			
			$ven_mes=$this->request->getPost('meseliminar');			
			
							
			$venta_model->eliminarpormes($ven_mes);

			$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
			return redirect()->to(base_url('Ventas')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Ventas')); 
		}

	}

	


}