<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Comisionmodel extends Model
{
    public function getComision()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision');
        $builder->select('tbl_comision.*');    
        $builder->where('tbl_comision.com_estado', 1);
        $builder->where('tbl_comision.com_titulo', 1);
        $builder->where('tbl_comision.com_comision_general', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getComisionGrupoPorcentajeBYPUV_ID($puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision');
        $builder->select('tbl_comision.*,tbl_comision_grupo_porcentaje.*');   
        $builder->join('tbl_comision_grupo_porcentaje','tbl_comision_grupo_porcentaje.com_id=tbl_comision.com_id');
        $builder->join('tbl_comision_grupo','tbl_comision_grupo_porcentaje.cog_id=tbl_comision_grupo.cog_id');
        $builder->join('tbl_punto_venta','tbl_punto_venta.cog_id=tbl_comision_grupo.cog_id');
        $builder->where('tbl_comision.com_estado', 1);
        $builder->where('tbl_comision_grupo_porcentaje.cgp_estado', 1);
        $builder->where('tbl_comision.com_titulo', 0);
        $builder->where('tbl_punto_venta.puv_id', $puv_id);
        $builder->where('tbl_comision.com_comision_general', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getComisionGeneralBYPUV_ID($puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision');
        $builder->select('tbl_comision.*,tbl_comision_grupo_porcentaje.*');   
        $builder->join('tbl_comision_grupo_porcentaje','tbl_comision_grupo_porcentaje.com_id=tbl_comision.com_id');
        $builder->join('tbl_comision_grupo','tbl_comision_grupo_porcentaje.cog_id=tbl_comision_grupo.cog_id');
        $builder->join('tbl_punto_venta','tbl_punto_venta.cog_id=tbl_comision_grupo.cog_id');
        $builder->where('tbl_comision.com_estado', 1);
        $builder->where('tbl_comision_grupo_porcentaje.cgp_estado', 1);
        $builder->where('tbl_comision.com_titulo', 0);
        $builder->where('tbl_punto_venta.puv_id', $puv_id);
        $builder->where('tbl_comision.com_comision_general', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getGrupos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_grupo');
        $builder->select('tbl_comision_grupo.*');    
        $builder->where('tbl_comision_grupo.cog_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getComisionGrupoPorcentajeBYCOG_ID($cog_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision');
        $builder->select('tbl_comision.*,tbl_comision_grupo_porcentaje.*,tbl_comision_grupo.cog_nombre,tbl_comision_grupo.cog_observacion,');   
        $builder->join('tbl_comision_grupo_porcentaje','tbl_comision_grupo_porcentaje.com_id=tbl_comision.com_id');
        $builder->join('tbl_comision_grupo','tbl_comision_grupo_porcentaje.cog_id=tbl_comision_grupo.cog_id');
        $builder->where('tbl_comision.com_estado', 1);
        $builder->where('tbl_comision_grupo_porcentaje.cgp_estado', 1);
        $builder->where('tbl_comision.com_titulo', 0);
        $builder->where('tbl_comision_grupo_porcentaje.cog_id', $cog_id);
        //$builder->where('tbl_comision.com_comision_general', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPuntosdeVentaporGrupos($cog_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_grupo');
        $builder->select('tbl_comision_grupo.cog_nombre,tbl_comision_grupo.cog_observacion,tbl_punto_venta.*');   
        $builder->join('tbl_punto_venta','tbl_comision_grupo.cog_id=tbl_punto_venta.cog_id');   
        $builder->where('tbl_comision_grupo.cog_id', $cog_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function insertarGrupo($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_grupo');
        $builder->set($data);
		$builder->insert();
        
        $builder = $db->table('tbl_comision_grupo');
        $builder->selectMax('tbl_comision_grupo.cog_id');   
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function insertarComisionGrupoPorcentaje($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_grupo_porcentaje');
        $builder->set($data);
		$builder->insert();
    }
    
    public function actualizarComisionGrupo($cog_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_grupo');
        $builder->where('tbl_comision_grupo.cog_id', $cog_id);
		return $builder->update($data);        
    }
    public function actualizarComisionGrupoPorcentaje($cog_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_grupo_porcentaje');
        $builder->where('tbl_comision_grupo_porcentaje.cog_id', $cog_id);
		return $builder->update($data);        
    }
    
   public function actualizar($com_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision');
        $builder->where('tbl_comision.com_id', $com_id);
		return $builder->update($data);        
    }

}