<?php

namespace App\Models;

use CodeIgniter\Model;
use Exception;

class Comisionmodelfinal extends Model
{
    protected $table = 'transaccion_cabecera'; // Tabla principal
    protected $primaryKey = 'trc_id'; // Llave primaria
    protected $returnType = 'array';

    // Obtener comisiones por mes agrupadas por punto de venta
    public function calcularComisionesPorMes($mes)
    {
        $db = \Config\Database::connect('postgres'); // Conexión a la base de datos

        try {
            // Preparar la fecha de inicio y fin del mes
            $inicioMes = $mes . '-01 00:00:00'; // Ejemplo: 2024-08-01
            $proximoMes = date('Y-m-d', strtotime($inicioMes . ' +1 month'));
            $finMes = date('Y-m-t', strtotime($inicioMes)).' 23:59:59'; // Último día del mes

            // Preparar la consulta SQL
            $sql = "WITH pagos_tarjeta AS (
    -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
    SELECT 
        trp_secuencial, 
        trp_nombre_almacen,
        bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD','DE_UNA')) AS es_tarjeta
    FROM 
        transaccion_pago
    GROUP BY 
        trp_secuencial, trp_nombre_almacen
)
SELECT 
    tc.trc_nombre_almacen,

    -- Sumas de valores y comisiones
    SUM(
        CASE 
            WHEN td.trd_es_pesado = false AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal 
            ELSE 0 
        END
    ) AS valor_ferreteria_precio_mayor,

    SUM(CASE 
        WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
        THEN ROUND(((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80, 4)
        ELSE 0 
    END) AS comision_ferreteria_precio_mayor,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = false AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal  
            ELSE 0 
        END
    ) AS valor_ferreteria_precio_igual,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) * td.trd_cantidad_venta * 0.005, 4)
            ELSE 0 
        END
    ) AS comision_ferreteria_precio_igual,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal  
            ELSE 0 
        END
    ) AS valor_pesado_precio_mayor,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80, 4)
            ELSE 0 
        END
    ) AS comision_pesado_precio_mayor,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal 
            ELSE 0 
        END
    ) AS valor_pesado_precio_igual,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) * td.trd_cantidad_venta * 0.0025, 4)
            ELSE 0 
        END
    ) AS comision_pesado_precio_igual,

    -- Suma total de comisiones
    SUM(
        ROUND(
            CASE 
                WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80
                WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9) * td.trd_cantidad_venta * 0.005, 4)
                WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80
                WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9) * td.trd_cantidad_venta * 0.0025, 4)
                ELSE 0
            END, 4
        )
    ) AS total_comision
FROM 
    transaccion_cabecera tc
JOIN 
    transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
LEFT JOIN 
     pagos_tarjeta pt ON tc.trc_secuencial = pt.trp_secuencial AND tc.trc_nombre_almacen = pt.trp_nombre_almacen
WHERE 
    tc.trc_fecha_transaccion >= '$inicioMes' AND
    tc.trc_fecha_transaccion <= '$finMes'
    AND NOT EXISTS (
        SELECT 1
        FROM cotizacion_cabecera ctc
        WHERE ctc.trc_secuencial = tc.trc_secuencial
          AND ctc.ctc_dni_cliente = tc.trc_dni_cliente
    )
GROUP BY 
    tc.trc_nombre_almacen;

            ";

            // Ejecutar la consulta
            $query = $db->query($sql);
            // Obtener el resultado
            $result = $query->getResultArray();

            // Verificar si la consulta ha retornado resultados
            if (empty($result)) {
                throw new Exception('No se encontraron registros para el mes especificado.');
            }

            return $result;

        } catch (Exception $e) {
            return '' . $e->getMessage();
        }
    }
    
    public function calcularComisionesPorMesPDV($mes, $almacen)
    {
        $db = \Config\Database::connect('postgres'); // Conexión a la base de datos
    
        try {
            // Preparar la fecha de inicio y fin del mes
            $inicioMes = $mes . '-01 00:00:00'; // Ejemplo: 2024-08-01// Ejemplo: 2024-08-01
            $finMes = date('Y-m-t', strtotime($inicioMes)).' 23:59:59'; // Último día del mes
            $proximoMes = date('Y-m-d', strtotime($inicioMes . ' +1 month'));
            
            // Preparar la consulta SQL
            $sql = "WITH pagos_tarjeta AS (
    -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
    SELECT 
        trp_secuencial, 
        trp_nombre_almacen,
        bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD','DE_UNA')) AS es_tarjeta
    FROM 
        transaccion_pago
    GROUP BY 
        trp_secuencial, trp_nombre_almacen
)
SELECT 
    tc.trc_nombre_almacen,

    -- Sumas de valores y comisiones
    SUM(
        CASE 
            WHEN td.trd_es_pesado = false AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal 
            ELSE 0 
        END
    ) AS valor_ferreteria_precio_mayor,

    SUM(CASE 
        WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
        THEN ROUND(((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80, 4)
        ELSE 0 
    END) AS comision_ferreteria_precio_mayor,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = false AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal  
            ELSE 0 
        END
    ) AS valor_ferreteria_precio_igual,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) * td.trd_cantidad_venta * 0.005, 4)
            ELSE 0 
        END
    ) AS comision_ferreteria_precio_igual,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal  
            ELSE 0 
        END
    ) AS valor_pesado_precio_mayor,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80, 4)
            ELSE 0 
        END
    ) AS comision_pesado_precio_mayor,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN td.trd_subtotal 
            ELSE 0 
        END
    ) AS valor_pesado_precio_igual,

    SUM(
        CASE 
            WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
            THEN ROUND(ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) * td.trd_cantidad_venta * 0.0025, 4)
            ELSE 0 
        END
    ) AS comision_pesado_precio_igual,

    -- Suma total de comisiones
    SUM(
        ROUND(
            CASE 
                WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80
                WHEN td.trd_es_pesado = false AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9) * td.trd_cantidad_venta * 0.005, 4)
                WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ((ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) - ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)) * td.trd_cantidad_venta) * 0.80
                WHEN td.trd_es_pesado = true AND td.trd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales) AND ROUND(td.trd_precio_venta / CASE WHEN pt.es_tarjeta THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9), 4)
                THEN ROUND(COALESCE(NULLIF(td.trd_precio_base, 0), td.trd_precio_venta * 0.9) * td.trd_cantidad_venta * 0.0025, 4)
                ELSE 0
            END, 4
        )
    ) AS total_comision
FROM 
    transaccion_cabecera tc
JOIN 
    transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
LEFT JOIN 
     pagos_tarjeta pt ON tc.trc_secuencial = pt.trp_secuencial AND tc.trc_nombre_almacen = pt.trp_nombre_almacen
WHERE 
    tc.trc_fecha_transaccion >= '$inicioMes' AND
    tc.trc_fecha_transaccion <= '$finMes'
    AND NOT EXISTS (
        SELECT 1
        FROM cotizacion_cabecera ctc
        WHERE ctc.trc_secuencial = tc.trc_secuencial
          AND ctc.ctc_dni_cliente = tc.trc_dni_cliente
    )
    AND tc.trc_nombre_almacen = '$almacen'
GROUP BY 
    tc.trc_nombre_almacen;

            ";
    
            // Ejecutar la consulta con el parámetro de almacén
            $query = $db->query($sql);
   // echo $db->getLastQuery();die();
            // Obtener el resultado
            $result = $query->getResultArray();
            // Verificar si la consulta ha retornado resultados
            if (empty($result)) {
                throw new Exception('No se encontraron registros para el mes especificado.');
            }
    
            return $result;
    
        } catch (Exception $e) {
            return '' . $e->getMessage();
        }
    }
    
    public function calcularNotasCreditoPorMes($mes)
    {
        $db = \Config\Database::connect('postgres'); // Conexión a la base de datos
    
        try {
            // Preparar la fecha de inicio y fin del mes
            $inicioMes = $mes . '-01 00:00:00'; // Ejemplo: 2024-08-01
            $finMes = date('Y-m-t', strtotime($inicioMes)).' 23:59:59'; // Último día del mes
    
            // Preparar la consulta SQL
            $sql = "WITH pagos_tarjeta AS (
    -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
    SELECT 
        trp_secuencial, 
        trp_nombre_almacen,
        bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD', 'DE_UNA')) AS es_tarjeta
    FROM 
        transaccion_pago
    GROUP BY 
        trp_secuencial, trp_nombre_almacen
)
SELECT 
    ncc.ncc_nombre_almacen,
    bool_or(COALESCE(pt.es_tarjeta, false)) AS es_tarjeta, -- Indicador consolidado de si alguna transacción fue con tarjeta

    -- Valor de devolución de productos de ferretería con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_ferreteria_precio_mayor,

    -- Comisión de devolución de productos de ferretería con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
               - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
        ELSE 0
    END) AS nc_comision_ferreteria_precio_mayor,

    -- Valor de devolución de productos pesados con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_pesado_precio_mayor,

    -- Comisión de devolución de productos pesados con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
               - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
        ELSE 0
    END) AS nc_comision_pesado_precio_mayor,

    -- Valor de devolución de productos de ferretería con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_ferreteria_precio_igual,

    -- Comisión de devolución de productos de ferretería con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.005
        ELSE 0
    END) AS nc_comision_ferreteria_precio_igual,

    -- Valor de devolución de productos pesados con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_pesado_precio_igual,

    -- Comisión de devolución de productos pesados con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.0025
        ELSE 0
    END) AS nc_comision_pesado_precio_igual,

    -- Comisión total
    SUM(
        CASE 
            WHEN ncd.ncd_es_pesado = false AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                   - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
            WHEN ncd.ncd_es_pesado = true AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                   - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
            WHEN ncd.ncd_es_pesado = false AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.005
            WHEN ncd.ncd_es_pesado = true AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.0025
            ELSE 0
        END
    ) AS nc_total_comision

FROM 
    nota_credito_cabecera ncc
JOIN 
    nota_credito_detalle ncd ON ncc.ncc_id = ncd.ncd_id_cabecera
LEFT JOIN 
    pagos_tarjeta pt ON ncc.ncc_secuencial_fv = pt.trp_secuencial AND ncc.ncc_nombre_almacen = pt.trp_nombre_almacen
WHERE 
    ncc.ncc_fecha_transaccion_nc BETWEEN '$inicioMes' AND '$finMes'
GROUP BY 
    ncc.ncc_nombre_almacen
ORDER BY 
    ncc.ncc_nombre_almacen;


";
    
            // Ejecutar la consulta con el parámetro de almacén
            $query = $db->query($sql, [$almacen]);
    
            // Obtener el resultado
            $result = $query->getResultArray();
    
            // Verificar si la consulta ha retornado resultados
            if (empty($result)) {
                throw new Exception('No se encontraron registros para el mes especificado.');
            }
    
            return $result;
    
        } catch (Exception $e) {
            return '' . $e->getMessage();
        }
    }
    
    public function calcularNotasCreditoPorMesPDV($mes,$almacen)
    {
        $db = \Config\Database::connect('postgres'); // Conexión a la base de datos
    
        try {
            // Preparar la fecha de inicio y fin del mes
            $inicioMes = $mes . '-01 00:00:00'; // Ejemplo: 2024-08-01
            $finMes = date('Y-m-t', strtotime($inicioMes)).' 23:59:59'; // Último día del mes
            // Preparar la consulta SQL
            $sql = "WITH pagos_tarjeta AS (
    -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
    SELECT 
        trp_secuencial, 
        trp_nombre_almacen,
        bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD', 'DE_UNA')) AS es_tarjeta
    FROM 
        transaccion_pago
    GROUP BY 
        trp_secuencial, trp_nombre_almacen
)
SELECT 
    ncc.ncc_nombre_almacen,
    bool_or(COALESCE(pt.es_tarjeta, false)) AS es_tarjeta, -- Indicador consolidado de si alguna transacción fue con tarjeta

    -- Valor de devolución de productos de ferretería con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_ferreteria_precio_mayor,

    -- Comisión de devolución de productos de ferretería con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
               - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
        ELSE 0
    END) AS nc_comision_ferreteria_precio_mayor,

    -- Valor de devolución de productos pesados con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_pesado_precio_mayor,

    -- Comisión de devolución de productos pesados con precio de venta mayor al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
               - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
        ELSE 0
    END) AS nc_comision_pesado_precio_mayor,

    -- Valor de devolución de productos de ferretería con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_ferreteria_precio_igual,

    -- Comisión de devolución de productos de ferretería con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = false 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.005
        ELSE 0
    END) AS nc_comision_ferreteria_precio_igual,

    -- Valor de devolución de productos pesados con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN ncd.ncd_subtotal
        ELSE 0
    END) AS nc_valor_pesado_precio_igual,

    -- Comisión de devolución de productos pesados con precio de venta igual al precio base
    SUM(CASE 
        WHEN ncd.ncd_es_pesado = true 
             AND ncd.ncd_codigo_referencia NOT IN (SELECT cop_codigo_referencia FROM codigos_promocionales)
             AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
        THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.0025
        ELSE 0
    END) AS nc_comision_pesado_precio_igual,

    -- Comisión total
    SUM(
        CASE 
            WHEN ncd.ncd_es_pesado = false 
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                   - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
            WHEN ncd.ncd_es_pesado = true 
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) > ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN ((ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) 
                   - ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)) * ncd.ncd_cantidad) * 0.80
            WHEN ncd.ncd_es_pesado = false 
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.005
            WHEN ncd.ncd_es_pesado = true 
                 AND ROUND(ncd.ncd_precio_venta / CASE WHEN COALESCE(pt.es_tarjeta, false) THEN 1.035 ELSE 1 END, 4) = ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4)
            THEN (ROUND(COALESCE(NULLIF(ncd.ncd_precio_base, 0), ncd.ncd_precio_venta * 0.9), 4) * ncd.ncd_cantidad) * 0.0025
            ELSE 0
        END
    ) AS nc_total_comision

FROM 
    nota_credito_cabecera ncc
JOIN 
    nota_credito_detalle ncd ON ncc.ncc_id = ncd.ncd_id_cabecera
LEFT JOIN 
    pagos_tarjeta pt ON ncc.ncc_secuencial_fv = pt.trp_secuencial AND ncc.ncc_nombre_almacen = pt.trp_nombre_almacen
WHERE 
    ncc.ncc_fecha_transaccion_nc BETWEEN '$inicioMes' AND '$finMes'
    and ncc.ncc_nombre_almacen='$almacen'
GROUP BY 
    ncc.ncc_nombre_almacen
ORDER BY 
    ncc.ncc_nombre_almacen;



";
    
            // Ejecutar la consulta con el parámetro de almacén
            $query = $db->query($sql, [$almacen]);
    
            // Obtener el resultado
            $result = $query->getResultArray();
    
            // Verificar si la consulta ha retornado resultados
            if (empty($result)) {
                //throw new Exception('No se encontraron registros para el mes especificado.');
            }
    
            return $result;
    
        } catch (Exception $e) {
            return '' . $e->getMessage();
        }
    }
    
    
      public function ventasDiariasPDV($mes, $almacen) {
          $db = \Config\Database::connect('postgres'); // Conexión a la base de datos
    $inicioMes = $mes . '-01 00:00:00'; // Ejemplo: 2024-08-01
    $finMes = date('Y-m-t', strtotime($inicioMes)).' 23:59:59';
    
    $sql = "
        SELECT 
            DATE(tc.trc_fecha_transaccion) AS fecha,
            tc.trc_nombre_almacen,
            SUM(td.trd_subtotal) AS total_transacciones_dia
        FROM 
            public.transaccion_cabecera tc
        INNER JOIN 
            public.transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
        WHERE 
            tc.trc_fecha_transaccion BETWEEN ? AND ?
            AND tc.trc_nombre_almacen = ?
        GROUP BY 
            fecha, 
            tc.trc_nombre_almacen
        ORDER BY 
            fecha
    ";

    try {
        // Usa $this->db para acceder a la base de datos en CodeIgniter
        $query = $db->query($sql, [$inicioMes, $finMes, $almacen]);
        $result = $query->getResultArray();
        // Verificar si la consulta devolvió resultados
        if (empty($result)) {
            throw new Exception('No se encontraron transacciones para el rango de fechas y almacén especificados.');
        }
        
        return $result;

    } catch (Exception $e) {
        // Capturar el error exacto y devolverlo en la respuesta
        log_message('error', 'Error en la consulta de transacciones: ' . $e->getMessage());
        return [
            'status' => 'error',
            'message' => 'Ocurrió un error al obtener las transacciones. Detalle: ' . $e->getMessage()
        ];
    }

}
    public function sinCotizacionMenorPrecio($mes, $pdv) {
    $db = \Config\Database::connect('postgres'); // Conexión a la base de datos
    $inicioMes = $mes . '-01'; // Ejemplo: 2024-08-01
    $finMes = date('Y-m-t', strtotime($inicioMes));
    
    $sql = "
        SELECT 
    tc.trc_nombre_almacen,
    tc.trc_secuencial,
    td.trd_codigo_referencia,
    td.trd_cantidad_venta,
    td.trd_precio_base,
    td.trd_precio_venta,
    td.trd_subtotal,(td.trd_subtotal) AS total_transacciones_dia, 
            0 as comision
FROM 
    public.transaccion_cabecera tc
JOIN 
    public.transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
WHERE 
    td.trd_precio_base > td.trd_precio_venta
    AND NOT EXISTS (
        SELECT 1
        FROM public.cotizacion_cabecera ctc
        WHERE ctc.trc_secuencial = tc.trc_secuencial
    )
    AND NOT EXISTS (
        SELECT 1
        FROM public.cotizacion_detalle ctd
        WHERE ctd.ctd_codigo_referencia = td.trd_codigo_referencia
    )
    and tc.trc_fecha_transaccion BETWEEN ? AND ?
            AND tc.trc_nombre_almacen = ?

    ";

    try {
        $query = $db->query($sql, [$inicioMes, $finMes, $pdv]);


        $result = $query->getResultArray();

        if (empty($result)) {
            return "error";
        }
        
        return $result;

    } catch (Exception $e) {
        log_message('error', 'Error en la consulta de transacciones: ' . $e->getMessage());
        return [
            'status' => 'error',
            'message' => 'Ocurrió un error al obtener las transacciones. Detalle: ' . $e->getMessage()
        ];
    }
}
public function cotizacionesPDV($mes, $pdv) {
    $db = \Config\Database::connect('postgres'); // Conexión a la base de datos
    $inicioMes = $mes . '-01 00:00:00'; // Ejemplo: 2024-08-01
    $finMes = date('Y-m-t', strtotime($inicioMes)) . ' 23:59:59';
    
    $sql = "
        WITH pagos_tarjeta AS (
        -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
        SELECT 
            trp_secuencial, trp_dni_cliente,
            bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD','DE_UNA')) AS es_tarjeta
        FROM 
            transaccion_pago
        GROUP BY 
            trp_secuencial,trp_dni_cliente
    )
    SELECT 
        tc.trc_nombre_almacen,
        SUM(
            CASE 
                WHEN td.trd_es_pesado = false 
                THEN ROUND(td.trd_precio_venta * td.trd_cantidad_venta * ctd.ctd_comision / 100, 4)
                ELSE 0
            END
        ) AS total_comision_cotizacion_ferreteria,
        SUM(
            CASE 
                WHEN td.trd_es_pesado = true 
                THEN ROUND(td.trd_precio_venta * td.trd_cantidad_venta * ctd.ctd_comision / 100, 4)
                ELSE 0
            END
        ) AS total_comision_cotizacion_pesado,
        SUM(
            CASE 
                WHEN td.trd_es_pesado = false 
                THEN ROUND(td.trd_precio_venta * td.trd_cantidad_venta * ctd.ctd_comision / 100, 4)
                WHEN td.trd_es_pesado = true 
                THEN ROUND(td.trd_precio_venta * td.trd_cantidad_venta * ctd.ctd_comision / 100, 4)
                ELSE 0
            END
        ) AS total_comision_general
    FROM 
        transaccion_cabecera tc
    JOIN 
        transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
    LEFT JOIN 
        pagos_tarjeta pt ON tc.trc_secuencial = pt.trp_secuencial and tc.trc_dni_cliente=trp_dni_cliente
    JOIN 
        cotizacion_cabecera ctc ON tc.trc_secuencial = ctc.trc_secuencial
    JOIN 
        cotizacion_detalle ctd ON ctc.ctc_id = ctd.ctd_id_cabecera AND td.trd_codigo_referencia = ctd.ctd_codigo_referencia
    WHERE 
        tc.trc_fecha_transaccion >= ? AND
        tc.trc_fecha_transaccion <= ?
        AND tc.trc_nombre_almacen = ?
    GROUP BY 
        tc.trc_nombre_almacen
    ORDER BY 
        tc.trc_nombre_almacen;

    ";

    try {
        $query = $db->query($sql, [$inicioMes, $finMes, $pdv]);

        $result = $query->getResultArray();

        if (empty($result)) {
            return "error";
        }
        
        return $result;

    } catch (Exception $e) {
        log_message('error', 'Error en la consulta de transacciones: ' . $e->getMessage());
        return [
            'status' => 'error',
            'message' => 'Ocurrió un error al obtener las transacciones. Detalle: ' . $e->getMessage()
        ];
    }
}
}
