<?php

namespace App\Models;

use CodeIgniter\Model;
use Exception;

class Comisionmodelfinal extends Model
{
    protected $table = 'transaccion_cabecera'; // Tabla principal
    protected $primaryKey = 'trc_id'; // Llave primaria
    protected $returnType = 'array';

    // Obtener comisiones por mes agrupadas por punto de venta
    public function calcularComisionesPorMes($mes)
    {
        $db = \Config\Database::connect('postgres'); // Conexión a la base de datos

        try {
            // Preparar la fecha de inicio y fin del mes
            $inicioMes = $mes . '-01'; // Ejemplo: 2024-08-01
            $finMes = date('Y-m-t', strtotime($inicioMes)); // Último día del mes

            // Preparar la consulta SQL
            $sql = "WITH pagos_tarjeta AS (
                        -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
                        SELECT 
                            trp_secuencial, 
                            bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD')) AS es_tarjeta
                        FROM 
                            transaccion_pago
                        GROUP BY 
                            trp_secuencial
                    ),
                    notas_credito AS (
                        -- Obtenemos el valor de la nota de crédito y el secuencial de la factura que afecta
                        SELECT 
                            ncc.ncc_secuencial_fv,
                            SUM(ncd.ncd_precio_venta * ncd.ncd_cantidad) AS valor_total_nota_credito,
                            SUM(
                                CASE 
                                    WHEN ncd.ncd_precio_venta > ncd.ncd_precio_base 
                                        THEN ((ncd.ncd_precio_venta - ncd.ncd_precio_base) * ncd.ncd_cantidad) * 0.80
                                    WHEN ncd.ncd_precio_venta = ncd.ncd_precio_base AND ncd.ncd_es_pesado = false 
                                        THEN (ncd.ncd_precio_base * ncd.ncd_cantidad) * 0.005
                                    WHEN ncd.ncd_precio_venta = ncd.ncd_precio_base AND ncd.ncd_es_pesado = true 
                                        THEN (ncd.ncd_precio_base * ncd.ncd_cantidad) * 0.0025
                                    ELSE 0
                                END
                            ) AS comision_nota_credito
                        FROM 
                            nota_credito_cabecera ncc
                        JOIN 
                            nota_credito_detalle ncd ON ncc.ncc_id = ncd.ncd_id_cabecera
                        WHERE 
                            ncc.ncc_fecha_transaccion_nc BETWEEN '$inicioMes' AND '$finMes'
                        GROUP BY 
                            ncc.ncc_secuencial_fv
                    ),
                    cotizaciones AS (
                        -- Obtenemos las comisiones de cotizaciones separadas en ferretería (no pesado) y pesado
                        SELECT 
                            ctc.trc_secuencial,
                            SUM(
                                CASE 
                                    WHEN td.trd_es_pesado = false 
                                    THEN td.trd_precio_base * td.trd_cantidad_venta * ctd.ctd_comision 
                                    ELSE 0 
                                END
                            ) AS comision_cotizacion_ferreteria,
                            SUM(
                                CASE 
                                    WHEN td.trd_es_pesado = true 
                                    THEN td.trd_precio_base * td.trd_cantidad_venta * ctd.ctd_comision 
                                    ELSE 0 
                                END
                            ) AS comision_cotizacion_pesado
                        FROM 
                            cotizacion_cabecera ctc
                        JOIN 
                            cotizacion_detalle ctd ON ctc.ctc_id = ctd.ctd_id_cabecera
                        JOIN 
                            transaccion_detalle td ON td.trd_codigo_referencia = ctd.ctd_codigo_referencia
                        WHERE 
                            ctc.ctc_fecha_transaccion BETWEEN '$inicioMes' AND '$finMes' 
                            AND td.trd_precio_venta < td.trd_precio_base
                        GROUP BY 
                            ctc.trc_secuencial
                    )
                    SELECT 
                        tc.trc_nombre_almacen,

                        -- Valor de venta de productos de ferretería con precio de venta mayor al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = false AND td.trd_precio_venta > td.trd_precio_base 
                            THEN td.trd_precio_venta * td.trd_cantidad_venta 
                            ELSE 0 
                        END) AS valor_ferreteria_precio_mayor,

                        -- Comisión de productos de ferretería con precio de venta mayor al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = false AND td.trd_precio_venta > td.trd_precio_base 
                            THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                            ELSE 0 
                        END * CASE 
                            WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                        ) AS comision_ferreteria_precio_mayor,

                        -- Valor de venta de productos de ferretería con precio de venta igual al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = false AND td.trd_precio_venta = td.trd_precio_base 
                            THEN td.trd_precio_venta * td.trd_cantidad_venta 
                            ELSE 0 
                        END) AS valor_ferreteria_precio_igual,

                        -- Comisión de productos de ferretería con precio de venta igual al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = false AND td.trd_precio_venta = td.trd_precio_base 
                            THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.005
                            ELSE 0 
                        END * CASE 
                            WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                        ) AS comision_ferreteria_precio_igual,

                        -- Valor de venta de productos pesados con precio de venta mayor al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = true AND td.trd_precio_venta > td.trd_precio_base 
                            THEN td.trd_precio_venta * td.trd_cantidad_venta 
                            ELSE 0 
                        END) AS valor_pesado_precio_mayor,

                        -- Comisión de productos pesados con precio de venta mayor al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = true AND td.trd_precio_venta > td.trd_precio_base 
                            THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                            ELSE 0 
                        END * CASE 
                            WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                        ) AS comision_pesado_precio_mayor,

                        -- Valor de venta de productos pesados con precio de venta igual al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = true AND td.trd_precio_venta = td.trd_precio_base 
                            THEN td.trd_precio_venta * td.trd_cantidad_venta 
                            ELSE 0 
                        END) AS valor_pesado_precio_igual,

                        -- Comisión de productos pesados con precio de venta igual al precio base
                        SUM(CASE 
                            WHEN td.trd_es_pesado = true AND td.trd_precio_venta = td.trd_precio_base 
                            THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.0025
                            ELSE 0 
                        END * CASE 
                            WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                        ) AS comision_pesado_precio_igual,

                        -- Comisiones asociadas a las notas de crédito (se restan)
                        COALESCE(SUM(nc.comision_nota_credito), 0) AS comision_nota_credito,

                        -- Comisiones de cotización para productos de ferretería (se suman)
                        COALESCE(SUM(ct.comision_cotizacion_ferreteria), 0) AS comision_cotizacion_ferreteria,

                        -- Comisiones de cotización para productos pesados (se suman)
                        COALESCE(SUM(ct.comision_cotizacion_pesado), 0) AS comision_cotizacion_pesado,

                        -- Cálculo de la comisión total
                        SUM(
                            CASE 
                                WHEN td.trd_es_pesado = false AND td.trd_precio_venta > td.trd_precio_base 
                                    THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                                WHEN td.trd_es_pesado = false AND td.trd_precio_venta = td.trd_precio_base 
                                    THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.005
                                WHEN td.trd_es_pesado = true AND td.trd_precio_venta > td.trd_precio_base 
                                    THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                                WHEN td.trd_es_pesado = true AND td.trd_precio_venta = td.trd_precio_base 
                                    THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.0025
                                ELSE 0
                            END * CASE 
                                -- Aplicar descuento del 3.5% si se pagó con tarjeta
                                WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                        ) 
                        + COALESCE(SUM(ct.comision_cotizacion_ferreteria), 0) 
                        + COALESCE(SUM(ct.comision_cotizacion_pesado), 0)
                        - COALESCE(SUM(nc.comision_nota_credito), 0) AS total_comision

                    FROM 
                        transaccion_cabecera tc
                    JOIN 
                        transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
                    LEFT JOIN 
                        pagos_tarjeta pt ON tc.trc_secuencial = pt.trp_secuencial
                    LEFT JOIN 
                        notas_credito nc ON tc.trc_secuencial = nc.ncc_secuencial_fv
                    LEFT JOIN 
                        cotizaciones ct ON tc.trc_secuencial = ct.trc_secuencial
                    WHERE 
                        tc.trc_fecha_transaccion BETWEEN '$inicioMes' AND '$finMes'
                    GROUP BY 
                        tc.trc_nombre_almacen
                    ORDER BY 
                        total_comision DESC";

            // Ejecutar la consulta
            $query = $db->query($sql);

            // Obtener el resultado
            $result = $query->getResultArray();

            // Verificar si la consulta ha retornado resultados
            if (empty($result)) {
                throw new Exception('No se encontraron registros para el mes especificado.');
            }

            return $result;

        } catch (Exception $e) {
            return '' . $e->getMessage();
        }
    }
    
    public function calcularComisionesPorMesPDV($mes, $almacen)
{
    $db = \Config\Database::connect('postgres'); // Conexión a la base de datos

    try {
        // Preparar la fecha de inicio y fin del mes
        $inicioMes = $mes . '-01'; // Ejemplo: 2024-08-01
        $finMes = date('Y-m-t', strtotime($inicioMes)); // Último día del mes

        // Preparar la consulta SQL
        $sql = "WITH pagos_tarjeta AS (
                    -- Verificamos si las transacciones fueron pagadas con tarjeta de crédito o débito
                    SELECT 
                        trp_secuencial, 
                        bool_or(trp_metodo_pago IN ('DEBIT', 'CREDIT_CARD')) AS es_tarjeta
                    FROM 
                        transaccion_pago
                    GROUP BY 
                        trp_secuencial
                ),
                notas_credito AS (
                    -- Obtenemos el valor de la nota de crédito y el secuencial de la factura que afecta
                    SELECT 
                        ncc.ncc_secuencial_fv,
                        SUM(ncd.ncd_precio_venta * ncd.ncd_cantidad) AS valor_total_nota_credito,
                        SUM(
                            CASE 
                                WHEN ncd.ncd_precio_venta > ncd.ncd_precio_base 
                                    THEN ((ncd.ncd_precio_venta - ncd.ncd_precio_base) * ncd.ncd_cantidad) * 0.80
                                WHEN ncd.ncd_precio_venta = ncd.ncd_precio_base AND ncd.ncd_es_pesado = false 
                                    THEN (ncd.ncd_precio_base * ncd.ncd_cantidad) * 0.005
                                WHEN ncd.ncd_precio_venta = ncd.ncd_precio_base AND ncd.ncd_es_pesado = true 
                                    THEN (ncd.ncd_precio_base * ncd.ncd_cantidad) * 0.0025
                                ELSE 0
                            END
                        ) AS comision_nota_credito
                    FROM 
                        nota_credito_cabecera ncc
                    JOIN 
                        nota_credito_detalle ncd ON ncc.ncc_id = ncd.ncd_id_cabecera
                    WHERE 
                        ncc.ncc_fecha_transaccion_nc BETWEEN '$inicioMes' AND '$finMes'
                    GROUP BY 
                        ncc.ncc_secuencial_fv
                ),
                cotizaciones AS (
                    -- Obtenemos las comisiones de cotizaciones separadas en ferretería (no pesado) y pesado
                    SELECT 
                        ctc.trc_secuencial,
                        SUM(
                            CASE 
                                WHEN td.trd_es_pesado = false 
                                THEN td.trd_precio_base * td.trd_cantidad_venta * ctd.ctd_comision 
                                ELSE 0 
                            END
                        ) AS comision_cotizacion_ferreteria,
                        SUM(
                            CASE 
                                WHEN td.trd_es_pesado = true 
                                THEN td.trd_precio_base * td.trd_cantidad_venta * ctd.ctd_comision 
                                ELSE 0 
                            END
                        ) AS comision_cotizacion_pesado
                    FROM 
                        cotizacion_cabecera ctc
                    JOIN 
                        cotizacion_detalle ctd ON ctc.ctc_id = ctd.ctd_id_cabecera
                    JOIN 
                        transaccion_detalle td ON td.trd_codigo_referencia = ctd.ctd_codigo_referencia
                    WHERE 
                        ctc.ctc_fecha_transaccion BETWEEN '$inicioMes' AND '$finMes' 
                        AND td.trd_precio_venta < td.trd_precio_base
                    GROUP BY 
                        ctc.trc_secuencial
                )
                SELECT 
                    tc.trc_nombre_almacen,

                    -- Valor de venta de productos de ferretería con precio de venta mayor al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = false AND td.trd_precio_venta > td.trd_precio_base 
                        THEN td.trd_precio_venta * td.trd_cantidad_venta 
                        ELSE 0 
                    END) AS valor_ferreteria_precio_mayor,

                    -- Comisión de productos de ferretería con precio de venta mayor al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = false AND td.trd_precio_venta > td.trd_precio_base 
                        THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                        ELSE 0 
                    END * CASE 
                        WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                    ) AS comision_ferreteria_precio_mayor,

                    -- Valor de venta de productos de ferretería con precio de venta igual al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = false AND td.trd_precio_venta = td.trd_precio_base 
                        THEN td.trd_precio_venta * td.trd_cantidad_venta 
                        ELSE 0 
                    END) AS valor_ferreteria_precio_igual,

                    -- Comisión de productos de ferretería con precio de venta igual al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = false AND td.trd_precio_venta = td.trd_precio_base 
                        THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.005
                        ELSE 0 
                    END * CASE 
                        WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                    ) AS comision_ferreteria_precio_igual,

                    -- Valor de venta de productos pesados con precio de venta mayor al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = true AND td.trd_precio_venta > td.trd_precio_base 
                        THEN td.trd_precio_venta * td.trd_cantidad_venta 
                        ELSE 0 
                    END) AS valor_pesado_precio_mayor,

                    -- Comisión de productos pesados con precio de venta mayor al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = true AND td.trd_precio_venta > td.trd_precio_base 
                        THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                        ELSE 0 
                    END * CASE 
                        WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                    ) AS comision_pesado_precio_mayor,

                    -- Valor de venta de productos pesados con precio de venta igual al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = true AND td.trd_precio_venta = td.trd_precio_base 
                        THEN td.trd_precio_venta * td.trd_cantidad_venta 
                        ELSE 0 
                    END) AS valor_pesado_precio_igual,

                    -- Comisión de productos pesados con precio de venta igual al precio base
                    SUM(CASE 
                        WHEN td.trd_es_pesado = true AND td.trd_precio_venta = td.trd_precio_base 
                        THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.0025
                        ELSE 0 
                    END * CASE 
                        WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                    ) AS comision_pesado_precio_igual,

                    -- Comisiones asociadas a las notas de crédito (se restan)
                    COALESCE(SUM(nc.comision_nota_credito), 0) AS comision_nota_credito,

                    -- Comisiones de cotización para productos de ferretería (se suman)
                    COALESCE(SUM(ct.comision_cotizacion_ferreteria), 0) AS comision_cotizacion_ferreteria,

                    -- Comisiones de cotización para productos pesados (se suman)
                    COALESCE(SUM(ct.comision_cotizacion_pesado), 0) AS comision_cotizacion_pesado,

                    -- Cálculo de la comisión total
                    SUM(
                        CASE 
                            WHEN td.trd_es_pesado = false AND td.trd_precio_venta > td.trd_precio_base 
                                THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                            WHEN td.trd_es_pesado = false AND td.trd_precio_venta = td.trd_precio_base 
                                THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.005
                            WHEN td.trd_es_pesado = true AND td.trd_precio_venta > td.trd_precio_base 
                                THEN ((td.trd_precio_venta - td.trd_precio_base) * td.trd_cantidad_venta) * 0.80
                            WHEN td.trd_es_pesado = true AND td.trd_precio_venta = td.trd_precio_base 
                                THEN (td.trd_precio_base * td.trd_cantidad_venta) * 0.0025
                            ELSE 0
                        END * CASE 
                            -- Aplicar descuento del 3.5% si se pagó con tarjeta
                            WHEN pt.es_tarjeta THEN 0.965 ELSE 1 END
                    ) 
                    + COALESCE(SUM(ct.comision_cotizacion_ferreteria), 0) 
                    + COALESCE(SUM(ct.comision_cotizacion_pesado), 0)
                    - COALESCE(SUM(nc.comision_nota_credito), 0) AS total_comision

                FROM 
                    transaccion_cabecera tc
                JOIN 
                    transaccion_detalle td ON tc.trc_id = td.trd_id_cabecera
                LEFT JOIN 
                    pagos_tarjeta pt ON tc.trc_secuencial = pt.trp_secuencial
                LEFT JOIN 
                    notas_credito nc ON tc.trc_secuencial = nc.ncc_secuencial_fv
                LEFT JOIN 
                    cotizaciones ct ON tc.trc_secuencial = ct.trc_secuencial
                WHERE 
                    tc.trc_fecha_transaccion BETWEEN '$inicioMes' AND '$finMes'
                    AND tc.trc_nombre_almacen = ?
                GROUP BY 
                    tc.trc_nombre_almacen
                ORDER BY 
                    total_comision DESC";

        // Ejecutar la consulta con el parámetro de almacén
        $query = $db->query($sql, [$almacen]);

        // Obtener el resultado
        $result = $query->getResultArray();

        // Verificar si la consulta ha retornado resultados
        if (empty($result)) {
            throw new Exception('No se encontraron registros para el mes especificado.');
        }

        return $result;

    } catch (Exception $e) {
        return '' . $e->getMessage();
    }
}

}
