<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Descuentomensualmodel extends Model
{
    public function getDescuentomensual()
    {
        $fecha_actual = date('Y-m-d'); // Fecha actual completa
        $anio_mes_actual = date('Y-m'); // Año y mes actual en formato "YYYY-MM"
        $dia_actual = date('d'); // Día actual
        $mes_actual = date('m'); // Mes actual
        $anio_actual = date('Y'); // Año actual
    
        // Verificar si el mes actual tiene 28 días en caso de febrero
        if ($mes_actual == 2) { // Si es febrero
            $ultimo_dia_mes = date('t', strtotime("$anio_actual-$mes_actual-01")); // Obtiene el último día del mes
            if ($ultimo_dia_mes == 28) {
                $max_dia = 28; // Si es un año normal, ajustamos a 28
            } else {
                $max_dia = 29; // Si es año bisiesto, permitimos hasta 29
            }
        } else {
            $max_dia = 31; // Para otros meses, el máximo es 31
        }
    
        $this->session = \Config\Services::session();
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales');
        $builder->select('tbl_descuentos_mensuales.*');
    
        if ($this->session->get('ROL_ID') == 29) {
            $builder->join('tbl_asignacion_descuento', 'tbl_asignacion_descuento.DEM_ID = tbl_descuentos_mensuales.dem_id', 'inner');
    
            // Ajustar ASD_DIA si el día es 29 en febrero y el mes tiene 28 días
            $builder->where("STR_TO_DATE(
                CONCAT('$anio_mes_actual-', 
                    CASE 
                        WHEN tbl_asignacion_descuento.ASD_DIA > $max_dia THEN '$max_dia'
                        ELSE LPAD(tbl_asignacion_descuento.ASD_DIA, 2, '0') 
                    END
                ), '%Y-%m-%d') >=", $fecha_actual);
        }
    
        //$builder->where('tbl_descuentos_mensuales.dem_estado =', 1);
        $query = $builder->get();
        $resultado = $query->getResultArray();
        return $resultado;
    }

    public function getDescuentomensualActivo()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales');
        $builder->select('tbl_descuentos_mensuales.*');   
        $builder->where('tbl_descuentos_mensuales.dem_estado =', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getDescuentomensualdesdehastatipo($dem_tipo,$dem_desde,$dem_hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales');
        $builder->select('tbl_descuentos_mensuales.*');   
        $builder->where('tbl_descuentos_mensuales.dem_tipo', $dem_tipo);
        $builder->where('tbl_descuentos_mensuales.dem_desde <=', $dem_desde);
        $builder->where('tbl_descuentos_mensuales.dem_hasta >=', $dem_hasta); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales');
        $builder->set($data);
		$builder->insert();

    }
    public function insertarDescuentoUsuario($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_asignacion_descuento');
        $builder->set($data);
		$builder->insert();

    }
    public function eliminarDescuentoUsuario($USU_ID)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_asignacion_descuento');
        $builder->where('USU_ID', $USU_ID);
        $builder->delete();
    
        return ''; // Retorna la cantidad de filas eliminadas
    }
    public function activarDescuentoUsuario($dem_id,$USU_ID)
    {
        $data=array('ASD_ESTADO'=>1);
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_asignacion_descuento');
        $builder->where('tbl_asignacion_descuento.dem_id', $dem_id);
        $builder->where('USU_ID', $USU_ID);
		return $builder->update($data);        
    }
    public function inactivarDescuentoUsuario($dem_id,$USU_ID)
    {
        $data=array('ASD_ESTADO'=>0);
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_asignacion_descuento');
        $builder->where('tbl_asignacion_descuento.dem_id', $dem_id);
        $builder->where('USU_ID', $USU_ID);
		return $builder->update($data);        
    }
    public function actualizar($dem_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales');
        $builder->where('tbl_descuentos_mensuales.dem_id', $dem_id);
		return $builder->update($data);        
    }
    

}