<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Descuentopendientepagomodel extends Model
{
      
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->set($data);
		$builder->insert();
    }
    
    public function getCuotaPendienteByDESID($des_id,$numero_mes,$numero_ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->selectMax('tbl_descuento_pendiente_pago.dpp_id');  
        $builder->selectMax('tbl_descuento_pendiente_pago.dpp_transaccion');  
        $builder->where('tbl_descuento_pendiente_pago.des_id', $des_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        $builder->where('tbl_descuento_pendiente_pago.dpp_mes_cobro', $numero_mes);
        $builder->where('tbl_descuento_pendiente_pago.dpp_ano_cobro', $numero_ano);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getCuotaPendienteByDEMID($dem_id,$numero_mes,$numero_ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->selectMax('tbl_descuento_pendiente_pago.dpp_id');  
        $builder->selectMax('tbl_descuento_pendiente_pago.dpp_transaccion');  
        $builder->where('tbl_descuento_pendiente_pago.dem_id', $dem_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        $builder->where('tbl_descuento_pendiente_pago.dpp_mes_cobro', $numero_mes);
        $builder->where('tbl_descuento_pendiente_pago.dpp_ano_cobro', $numero_ano);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getCuotasPendienteDescuentoMensual($numero_mes, $numero_ano, $puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago'); 
        $builder->selectMax('tbl_descuento_pendiente_pago.dpp_transaccion');
        $builder->select('dp.*');
        $builder->select('tbl_descuentos_mensuales.*');
        $builder->join('(select * from tbl_descuento_pendiente_pago) as dp','dp.dpp_id = tbl_descuento_pendiente_pago.dpp_id '); 
        $builder->join('tbl_descuentos_mensuales','tbl_descuentos_mensuales.dem_id = dp.dem_id '); 
        $builder->join('tbl_descuentos_mensuales_valor','tbl_descuentos_mensuales_valor.dem_id = dp.dem_id '); 
        $builder->where('tbl_descuento_pendiente_pago.dem_id is not NULL');
        $builder->where('tbl_descuento_pendiente_pago.puv_id',$puv_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        $builder->where('Concat(dp.dpp_ano_cobro,dp.dpp_mes_cobro) <', $numero_ano.$numero_mes);
        $builder->groupBy(array('dp.dem_id','dp.dpp_ano_cobro','dp.dpp_mes_cobro'));
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getCuotasPendienteDescuento($numero_mes, $numero_ano, $puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago'); 
        $builder->selectMax('tbl_descuento_pendiente_pago.dpp_transaccion');
        $builder->select('dp.*');
        $builder->select('tbl_descuento.*');
        $builder->join('(select * from tbl_descuento_pendiente_pago) as dp','dp.dpp_id = tbl_descuento_pendiente_pago.dpp_id '); 
        $builder->join('tbl_descuento','tbl_descuento.des_id = dp.des_id '); 
        $builder->where('tbl_descuento_pendiente_pago.des_id is not NULL');
        $builder->where('tbl_descuento_pendiente_pago.puv_id',$puv_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        $builder->where('Concat(dp.dpp_ano_cobro,dp.dpp_mes_cobro) <', $numero_ano.$numero_mes);
        $builder->groupBy(array('dp.des_id','dp.dpp_ano_cobro','dp.dpp_mes_cobro'));
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function pagarCuotaPendiente($dpp_id,$mes,$ano)
    {
        $data = [
            'dpp_estado' => 1,
            'dpp_mes_pago' => $mes,
            'dpp_ano_pago' => $ano,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->where('tbl_descuento_pendiente_pago.dpp_id', $dpp_id);
        return $builder->update($data);
    }
    
    public function insertCuotaPendiente($des_id, $dem_id,$dpp_motivo,$dpp_transaccion, $puv_id, $valor,$mes_cobro,$ano_cobro )
    {
        $dpp_transaccion=$dpp_transaccion+1;
        $fecha=date('Y-m-d');
        $data = [
            'des_id' => $des_id,
            'dem_id' => $dem_id,
            'dpp_motivo' => $dpp_motivo,
            'dpp_fecha_registro' => $fecha,
            'dpp_transaccion'   => $dpp_transaccion,
            'puv_id' => $puv_id,
            'dpp_estado' => 0,
            'dpp_valor' => $valor,
            'dpp_mes_cobro' => $mes_cobro,
            'dpp_ano_cobro' => $ano_cobro,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->set($data);
		$builder->insert();  
    }
    public function updateRegistroAnteriorCuotaPendienteDes($des_id,$puv_id,$numero_mes,$numero_ano)
    {
        $data = [
            'dpp_estado' => 2,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->where('tbl_descuento_pendiente_pago.des_id', $des_id);
        $builder->where('tbl_descuento_pendiente_pago.puv_id', $puv_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_mes_cobro', $numero_mes);
        $builder->where('tbl_descuento_pendiente_pago.dpp_ano_cobro', $numero_ano);
        return $builder->update($data);        
    }
    
    public function updateRegistroAnteriorCuotaPendienteDem($des_id,$puv_id,$numero_mes,$numero_ano)
    {
        $data = [
            'dpp_estado' => 2,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->where('tbl_descuento_pendiente_pago.dem_id', $des_id);
        $builder->where('tbl_descuento_pendiente_pago.puv_id', $puv_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_mes_cobro', $numero_mes);
        $builder->where('tbl_descuento_pendiente_pago.dpp_ano_cobro', $numero_ano);
        return $builder->update($data);        
    }
    
    public function updateRegistroCuotaPendienteActualDes($des_id,$puv_id,$numero_mes,$numero_ano)
    {
        $data = [
            'dpp_estado' => 1,
            'dpp_ano_pago'=>$numero_ano,
            'dpp_mes_pago'=>$numero_mes
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->where('tbl_descuento_pendiente_pago.des_id', $des_id);
        $builder->where('tbl_descuento_pendiente_pago.puv_id', $puv_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_mes_cobro', $numero_mes);
        $builder->where('tbl_descuento_pendiente_pago.dpp_ano_cobro', $numero_ano);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        return $builder->update($data);        
    }
    
    public function updateRegistroCuotaPendienteActualDem($dem_id,$puv_id,$numero_mes,$numero_ano)
    {
        $data = [
            'dpp_estado' => 1,
            'dpp_ano_pago'=>$numero_ano,
            'dpp_mes_pago'=>$numero_mes
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->where('tbl_descuento_pendiente_pago.dem_id', $dem_id);
        $builder->where('tbl_descuento_pendiente_pago.puv_id', $puv_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_mes_cobro', $numero_mes);
        $builder->where('tbl_descuento_pendiente_pago.dpp_ano_cobro', $numero_ano);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        return $builder->update($data);        
    }
    
    public function getNumeroCuotasPendientesByPraId($pra_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->select('tbl_descuento_pendiente_pago.dpp_id');  
        $builder->where('tbl_descuento_pendiente_pago.pra_id', $pra_id);
        $builder->where('tbl_descuento_pendiente_pago.dpp_estado', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function pagarDescuentoPendiente($dpp_id,$mes,$ano)
    {
        $data = [
            'dpp_estado' => 1,
            'dpp_mes_pago' => $mes,
            'dpp_ano_pago' => $ano,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuento_pendiente_pago');
        $builder->where('tbl_descuento_pendiente_pago.dpp_id', $dpp_id);
        return $builder->update($data);
    }
}