<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Postconveniovalormodel extends Model
{
    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_post_convenio_valor');
        $builder->set($data);
        $builder->insert();
    }

    public function getpostconvenioporcentajeid($puv_id,$poc_id,$pcv_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_post_convenio_valor');
        $builder->select('tbl_post_convenio_valor.*,tbl_post_convenio.*');   
        $builder->join('tbl_post_convenio', 'tbl_post_convenio_valor.poc_id=tbl_post_convenio.poc_id');
        $builder->where('tbl_post_convenio_valor.puv_id', $puv_id);
        $builder->where('tbl_post_convenio_valor.poc_id', $poc_id);
        $builder->where('tbl_post_convenio_valor.pcv_mes', $pcv_mes);    
        $builder->where('tbl_post_convenio.poc_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 

    public function getpostconvenioporvalorpocid($poc_id,$pcv_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_post_convenio_valor');
        $builder->select('tbl_post_convenio_valor.*,tbl_post_convenio.*,tbl_punto_venta.*');  
        $builder->join('tbl_punto_venta', 'tbl_post_convenio_valor.puv_id=tbl_punto_venta.puv_id');
        $builder->join('tbl_post_convenio', 'tbl_post_convenio_valor.poc_id=tbl_post_convenio.poc_id'); 
        $builder->where('tbl_post_convenio_valor.poc_id', $poc_id); 
        $builder->where('tbl_post_convenio_valor.pcv_mes', $pcv_mes);   
        $builder->where('tbl_post_convenio.poc_estado', 1);
       // $sql = $builder->getCompiledSelect();
        //echo $sql;
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function actualizar($pcv_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_post_convenio_valor');
        $builder->where('tbl_post_convenio_valor.pcv_id', $pcv_id);
        return $builder->update($data);        
    }
    public function eliminarsegunpocid($poc_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_post_convenio_valor');
        $builder->where('tbl_post_convenio_valor.poc_id', $poc_id);
        return $builder->delete();        
    }
    public function eliminarsegunpocidmes($poc_id,$pcv_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_post_convenio_valor');
        $builder->where('tbl_post_convenio_valor.poc_id', $poc_id);
        $builder->where('tbl_post_convenio_valor.pcv_mes', $pcv_mes);
        return $builder->delete();        
    }
   public function buscarPostConvenioPorNombre($nombrePostConvenio) {
    if (!isset($this->db)) {
        $this->db = \Config\Database::connect();  // Conectar a la base de datos si no est conectado
    }

    $builder = $this->db->table('tbl_post_convenio'); // Crea el query builder para la tabla
    
    // Aplica la condicin, asegurando que la bsqueda ignore maysculas/minsculas
    $builder->where('LOWER(poc_nombre)', strtolower($nombrePostConvenio));
     
    $query = $builder->get(); // Ejecuta la consulta
    return $query->getRowArray(); // Retorna un array con los datos del post convenio
}



    // Insertar un nuevo post convenio
    public function insertarPostConvenio($puv_id, $nombrePostConvenio, $valor, $mes) {
        // Buscar el post convenio por nombre
        $postConvenio = $this->buscarPostConvenioPorNombre($nombrePostConvenio);
    
        if ($postConvenio) {
            $data = [
                'puv_id' => $puv_id,
                'poc_id' => $postConvenio['poc_id'],  // ID del post convenio
                'pcv_valor' => $valor,  // Valor a insertar
                'pcv_mes' => $mes,  // Mes actual
                'pcv_estado' => 1  // Estado activo
            ];
    
            // Usar el query builder para insertar en la tabla tbl_post_convenio_valor
            $builder = $this->db->table('tbl_post_convenio_valor');
            return $builder->insert($data);
        } else {
            return false;  // Post convenio no encontrado
        }
    }


}