<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Prestamoamortizaciondetallemodel extends Model
{
      
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->set($data);
		$builder->insert();
		
		$builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->selectMax('tbl_prestamo_amortizacion_detalle.prd_id');   
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getTablaAmortizacionActivaByIdPrestamo($pre_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*,tbl_prestamo_amortizacion.pra_observacion_creacion,tbl_prestamos.pre_estado,tbl_prestamos.pre_id,tbl_prestamos.puv_id');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id=tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id=tbl_prestamo_amortizacion.pre_id');
        $builder->where('tbl_prestamo_amortizacion.pre_id', $pre_id);
        $builder->where('tbl_prestamo_amortizacion.pra_estado', 1);
        $builder->orderBy('tbl_prestamo_amortizacion_detalle.prd_numero_cuota', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPrestamosCuotasPendientes($mes,$ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*,tbl_prestamos.*');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id=tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id=tbl_prestamo_amortizacion.pre_id');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_estado', 0);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_mes_estimado<=', $mes);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_ano_estimado<=', $ano);
        $builder->where('tbl_prestamos.pre_estado', 1);
        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
  public function getCuotasPendientesPrestamoByPDV($pre_nombre,$puv_id,$mes,$ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*,tbl_prestamos.*, tbl_prestamo_amortizacion.pra_estado, "PENDIENTEMES" as a ');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id=tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id=tbl_prestamo_amortizacion.pre_id');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_mes_estimado=', $mes);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_ano_estimado=', $ano);
        $builder->where('tbl_prestamo_amortizacion_detalle.meg_id is NULL');
        $builder->where('tbl_prestamo_amortizacion.pra_estado=', 1);
        $builder->where('tbl_prestamos.pre_estado=', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }



    public function getCuotasPendientesPrestamoByPDVPagadasMesActual($pre_nombre,$puv_id,$mes,$ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*,tbl_prestamos.*, tbl_prestamo_amortizacion.pra_estado, "PENDIENTEMES" as a ');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id=tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id=tbl_prestamo_amortizacion.pre_id');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $builder->where('concat(tbl_prestamo_amortizacion_detalle.prd_ano_real,tbl_prestamo_amortizacion_detalle.prd_mes_real)=', $ano.$mes);
        $builder->where('concat(tbl_prestamo_amortizacion_detalle.prd_ano_estimado,tbl_prestamo_amortizacion_detalle.prd_mes_estimado)!=', $ano.$mes);
        $builder->where('tbl_prestamo_amortizacion_detalle.meg_id is NULL');
        $builder->where('tbl_prestamo_amortizacion.pra_estado=', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getCuotasAnterioresPendientesByPRAID($pre_nombre,$puv_id,$mes,$ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*,tbl_prestamos.*, tbl_prestamo_amortizacion.pra_estado, "PENDIENTEANTERIOR" as a');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id=tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id=tbl_prestamo_amortizacion.pre_id');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->join('tbl_prestamo_pendiente_pago', 'tbl_prestamo_pendiente_pago.prd_id=tbl_prestamo_amortizacion_detalle.prd_id');
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $builder->where('tbl_prestamos.pre_estado', 1);
        $builder->where('tbl_prestamo_amortizacion.pra_estado=', 1);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_tipo_pago=', 'A');
        //$builder->where('tbl_prestamo_amortizacion.prd_estado=', 0);
        $builder->where('concat(tbl_prestamo_amortizacion_detalle.prd_ano_estimado,tbl_prestamo_amortizacion_detalle.prd_mes_estimado)!=', $ano.$mes);
        $builder->where('concat(tbl_prestamo_amortizacion_detalle.prd_ano_estimado,tbl_prestamo_amortizacion_detalle.prd_mes_estimado)<', $ano.$mes);
        $builder->whereIn('tbl_prestamo_pendiente_pago.ppp_estado', [0,3]);
        //$builder->orwhere('concat(tbl_prestamo_pendiente_pago.ppp_ano_pago,tbl_prestamo_pendiente_pago.ppp_mes_pago)!=', $ano.$mes);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getCuotasMesGracia($pre_nombre,$puv_id, $mes)
    {
        
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*, tbl_prestamos.*, tbl_prestamo_amortizacion.pra_estado, "PENDIENTEMESGRACIA" as a');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id = tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id = tbl_prestamo_amortizacion.pre_id');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id = tbl_punto_venta.puv_id');
        $builder->join('tbl_prestamo_mes_gracia', 'tbl_prestamo_mes_gracia.pre_id = tbl_prestamos.pre_id and tbl_prestamo_mes_gracia.meg_mes = tbl_prestamo_amortizacion_detalle.prd_mes_estimado and tbl_prestamo_amortizacion_detalle.prd_ano_estimado = tbl_prestamo_mes_gracia.meg_ano');
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $builder->where('tbl_prestamo_amortizacion.pra_estado', 1);
        $builder->where('tbl_prestamo_mes_gracia.meg_estado !=', 0);
        $builder->groupStart()
            ->where('CONCAT(tbl_prestamo_amortizacion_detalle.prd_ano_real, tbl_prestamo_amortizacion_detalle.prd_mes_real) =', $mes, false)
            ->orWhere('tbl_prestamo_amortizacion_detalle.prd_ano_real IS NULL')
            ->where('CONCAT(tbl_prestamo_amortizacion_detalle.prd_ano_estimado, tbl_prestamo_amortizacion_detalle.prd_mes_estimado) =', $mes, false)
            //->where('tbl_prestamo_amortizacion_detalle.prd_id =', 762)
            ->groupEnd();
        
        $query = $builder->get();
        $resultado = $query->getResultArray();
        return $resultado;
        
        

    }
    public function getCuotasPendientesPrestamoSINMesGracia($pre_nombre,$puv_id,$mes,$ano)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion_detalle.*,tbl_prestamos.*, tbl_prestamo_amortizacion.pra_estado');  
        $builder->join('tbl_prestamo_amortizacion_detalle', 'tbl_prestamo_amortizacion_detalle.pra_id=tbl_prestamo_amortizacion.pra_id');
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id=tbl_prestamo_amortizacion.pre_id');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $builder->where('tbl_prestamo_amortizacion_detalle.meg_id is null');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_estado=', 0);
        $builder->where('tbl_prestamo_amortizacion.pra_estado=', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertCobroCuota($prd_id,$mes,$ano)
    {
        $data = [
            'prd_mes_real' => $mes,
            'prd_ano_real' => $ano,
            'prd_estado'   => 1,
            'prd_observacion_no_pago'   => '',
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        return $builder->update($data);        
    }
    public function insertAbonoCuota($prd_id,$mes,$ano,$abono,$saldo,$estado)
    {
        $data = [
            'prd_mes_real' => $mes,
            'prd_ano_real' => $ano,
            'prd_estado'   => $estado,
            'prd_observacion_no_pago'   => '',
            'prd_abono_cuota'   => $abono,
            'prd_saldo_cuota'   => $saldo,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        return $builder->update($data);        
    }
    public function insertarMotivoNoPagoCuota($prd_id,$prd_observacion_no_pago,$estado)
    {
        $data = [
            'prd_observacion_no_pago' => $prd_observacion_no_pago,
            'prd_estado'   => $estado,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        return $builder->update($data);        
    }
    public function reiniciarPagoCuota($prd_id)
    {
        $data = [
            'prd_estado'   => 0,
            'prd_mes_real'   => null,
            'prd_ano_real'   => null,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        
        return $builder->update($data);        
    }
    public function getDetalleTablasAmortizacionByPraId($pra_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->select('tbl_prestamo_amortizacion_detalle.*');  
        $builder->where('tbl_prestamo_amortizacion_detalle.pra_id', $pra_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUltimaCuotaByPRDID($prd_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->selectMax('tbl_prestamo_amortizacion_detalle.prd_numero_cuota');  
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->select('tbl_prestamo_amortizacion_detalle.*');  
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_numero_cuota', $resultado[0]['prd_numero_cuota']);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function pagarCuota($prd_id,$mes,$ano,$observacion)
    {
        $data = [
            'prd_mes_real' => $mes,
            'prd_ano_real' => $ano,
            'prd_estado'   => 1,
            'prd_observacion_no_pago'   => $observacion,
            'prd_tipo_pago'=>'M'
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_id', $prd_id);
        return $builder->update($data);        
    }
}