<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Prestamopendientepagomodel extends Model
{
      
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->set($data);
		$builder->insert();
    }
    
    public function getCuotaPendienteByPRDID($prd_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->selectMax('tbl_prestamo_pendiente_pago.ppp_id');  
        $builder->selectMax('tbl_prestamo_pendiente_pago.ppp_transaccion');  
        $builder->join('tbl_prestamos', 'tbl_prestamos.pre_id = tbl_prestamos.pre_id');
        $builder->where('tbl_prestamo_pendiente_pago.prd_id', $prd_id);
        $builder->whereIn('tbl_prestamo_pendiente_pago.ppp_estado', [0,3]);
        $builder->where('tbl_prestamos.pre_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function pagarCuotaPendiente($ppp_id,$mes,$ano)
    {
        $data = [
            'ppp_estado' => 1,
            'ppp_mes_pago' => $mes,
            'ppp_ano_pago' => $ano,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->where('tbl_prestamo_pendiente_pago.ppp_id', $ppp_id);
        return $builder->update($data);
    }
    
    public function insertCuotaPendiente($pre_id, $pra_id, $prd_id,$ppp_motivo,$ppp_transaccion, $puv_id,$estado )
    {
        $ppp_transaccion=$ppp_transaccion+1;
        $fecha=date('Y-m-d');
        $data = [
            'pre_id' => $pre_id,
            'pra_id' => $pra_id,
            'prd_id'   => $prd_id,
            'ppp_motivo' => $ppp_motivo,
            'ppp_fecha_registro' => $fecha,
            'ppp_transaccion'   => $ppp_transaccion,
            'puv_id' => $puv_id,
            'ppp_estado' => $estado,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->set($data);
		$builder->insert();  
    }
    public function updateRegistroAnteriorCuotaPendiente($prd_id,$ppp_motivo,$ppp_transaccion, $puv_id,$estado )
    {
        $ppp_transaccion=$ppp_transaccion+1;
        $fecha=date('Y-m-d');
        $data = [
            'ppp_motivo' => $ppp_motivo,
            'ppp_fecha_registro' => $fecha,
            'ppp_transaccion'   => $ppp_transaccion,
            'puv_id' => $puv_id,
            'ppp_estado' => $estado,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->where('tbl_prestamo_pendiente_pago.prd_id', $prd_id);
        return $builder->update($data);        
    }
    
    public function getNumeroCuotasPendientesByPraId($pra_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->select('tbl_prestamo_pendiente_pago.ppp_id');  
        $builder->where('tbl_prestamo_pendiente_pago.pra_id', $pra_id);
        $builder->where('tbl_prestamo_pendiente_pago.ppp_estado', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
}