<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Puntoventamodel extends Model
{
    public function getPuntoventa()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*,tbl_tipo_franquicia_comisiones.*,tbl_iva_renta_pdv.*,tbl_comision_grupo.*');    
        $builder->join('tbl_tipo_franquicia_comisiones', 'tbl_punto_venta.tfc_id=tbl_tipo_franquicia_comisiones.tfc_id');
        $builder->join('tbl_iva_renta_pdv', 'tbl_punto_venta.irp_id=tbl_iva_renta_pdv.irp_id'); 
        $builder->join('tbl_comision_grupo', 'tbl_punto_venta.cog_id=tbl_comision_grupo.cog_id');
        $builder->orderBy('tbl_punto_venta.puv_punto_venta', 'ASC'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function getPuntoventaActivo()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*,tbl_tipo_franquicia_comisiones.*,tbl_iva_renta_pdv.*,tbl_comision_grupo.*');    
        $builder->join('tbl_tipo_franquicia_comisiones', 'tbl_punto_venta.tfc_id=tbl_tipo_franquicia_comisiones.tfc_id');
        $builder->join('tbl_iva_renta_pdv', 'tbl_punto_venta.irp_id=tbl_iva_renta_pdv.irp_id'); 
        $builder->join('tbl_comision_grupo', 'tbl_punto_venta.cog_id=tbl_comision_grupo.cog_id');
        $builder->where('tbl_punto_venta.puv_estado', 1); 
        $builder->orderBy('tbl_punto_venta.puv_punto_venta', 'ASC'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function getNombrePuntoventa()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*');    
        $builder->orderBy('tbl_punto_venta.puv_punto_venta', 'ASC'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function getNombrePuntoventaDueno($tipo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*');    
        if($tipo!=2){
            $builder->where('tbl_punto_venta.puv_propio', $tipo); 
        }
        $builder->orderBy('tbl_punto_venta.puv_punto_venta', 'ASC'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->set($data);
		$builder->insert();
    }   
    public function getPuntoventasegunnombre($puv_punto_venta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*,tbl_iva_renta_pdv.*');  
        $builder->where('tbl_punto_venta.puv_punto_venta', $puv_punto_venta);  
        $builder->join('tbl_iva_renta_pdv', 'tbl_punto_venta.irp_id=tbl_iva_renta_pdv.irp_id');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getPuntoventasegunId($puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*,tbl_iva_renta_pdv.*');  
        $builder->join('tbl_tipo_franquicia_comisiones', 'tbl_punto_venta.tfc_id=tbl_tipo_franquicia_comisiones.tfc_id');
        $builder->join('tbl_iva_renta_pdv', 'tbl_punto_venta.irp_id=tbl_iva_renta_pdv.irp_id'); 
        $builder->where('tbl_punto_venta.puv_id', $puv_id);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnPuntoventa($puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*');  
        $builder->where('tbl_punto_venta.puv_id', $puv_id);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function actualizar($puv_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->where('tbl_punto_venta.puv_id', $puv_id);
        return $builder->update($data);        
    } 
    
    public function getPuntoventatipofranquicia($tfc_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_punto_venta');
        $builder->select('tbl_punto_venta.*');  
        $builder->where('tbl_punto_venta.tfc_id', $tfc_id);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 

    public function insertarObservacionReporteMensualPDV($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_pdv_observacion_mes');
        $builder->set($data);
		$builder->insert();
    } 
    
    public function actualizarObservacionReporteMensualPDV($data, $puv_id, $mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_pdv_observacion_mes');
        $builder->where('tbl_comision_pdv_observacion_mes.puv_id', $puv_id);
        $builder->where('tbl_comision_pdv_observacion_mes.cpo_fecha', $mes);
        return $builder->update($data); 
    } 
    
    public function getObservacionReporteMensualPDV($mes,$puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_comision_pdv_observacion_mes');
        $builder->where('tbl_comision_pdv_observacion_mes.puv_id', $puv_id);
        $builder->where('tbl_comision_pdv_observacion_mes.cpo_fecha', $mes);
		$query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function buscarPDVPorNombre($nombrePdv) {
        if (!isset($this->db)) {
            $this->db = \Config\Database::connect();  // Conectar a la base de datos si no está conectado
        }
    
        $builder = $this->db->table('tbl_punto_venta'); // Crea el query builder para la tabla
        
        // Aplica la condición, asegurando que la búsqueda ignore mayúsculas/minúsculas
        $builder->where('LOWER(puv_punto_venta)', strtolower($nombrePdv));
         
        $query = $builder->get(); // Ejecuta la consulta
        return $query->getRowArray(); // Retorna un array con los datos del post convenio
    }
}