<?php

namespace App\Models;

use CodeIgniter\Model;

class Transaccionespagomodel extends Model
{
    protected $table = 'transaccion_pago';
    protected $primaryKey = 'trp_id';
    protected $allowedFields = [
        'trp_dispatch_id',
        'trp_nombre_almacen',
        'trp_punto_emision',
        'trp_fecha_transaccion',
        'trp_secuencial',
        'trp_dni_cliente',
        'trp_nombre_cliente',
        'trp_metodo_pago',
        'trp_total',
        'trp_monto_metodo_pago'
    ];

    protected $db;  // Conexin a PostgreSQL

    public function __construct()
    {
        parent::__construct();
        // Conexin explcita a la base de datos PostgreSQL
        $this->db = \Config\Database::connect('postgres');
    }

    /**
     * Inserta una nueva transaccin si no existe ya una transaccin
     * con el mismo secuencial y mtodo de pago.
     *
     * @param array $data
     * @return bool|null Retorna true si fue exitoso, false en caso de error, o null si ya exista
     */
    public function insertarTransaccionSiNoExiste($data)
    {
        // Crear la consulta SQL para insertar si no existe un conflicto
        $query = "INSERT INTO transaccion_pago (trp_dispatch_id, trp_nombre_almacen, trp_punto_emision, trp_fecha_transaccion, trp_secuencial, trp_dni_cliente, trp_nombre_cliente, trp_metodo_pago, trp_total, trp_monto_metodo_pago) 
                  VALUES (:trp_dispatch_id:, :trp_nombre_almacen:, :trp_punto_emision:, :trp_fecha_transaccion:, :trp_secuencial:, :trp_dni_cliente:, :trp_nombre_cliente:, :trp_metodo_pago:, :trp_total:, :trp_monto_metodo_pago:)
                  ON CONFLICT (trp_secuencial, trp_metodo_pago) DO NOTHING"; // Ignorar si ya existe

        // Ejecutar la consulta usando la conexin PostgreSQL
        $this->db->query($query, $data);

        // Imprimir la ltima consulta ejecutada para depuracin
        echo $this->db->getLastQuery();

        // Capturar el error si lo hay
        $error = $this->db->error();
        if ($error['code'] != 0) {
            // Si hay un error, imprimir el mensaje de error
            echo "Error al insertar: " . $error['message'];
            return false;
        }

        // Retornar true si se insert correctamente o null si ya exista
        return $this->db->affectedRows() > 0 ? true : null;
    }
}
